/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sg.datamodel.impl;

import com.sas.sg.datamodel.DataAnimator;
import com.sas.sg.datamodel.DataModel;
import com.sas.sg.datamodel.DataModelEvent;
import com.sas.sg.datamodel.DataModelListener;
import com.sas.sg.datamodel.DataPropertyModel;
import com.sas.sg.datamodel.DataReaderModel;
import com.sas.sg.datamodel.DataWriterModel;
import com.sas.sg.datamodel.ObsDataEvent;
import com.sas.sg.datamodel.ObsPermutationModel;
import com.sas.sg.datamodel.ObsPropertyModel;
import com.sas.sg.datamodel.PermutationPolicy;
import com.sas.sg.datamodel.ValueDataEvent;
import com.sas.sg.datamodel.VarDataEvent;
import com.sas.sg.datamodel.VarPropertyModel;
import com.sas.sg.datamodel.impl.SgObsBooleanProp;
import com.sas.sg.datamodel.impl.SgObsColor;
import com.sas.sg.datamodel.impl.SgObsMarker;
import com.sas.sg.datamodel.impl.SgObsSelection;
import com.sas.sg.datamodel.impl.SgObsSortContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public abstract class SgAbstractDataModel
implements DataModel {
    protected int m_blockSize = 64;
    protected String m_dataName;
    protected String m_dataLabel;
    protected HashMap m_obsPropModels = new HashMap();
    protected HashMap m_varPropModels = new HashMap();
    protected HashMap m_customPropModels = new HashMap();
    protected HashMap m_obsPermutations = new HashMap();
    protected ArrayList m_listenerList = new ArrayList();
    protected ArrayList m_animatorList = new ArrayList();
    protected int[] m_obsList;
    protected DataReaderModel m_dataReader;
    protected DataWriterModel m_dataWriter;

    public void setBlockSize(int size) {
        this.m_blockSize = size;
    }

    public int getBlockSize() {
        return this.m_blockSize;
    }

    public void setDataName(String name) {
        this.m_dataName = name;
    }

    public String getDataName() {
        return this.m_dataName;
    }

    public void setDataLabel(String label) {
        this.m_dataLabel = label;
    }

    public String getDataLabel() {
        return this.m_dataLabel;
    }

    public void setDataReader(DataReaderModel reader) {
        this.m_dataReader = reader;
    }

    public DataReaderModel getDataReader() {
        return this.m_dataReader;
    }

    public void setDataWriter(DataWriterModel writer) {
        this.m_dataWriter = writer;
    }

    public DataWriterModel getDataWriter() {
        return this.m_dataWriter;
    }

    protected void addPropertyModel(HashMap modelList, String propName, Object propModel) {
        if (propName == null || propModel == null) {
            throw new IllegalArgumentException();
        }
        if (!modelList.containsKey(propName)) {
            modelList.put(propName, propModel);
        }
    }

    protected void removePropertyModel(HashMap modelList, String propName) {
        if (propName == null) {
            throw new IllegalArgumentException();
        }
        DataPropertyModel propModel = (DataPropertyModel)this.getPropertyModel(modelList, propName);
        if (propModel != null && propModel.getNumListeners() == 0) {
            modelList.remove(propName);
        }
    }

    protected boolean isPropertyModelExist(HashMap modelList, String propName) {
        if (propName == null) {
            throw new IllegalArgumentException();
        }
        return modelList.containsKey(propName);
    }

    protected Object getPropertyModel(HashMap modelList, String propName) {
        if (propName == null) {
            throw new IllegalArgumentException();
        }
        return (DataPropertyModel)modelList.get(propName);
    }

    public void addObsPropertyModel(String propName, ObsPropertyModel propModel) {
        this.addPropertyModel(this.m_obsPropModels, propName, propModel);
    }

    public void removeObsPropertyModel(String propName) {
        this.removePropertyModel(this.m_obsPropModels, propName);
    }

    public boolean isObsPropertyModelExist(String propName) {
        return this.isPropertyModelExist(this.m_obsPropModels, propName);
    }

    public ObsPropertyModel getObsPropertyModel(String propName) {
        ObsPropertyModel prop = (ObsPropertyModel)this.getPropertyModel(this.m_obsPropModels, propName);
        if (prop == null) {
            if (propName.equals("Obs Selection")) {
                prop = new SgObsSelection(this, false);
                this.addObsPropertyModel("Obs Selection", prop);
            } else if (propName.equals("Obs Color")) {
                prop = new SgObsColor(this);
                this.addObsPropertyModel("Obs Color", prop);
            } else if (propName.equals("Obs Marker Shape")) {
                prop = new SgObsMarker(this);
                this.addObsPropertyModel("Obs Marker Shape", prop);
            } else if (propName.equals("Obs Graphed")) {
                prop = new SgObsBooleanProp(this, true);
                this.addObsPropertyModel("Obs Graphed", prop);
            }
        }
        return prop;
    }

    public void addVarPropertyModel(String propName, VarPropertyModel propModel) {
        this.addPropertyModel(this.m_varPropModels, propName, propModel);
    }

    public void removeVarPropertyModel(String propName) {
        this.removePropertyModel(this.m_varPropModels, propName);
    }

    public boolean isVarPropertyModelExist(String propName) {
        return this.isPropertyModelExist(this.m_varPropModels, propName);
    }

    public VarPropertyModel getVarPropertyModel(String propName) {
        return (VarPropertyModel)this.getPropertyModel(this.m_varPropModels, propName);
    }

    public void addCustomPropertyModel(String propName, DataPropertyModel propModel) {
        this.addPropertyModel(this.m_customPropModels, propName, propModel);
    }

    public void removeCustomPropertyModel(String propName) {
        this.removePropertyModel(this.m_customPropModels, propName);
    }

    public boolean isCustomPropertyModelExist(String propName) {
        return this.isPropertyModelExist(this.m_customPropModels, propName);
    }

    public DataPropertyModel getCustomPropertyModel(String propName) {
        return (DataPropertyModel)this.getPropertyModel(this.m_customPropModels, propName);
    }

    public ObsPermutationModel getObsPermutation(PermutationPolicy policy) {
        if (policy == null) {
            throw new IllegalArgumentException();
        }
        ObsPermutationModel permute = (ObsPermutationModel)this.m_obsPermutations.get(policy);
        if (permute == null) {
            Iterator iterator = this.m_obsPermutations.keySet().iterator();
            while (permute == null && iterator.hasNext()) {
                Object key = iterator.next();
                if (!key.equals(policy)) continue;
                permute = (ObsPermutationModel)this.m_obsPermutations.get(key);
            }
        }
        if (permute == null) {
            try {
                permute = (ObsPermutationModel)policy.getPermutationClass().newInstance();
                permute.init((DataModel)this, policy);
                permute.doPermutation();
                this.addObsPermutation(permute);
            }
            catch (Exception e) {
                permute = null;
            }
        }
        return permute;
    }

    public ObsPermutationModel getObsPermutation(PermutationPolicy policy, String permutationClassName) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        boolean found;
        if (policy == null) {
            throw new IllegalArgumentException();
        }
        ObsPermutationModel permute = (ObsPermutationModel)this.m_obsPermutations.get(policy);
        boolean bl = found = permute != null;
        if (permute == null && permutationClassName == null) {
            permute = new SgObsSortContext();
            permute.init((DataModel)this, policy);
        }
        if (permute != null) {
            if (permutationClassName != null && !permute.getClass().getName().equals(permutationClassName)) {
                throw new IllegalArgumentException("Attempt to use the same policy for different permutation classes");
            }
            if (!found) {
                this.m_obsPermutations.put(policy, permute);
                permute.addReference();
            }
            return permute;
        }
        Class<?> c = Class.forName(permutationClassName);
        Class<?>[] theInterfaces = c.getInterfaces();
        found = false;
        for (int i = 0; i < theInterfaces.length && !found; ++i) {
            if (theInterfaces[i] != ObsPermutationModel.class) continue;
            found = true;
        }
        if (!found) {
            throw new IllegalArgumentException(permutationClassName + " does not implement ObsPermutationModel interface");
        }
        permute = (ObsPermutationModel)c.newInstance();
        permute.init((DataModel)this, policy);
        this.m_obsPermutations.put(policy, permute);
        permute.addReference();
        return permute;
    }

    public void addObsPermutation(ObsPermutationModel permutation) {
        if (permutation == null) {
            throw new IllegalArgumentException();
        }
        PermutationPolicy policy = permutation.getPolicy();
        if (policy == null) {
            throw new IllegalArgumentException("Permutation has no key");
        }
        if (!this.m_obsPermutations.containsKey(policy)) {
            this.m_obsPermutations.put(policy, permutation);
            permutation.addReference();
        }
    }

    public void releaseObsPermutation(ObsPermutationModel permutation) {
        if (permutation == null) {
            throw new IllegalArgumentException();
        }
        this.releaseObsPermutation(permutation.getPolicy());
    }

    public void releaseObsPermutation(PermutationPolicy policy) {
        ObsPermutationModel permutation = this.getObsPermutation(policy);
        if (permutation != null) {
            permutation.release();
            if (permutation.getNumReferences() == 0) {
                this.m_obsPermutations.remove(policy);
            }
        }
    }

    public void addDataModelListener(DataModelListener listener) {
        if (listener != null && this.m_listenerList.indexOf(listener) < 0) {
            this.m_listenerList.add(listener);
        }
    }

    public void removeDataModelListener(DataModelListener listener) {
        this.m_listenerList.remove(listener);
    }

    protected void fireObsChange(ObsDataEvent event) {
        int numListeners = this.m_listenerList.size();
        for (int i = 0; i < numListeners; ++i) {
            ((DataModelListener)this.m_listenerList.get(i)).obsChanged((DataModelEvent)event);
        }
    }

    protected void fireVarChange(VarDataEvent event) {
        int numListeners = this.m_listenerList.size();
        for (int i = 0; i < numListeners; ++i) {
            ((DataModelListener)this.m_listenerList.get(i)).varChanged((DataModelEvent)event);
        }
    }

    protected void fireValueChange(ValueDataEvent event) {
        int numListeners = this.m_listenerList.size();
        for (int i = 0; i < numListeners; ++i) {
            ((DataModelListener)this.m_listenerList.get(i)).valueChanged((DataModelEvent)event);
        }
    }

    public void addDataAnimator(DataAnimator animator) {
        if (this.m_animatorList.indexOf(animator) < 0) {
            this.m_animatorList.add(animator);
        }
    }

    public void removeDataAnimator(DataAnimator animator) {
        this.m_animatorList.remove(animator);
    }

    public void stopAnimation(Object requestor) {
        int numAnimators = this.m_animatorList.size();
        for (int i = 0; i < numAnimators; ++i) {
            ((DataAnimator)this.m_animatorList.get(i)).stopAnimation(requestor);
        }
    }
}

