/*
 * Decompiled with CFR 0.152.
 */
package com.sas.batch.core;

import com.sas.batch.core.RB;
import com.sas.text.Message;
import com.sas.util.DatePeriod;
import com.sas.util.DateTypes;
import com.sas.util.ValueItem;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DateParser {
    public static final DateFormat DATE_FORMAT_SHORT = DateFormat.getDateInstance(3);
    private static Locale _locale = Locale.getDefault();
    private static final String HIDDEN = "HIDDEN";
    public static final String DATE_TODAY = RB.getStringResource("DateParser.Today.txt");
    public static final String DATE_YESTERDAY = RB.getStringResource("DateParser.Yesterday.txt");
    public static final String DATE_ONE_YEAR_AGO = RB.getStringResource("DateParser.CurrentDayLastYear.txt");
    public static final String DATE_ONE_MONTH_AGO = RB.getStringResource("DateParser.CurrentDayLastMonth.txt");
    public static final String DATE_ONE_WEEK_AGO = RB.getStringResource("DateParser.CurrentDayLastWeek.txt");
    public static final String DATE_N_DAYS_AGO = RB.getStringResource("DateParser.NDaysAgo.txt");
    public static final String DAYS_AGO = RB.getStringResource("DateParser.DaysAgo.txt");
    private static final Pattern DAYS_AGO_PATTERN = Pattern.compile("([0-9a-zA-Z.]+) " + DAYS_AGO);
    public static final String RANGE_YEAR_TO_DATE = RB.getStringResource("DatePeriod.YearToDate.txt");
    public static final String RANGE_MONTH_TO_DATE = RB.getStringResource("DatePeriod.MonthToDate.txt");
    public static final String RANGE_WEEK_TO_DATE = RB.getStringResource("DatePeriod.WeekToDate.txt");
    public static final String RANGE_LAST_YEAR = RB.getStringResource("DatePeriod.LastYear.txt");
    public static final String RANGE_LAST_MONTH = RB.getStringResource("DatePeriod.LastMonth.txt");
    public static final String RANGE_LAST_WEEK = RB.getStringResource("DatePeriod.LastWeek.txt");
    public static final String RANGE_PREVIOUS_DAYS_AGO = RB.getStringResource("DatePeriod.PreviousNDays.txt");
    private List<ValueItem> _relativeDatesList;
    private List<ValueItem> _rangeOptionsList;
    private List<DateFormat> _formatsList;
    private static DateParser _instance;

    private DateParser() {
        this.createRangeOptions();
        this._relativeDatesList = this.createRelativeDateOptions();
        this.createAbsoluteDateFormats();
    }

    public static synchronized DateParser getInstance() {
        if (_instance == null) {
            _instance = new DateParser();
        }
        return _instance;
    }

    public static String formatDate(Date date, DateFormat df) {
        return df.format(date);
    }

    public List<ValueItem> getRangeOptions() {
        return this._rangeOptionsList;
    }

    public List<ValueItem> getRelativeFromDateOptions() {
        List<ValueItem> fromDatesList = this.createRelativeDateOptions();
        return fromDatesList;
    }

    public List<ValueItem> getRelativeToDateOptions() {
        List<ValueItem> toDatesList = this.createRelativeDateOptions();
        return toDatesList;
    }

    public List<ValueItem> getRelativeDateOptions() {
        return this._relativeDatesList;
    }

    public List<DateFormat> getDateFormats() {
        return this._formatsList;
    }

    public Date parseDate(String date) throws IllegalArgumentException {
        if (date == null || date.length() == 0) {
            return null;
        }
        Date relativeDate = this.getRelativeDate(date = date.trim());
        if (relativeDate != null) {
            return relativeDate;
        }
        for (DateFormat format : this._formatsList) {
            try {
                Date d = format.parse(date);
                if (d == null) continue;
                return d;
            }
            catch (ParseException e) {
            }
        }
        String msg = Message.format((ResourceBundle)RB.getResources(), (String)"DateParser.InvalidDateFormat.fmt.txt", (Object)date);
        throw new IllegalArgumentException(msg);
    }

    public String[] getAbsoluteDatePatterns() {
        ArrayList<String> patterns = new ArrayList<String>();
        for (DateFormat format : this._formatsList) {
            patterns.add(((SimpleDateFormat)format).toPattern());
        }
        return patterns.toArray(new String[patterns.size()]);
    }

    public String[] getRelativeDatePatterns() {
        ArrayList<String> patterns = new ArrayList<String>();
        this.addRelativeDates(patterns, this._relativeDatesList);
        this.addRelativeDates(patterns, this._rangeOptionsList);
        return patterns.toArray(new String[patterns.size()]);
    }

    public String getRelativeDateLabel(Date date) {
        if (date instanceof DatePeriod && ((DatePeriod)date).isRelativeDate()) {
            for (ValueItem item : this._relativeDatesList) {
                Object value = item.getValue();
                if (value != date) continue;
                return item.getLabel();
            }
        }
        return null;
    }

    private void addRelativeDates(List<String> patterns, List<ValueItem> dateList) {
        for (ValueItem item : dateList) {
            if (item.getAttribute(HIDDEN) == Boolean.TRUE) continue;
            patterns.add(item.getLabel());
        }
    }

    private Date getRelativeDate(String date) {
        String label;
        for (ValueItem item : this._relativeDatesList) {
            label = item.getLabel();
            if (!date.equalsIgnoreCase(label)) continue;
            return (Date)item.getValue();
        }
        for (ValueItem item : this._rangeOptionsList) {
            Object value;
            label = item.getLabel();
            if (!date.equalsIgnoreCase(label) || (value = item.getValue()) == null || !(value instanceof Object[])) continue;
            Object[] v = (Object[])value;
            return (Date)v[0];
        }
        Date nDaysAgo = this.getNDaysAgoDate(date);
        if (nDaysAgo != null) {
            return nDaysAgo;
        }
        return null;
    }

    private Date getNDaysAgoDate(String date) throws IllegalArgumentException {
        Matcher m = DAYS_AGO_PATTERN.matcher(date);
        if (m.find()) {
            String daysAgo = m.group(1);
            try {
                int days = Integer.parseInt(daysAgo);
                if (days < 0) {
                    throw new IllegalArgumentException(RB.getStringResource("DateParser.ParseFailed.NDaysAgo.txt"));
                }
                DatePeriod dp = new DatePeriod(DateTypes.DATE, _locale);
                dp.setNDays(0 - days);
                return dp;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(RB.getStringResource("DateParser.ParseFailed.NDaysAgo.txt"));
            }
        }
        return null;
    }

    private void createRangeOptions() {
        this._rangeOptionsList = new ArrayList<ValueItem>(4);
        ValueItem yearDate = new ValueItem((Object)RANGE_YEAR_TO_DATE, (Object)new Object[]{new DatePeriod(DateTypes.DATE, DateTypes.YEAR, 1, _locale), new DatePeriod(DateTypes.DATE, _locale)});
        this._rangeOptionsList.add(yearDate);
        ValueItem monthDate = new ValueItem((Object)RANGE_MONTH_TO_DATE, (Object)new Object[]{new DatePeriod(DateTypes.DATE, DateTypes.MONTH, 1, _locale), new DatePeriod(DateTypes.DATE, _locale)});
        this._rangeOptionsList.add(monthDate);
        ValueItem weekDate = new ValueItem((Object)RANGE_WEEK_TO_DATE, (Object)new Object[]{new DatePeriod(DateTypes.DATE, DateTypes.WEEK, 1, _locale), new DatePeriod(DateTypes.DATE, _locale)});
        this._rangeOptionsList.add(weekDate);
    }

    private List<ValueItem> createRelativeDateOptions() {
        ArrayList<ValueItem> datesList = new ArrayList<ValueItem>(6);
        ValueItem today = new ValueItem((Object)DATE_TODAY, (Object)new DatePeriod(DateTypes.DATE, 0, 0, 0, 0, 0, 0, 0, _locale));
        datesList.add(today);
        ValueItem yesterday = new ValueItem((Object)DATE_YESTERDAY, (Object)new DatePeriod(DateTypes.DATE, 0, 0, 0, 0, -1, 0, 0, _locale));
        datesList.add(yesterday);
        ValueItem lastYear = new ValueItem((Object)DATE_ONE_YEAR_AGO, (Object)new DatePeriod(DateTypes.DATE, -1, 0, 0, 0, 0, 0, 0, _locale));
        datesList.add(lastYear);
        ValueItem lastMonth = new ValueItem((Object)DATE_ONE_MONTH_AGO, (Object)new DatePeriod(DateTypes.DATE, 0, 0, -1, 0, 0, 0, 0, _locale));
        datesList.add(lastMonth);
        ValueItem lastWeek = new ValueItem((Object)DATE_ONE_WEEK_AGO, (Object)new DatePeriod(DateTypes.DATE, 0, 0, 0, -1, 0, 0, 0, _locale));
        datesList.add(lastWeek);
        ValueItem nDaysAgo = new ValueItem((Object)DATE_N_DAYS_AGO, (Object)new DatePeriod(DateTypes.DATE, _locale));
        nDaysAgo.setAttribute("RELATIVE_TYPE", (Object)"N_AGO");
        nDaysAgo.setAttribute("PERIOD_TYPE", (Object)DateTypes.DATE);
        datesList.add(nDaysAgo);
        return datesList;
    }

    private void createAbsoluteDateFormats() {
        this._formatsList = new ArrayList<DateFormat>(8);
        this._formatsList.add(DATE_FORMAT_SHORT);
        this._formatsList.add(new SimpleDateFormat("ddMMMyy:HH:mm:ss"));
        this._formatsList.add(new SimpleDateFormat("ddMMMyy"));
        this._formatsList.add(new SimpleDateFormat("ddMMMyyyy:HH:mm:ss"));
        this._formatsList.add(new SimpleDateFormat("ddMMMyyyy"));
        this._formatsList.add(new SimpleDateFormat("MM/dd/yyyy HH:mm:ss"));
        this._formatsList.add(new SimpleDateFormat("MM/dd/yyyy"));
        this._formatsList.add(new SimpleDateFormat("yyyyMMdd:HH:mm:ss"));
        this._formatsList.add(new SimpleDateFormat("yyyyMMdd"));
    }
}

