/*
 * Decompiled with CFR 0.152.
 */
package com.sas.batch.core;

import com.sas.batch.core.DateParser;
import com.sas.batch.core.RB;
import com.sas.text.Message;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public abstract class BaseFilterOptions {
    private static final String NEW_LINE = "\r\n";
    public static final String OPTION_FOLDER = "folder";
    public static final String OPTION_FOLDER_TREE = "folderTree";
    public static final String OPTION_TYPES = "types";
    public static final String OPTION_EXCLUDE_SUBTYPES = "excludeSubTypes";
    public static final String OPTION_NAME = "name";
    public static final String OPTION_NAME_MATCH_TYPE = "nameMatchType";
    public static final String OPTION_INCLUDE_DESCRIPTION = "includeDesc";
    public static final String OPTION_CREATED_DATE = "created";
    public static final String OPTION_MODIFIED_DATE = "modified";
    public static final String OPTION_SINCE_DATE = "since";
    public static final String OPTION_BEFORE_DATE = "before";
    public static final String OPTION_KEYWORDS = "keywords";
    public static final String OPTION_NOTES = "notes";
    public static final String OPTION_EXTENSIONS_NAME = "extName";
    public static final String OPTION_EXTENSIONS_VALUE = "extValue";
    public static final String OPTION_RESP_USERNAME = "respName";
    public static final String OPTION_RESP_ROLE = "respRole";
    protected String filterFolder;
    protected String filterFolderTree;
    protected String name;
    protected String nameMatchType;
    protected boolean includeDescription;
    protected List<String> types;
    protected boolean excludeSubtypes = false;
    protected String sinceDate;
    protected String beforeDate;
    protected boolean created;
    protected boolean modified;
    protected List<String> keywords;
    protected String respUserName;
    protected String respRole;

    public void parse(CommandLine commandLine) {
        String[] typesOption;
        if (commandLine.hasOption(OPTION_FOLDER)) {
            this.filterFolder = commandLine.getOptionValue(OPTION_FOLDER);
        }
        if (commandLine.hasOption(OPTION_FOLDER_TREE)) {
            this.filterFolderTree = commandLine.getOptionValue(OPTION_FOLDER_TREE);
        }
        if ((typesOption = commandLine.getOptionValues(OPTION_TYPES)) != null && typesOption.length > 0) {
            this.types = Arrays.asList(typesOption);
            if (commandLine.hasOption(OPTION_EXCLUDE_SUBTYPES)) {
                this.excludeSubtypes = true;
            }
        }
        this.name = commandLine.getOptionValue(OPTION_NAME);
        this.nameMatchType = commandLine.getOptionValue(OPTION_NAME_MATCH_TYPE);
        this.includeDescription = commandLine.hasOption(OPTION_INCLUDE_DESCRIPTION);
        this.sinceDate = commandLine.getOptionValue(OPTION_SINCE_DATE);
        this.beforeDate = commandLine.getOptionValue(OPTION_BEFORE_DATE);
        this.created = commandLine.hasOption(OPTION_CREATED_DATE);
        this.modified = commandLine.hasOption(OPTION_MODIFIED_DATE);
        String[] keywordsOption = commandLine.getOptionValues(OPTION_KEYWORDS);
        if (keywordsOption != null && keywordsOption.length > 0) {
            this.keywords = Arrays.asList(keywordsOption);
        }
        this.respUserName = commandLine.getOptionValue(OPTION_RESP_USERNAME);
        this.respRole = commandLine.getOptionValue(OPTION_RESP_ROLE);
    }

    public void addToOptions(Options options) {
        Option option = new Option(OPTION_FOLDER, true, RB.getStringResource("BaseFilterOptions.Folder.Desc.txt"));
        option.setArgName(RB.getStringResource("BaseFilterOptions.Folder.ArgName.txt"));
        options.addOption(option);
        option = new Option(OPTION_FOLDER_TREE, true, RB.getStringResource("BaseFilterOptions.FolderTree.Desc.txt"));
        option.setArgName(RB.getStringResource("BaseFilterOptions.FolderTree.ArgName.txt"));
        options.addOption(option);
        option = new Option(OPTION_TYPES, true, RB.getStringResource("BaseFilterOptions.Types.Desc.txt"));
        option.setArgName(RB.getStringResource("BaseFilterOptions.Types.ArgName.txt"));
        option.setArgs(-2);
        options.addOption(option);
        option = new Option(OPTION_EXCLUDE_SUBTYPES, RB.getStringResource("BaseFilterOptions.ExcludeSubTypes.Desc.txt"));
        options.addOption(option);
        option = new Option(OPTION_NAME, true, RB.getStringResource("BaseFilterOptions.Name.Desc.txt"));
        option.setArgName(RB.getStringResource("BaseFilterOptions.Name.ArgName.txt"));
        options.addOption(option);
        option = new Option(OPTION_NAME_MATCH_TYPE, true, RB.getStringResource("BaseFilterOptions.NameMatchType.Desc.txt"));
        option.setArgName(RB.getStringResource("BaseFilterOptions.NameMatchType.ArgName.txt"));
        options.addOption(option);
        option = new Option(OPTION_INCLUDE_DESCRIPTION, RB.getStringResource("BaseFilterOptions.IncludeDescription.Desc.txt"));
        options.addOption(option);
        option = new Option(OPTION_CREATED_DATE, RB.getStringResource("BaseFilterOptions.CreatedDate.Desc.txt"));
        options.addOption(option);
        option = new Option(OPTION_MODIFIED_DATE, RB.getStringResource("BaseFilterOptions.ModifiedDate.Desc.txt"));
        options.addOption(option);
        option = new Option(OPTION_SINCE_DATE, true, this.getSinceDateDescriptor());
        option.setArgName(RB.getStringResource("BaseFilterOptions.SinceDate.ArgName.txt"));
        options.addOption(option);
        option = new Option(OPTION_BEFORE_DATE, true, RB.getStringResource("BaseFilterOptions.BeforeDate.Desc.txt"));
        option.setArgName(RB.getStringResource("BaseFilterOptions.BeforeDate.ArgName.txt"));
        options.addOption(option);
        option = new Option(OPTION_KEYWORDS, true, RB.getStringResource("BaseFilterOptions.Keywords.Desc.txt"));
        option.setArgName(RB.getStringResource("BaseFilterOptions.Keywords.ArgName.txt"));
        option.setArgs(-2);
        options.addOption(option);
        option = new Option(OPTION_RESP_USERNAME, true, RB.getStringResource("BaseFilterOptions.RespName.Desc.txt"));
        option.setArgName(RB.getStringResource("BaseFilterOptions.RespName.ArgName.txt"));
        options.addOption(option);
        option = new Option(OPTION_RESP_ROLE, true, RB.getStringResource("BaseFilterOptions.RespRole.Desc.txt"));
        option.setArgName(RB.getStringResource("BaseFilterOptions.RespRole.ArgName.txt"));
        options.addOption(option);
    }

    private String getSinceDateDescriptor() {
        DateParser parser = DateParser.getInstance();
        String[] absoluteDatePatterns = parser.getAbsoluteDatePatterns();
        String[] relativeDatePatterns = parser.getRelativeDatePatterns();
        String dateInfo = Message.format((ResourceBundle)RB.getResources(), (String)"BaseFilterOptions.DateInfo.fmt.txt", (Object)this.getDisplayTextForPatterns(absoluteDatePatterns), (Object)this.getDisplayTextForPatterns(relativeDatePatterns));
        StringBuffer desc = new StringBuffer();
        desc.append(RB.getStringResource("BaseFilterOptions.SinceDate.Desc.txt"));
        desc.append(NEW_LINE).append(dateInfo);
        return desc.toString();
    }

    private String getDisplayTextForPatterns(String[] patterns) {
        StringBuffer sb = new StringBuffer();
        if (patterns != null && patterns.length > 0) {
            sb.append(NEW_LINE);
            int length = patterns.length;
            for (int i = 0; i < length; ++i) {
                sb.append("\"").append(patterns[i]).append("\"");
                if (i == length - 1) continue;
                sb.append(", ");
            }
        }
        return sb.toString();
    }

    protected final void validateDateOptions(String sinceDate, String beforeDate) {
        DateParser parser = DateParser.getInstance();
        Date beginDate = parser.parseDate(sinceDate);
        Date endDate = parser.parseDate(beforeDate);
        this.validateDateOptions(beginDate, endDate);
    }

    protected final void validateDateOptions(Date sinceDate, Date beforeDate) {
        if (sinceDate != null && beforeDate != null && beforeDate.before(sinceDate)) {
            throw new IllegalArgumentException(RB.getStringResource("BaseFilterOptions.InvalidDateRange.txt"));
        }
    }
}

