/*
 * Decompiled with CFR 0.152.
 */
package com.sas.batch.core;

import com.sas.batch.core.RB;
import com.sas.codepolicy.SASScopeExtension;
import com.sas.text.Message;
import java.io.File;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.layout.PatternLayout;

@SASScopeExtension(value="sas")
public abstract class AbstractBatchUtility2 {
    public static final int SUCCESS = 0;
    public static final int WARNING = 4;
    public static final int ERROR = 8;
    protected static final String MAIN_CLI_GROUP = "MAIN_GROUP";
    public static final String OPTION_DEBUG = "debug";
    public static final String OPTION_HELP = "?";
    public static final String OPTION_HELP_LONG = "help";
    public static final String OPTION_LOG = "log";
    public static final String OPTION_NOLOG = "nolog";
    private Map<String, CommandLine> commandLines;
    protected CommandLine commandLine;
    protected int returnCode = 0;
    protected Logger logger;
    protected boolean debug = false;
    protected String utilityName = this.getClass().getSimpleName();
    private String logFileOption = null;
    private String logFilePrefix = null;
    private boolean logTimestamps = false;
    private boolean appendToLogFile = true;
    private boolean logFileTimestamp = false;
    private boolean logDecorations = false;
    protected String logFileName;
    private ConsoleAppender consoleAppender;
    private Appender logFileAppender;

    protected AbstractBatchUtility2() {
        this.logger = LogManager.getLogger((String)this.getClass().getPackage().getName());
        this.commandLines = new HashMap<String, CommandLine>(3);
    }

    protected final CommandLine getCommandLine(String groupName) {
        if (groupName == null) {
            groupName = MAIN_CLI_GROUP;
        }
        return this.commandLines.get(groupName);
    }

    public boolean isLogDecorations() {
        return this.logDecorations;
    }

    public void setLogDecorations(boolean logDecorations) {
        this.logDecorations = logDecorations;
    }

    public void setLogFile(String logFileOrDirectory) {
        if (this.logFileAppender != null) {
            throw new IllegalStateException("Log options may not be set after the log has been created.");
        }
        this.logFileOption = logFileOrDirectory;
    }

    protected void setLogFilePrefix(String logFilePrefix) {
        if (this.logFileAppender != null) {
            throw new IllegalStateException("Log options may not be set after the log has been created.");
        }
        this.logFilePrefix = logFilePrefix;
    }

    protected void setLogFileTimestamp(boolean logFileTimestamp) {
        if (this.logFileAppender != null) {
            throw new IllegalStateException("Log options may not be set after the log has been created.");
        }
        this.logFileTimestamp = logFileTimestamp;
    }

    protected void setLogTimestamps(boolean logTimestamps) {
        if (this.logFileAppender != null || this.consoleAppender != null) {
            throw new IllegalStateException("Log options may not be set after the log has been created.");
        }
        this.logTimestamps = logTimestamps;
    }

    protected void setAppendToLogFile(boolean append) {
        if (this.logFileAppender != null) {
            throw new IllegalStateException("Log options may not be set after the log has been created.");
        }
        this.appendToLogFile = append;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
        if (debug) {
            this.logTimestamps = true;
        }
    }

    protected Options getCommandLineOptions(boolean forHelpText) {
        Option option;
        Options commandLineOptions = new Options();
        if (!forHelpText) {
            option = new Option(OPTION_DEBUG, false, RB.getStringResource("AbstractBatchUtility.Debug.Desc.txt"));
            option.setRequired(false);
            commandLineOptions.addOption(option);
        }
        option = new Option(OPTION_HELP, OPTION_HELP_LONG, false, RB.getStringResource("AbstractBatchUtility.Help.Desc.txt"));
        option.setRequired(false);
        commandLineOptions.addOption(option);
        option = new Option(OPTION_LOG, true, RB.getStringResource("AbstractBatchUtility.Log.Desc.txt"));
        option.setArgName(RB.getStringResource("AbstractBatchUtility.Log.ArgName.txt"));
        option.setRequired(false);
        commandLineOptions.addOption(option);
        if (!forHelpText || this.logFileOption != null) {
            option = new Option(OPTION_NOLOG, false, RB.getStringResource("AbstractBatchUtility.Nolog.Desc.txt"));
            option.setRequired(false);
            commandLineOptions.addOption(option);
        }
        return commandLineOptions;
    }

    protected Options getCommandLineOptions(boolean forHelpText, String groupName) {
        Options nestedOptions = new Options();
        return nestedOptions;
    }

    protected List<String> getNestedOptionGroups() {
        return null;
    }

    protected boolean parse(String[] args) throws ParseException, MissingOptionException {
        if (args == null || args.length == 0 || args[0].equalsIgnoreCase("-?") || args[0].equalsIgnoreCase("--help")) {
            this.displayHelp();
            return false;
        }
        Map<String, String[]> groupArgs = null;
        List<String> nestedOptionGroups = this.getNestedOptionGroups();
        if (nestedOptionGroups != null && !nestedOptionGroups.isEmpty()) {
            NestedOptionsParser parser = new NestedOptionsParser();
            parser.parse(args, nestedOptionGroups);
            args = parser.getUpdatedArgList();
            groupArgs = parser.getNestedOptions();
        }
        this.commandLine = this.parseOptions(args, null);
        if (this.commandLine.hasOption(OPTION_HELP)) {
            this.displayHelp();
            return false;
        }
        if (this.commandLine.hasOption(OPTION_LOG)) {
            this.setLogFile(this.commandLine.getOptionValue(OPTION_LOG));
        } else if (this.commandLine.hasOption(OPTION_NOLOG)) {
            this.setLogFile(null);
        }
        if (this.commandLine.hasOption(OPTION_DEBUG)) {
            this.setDebug(true);
        }
        if (groupArgs != null && groupArgs.size() > 0) {
            for (String group : groupArgs.keySet()) {
                String[] argArray = groupArgs.get(group);
                this.parseOptions(argArray, group);
            }
        }
        return true;
    }

    private CommandLine parseOptions(String[] args, String groupName) throws ParseException {
        Options options = null;
        options = groupName == null || MAIN_CLI_GROUP.equalsIgnoreCase(groupName) ? this.getCommandLineOptions(false) : this.getCommandLineOptions(false, groupName);
        CommandLine cl = new DefaultParser().parse(options, args);
        this.commandLines.put(groupName == null ? MAIN_CLI_GROUP : groupName, cl);
        return cl;
    }

    protected abstract void displayHelp();

    protected void displayHelp(String ... usages) {
        int width = 80;
        HelpFormatter help = new HelpFormatter();
        PrintWriter pw = new PrintWriter(System.out);
        for (String usage : usages) {
            help.printUsage(pw, 80, usage);
            pw.println();
        }
        Options helpOptions = this.getCommandLineOptions(true);
        help.printWrapped(pw, 80, "Standard options:");
        help.printOptions(pw, 80, helpOptions, 2, 2);
        List<String> nestedOptionGroups = this.getNestedOptionGroups();
        if (nestedOptionGroups != null && !nestedOptionGroups.isEmpty()) {
            for (String optionGroup : nestedOptionGroups) {
                help.printWrapped(pw, 80, help.getNewLine());
                help.printWrapped(pw, 80, optionGroup + " options:");
                Options nestedHelpOptions = this.getCommandLineOptions(true, optionGroup);
                help.printOptions(pw, 80, nestedHelpOptions, 2, 2);
            }
        }
        pw.flush();
    }

    public Logger getLogger() {
        return this.logger;
    }

    public String getLogFileName() {
        return this.logFileName;
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    protected void initializeBatchLogging() {
        String pattern = (this.logTimestamps ? RB.getStringResource("AbstractBatchUtility.LogPatternTimePrefix.txt") + " " : "") + (this.debug ? RB.getStringResource("AbstractBatchUtility.LogPatternDebug.txt") : RB.getStringResource("AbstractBatchUtility.LogPattern.txt"));
        LoggerContext lc = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = lc.getConfiguration();
        PatternLayout layout = PatternLayout.newBuilder().withConfiguration(config).withPattern(pattern).build();
        this.consoleAppender = ((ConsoleAppender.Builder)((ConsoleAppender.Builder)((ConsoleAppender.Builder)ConsoleAppender.newBuilder().setName("SASConsoleAppender")).setConfiguration(config)).setLayout((Layout)layout)).build();
        this.consoleAppender.start();
        config.addAppender((Appender)this.consoleAppender);
        lc.getRootLogger().addAppender((Appender)this.consoleAppender);
        this.logFileAppender = this.makeLogFileAppender(layout);
        if (this.logFileAppender != null) {
            lc.getRootLogger().addAppender(this.logFileAppender);
        }
        lc.getRootLogger().setLevel(Level.WARN);
        if (this.debug) {
            Configurator.setLevel((String)this.logger.getName(), (Level)Level.DEBUG);
        } else {
            Configurator.setLevel((String)this.logger.getName(), (Level)Level.INFO);
        }
        lc.updateLoggers();
    }

    protected void terminateBatchLogging() {
        LoggerContext lc = (LoggerContext)LogManager.getContext((boolean)false);
        if (this.consoleAppender != null) {
            lc.getRootLogger().removeAppender((Appender)this.consoleAppender);
            this.consoleAppender.stop();
        }
        if (this.logFileAppender != null) {
            lc.getRootLogger().removeAppender(this.logFileAppender);
            this.logFileAppender.stop();
        }
        lc.updateLoggers();
    }

    protected Appender makeLogFileAppender(PatternLayout layout) {
        if (this.logFileOption == null) {
            return null;
        }
        this.logFileName = null;
        File testLogFile = new File(this.logFileOption);
        if (testLogFile.isDirectory()) {
            String suffix;
            String fileSep = System.getProperty("file.separator");
            if (this.logFileOption.endsWith(fileSep)) {
                fileSep = "";
            }
            if (this.logFileTimestamp) {
                SimpleDateFormat sdf = new SimpleDateFormat("_yyMMddHHmmss'.log'");
                suffix = sdf.format(new Date());
            } else {
                suffix = ".log";
            }
            if (this.logFilePrefix == null) {
                this.logFilePrefix = this.utilityName;
            }
            this.logFileName = this.logFileOption + fileSep + this.logFilePrefix + suffix;
        } else {
            this.logFileName = this.logFileOption;
        }
        LoggerContext lc = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = lc.getConfiguration();
        FileAppender fileAppender = ((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)FileAppender.newBuilder().setName(this.logFileName)).withFileName(this.logFileName).setLayout((Layout)layout)).withAppend(this.appendToLogFile).setConfiguration(config)).build();
        fileAppender.start();
        return fileAppender;
    }

    protected void logStart() {
        if (!this.logDecorations) {
            return;
        }
        this.logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"AbstractBatchUtility.Start.fmt.log", (Object)this.utilityName, (Object)new Date()));
    }

    protected void logCompletion() {
        if (!this.logDecorations) {
            return;
        }
        if (this.returnCode == 0) {
            System.out.println(Message.format((ResourceBundle)RB.getResources(), (String)"AbstractBatchUtility.Complete.fmt.txt", (Object)this.utilityName));
        } else if (this.returnCode == 4) {
            System.out.println(Message.format((ResourceBundle)RB.getResources(), (String)"AbstractBatchUtility.CompleteWarning.fmt.txt", (Object)this.utilityName));
        } else {
            System.out.println(Message.format((ResourceBundle)RB.getResources(), (String)"AbstractBatchUtility.CompleteError.fmt.txt", (Object)this.utilityName));
        }
        if (this.logFileName != null) {
            System.out.println(Message.format((ResourceBundle)RB.getResources(), (String)"AbstractBatchUtility.LogSaved.fmt.txt", (Object)this.logFileName));
        }
    }

    protected void logException(Throwable t) {
        this.returnCode = 8;
        if (t instanceof ParseException) {
            System.err.println(RB.getStringResource("AbstractBatchUtility.InvalidSyntax.log"));
            System.err.println(t.getLocalizedMessage());
            return;
        }
        String msg = Message.format((ResourceBundle)RB.getResources(), (String)"AbstractBatchUtility.Failed.fmt.txt", (Object)this.utilityName, (Object)t.getLocalizedMessage());
        LoggerContext context = LoggerContext.getContext((boolean)false);
        Configuration configuration = context.getConfiguration();
        LoggerConfig loggerConfig = configuration.getRootLogger();
        if (this.logger != null && !loggerConfig.getAppenders().isEmpty()) {
            this.logger.error(msg);
            if (t.getCause() != null) {
                this.logger.error(t.getCause().getLocalizedMessage());
            }
            if (this.debug) {
                for (StackTraceElement trace : t.getStackTrace()) {
                    this.logger.error("  at " + trace.toString());
                }
            }
        } else {
            System.err.println(msg);
            if (t.getCause() != null) {
                System.err.println("  " + t.getCause().getLocalizedMessage());
            }
            if (this.debug) {
                t.printStackTrace();
            }
        }
    }

    protected static Options getHelpOptions(Options allOptions, String[] optionsToExclude) {
        if (allOptions == null || optionsToExclude == null || optionsToExclude.length == 0) {
            return allOptions;
        }
        Options helpOptions = new Options();
        Collection options = allOptions.getOptions();
        for (Option option : options) {
            String name = option.getOpt();
            boolean include = true;
            for (String optionToExclude : optionsToExclude) {
                if (!name.equalsIgnoreCase(optionToExclude)) continue;
                include = false;
                break;
            }
            if (!include) continue;
            helpOptions.addOption(option);
        }
        return helpOptions;
    }

    private class NestedOptionsParser {
        Map<String, String[]> nestedOptions;
        List<String> argList;

        private NestedOptionsParser() {
        }

        public void parse(String[] args, List<String> groupNames) throws ParseException {
            this.nestedOptions = new HashMap<String, String[]>(groupNames.size());
            this.argList = new ArrayList<String>();
            for (int index = 0; index < args.length; ++index) {
                String shortArg;
                String arg = args[index];
                this.argList.add(arg);
                if (arg.charAt(0) != '-' || !groupNames.contains(shortArg = arg.substring(1))) continue;
                if (index == args.length - 1) {
                    throw new ParseException(RB.getStringResource("AbstractBatchUtility.InvalidNestedSyntax.NoneFound.txt"));
                }
                int nestedIndex = index + 1;
                String nestedArgGroup = args[nestedIndex];
                if (nestedArgGroup.equalsIgnoreCase("{")) {
                    ++nestedIndex;
                } else if (!nestedArgGroup.startsWith("{")) {
                    throw new ParseException(RB.getStringResource("AbstractBatchUtility.InvalidNestedSyntax.Start.txt"));
                }
                ArrayList<String> nestedArgs = new ArrayList<String>();
                int count = 0;
                boolean doneParsing = false;
                while (nestedIndex < args.length) {
                    String nestedArg = args[nestedIndex];
                    if (count == 0 && nestedArg.startsWith("{")) {
                        nestedArg = nestedArg.substring(1);
                    }
                    if (nestedArg.equalsIgnoreCase("}")) {
                        doneParsing = true;
                        break;
                    }
                    if (nestedArg.endsWith("}")) {
                        doneParsing = true;
                        nestedArg = nestedArg.substring(0, nestedArg.length() - 1);
                        nestedArgs.add(nestedArg);
                        break;
                    }
                    nestedArgs.add(nestedArg);
                    ++count;
                    ++nestedIndex;
                }
                if (!doneParsing) {
                    throw new ParseException(RB.getStringResource("AbstractBatchUtility.InvalidNestedSyntax.End.txt"));
                }
                String[] nestedArgsArray = nestedArgs.toArray(new String[nestedArgs.size()]);
                this.nestedOptions.put(shortArg, nestedArgsArray);
                index = nestedIndex;
                this.argList.add("");
            }
        }

        public Map<String, String[]> getNestedOptions() {
            return this.nestedOptions;
        }

        public String[] getUpdatedArgList() {
            if (this.argList == null) {
                return new String[0];
            }
            return this.argList.toArray(new String[this.argList.size()]);
        }
    }
}

