/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSF.security;

import com.platform.LSF.security.EauthCredentials;
import com.platform.LSF.security.LSFUser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamTokenizer;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Principal;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class EauthLogin
implements LoginModule {
    private static final String OS_TYPE = System.getProperty("os.name").toLowerCase();
    private static EauthCredentials s_credentials = null;
    private boolean m_debug = false;
    private Subject m_subject = null;
    private static String m_sLocalHostName = EauthLogin.getLocalHostName();
    private static final Pattern PERCENTS_PAT = Pattern.compile("(%)([0-9a-fA-F])([0-9a-fA-F])");
    private static final Pattern DIR_BLACKLIST_PAT = Pattern.compile("([*?<>|])");
    private CallbackHandler m_callbackHandler = null;
    private String m_jsHost = null;

    private String getEauthBinaryName() {
        return "eauth";
    }

    private int extractID(StreamTokenizer streamTokenizer, String string) throws IOException {
        int n;
        do {
            n = streamTokenizer.nextToken();
            if (n == -1) {
                return -1;
            }
        } while (n != -3 || !streamTokenizer.sval.equals(string));
        if (streamTokenizer.nextToken() != 61) {
            return -1;
        }
        if (streamTokenizer.nextToken() != -3) {
            return -1;
        }
        return Integer.parseInt(streamTokenizer.sval);
    }

    private int extractUID(StreamTokenizer streamTokenizer) throws IOException {
        return this.extractID(streamTokenizer, "uid");
    }

    private int extractGID(StreamTokenizer streamTokenizer) throws IOException {
        return this.extractID(streamTokenizer, "gid");
    }

    private Principal getPrincipal() throws FailedLoginException {
        String string = System.getProperty("user.name");
        if (string == null) {
            throw new FailedLoginException("Cannot detect current user name");
        }
        if (string.indexOf(92) >= 0 || string.indexOf(9) >= 0) {
            throw new FailedLoginException("User name contains invalid character");
        }
        if (OS_TYPE.indexOf("win") < 0 && string.indexOf(32) >= 0) {
            throw new FailedLoginException("User name contains invalid character");
        }
        String string2 = this.getDomainName();
        if (string2 != null && string2.equalsIgnoreCase(m_sLocalHostName)) {
            string2 = ".";
        }
        int n = 12345;
        int n2 = 12346;
        return new LSFUser(string, n, n2, string2);
    }

    private String getDomainName() {
        Class<?> clazz = null;
        if (!System.getProperty("os.name").startsWith("Windows")) {
            return null;
        }
        try {
            clazz = Class.forName("com.ibm.security.auth.module.NTSystem");
        }
        catch (Exception exception) {
            try {
                clazz = Class.forName("com.ibm.security.auth.module.Win64System");
            }
            catch (Exception exception2) {
                try {
                    clazz = Class.forName("com.sun.security.auth.module.NTSystem");
                }
                catch (Exception exception3) {
                    return null;
                }
            }
        }
        try {
            Object obj = clazz.newInstance();
            Method method = clazz.getMethod("getDomain", null);
            String string = (String)method.invoke(obj, null);
            return string;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String getLocalHostName() {
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
        if (inetAddress == null) {
            return null;
        }
        String string = inetAddress.getCanonicalHostName();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (stringTokenizer.hasMoreTokens()) {
            return stringTokenizer.nextToken();
        }
        return null;
    }

    private synchronized Object getCredentials() throws FailedLoginException {
        Object object;
        String string = System.getProperty("JS_ENVDIR");
        if (string == null || string.equals("")) {
            throw new FailedLoginException("JS_ENVDIR not set");
        }
        String string2 = System.getProperty("JS_SERVERDIR");
        if (string2 == null) {
            if (this.m_debug) {
                System.out.println("Failed to get JS_SERVERDIR");
            }
            throw new FailedLoginException("JS_SERVERDIR not set");
        }
        String[] stringArray = new String[]{string2 + File.separator + this.getEauthBinaryName(), "-c"};
        String[] stringArray2 = new String[]{"LSF_ENVDIR=" + string, "LSF_EAUTH_CLIENT=user", "LSF_EAUTH_SERVER=jfd", "LSF_SERVERDIR=" + string2, "LSF_CONFDIR=dummy", "EGO_CONFDIR=" + string, "JS_HOST=" + this.m_jsHost};
        String string3 = string + System.getProperty("file.separator") + "lsf.conf";
        if (this.m_debug) {
            System.out.println("getCredentials: " + string3);
        }
        try {
            boolean bl;
            this.doDirCheck(string);
            object = new File(string3);
            boolean bl2 = ((File)object).exists();
            if (!bl2 && (bl = ((File)object).createNewFile())) {
                ((File)object).deleteOnExit();
            }
        }
        catch (Exception exception) {
            if (this.m_debug) {
                exception.printStackTrace();
            }
            throw new FailedLoginException("Error with file " + string3);
        }
        if (this.m_debug) {
            System.out.println("eauth path: " + stringArray[0]);
        }
        try {
            int n;
            int n2;
            object = Runtime.getRuntime().exec(stringArray, stringArray2);
            InputStream inputStream = ((Process)object).getInputStream();
            byte[] byArray = new byte[1024];
            int n3 = 0;
            while ((n2 = inputStream.read()) != -1) {
                byArray[n3] = (byte)n2;
                ++n3;
            }
            ((Process)object).waitFor();
            byte[] byArray2 = new byte[n3];
            for (n = 0; n < n3; ++n) {
                byArray2[n] = byArray[n];
            }
            if (this.m_debug) {
                System.out.println("Read " + n3 + " bytes from eauth ");
                for (n = 0; n < n3; ++n) {
                    System.out.print((char)byArray[n]);
                }
                System.out.println();
                System.out.println("Exit code from eauth: " + ((Process)object).exitValue());
            }
            s_credentials = new EauthCredentials(byArray2);
            return s_credentials;
        }
        catch (Exception exception) {
            throw new FailedLoginException("Error invoking eauth");
        }
    }

    private void doDirCheck(String string) throws Exception {
        Matcher matcher = DIR_BLACKLIST_PAT.matcher(string);
        if (matcher.find()) {
            throw new Exception("Invalid directory: Directory path (" + string + ") contains illegal character: " + matcher.group());
        }
        Matcher matcher2 = PERCENTS_PAT.matcher(string);
        if (matcher2.find()) {
            throw new Exception("Invalid directory: Directory path (" + string + ") contains encoded characters: " + matcher2.group());
        }
        int n = this.containsUnprintableCharacters(string);
        if (n != -1) {
            throw new Exception("Invalid directory: Directory path (" + string + ") contains unprintable character: " + n);
        }
    }

    private int containsUnprintableCharacters(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= ' ' && c <= '~') continue;
            return c;
        }
        return -1;
    }

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map map, Map map2) {
        if (map2.containsKey("debug")) {
            this.m_debug = new Boolean((String)map2.get("debug"));
        }
        if (this.m_debug) {
            System.out.println("initialize invoked");
        }
        this.m_subject = subject;
        this.m_callbackHandler = callbackHandler;
        if (this.m_debug) {
            Set<Principal> set = subject.getPrincipals();
            for (Principal principal : set) {
                System.out.println("Name: " + principal.getName());
            }
        }
    }

    @Override
    public synchronized boolean login() throws LoginException {
        if (this.m_debug) {
            System.out.println("login invoked");
        }
        Callback[] callbackArray = new Callback[]{new TextInputCallback("JS_HOST")};
        try {
            this.m_callbackHandler.handle(callbackArray);
            this.m_jsHost = ((TextInputCallback)callbackArray[0]).getText();
            if (this.m_debug) {
                System.out.println("Get JS_HOST from login Callback is: " + this.m_jsHost);
            }
        }
        catch (IOException iOException) {
            throw new FailedLoginException("IOException occured.");
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
            throw new FailedLoginException("UnsupportedCallbackException encountered.");
        }
        Set<Principal> set = this.m_subject.getPrincipals();
        set.add(this.getPrincipal());
        Set<Object> set2 = this.m_subject.getPublicCredentials();
        if (this.isDemoMode()) {
            s_credentials = new EauthCredentials(new String("dummy").getBytes());
            set2.add(s_credentials);
        } else {
            set2.add(this.getCredentials());
        }
        if (this.m_debug) {
            for (Principal principal : set) {
                System.out.println("Name: " + principal.getName());
            }
        }
        return true;
    }

    private boolean isDemoMode() {
        String string = System.getProperty("JS_ENVDIR");
        if (string == null) {
            string = System.getProperty("file.separator") + "etc";
        }
        String string2 = string + System.getProperty("file.separator") + "js.conf";
        try {
            FileInputStream fileInputStream = new FileInputStream(string2);
            Properties properties = new Properties();
            properties.load(fileInputStream);
            String string3 = properties.getProperty("JS_DEMO", "false");
            return new Boolean(string3);
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean commit() throws LoginException {
        if (this.m_debug) {
            System.out.println("commit invoked");
        }
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        if (this.m_debug) {
            System.out.println("abort invoked");
        }
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        if (this.m_debug) {
            System.out.println("logout invoked");
        }
        return true;
    }
}

