/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.connection.platform.tools;

import com.sas.codepolicy.SASScope;
import com.sas.services.connection.platform.mgmt.ServerFactoryMBean;
import com.sas.services.connection.platform.tools.RB;
import com.sas.services.util.JMXAgent;
import com.sas.text.Message;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;

@SASScope
public class AgentInit {
    private List _xmlConfigList = new ArrayList();
    private JMXAgent _agent = null;

    private void initProperties(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-xmlconfigfile")) {
                this._xmlConfigList.add(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-xmlconfiglist")) {
                this.initConfigList(args[++i]);
                continue;
            }
            throw new Exception(Message.format((ResourceBundle)RB.getResources(), (String)"AgentInit.invalidProp.ex.fmt.txt", (Object)args[i]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initConfigList(String propertiesFilename) throws Exception {
        if (propertiesFilename == null) {
            return;
        }
        try (BufferedReader input = null;){
            input = new BufferedReader(new FileReader(propertiesFilename));
            String line = null;
            while ((line = input.readLine()) != null) {
                this._xmlConfigList.add(line);
            }
        }
    }

    private void initMBS() throws Exception {
        this._agent = JMXAgent.getInstance();
        if (this._agent == null) {
            throw new Exception(RB.getStringResource("AgentInit.noAgent.txt"));
        }
        if (this._xmlConfigList.size() == 0) {
            try {
                ServerFactoryMBean factory = new ServerFactoryMBean((String)null);
                this._agent.registerMBean((Object)factory, null);
            }
            catch (Exception e) {
                System.err.println(Message.format((ResourceBundle)RB.getResources(), (String)"AgentInit.initErr2.fmt.txt", (Object)e.getMessage()));
            }
        } else {
            Iterator itor = this._xmlConfigList.iterator();
            String xmlFilename = null;
            while (itor.hasNext()) {
                try {
                    xmlFilename = (String)itor.next();
                    ServerFactoryMBean factory = new ServerFactoryMBean(xmlFilename);
                    this._agent.registerMBean((Object)factory, null);
                }
                catch (Exception e) {
                    System.err.println(Message.format((ResourceBundle)RB.getResources(), (String)"AgentInit.initErr.fmt.txt", (Object)xmlFilename, (Object)e.getMessage()));
                }
            }
        }
    }

    public static void main(String[] args) {
        AgentInit app = new AgentInit();
        try {
            app.initProperties(args);
            app.initMBS();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

