/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.connection.platform.mgmt;

import EDU.oswego.cs.dl.util.concurrent.Callable;
import EDU.oswego.cs.dl.util.concurrent.Executor;
import EDU.oswego.cs.dl.util.concurrent.FutureResult;
import com.sas.codepolicy.SASScope;
import com.sas.iom.ObjectSpawner.IClusterInstance;
import com.sas.iom.ObjectSpawner.ISpawnedServer;
import com.sas.iom.ObjectSpawner.ISpawnerAdministration;
import com.sas.iom.ObjectSpawner.ISpawnerAdministrationHelper;
import com.sas.iom.ObjectSpawner.ISpawnerInformation_1_1;
import com.sas.iom.ObjectSpawner.ISpawnerInformation_1_1Helper;
import com.sas.iom.ObjectSpawner.ISpawnerInformation_1_1Package.ClusterManagementNotSupported;
import com.sas.iom.ObjectSpawnerEvents.ISpawnerEventsHelper;
import com.sas.iom.ObjectSpawnerEvents._ISpawnerEventsImplBase;
import com.sas.iom.SASIOMCommon.IClusterAdministration;
import com.sas.iom.SASIOMCommon.IClusterAdministrationHelper;
import com.sas.iom.SASIOMCommon.IFilteredList;
import com.sas.iom.SASIOMCommon.IServerInformation;
import com.sas.iom.SASIOMCommon.IServerInformationHelper;
import com.sas.iom.SASIOMDefs.AnySeqHolder;
import com.sas.iom.SASIOMDefs.CP_ID;
import com.sas.iom.SASIOMDefs.ConnectionPoint;
import com.sas.iom.SASIOMDefs.ConnectionPointContainer;
import com.sas.iom.SASIOMDefs.ConnectionPointContainerHelper;
import com.sas.iom.SASIOMDefs.ConnectionPointHolder;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iom.SASIOMDefs.StringSeqHolder;
import com.sas.iom.SASIOMDefs.UUID;
import com.sas.iom.SASIOMDefs.UUIDSeqHolder;
import com.sas.iom.orb.UUIDConverter;
import com.sas.services.connection.ConnectionInterface;
import com.sas.services.connection.platform.PlatformConnectionFactoryConfiguration;
import com.sas.services.connection.platform.PlatformConnectionFactoryInterface;
import com.sas.services.connection.platform.PlatformConnectionFactoryManager;
import com.sas.services.connection.platform.mgmt.RB;
import com.sas.services.connection.platform.mgmt.ServerMBean;
import com.sas.services.connection.platform.mgmt.ServerMBeanUtil;
import com.sas.services.connection.platform.mgmt.SpawnedServerMBean;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.LogicalServerInterface;
import com.sas.services.information.metadata.ServerFilter;
import com.sas.services.user.UserContextInterface;
import com.sas.text.Message;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import javax.management.MBeanParameterInfo;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.omg.CORBA.Any;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.Object;

@SASScope
public class SpawnerMBean
extends ServerMBean
implements NotificationListener {
    private static final String MBEAN_DESCRIPTION = RB.getStringResource("SpawnerMBean.mBeanDesc.txt");
    private static final String LOGICAL_SERVER_DESC = RB.getStringResource("SpawnerMBean.logicalServerDesc.txt");
    private static final String SERVER_COMPONENT_DESC = RB.getStringResource("SpawnerMBean.serverComponentDesc.txt");
    private static final String CLASS_ID_DESC = RB.getStringResource("SpawnerMBean.classIdDesc.txt");
    private static final String PROCESS_OWNER_DESC = RB.getStringResource("SpawnerMBean.processOwnerDesc.txt");
    private static final String SERVER_TYPE_DESC = RB.getStringResource("SpawnerMBean.serverTypeDesc.txt");
    private final String STRING_CLASS_NAME = String.class.getName();
    private static final String VOID_TYPE_NAME = "void";
    private static final String FILTER_PARM_NAME = RB.getStringResource("SpawnerMBean.filterParmName.txt");
    private static final String[] INSTANCEID_INDEX_NAME = new String[]{"Instance Identifier"};
    private static final String SERVER_LIST_COMPOSITETYPE_NAME = "com.sas.services.connection.platform.ServerListCt";
    private static final String SERVER_LIST_TABULARTYPE_NAME = "com.sas.services.connection.platform.ServerListTt";
    private static final String SERVER_LIST_COMPOSITETYPE_DESCRIPTION = RB.getStringResource("SpawnerMBean.serverListCompositeDesc.txt");
    private static final String DEFINED_LIST_TABULARTYPE_DESCRIPTION = RB.getStringResource("SpawnerMBean.definedTabularDesc.txt");
    private static final String LAUNCHED_LIST_TABULARTYPE_DESCRIPTION = RB.getStringResource("SpawnerMBean.launchedTabularDesc.txt");
    private static final String ABANDONED_LIST_TABULARTYPE_DESCRIPTION = RB.getStringResource("SpawnerMBean.abandonedTabularDesc.txt");
    private static final String[] LAUNCHED_SERVER_DATA_DESCRIPTIONS = new String[]{LOGICAL_SERVER_DESC, SERVER_COMPONENT_DESC, CLASS_ID_DESC, PROCESS_OWNER_DESC, RB.getStringResource("SpawnerMBean.serverInstIdDesc.txt"), SERVER_TYPE_DESC};
    private static final OpenType[] LAUNCHED_SERVER_DATA_TYPES = new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING};
    private static final String LAUNCHED_SERVER_PARM_DESCRIPTION = RB.getStringResource("SpawnerMBean.spawnerLaunchedParmDesc.txt");
    public static final String LAUNCHED_SERVER_DATA_NAME_LOGICAL_SERVER = "Logical Server";
    public static final String LAUNCHED_SERVER_DATA_NAME_NAME = "Name";
    public static final String LAUNCHED_SERVER_DATA_NAME_CLASSID = "Class Identifier";
    public static final String LAUNCHED_SERVER_DATA_NAME_PROCESS_OWNER = "Process Owner";
    public static final String LAUNCHED_SERVER_DATA_NAME_INSTANCEID = "Instance Identifier";
    public static final String LAUNCHED_SERVER_DATA_NAME_TYPE = "Server Type";
    private static final String[] LAUNCHED_SERVER_DATA_NAMES = new String[]{"Logical Server", "Name", "Class Identifier", "Process Owner", "Instance Identifier", "Server Type"};
    private static final String[] DEFINED_SERVER_DATA_NAMES = new String[]{"Logical Server", "Name", "Class Identifier", "Server Type"};
    public static final String SUMMARY_DATA_NAME_CLIENTS = "Clients";
    public static final String SUMMARY_DATA_NAME_DEFINED_SERVERS = "Defined Servers";
    public static final String SUMMARY_DATA_NAME_LAUNCHED_SERVERS = "Launched Servers";
    public static final String SUMMARY_DATA_NAME_ABANDONED_SERVERS = "Abandoned Servers";
    private static final String[] SUMMARY_DATA_NAMES = new String[]{"Clients", "Defined Servers", "Launched Servers", "Abandoned Servers"};
    private static final String[] ABANDONED_SERVER_DATA_NAMES = LAUNCHED_SERVER_DATA_NAMES;
    private static final OpenType[] ABANDONED_SERVER_DATA_TYPES = LAUNCHED_SERVER_DATA_TYPES;
    private final String LAUNCHED_ID_PARM_NAME = RB.getStringResource("SpawnerMBean.launchedIdParmName.txt");
    private final String LAUNCHED_ID_PARM_DESCRIPTION = RB.getStringResource("SpawnerMBean.launchedIdParmDesc.txt");
    private final String LOGICAL_NAME_PARM_NAME = "Logical Server Name";
    private final String LOGICAL_NAME_PARM_DESCRIPTION = "The name of the logical server.";
    private static final String INFORMATION_CATEGORY_NAME = "Information";
    private static final String IOM_SERVERPORT_PROPERTY = "IOM.ServerPort";
    private static final String IOM_SERVERCOMPONENT_URI_PROPERTY = "IOM.ServerComponentURI";
    private ISpawnerAdministration _iSpawnerAdministration;
    private ISpawnerInformation_1_1 _iSpawnerInformation;
    private CompositeType _launchedCt;
    private TabularType _launchedTt;
    private CompositeType _definedCt;
    private TabularType _definedTt;
    private CompositeType _abandonedCt;
    private TabularType _abandonedTt;
    private CompositeType _summaryCt;
    private SpawnerEventsListener _eventsListener;
    private int _eventsHandle;
    private ConnectionPoint _connectionPoint;
    private boolean _automaticMBeanRegistration = false;
    private UserContextInterface _userContext;
    private Logger _logger;

    public SpawnerMBean(ConnectionInterface connection, UserContextInterface userContext) throws Exception {
        super(MBEAN_DESCRIPTION, connection, null);
        int i;
        this._iSpawnerAdministration = ISpawnerAdministrationHelper.narrow((Object)connection.getObject());
        this._iSpawnerInformation = ISpawnerInformation_1_1Helper.narrow((Object)connection.getObject());
        this._userContext = userContext;
        this._logger = LogManager.getLogger(SpawnerMBean.class);
        this.addMBeanAttribute("AutomaticMBeanRegistration", Boolean.class.getName(), true, true, false, RB.getStringResource("SpawnerMBean.autoDesc.txt"));
        this.addMBeanOperation("refresh", RB.getStringResource("SpawnerMBean.refreshDesc.txt"), null, VOID_TYPE_NAME, 1);
        this.addMBeanOperation("killLaunchedServer", RB.getStringResource("SpawnerMBean.killLaunchedDesc.txt"), new MBeanParameterInfo[]{new MBeanParameterInfo(this.LAUNCHED_ID_PARM_NAME, this.STRING_CLASS_NAME, this.LAUNCHED_ID_PARM_DESCRIPTION)}, VOID_TYPE_NAME, 1);
        this.createDefinedServerTypes();
        this.addMBeanOperation("listDefinedServers", RB.getStringResource("SpawnerMBean.definedDesc.txt"), new MBeanParameterInfo[]{new MBeanParameterInfo(FILTER_PARM_NAME, "java.lang.String", RB.getStringResource("SpawnerMBean.spawnerParmDesc.txt"))}, "javax.management.openmbean.TabularData", 0);
        this.addMBeanOperation("manageLaunchedServer", RB.getStringResource("SpawnerMBean.manageLaunchedDesc.txt"), new MBeanParameterInfo[]{new MBeanParameterInfo(this.LAUNCHED_ID_PARM_NAME, this.STRING_CLASS_NAME, this.LAUNCHED_ID_PARM_DESCRIPTION)}, this.STRING_CLASS_NAME, 1);
        this.addMBeanOperation("manageLaunchedServers", RB.getStringResource("SpawnerMBean.manageLaunchedServersDesc.txt"), null, VOID_TYPE_NAME, 1);
        this.createLaunchedServerTypes();
        this.addMBeanOperation("listLaunchedServers", RB.getStringResource("SpawnerMBean.launchedDesc.txt"), new MBeanParameterInfo[]{new MBeanParameterInfo(FILTER_PARM_NAME, this.STRING_CLASS_NAME, LAUNCHED_SERVER_PARM_DESCRIPTION)}, "javax.management.openmbean.TabularData", 0);
        this.createAbandonedServerTypes();
        this.addMBeanOperation("listAbandonedServers", RB.getStringResource("SpawnerMBean.abandonedDesc.txt"), new MBeanParameterInfo[]{new MBeanParameterInfo(FILTER_PARM_NAME, this.STRING_CLASS_NAME, RB.getStringResource("SpawnerMBean.spawnerAbandonedParmDesc.txt"))}, "javax.management.openmbean.TabularData", 0);
        this.createSummaryTypes();
        this.addMBeanOperation("listSummaryStatus", RB.getStringResource("SpawnerMBean.summaryDesc.txt"), null, "javax.management.openmbean.CompositeData", 0);
        this.addMBeanOperation("stopCluster", RB.getStringResource("ServerMBean.stopClusterDesc.txt"), new MBeanParameterInfo[]{new MBeanParameterInfo("Logical Server Name", this.STRING_CLASS_NAME, "The name of the logical server.")}, this.STRING_CLASS_NAME, 1);
        this.addMBeanOperation("pauseCluster", RB.getStringResource("ServerMBean.pauseClusterDesc.txt"), new MBeanParameterInfo[]{new MBeanParameterInfo("Logical Server Name", this.STRING_CLASS_NAME, "The name of the logical server.")}, this.STRING_CLASS_NAME, 1);
        this.addMBeanOperation("deferredStopCluster", RB.getStringResource("ServerMBean.deferredStopClusterDesc.txt"), new MBeanParameterInfo[]{new MBeanParameterInfo("Logical Server Name", this.STRING_CLASS_NAME, "The name of the logical server.")}, this.STRING_CLASS_NAME, 1);
        this.addMBeanOperation("continueCluster", RB.getStringResource("ServerMBean.continueClusterDesc.txt"), new MBeanParameterInfo[]{new MBeanParameterInfo("Logical Server Name", this.STRING_CLASS_NAME, "The name of the logical server.")}, this.STRING_CLASS_NAME, 1);
        this._eventsListener = new SpawnerEventsListener();
        String cpidString = ISpawnerEventsHelper.id();
        int d1 = (int)Long.parseLong(cpidString.substring(4, 12), 16);
        short d2 = (short)Integer.parseInt(cpidString.substring(13, 17), 16);
        short d3 = (short)Integer.parseInt(cpidString.substring(18, 22), 16);
        byte[] d4 = new byte[8];
        for (i = 0; i < 2; ++i) {
            d4[i] = (byte)Short.parseShort(cpidString.substring(23 + i * 2, 25 + i * 2), 16);
        }
        for (i = 0; i < 6; ++i) {
            d4[i + 2] = (byte)Short.parseShort(cpidString.substring(28 + i * 2, 30 + i * 2), 16);
        }
        CP_ID cpid = new CP_ID(d1, d2, d3, d4);
        ConnectionPointContainer cpContainer = ConnectionPointContainerHelper.narrow((Object)this._iSpawnerAdministration);
        ConnectionPointHolder cpHolder = new ConnectionPointHolder();
        cpContainer.FindConnectionPoint(cpid, cpHolder);
        this._connectionPoint = cpHolder.value;
        IntHolder handleHolder = new IntHolder();
        this._connectionPoint.Advise((Object)this._eventsListener, handleHolder);
        this._eventsHandle = handleHolder.value;
        this.addMBeanNotification(new String[]{"Spawner.newServer"}, "javax.management.Notification", RB.getStringResource("SpawnerMBean.newNotifDesc.txt"));
    }

    public TabularData listDefinedServers(final String filter) throws Exception {
        if (this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"SpawnerMBean.getDefined.fmt.txt", (java.lang.Object)this._objectNameCanonicalName));
        }
        if (this._iSpawnerInformation == null) {
            if (this._logger != null) {
                this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"SpawnerMBean.definedNoInfo.fmt.txt", (java.lang.Object)this._objectNameCanonicalName));
            }
            throw new Exception(RB.getStringResource("SpawnerMBean.noInfo.ex.txt"));
        }
        final TabularDataSupport td = new TabularDataSupport(this._definedTt);
        Executor ex = this.getExecutor();
        FutureResult fr = new FutureResult();
        Runnable myrun = fr.setter(new Callable(){

            public java.lang.Object call() {
                try {
                    StringSeqHolder logicalHolder = new StringSeqHolder();
                    StringSeqHolder serverComponentHolder = new StringSeqHolder();
                    UUIDSeqHolder classIdHolder = new UUIDSeqHolder();
                    SpawnerMBean.this._iSpawnerInformation.ListDefinedServers(filter, logicalHolder, serverComponentHolder, classIdHolder);
                    String[] logicalServers = logicalHolder.value;
                    String[] serverComponents = serverComponentHolder.value;
                    UUID[] classIds = classIdHolder.value;
                    for (int i = 0; i < logicalServers.length; ++i) {
                        java.lang.Object[] itemValues = new java.lang.Object[]{logicalServers[i], serverComponents[i], UUIDConverter.uuidToString((UUID)classIds[i]), ServerMBeanUtil.getLocalizedServerType(classIds[i])};
                        td.put(new CompositeDataSupport(SpawnerMBean.this._definedCt, DEFINED_SERVER_DATA_NAMES, itemValues));
                    }
                }
                catch (Throwable t) {
                    return t;
                }
                return null;
            }
        });
        ex.execute(myrun);
        this.handleThrowable((Throwable)fr.get(), "SpawnerMBean.getDefinedErr.fmt.txt");
        if (this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug(RB.getStringResource("SpawnerMBean.definedReturn.txt"));
        }
        return td;
    }

    public TabularData listLaunchedServers(final String filter) throws Exception {
        if (this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"SpawnerMBean.getLaunched.fmt.txt", (java.lang.Object)this._objectNameCanonicalName));
        }
        if (this._iSpawnerInformation == null) {
            if (this._logger != null) {
                this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"SpawnerMBean.launchedNoInfo.fmt.txt", (java.lang.Object)this._objectNameCanonicalName));
            }
            throw new Exception(RB.getStringResource("SpawnerMBean.noInfo.ex.txt"));
        }
        final TabularDataSupport td = new TabularDataSupport(this._launchedTt);
        Executor ex = this.getExecutor();
        FutureResult fr = new FutureResult();
        Runnable myrun = fr.setter(new Callable(){

            public java.lang.Object call() {
                try {
                    String filterStr = "";
                    if (filter != null) {
                        filterStr = filter;
                    }
                    StringSeqHolder logicalHolder = new StringSeqHolder();
                    StringSeqHolder serverComponentHolder = new StringSeqHolder();
                    UUIDSeqHolder classIdHolder = new UUIDSeqHolder();
                    StringSeqHolder processHolder = new StringSeqHolder();
                    UUIDSeqHolder instanceIdHolder = new UUIDSeqHolder();
                    SpawnerMBean.this._iSpawnerInformation.ListLaunchedServers(filterStr, logicalHolder, serverComponentHolder, classIdHolder, processHolder, instanceIdHolder);
                    String[] logicalServers = logicalHolder.value;
                    String[] serverComponents = serverComponentHolder.value;
                    UUID[] classIds = classIdHolder.value;
                    String[] processOwners = processHolder.value;
                    UUID[] instanceIds = instanceIdHolder.value;
                    for (int i = 0; i < logicalServers.length; ++i) {
                        java.lang.Object[] itemValues = new java.lang.Object[]{logicalServers[i], serverComponents[i], UUIDConverter.uuidToString((UUID)classIds[i]), processOwners[i], UUIDConverter.uuidToString((UUID)instanceIds[i]), ServerMBeanUtil.getLocalizedServerType(classIds[i])};
                        td.put(new CompositeDataSupport(SpawnerMBean.this._launchedCt, LAUNCHED_SERVER_DATA_NAMES, itemValues));
                    }
                }
                catch (Throwable t) {
                    return t;
                }
                return null;
            }
        });
        ex.execute(myrun);
        this.handleThrowable((Throwable)fr.get(), "SpawnerMBean.getLaunchedErr.fmt.txt");
        if (this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug(RB.getStringResource("SpawnerMBean.launchedReturn.txt"));
        }
        return td;
    }

    public TabularData listAbandonedServers(final String filter) throws Exception {
        if (this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"SpawnerMBean.getAbandoned.fmt.txt", (java.lang.Object)this._objectNameCanonicalName));
        }
        if (this._iSpawnerInformation == null) {
            if (this._logger != null) {
                this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"SpawnerMBean.abandonedNoInfo.fmt.txt", (java.lang.Object)this._objectNameCanonicalName));
            }
            throw new Exception(RB.getStringResource("SpawnerMBean.noInfo.ex.txt"));
        }
        final TabularDataSupport td = new TabularDataSupport(this._abandonedTt);
        Executor ex = this.getExecutor();
        FutureResult fr = new FutureResult();
        Runnable myrun = fr.setter(new Callable(){

            public java.lang.Object call() {
                try {
                    StringSeqHolder logicalHolder = new StringSeqHolder();
                    StringSeqHolder serverComponentHolder = new StringSeqHolder();
                    UUIDSeqHolder classIdHolder = new UUIDSeqHolder();
                    StringSeqHolder processHolder = new StringSeqHolder();
                    UUIDSeqHolder instanceIdHolder = new UUIDSeqHolder();
                    SpawnerMBean.this._iSpawnerInformation.ListAbandonedServers(filter, logicalHolder, serverComponentHolder, classIdHolder, processHolder, instanceIdHolder);
                    String[] logicalServers = logicalHolder.value;
                    String[] serverComponents = serverComponentHolder.value;
                    UUID[] classIds = classIdHolder.value;
                    String[] processOwners = processHolder.value;
                    UUID[] instanceIds = instanceIdHolder.value;
                    for (int i = 0; i < logicalServers.length; ++i) {
                        java.lang.Object[] itemValues = new java.lang.Object[]{logicalServers[i], serverComponents[i], UUIDConverter.uuidToString((UUID)classIds[i]), processOwners[i], UUIDConverter.uuidToString((UUID)instanceIds[i]), ServerMBeanUtil.getLocalizedServerType(classIds[i])};
                        td.put(new CompositeDataSupport(SpawnerMBean.this._abandonedCt, ABANDONED_SERVER_DATA_NAMES, itemValues));
                    }
                }
                catch (Throwable t) {
                    return t;
                }
                return null;
            }
        });
        ex.execute(myrun);
        this.handleThrowable((Throwable)fr.get(), "SpawnerMBean.getAbandonedErr.fmt.txt");
        if (this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug(RB.getStringResource("SpawnerMBean.abandonedReturn.txt"));
        }
        return td;
    }

    public void killLaunchedServer(final String uuid) throws Exception {
        if (this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"SpawnerMBean.killLaunchedServer.fmt.txt", (java.lang.Object)this._objectNameCanonicalName, (java.lang.Object)uuid));
        }
        if (this._iSpawnerAdministration == null) {
            if (this._logger != null) {
                this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"SpawnerMBean.killLaunchedNoAdmin.fmt.txt", (java.lang.Object)this._objectNameCanonicalName));
            }
            throw new Exception(RB.getStringResource("SpawnerMBean.noAdmin.ex.txt"));
        }
        Executor ex = this.getExecutor();
        FutureResult fr = new FutureResult();
        Runnable myrun = fr.setter(new Callable(){

            public java.lang.Object call() {
                try {
                    UUID theUUID = null;
                    try {
                        theUUID = UUIDConverter.stringToUUID((String)uuid);
                    }
                    catch (Exception e) {
                        Exception ex = new Exception(RB.getStringResource("SpawnerMBean.invalidId.ex.txt"));
                        return ex;
                    }
                    if (theUUID == null) {
                        Exception ex = new Exception(RB.getStringResource("SpawnerMBean.nullUUID.ex.txt"));
                        return ex;
                    }
                    SpawnerMBean.this._iSpawnerAdministration.KillSpawnedServer(theUUID);
                }
                catch (Throwable t) {
                    return t;
                }
                return null;
            }
        });
        ex.execute(myrun);
        Throwable t = (Throwable)fr.get();
        if (t != null) {
            if (t instanceof COMM_FAILURE) {
                if (this._logger != null) {
                    this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"SpawnerMBean.unrecoverErr.fmt.txt", (java.lang.Object)this._objectNameCanonicalName), t);
                }
                this.unRegister();
                this.cleanup();
                throw new Exception(t.getLocalizedMessage());
            }
            if (this._logger != null) {
                this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"SpawnerMBean.killLaunchedErr.fmt.txt", (java.lang.Object)this._objectNameCanonicalName, (java.lang.Object)uuid), t);
            }
            throw new Exception(t.getLocalizedMessage());
        }
        if (this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug(RB.getStringResource("SpawnerMBean.killLaunchedReturn.txt"));
        }
    }

    public String manageLaunchedServer(final String uuid) throws Exception {
        if (this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"SpawnerMBean.manageLaunchedServer.fmt.txt", (java.lang.Object)this._objectNameCanonicalName, (java.lang.Object)uuid));
        }
        if (this._iSpawnerInformation == null) {
            if (this._logger != null) {
                this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"SpawnerMBean.manageNoInfo.fmt.txt", (java.lang.Object)this._objectNameCanonicalName));
            }
            throw new Exception(RB.getStringResource("SpawnerMBean.noInfo.ex.txt"));
        }
        final ServerMBean.ReturnValue rv = new ServerMBean.ReturnValue();
        Executor ex = this.getExecutor();
        FutureResult fr = new FutureResult();
        Runnable myrun = fr.setter(new Callable(){

            public java.lang.Object call() {
                try {
                    UUID theUUID = null;
                    try {
                        theUUID = UUIDConverter.stringToUUID((String)uuid);
                    }
                    catch (Exception e) {
                        Exception ex = new Exception(RB.getStringResource("SpawnerMBean.invalidId.ex.txt"));
                        return ex;
                    }
                    ISpawnedServer spawnedServer = SpawnerMBean.this._iSpawnerInformation.GetSpawnedServer(theUUID);
                    rv.setValue(SpawnerMBean.this.createServerMBean(spawnedServer, uuid));
                }
                catch (Throwable t) {
                    return t;
                }
                return null;
            }
        });
        ex.execute(myrun);
        this.handleThrowable((Throwable)fr.get(), "SpawnerMBean.manageLaunchedErr.fmt.txt");
        if (this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug(RB.getStringResource("SpawnerMBean.manageLaunchedReturn.txt"));
        }
        return ((ObjectName)rv.getValue()).getCanonicalName();
    }

    public void manageLaunchedServers() throws Exception {
        if (this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"SpawnerMBean.manageLaunchedServers.fmt.txt", (java.lang.Object)this._objectNameCanonicalName));
        }
        if (this._iSpawnerInformation == null) {
            if (this._logger != null) {
                this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"SpawnerMBean.manageNoInfo.fmt.txt", (java.lang.Object)this._objectNameCanonicalName));
            }
            throw new Exception(RB.getStringResource("SpawnerMBean.noInfo.ex.txt"));
        }
        final StringSeqHolder logicalHolder = new StringSeqHolder();
        final StringSeqHolder serverComponentHolder = new StringSeqHolder();
        final UUIDSeqHolder classIdHolder = new UUIDSeqHolder();
        final StringSeqHolder processHolder = new StringSeqHolder();
        final UUIDSeqHolder instanceIdHolder = new UUIDSeqHolder();
        Executor ex = this.getExecutor();
        FutureResult fr = new FutureResult();
        Runnable myrun = fr.setter(new Callable(){

            public java.lang.Object call() {
                try {
                    SpawnerMBean.this._iSpawnerInformation.ListLaunchedServers("", logicalHolder, serverComponentHolder, classIdHolder, processHolder, instanceIdHolder);
                }
                catch (Throwable t) {
                    return t;
                }
                return null;
            }
        });
        ex.execute(myrun);
        this.handleThrowable((Throwable)fr.get(), "SpawnerMBean.manageLaunchedServersErr.fmt.txt");
        UUID[] instanceIds = instanceIdHolder.value;
        for (int i = 0; i < instanceIds.length; ++i) {
            try {
                this.manageLaunchedServer(UUIDConverter.uuidToString((UUID)instanceIds[i]));
                continue;
            }
            catch (Exception e) {
                if (this._logger == null) continue;
                this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"SpawnerMBean.manageLaunchedErr.fmt.txt", (java.lang.Object)this._objectNameCanonicalName), (Throwable)e);
            }
        }
        if (this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug(RB.getStringResource("SpawnerMBean.manageLaunchedServersReturn.txt"));
        }
    }

    public Boolean getAutomaticMBeanRegistration() {
        return this._automaticMBeanRegistration;
    }

    public void setAutomaticMBeanRegistration(Boolean automatic) {
        this._automaticMBeanRegistration = automatic;
    }

    public void refresh() throws Exception {
        if (this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"SpawnerMBean.refresh.fmt.txt", (java.lang.Object)this._objectNameCanonicalName));
        }
        if (this._iSpawnerAdministration == null) {
            if (this._logger != null) {
                this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"SpawnerMBean.refreshNoAdmin.fmt.txt", (java.lang.Object)this._objectNameCanonicalName));
            }
            throw new Exception(RB.getStringResource("SpawnerMBean.noAdmin.ex.txt"));
        }
        Executor ex = this.getExecutor();
        FutureResult fr = new FutureResult();
        Runnable myrun = fr.setter(new Callable(){

            public java.lang.Object call() {
                try {
                    SpawnerMBean.this._iSpawnerAdministration.Refresh();
                }
                catch (Throwable t) {
                    return t;
                }
                return null;
            }
        });
        ex.execute(myrun);
        this.handleThrowable((Throwable)fr.get(), "SpawnerMBean.refreshErr.fmt.txt");
        if (this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug(RB.getStringResource("SpawnerMBean.refreshReturn.txt"));
        }
    }

    public void stopCluster(final String logicalServerName) throws Exception {
        if (null != this._logger && this._logger.isDebugEnabled()) {
            StringBuilder buf = new StringBuilder();
            buf.append("Stop cluster issued on logical server, '");
            buf.append(logicalServerName);
            buf.append("'; Spawner MBean='");
            buf.append(this._objectNameCanonicalName);
            buf.append("'.");
            this._logger.debug(buf.toString());
        }
        if (null == this._iSpawnerInformation) {
            if (null != this._logger) {
                this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"SpawnerMBean.manageNoInfo.fmt.txt", (java.lang.Object)this._objectNameCanonicalName));
            }
            throw new Exception(RB.getStringResource("SpawnerMBean.noInfo.ex.txt"));
        }
        ServerMBean.ReturnValue rv = new ServerMBean.ReturnValue();
        Executor ex = this.getExecutor();
        FutureResult fr = new FutureResult();
        Runnable myrun = fr.setter(new Callable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public java.lang.Object call() {
                IClusterInstance clusterInst = null;
                try {
                    clusterInst = SpawnerMBean.this._iSpawnerInformation.GetClusterInstance(logicalServerName);
                    IClusterAdministration clusterAdmin = IClusterAdministrationHelper.narrow((Object)clusterInst);
                    clusterAdmin.StopCluster();
                }
                catch (ClusterManagementNotSupported ex) {
                    if (null != SpawnerMBean.this._logger && SpawnerMBean.this._logger.isDebugEnabled()) {
                        SpawnerMBean.this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"SpawnerMBean.clusterNotSupported.fmt.txt", (java.lang.Object)logicalServerName));
                    }
                    ClusterManagementNotSupported clusterManagementNotSupported = ex;
                    return clusterManagementNotSupported;
                }
                catch (Throwable t) {
                    Throwable throwable = t;
                    return throwable;
                }
                finally {
                    block18: {
                        if (null != clusterInst) {
                            try {
                                clusterInst.Close();
                            }
                            catch (GenericError e) {
                                if (null == SpawnerMBean.this._logger) break block18;
                                SpawnerMBean.this._logger.error((java.lang.Object)e);
                            }
                        }
                    }
                }
                return null;
            }
        });
        ex.execute(myrun);
        this.handleThrowable((Throwable)fr.get(), "ServerMBean.stopClusterErr.fmt.txt");
        if (null != this._logger && this._logger.isDebugEnabled()) {
            this._logger.debug(RB.getStringResource("ServerMBean.stopClusterReturn.txt"));
        }
    }

    public void deferredStopCluster(final String logicalServerName) throws Exception {
        if (null != this._logger && this._logger.isDebugEnabled()) {
            StringBuilder buf = new StringBuilder();
            buf.append("Deferred stop cluster issued on logical server, '");
            buf.append(logicalServerName);
            buf.append("'; Spawner MBean='");
            buf.append(this._objectNameCanonicalName);
            buf.append("'.");
            this._logger.debug(buf.toString());
        }
        if (null == this._iSpawnerInformation) {
            if (null != this._logger) {
                this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"SpawnerMBean.manageNoInfo.fmt.txt", (java.lang.Object)this._objectNameCanonicalName));
            }
            throw new Exception(RB.getStringResource("SpawnerMBean.noInfo.ex.txt"));
        }
        ServerMBean.ReturnValue rv = new ServerMBean.ReturnValue();
        Executor ex = this.getExecutor();
        FutureResult fr = new FutureResult();
        Runnable myrun = fr.setter(new Callable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public java.lang.Object call() {
                IClusterInstance clusterInst = null;
                try {
                    clusterInst = SpawnerMBean.this._iSpawnerInformation.GetClusterInstance(logicalServerName);
                    IClusterAdministration clusterAdmin = IClusterAdministrationHelper.narrow((Object)clusterInst);
                    clusterAdmin.DeferredStopCluster();
                }
                catch (ClusterManagementNotSupported ex) {
                    if (null != SpawnerMBean.this._logger && SpawnerMBean.this._logger.isDebugEnabled()) {
                        SpawnerMBean.this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"SpawnerMBean.clusterNotSupported.fmt.txt", (java.lang.Object)logicalServerName));
                    }
                    ClusterManagementNotSupported clusterManagementNotSupported = ex;
                    return clusterManagementNotSupported;
                }
                catch (Throwable t) {
                    Throwable throwable = t;
                    return throwable;
                }
                finally {
                    block18: {
                        if (null != clusterInst) {
                            try {
                                clusterInst.Close();
                            }
                            catch (GenericError e) {
                                if (null == SpawnerMBean.this._logger) break block18;
                                SpawnerMBean.this._logger.error((java.lang.Object)e);
                            }
                        }
                    }
                }
                return null;
            }
        });
        ex.execute(myrun);
        this.handleThrowable((Throwable)fr.get(), "ServerMBean.deferredStopClusterErr.fmt.txt");
        if (null != this._logger && this._logger.isDebugEnabled()) {
            this._logger.debug(RB.getStringResource("ServerMBean.deferredStopClusterReturn.txt"));
        }
    }

    public void continueCluster(final String logicalServerName) throws Exception {
        if (null != this._logger && this._logger.isDebugEnabled()) {
            StringBuilder buf = new StringBuilder();
            buf.append("Continue cluster issued on logical server, '");
            buf.append(logicalServerName);
            buf.append("'; Spawner MBean='");
            buf.append(this._objectNameCanonicalName);
            buf.append("'.");
            this._logger.debug(buf.toString());
        }
        if (null == this._iSpawnerInformation) {
            if (null != this._logger) {
                this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"SpawnerMBean.manageNoInfo.fmt.txt", (java.lang.Object)this._objectNameCanonicalName));
            }
            throw new Exception(RB.getStringResource("SpawnerMBean.noInfo.ex.txt"));
        }
        ServerMBean.ReturnValue rv = new ServerMBean.ReturnValue();
        Executor ex = this.getExecutor();
        FutureResult fr = new FutureResult();
        Runnable myrun = fr.setter(new Callable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public java.lang.Object call() {
                IClusterInstance clusterInst = null;
                try {
                    clusterInst = SpawnerMBean.this._iSpawnerInformation.GetClusterInstance(logicalServerName);
                    IClusterAdministration clusterAdmin = IClusterAdministrationHelper.narrow((Object)clusterInst);
                    clusterAdmin.ContinueCluster();
                }
                catch (ClusterManagementNotSupported ex) {
                    if (null != SpawnerMBean.this._logger && SpawnerMBean.this._logger.isDebugEnabled()) {
                        SpawnerMBean.this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"SpawnerMBean.clusterNotSupported.fmt.txt", (java.lang.Object)logicalServerName));
                    }
                    ClusterManagementNotSupported clusterManagementNotSupported = ex;
                    return clusterManagementNotSupported;
                }
                catch (Throwable t) {
                    Throwable throwable = t;
                    return throwable;
                }
                finally {
                    block18: {
                        if (null != clusterInst) {
                            try {
                                clusterInst.Close();
                            }
                            catch (GenericError e) {
                                if (null == SpawnerMBean.this._logger) break block18;
                                SpawnerMBean.this._logger.error((java.lang.Object)e);
                            }
                        }
                    }
                }
                return null;
            }
        });
        ex.execute(myrun);
        this.handleThrowable((Throwable)fr.get(), "ServerMBean.continueClusterErr.fmt.txt");
        if (null != this._logger && this._logger.isDebugEnabled()) {
            this._logger.debug(RB.getStringResource("ServerMBean.continueClusterReturn.txt"));
        }
    }

    public void pauseCluster(final String logicalServerName) throws Exception {
        if (null != this._logger && this._logger.isDebugEnabled()) {
            StringBuilder buf = new StringBuilder();
            buf.append("Pause cluster issued on logical server, '");
            buf.append(logicalServerName);
            buf.append("'; Spawner MBean='");
            buf.append(this._objectNameCanonicalName);
            buf.append("'.");
            this._logger.debug(buf.toString());
        }
        if (null == this._iSpawnerInformation) {
            if (null != this._logger) {
                this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"SpawnerMBean.manageNoInfo.fmt.txt", (java.lang.Object)this._objectNameCanonicalName));
            }
            throw new Exception(RB.getStringResource("SpawnerMBean.noInfo.ex.txt"));
        }
        ServerMBean.ReturnValue rv = new ServerMBean.ReturnValue();
        Executor ex = this.getExecutor();
        FutureResult fr = new FutureResult();
        Runnable myrun = fr.setter(new Callable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public java.lang.Object call() {
                IClusterInstance clusterInst = null;
                try {
                    clusterInst = SpawnerMBean.this._iSpawnerInformation.GetClusterInstance(logicalServerName);
                    IClusterAdministration clusterAdmin = IClusterAdministrationHelper.narrow((Object)clusterInst);
                    clusterAdmin.PauseCluster();
                }
                catch (ClusterManagementNotSupported ex) {
                    if (null != SpawnerMBean.this._logger && SpawnerMBean.this._logger.isDebugEnabled()) {
                        SpawnerMBean.this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"SpawnerMBean.clusterNotSupported.fmt.txt", (java.lang.Object)logicalServerName));
                    }
                    ClusterManagementNotSupported clusterManagementNotSupported = ex;
                    return clusterManagementNotSupported;
                }
                catch (Throwable t) {
                    Throwable throwable = t;
                    return throwable;
                }
                finally {
                    block18: {
                        if (null != clusterInst) {
                            try {
                                clusterInst.Close();
                            }
                            catch (GenericError e) {
                                if (null == SpawnerMBean.this._logger) break block18;
                                SpawnerMBean.this._logger.error((java.lang.Object)e);
                            }
                        }
                    }
                }
                return null;
            }
        });
        ex.execute(myrun);
        this.handleThrowable((Throwable)fr.get(), "ServerMBean.pauseClusterErr.fmt.txt");
        if (null != this._logger && this._logger.isDebugEnabled()) {
            this._logger.debug(RB.getStringResource("ServerMBean.pauseClusterReturn.txt"));
        }
    }

    @Override
    protected java.lang.Object getTargetObject() {
        return this;
    }

    private ObjectName createServerMBean(ISpawnedServer spawnedServer, String uuid) throws Exception {
        ObjectName on;
        block4: {
            on = ServerMBeanUtil.createSpawnedServerObjectName(spawnedServer.ServerComponentName(), spawnedServer.LogicalServerName(), spawnedServer.Class(), uuid, this._objectName.getKeyProperty("host"));
            if (!this.getMBeanServer().isRegistered(on)) {
                ConnectionInterface conn = null;
                try {
                    Map m = this.getTopLevelServerInfo(spawnedServer);
                    conn = this.connectToTopLevelServer(spawnedServer, m);
                    SpawnedServerMBean ssm = new SpawnedServerMBean(spawnedServer, uuid, this._objectName, conn);
                    this.getMBeanServer().registerMBean(ssm, on);
                }
                catch (Exception e) {
                    if (this._logger != null) {
                        this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"SpawnerMBean.createMBeanErr.fmt.txt", (java.lang.Object)this._objectNameCanonicalName), (Throwable)e);
                    }
                    if (conn == null) break block4;
                    conn.close();
                    conn = null;
                }
            }
        }
        return on;
    }

    @Override
    public void handleNotification(Notification notification, java.lang.Object handback) {
    }

    private void createDefinedServerTypes() throws OpenDataException {
        String[] SERVERCOMPONENT_INDEX_NAME = new String[]{LAUNCHED_SERVER_DATA_NAME_NAME};
        String[] DEFINED_SERVER_DATA_DESCRIPTIONS = new String[]{LOGICAL_SERVER_DESC, SERVER_COMPONENT_DESC, CLASS_ID_DESC, SERVER_TYPE_DESC};
        OpenType[] DEFINED_SERVER_DATA_TYPES = new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING};
        this._definedCt = new CompositeType(SERVER_LIST_COMPOSITETYPE_NAME, SERVER_LIST_COMPOSITETYPE_DESCRIPTION, DEFINED_SERVER_DATA_NAMES, DEFINED_SERVER_DATA_DESCRIPTIONS, DEFINED_SERVER_DATA_TYPES);
        this._definedTt = new TabularType(SERVER_LIST_TABULARTYPE_NAME, DEFINED_LIST_TABULARTYPE_DESCRIPTION, this._definedCt, SERVERCOMPONENT_INDEX_NAME);
    }

    private void createLaunchedServerTypes() throws OpenDataException {
        this._launchedCt = new CompositeType(SERVER_LIST_COMPOSITETYPE_NAME, SERVER_LIST_COMPOSITETYPE_DESCRIPTION, LAUNCHED_SERVER_DATA_NAMES, LAUNCHED_SERVER_DATA_DESCRIPTIONS, LAUNCHED_SERVER_DATA_TYPES);
        this._launchedTt = new TabularType(SERVER_LIST_TABULARTYPE_NAME, LAUNCHED_LIST_TABULARTYPE_DESCRIPTION, this._launchedCt, INSTANCEID_INDEX_NAME);
    }

    private void createAbandonedServerTypes() throws OpenDataException {
        String[] ABANDONED_SERVER_DATA_DESCRIPTIONS = LAUNCHED_SERVER_DATA_DESCRIPTIONS;
        this._abandonedCt = new CompositeType(SERVER_LIST_COMPOSITETYPE_NAME, SERVER_LIST_COMPOSITETYPE_DESCRIPTION, ABANDONED_SERVER_DATA_NAMES, ABANDONED_SERVER_DATA_DESCRIPTIONS, ABANDONED_SERVER_DATA_TYPES);
        this._abandonedTt = new TabularType(SERVER_LIST_TABULARTYPE_NAME, ABANDONED_LIST_TABULARTYPE_DESCRIPTION, this._abandonedCt, INSTANCEID_INDEX_NAME);
    }

    private void createSummaryTypes() throws OpenDataException {
        String[] SUMMARY_DATA_DESCRIPTIONS = new String[]{CLIENT_TABULARTYPE_DESCRIPTION, DEFINED_LIST_TABULARTYPE_DESCRIPTION, LAUNCHED_LIST_TABULARTYPE_DESCRIPTION, ABANDONED_LIST_TABULARTYPE_DESCRIPTION};
        OpenType[] TYPES = new OpenType[]{this._clientTt, this._definedTt, this._launchedTt, this._abandonedTt};
        this._summaryCt = new CompositeType(RB.getStringResource("SpawnerMBean.summaryCtDesc.txt"), RB.getStringResource("SpawnerMBean.summaryDesc.txt"), SUMMARY_DATA_NAMES, SUMMARY_DATA_DESCRIPTIONS, TYPES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getTopLevelServerInfo(ISpawnedServer spawnedServer) {
        int port = -1;
        String serverUri = null;
        IServerInformation isi = null;
        IFilteredList fl = null;
        HashMap<String, java.lang.Object> m = new HashMap<String, java.lang.Object>(2);
        try {
            java.lang.Object obj;
            isi = IServerInformationHelper.narrow((Object)spawnedServer);
            fl = isi.UseCategory(INFORMATION_CATEGORY_NAME, "IOM.");
            AnySeqHolder anySeqHolder = new AnySeqHolder();
            fl.GetAttribute(IOM_SERVERPORT_PROPERTY, "value", anySeqHolder);
            Any[] values = anySeqHolder.value;
            if (values.length >= 1 && (obj = ServerMBeanUtil.anyObjectToObject(values[0])) != null && obj instanceof Integer) {
                port = (Integer)obj;
                if (this._logger != null && this._logger.isDebugEnabled()) {
                    this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"SpawnerMBean.topPort.fmt.txt", (java.lang.Object)spawnedServer.ServerComponentName(), (java.lang.Object)port));
                }
            }
            fl.GetAttribute(IOM_SERVERCOMPONENT_URI_PROPERTY, "value", anySeqHolder);
            values = anySeqHolder.value;
            if (values.length >= 1 && (obj = ServerMBeanUtil.anyObjectToObject(values[0])) != null && obj instanceof String) {
                serverUri = (String)obj;
                if (this._logger != null && this._logger.isDebugEnabled()) {
                    this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"SpawnerMBean.serverURI.fmt.txt", (java.lang.Object)spawnedServer.ServerComponentName(), (java.lang.Object)port));
                }
            }
        }
        catch (Exception e) {
            if (this._logger != null) {
                this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"SpawnerMBean.topPortErr.fmt.txt", (java.lang.Object)spawnedServer.ServerComponentName()), (Throwable)e);
            }
        }
        finally {
            if (fl != null) {
                try {
                    fl.Close();
                }
                catch (Exception exception) {}
                fl = null;
            }
            isi = null;
        }
        m.put(IOM_SERVERPORT_PROPERTY, port);
        m.put(IOM_SERVERCOMPONENT_URI_PROPERTY, serverUri);
        return m;
    }

    private ConnectionInterface connectToTopLevelServer(ISpawnedServer spawnedServer, Map map) {
        ConnectionInterface conn;
        block12: {
            Integer iInt = (Integer)map.get(IOM_SERVERPORT_PROPERTY);
            int port = iInt;
            if (port == -1) {
                return null;
            }
            conn = null;
            if (this._logger != null && this._logger.isDebugEnabled()) {
                this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"SpawnerMBean.topConn.fmt.txt", (java.lang.Object)spawnedServer.ServerComponentName()));
            }
            if (this._userContext != null) {
                try {
                    ServerInterface authServer = this._userContext.getAuthServer();
                    com.sas.services.information.metadata.ServerInterface server = null;
                    String scName = spawnedServer.ServerComponentName();
                    ServerFilter filter = new ServerFilter();
                    filter.setName(scName);
                    filter.setServerType(16);
                    Iterator it = authServer.search((FilterInterface)filter).iterator();
                    if (it.hasNext()) {
                        server = (com.sas.services.information.metadata.ServerInterface)it.next();
                    }
                    if (server == null) {
                        if (this._logger != null) {
                            this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"SpawnerMBean.noServer.fmt.txt", (java.lang.Object)spawnedServer.ServerComponentName()));
                        }
                        return null;
                    }
                    LogicalServerInterface logicalServer = null;
                    it = server.getServed().iterator();
                    java.lang.Object obj = null;
                    while (it.hasNext()) {
                        obj = it.next();
                        if (!(obj instanceof LogicalServerInterface)) continue;
                        logicalServer = obj;
                        break;
                    }
                    if (logicalServer == null) {
                        if (this._logger != null) {
                            this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"SpawnerMBean.noLogical.fmt.txt", (java.lang.Object)spawnedServer.ServerComponentName()));
                        }
                        return null;
                    }
                    String serverUri = (String)map.get(IOM_SERVERCOMPONENT_URI_PROPERTY);
                    String host = this._objectName.getKeyPropertyList().get("host");
                    PlatformConnectionFactoryConfiguration config = new PlatformConnectionFactoryConfiguration(logicalServer, host != null ? host : serverUri, port);
                    PlatformConnectionFactoryInterface cxf = PlatformConnectionFactoryManager.getPlatformConnectionFactory(config);
                    conn = cxf.getConnection(this._userContext);
                    if (this._logger != null && this._logger.isDebugEnabled()) {
                        this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"SpawnerMBean.topConnOk.fmt.txt", (java.lang.Object)spawnedServer.ServerComponentName()));
                    }
                }
                catch (Exception e) {
                    if (this._logger == null) break block12;
                    this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"SpawnerMBean.topConnErr.fmt.txt", (java.lang.Object)spawnedServer.ServerComponentName()), (Throwable)e);
                }
            }
        }
        return conn;
    }

    public CompositeData listSummaryStatus() throws Exception {
        CompositeDataSupport cd = null;
        java.lang.Object[] itemValues = new java.lang.Object[]{this.listClients(), this.listDefinedServers(""), this.listLaunchedServers(""), this.listAbandonedServers("")};
        cd = new CompositeDataSupport(this._summaryCt, SUMMARY_DATA_NAMES, itemValues);
        return cd;
    }

    @Override
    protected void cleanup() {
        if (this._connectionPoint != null) {
            try {
                this._connectionPoint.Unadvise(this._eventsHandle);
            }
            catch (COMM_FAILURE cOMM_FAILURE) {
                // empty catch block
            }
            this._connectionPoint = null;
        }
        super.cleanup();
    }

    @Override
    protected void finalize() throws Throwable {
        try {
            this.cleanup();
        }
        finally {
            super.finalize();
        }
    }

    @SASScope
    class SpawnerEventsListener
    extends _ISpawnerEventsImplBase {
        SpawnerEventsListener() {
        }

        public void ServerEnd(UUID serverID) {
            String uuid = UUIDConverter.uuidToString((UUID)serverID);
            if (null != SpawnerMBean.this._logger && SpawnerMBean.this._logger.isDebugEnabled()) {
                SpawnerMBean.this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"SpawnerMBean.serverEnd.fmt.txt", (java.lang.Object)SpawnerMBean.this._objectNameCanonicalName, (java.lang.Object)uuid));
            }
            Notification notif = new Notification("Spawner.serverEnd", (java.lang.Object)this, System.currentTimeMillis());
            notif.setUserData(uuid);
            SpawnerMBean.this.sendNotification(notif);
        }

        public void ServerFailed(String logicalServer, String serverComponent) {
        }

        public void ServerStart(UUID serverID) {
            block5: {
                String uuid = UUIDConverter.uuidToString((UUID)serverID);
                if (SpawnerMBean.this._logger != null && SpawnerMBean.this._logger.isDebugEnabled()) {
                    SpawnerMBean.this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"SpawnerMBean.serverStart.fmt.txt", (java.lang.Object)SpawnerMBean.this._objectNameCanonicalName, (java.lang.Object)uuid));
                }
                if (SpawnerMBean.this.getAutomaticMBeanRegistration().booleanValue()) {
                    if (SpawnerMBean.this._logger != null && SpawnerMBean.this._logger.isDebugEnabled()) {
                        SpawnerMBean.this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"SpawnerMBean.automaticReg.fmt.txt", (java.lang.Object)SpawnerMBean.this._objectNameCanonicalName, (java.lang.Object)uuid));
                    }
                    try {
                        SpawnerMBean.this.manageLaunchedServer(uuid);
                    }
                    catch (Exception e) {
                        if (SpawnerMBean.this._logger == null) break block5;
                        SpawnerMBean.this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"SpawnerMBean.automaticRegErr.fmt.txt", (java.lang.Object)SpawnerMBean.this._objectNameCanonicalName, (java.lang.Object)uuid), (Throwable)e);
                    }
                }
            }
        }
    }
}

