/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.connection.platform.mgmt;

import com.sas.codepolicy.SASScope;
import com.sas.iom.SASIOMDefs.DateTimeHelper;
import com.sas.iom.SASIOMDefs.UUID;
import com.sas.iom.SASIOMDefs.UUIDHelper;
import com.sas.iom.orb.UUIDConverter;
import com.sas.net.util.DateConverter;
import com.sas.services.connection.Server;
import com.sas.services.connection.platform.mgmt.RB;
import com.sas.text.Message;
import java.util.Date;
import java.util.ResourceBundle;
import javax.management.ObjectName;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;

@SASScope
public class ServerMBeanUtil {
    public static final String WORKSPACE_SERVER_TYPE = "Workspace";
    public static final String METADATA_SERVER_TYPE = "Metadata";
    public static final String SPAWNER_SERVER_TYPE = "Spawner";
    public static final String OLAP_SERVER_TYPE = "OLAP";
    public static final String STOREDPROCESS_SERVER_TYPE = "StoredProcess";
    public static final String TABLE_SERVER_TYPE = "Table";
    public static final String MQX_SERVER_TYPE = "MQX";
    public static final String UNKNOWN_SERVER_TYPE = "Unknown";
    public static final String SERVERTYPE_OBJECTNAME_KEY = "serverType";
    public static final String HOST_OBJECTNAME_KEY = "host";
    public static final String PORT_OBJECTNAME_KEY = "port";
    public static final String LOGICAL_SERVER_OBJECTNAME_KEY = "logicalServer";
    public static final String NAME_OBJECTNAME_KEY = "name";
    public static final String INSTANCEID_OBJECTNAME_KEY = "instanceid";
    public static final String SERVER_INSTANCEID_OBJECTNAME_KEY = "serverInstanceid";
    public static final String TYPE_OBJECTNAME_KEY = "type";
    public static final String SAS_OBJECTNAME_DOMAIN = "com.sas.services:";
    public static final String SERVER_MBEAN_TYPE = "Server";

    private ServerMBeanUtil() {
    }

    public static Object anyObjectToObject(Any anyValue) throws Exception {
        Object obj = null;
        TypeCode typecode = anyValue.type();
        TCKind kind = typecode.kind();
        int kindType = kind.value();
        switch (kindType) {
            case 2: {
                obj = (int)anyValue.extract_short();
                break;
            }
            case 3: {
                obj = anyValue.extract_long();
                break;
            }
            case 6: {
                obj = Float.valueOf(anyValue.extract_float());
                break;
            }
            case 7: {
                obj = anyValue.extract_double();
                break;
            }
            case 8: {
                obj = anyValue.extract_boolean();
                break;
            }
            case 9: {
                obj = anyValue.extract_string();
                break;
            }
            case 23: {
                obj = anyValue.extract_longlong();
                break;
            }
            case 18: {
                obj = anyValue.extract_string();
                break;
            }
            case 21: {
                try {
                    if (!typecode.name().equals(DateTimeHelper.type().name())) break;
                    obj = DateConverter.corbaToJavaGMT((long)DateTimeHelper.extract((Any)anyValue));
                    break;
                }
                catch (BadKind e) {
                    throw new Exception(Message.format((ResourceBundle)RB.getResources(), (String)"ServerMBeanUtil.anyErr.ex.fmt.txt", (Object)e.getLocalizedMessage()));
                }
            }
            case 15: {
                try {
                    if (!typecode.name().equals(UUIDHelper.type().name())) break;
                    UUID uuid = UUIDHelper.extract((Any)anyValue);
                    obj = UUIDConverter.uuidToString((UUID)uuid);
                    break;
                }
                catch (BadKind e) {
                    throw new Exception(Message.format((ResourceBundle)RB.getResources(), (String)"ServerMBeanUtil.anyErr.ex.fmt.txt", (Object)e.getLocalizedMessage()));
                }
            }
            default: {
                obj = anyValue.toString();
            }
        }
        return obj;
    }

    public static String anyToJavaClassName(Any anyValue) {
        String className = null;
        int counterType = anyValue.type().kind().value();
        switch (counterType) {
            case 2: {
                className = Integer.class.getName();
                break;
            }
            case 3: {
                className = Integer.class.getName();
                break;
            }
            case 6: {
                className = Float.class.getName();
                break;
            }
            case 7: {
                className = Double.class.getName();
                break;
            }
            case 8: {
                className = Boolean.class.getName();
                break;
            }
            case 9: {
                className = String.class.getName();
                break;
            }
            case 23: {
                className = Long.class.getName();
                break;
            }
            case 21: {
                className = Date.class.getName();
                break;
            }
            default: {
                className = String.class.getName();
            }
        }
        return className;
    }

    public static Any objectToAny(Object object, ORB orb) {
        Any any = orb.create_any();
        if (object instanceof String) {
            any.insert_string((String)object);
        } else if (object instanceof Integer) {
            any.insert_long(((Integer)object).intValue());
        } else if (object instanceof Long) {
            any.insert_longlong(((Long)object).longValue());
        } else if (object instanceof Boolean) {
            any.insert_boolean(((Boolean)object).booleanValue());
        } else if (object instanceof Double) {
            any.insert_double(((Double)object).doubleValue());
        } else if (object instanceof Float) {
            any.insert_double((double)((Float)object).floatValue());
        } else {
            any.insert_string(object.toString());
        }
        return any;
    }

    public static OpenType objectToOpenType(Object object) {
        SimpleType<Object> ot = SimpleType.STRING;
        if (object instanceof String) {
            ot = SimpleType.STRING;
        } else if (object instanceof Integer) {
            ot = SimpleType.INTEGER;
        } else if (object instanceof Long) {
            ot = SimpleType.LONG;
        } else if (object instanceof Boolean) {
            ot = SimpleType.BOOLEAN;
        } else if (object instanceof Double) {
            ot = SimpleType.DOUBLE;
        } else if (object instanceof Float) {
            ot = SimpleType.FLOAT;
        } else if (object instanceof Date) {
            ot = SimpleType.DATE;
        }
        return ot;
    }

    public static String getLocalizedServerType(UUID classIdentifier) {
        return ServerMBeanUtil.getLocalizedServerType(UUIDConverter.uuidToString((UUID)classIdentifier));
    }

    public static String getLocalizedServerType(String classId) {
        String serverType = "";
        int stype = Server.clsidToServerType((String)classId);
        if (stype == 1) {
            serverType = RB.getStringResource("ServerMBeanUtil.workspaceType.txt");
        } else if (stype == 5) {
            serverType = RB.getStringResource("ServerMBeanUtil.metadataType.txt");
        } else if (stype == 7) {
            serverType = RB.getStringResource("ServerMBeanUtil.spawnerType.txt");
        } else if (stype == 3) {
            serverType = RB.getStringResource("ServerMBeanUtil.olapType.txt");
        } else if (stype == 6) {
            serverType = RB.getStringResource("ServerMBeanUtil.stpType.txt");
        } else if (stype == 8) {
            serverType = RB.getStringResource("ServerMBeanUtil.tableType.txt");
        }
        return serverType;
    }

    public static String getServerTypeForObjectName(UUID classIdentifier) {
        return ServerMBeanUtil.getServerTypeForObjectName(UUIDConverter.uuidToString((UUID)classIdentifier));
    }

    public static String getServerTypeForObjectName(String classId) {
        String serverType = "";
        int stype = Server.clsidToServerType((String)classId);
        switch (stype) {
            case 1: {
                serverType = WORKSPACE_SERVER_TYPE;
                break;
            }
            case 5: {
                serverType = METADATA_SERVER_TYPE;
                break;
            }
            case 7: {
                serverType = SPAWNER_SERVER_TYPE;
                break;
            }
            case 2: 
            case 3: {
                serverType = OLAP_SERVER_TYPE;
                break;
            }
            case 6: {
                serverType = STOREDPROCESS_SERVER_TYPE;
                break;
            }
            case 8: {
                serverType = TABLE_SERVER_TYPE;
                break;
            }
            case 4: {
                serverType = MQX_SERVER_TYPE;
                break;
            }
            case 0: {
                serverType = UNKNOWN_SERVER_TYPE;
            }
        }
        return serverType;
    }

    public static ObjectName createSpawnedServerObjectName(String name, String logicalServerName, UUID classid, String uuid, String host) throws Exception {
        ObjectName on = null;
        String serverType = ServerMBeanUtil.getServerTypeForObjectName(classid);
        on = ServerMBeanUtil.createSpawnedServerObjectName(name, logicalServerName, serverType, uuid, host);
        return on;
    }

    private static ObjectName createSpawnedServerObjectName(String name, String logicalServerName, String serverType, String uuid, String host) throws Exception {
        ObjectName on = null;
        StringBuffer buf = new StringBuffer();
        buf.append(SAS_OBJECTNAME_DOMAIN);
        buf.append(TYPE_OBJECTNAME_KEY);
        buf.append("=");
        buf.append(SERVER_MBEAN_TYPE);
        if (logicalServerName != null) {
            buf.append(",");
            buf.append(LOGICAL_SERVER_OBJECTNAME_KEY);
            buf.append("=");
            buf.append(ObjectName.quote(logicalServerName));
        }
        buf.append(",");
        buf.append(SERVERTYPE_OBJECTNAME_KEY);
        buf.append("=");
        buf.append(serverType);
        buf.append(",");
        buf.append(NAME_OBJECTNAME_KEY);
        buf.append("=");
        buf.append(ObjectName.quote(name));
        buf.append(",");
        buf.append(INSTANCEID_OBJECTNAME_KEY);
        buf.append("=");
        buf.append(ObjectName.quote(uuid));
        buf.append(",");
        buf.append(HOST_OBJECTNAME_KEY);
        buf.append("=");
        buf.append(host);
        on = new ObjectName(buf.toString());
        return on;
    }

    public static ObjectName createObjectName(String name, String logicalServerName, String classid, String host, int port, String uuid) throws Exception {
        ObjectName on = null;
        String serverType = ServerMBeanUtil.getServerTypeForObjectName(classid);
        if (serverType == null) {
            throw new Exception(RB.getStringResource("ServerMBeanUtil.notSupp.ex.txt"));
        }
        if (classid.equalsIgnoreCase("440196d4-90f0-11d0-9f41-00a024bb830c") || classid.equalsIgnoreCase("cf7bc7e6-c7e8-11d5-87e3-00c04f38f9f6") || classid.equalsIgnoreCase("15931e31-667f-11d5-8804-00c04f35ac8c")) {
            on = ServerMBeanUtil.createSpawnedServerObjectName(name, logicalServerName, serverType, uuid, host);
        } else {
            StringBuffer buf = new StringBuffer();
            buf.append(SAS_OBJECTNAME_DOMAIN);
            buf.append(TYPE_OBJECTNAME_KEY);
            buf.append("=");
            buf.append(SERVER_MBEAN_TYPE);
            if (logicalServerName != null) {
                buf.append(",");
                buf.append(LOGICAL_SERVER_OBJECTNAME_KEY);
                buf.append("=");
                buf.append(ObjectName.quote(logicalServerName));
            }
            buf.append(",");
            buf.append(SERVERTYPE_OBJECTNAME_KEY);
            buf.append("=");
            buf.append(serverType);
            if (name != null) {
                buf.append(",");
                buf.append(NAME_OBJECTNAME_KEY);
                buf.append("=");
                buf.append(ObjectName.quote(name));
            }
            buf.append(",");
            buf.append(HOST_OBJECTNAME_KEY);
            buf.append("=");
            buf.append(host);
            buf.append(",");
            buf.append(PORT_OBJECTNAME_KEY);
            buf.append("=");
            buf.append(port);
            on = new ObjectName(buf.toString());
        }
        return on;
    }
}

