/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.connection.platform;

import com.sas.codepolicy.SASScope;
import com.sas.services.connection.ConnectionFactoryKernel;
import com.sas.services.connection.Credential;
import com.sas.services.connection.UserCacheUtil;
import com.sas.services.session.RemoteSessionContextStateChangedListener;
import com.sas.services.session.SessionContextStateChangedEvent;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

@SASScope
public class PlatformUserCacheUtil
extends UserCacheUtil
implements RemoteSessionContextStateChangedListener {
    private Map kernelMap = new WeakHashMap(8);

    protected PlatformUserCacheUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextStateChanged(SessionContextStateChangedEvent event) {
        int ID = event.getStateChange();
        if (ID != 2 && ID != 1) {
            return;
        }
        Map map = this.kernelMap;
        synchronized (map) {
            Set entrySet = this.kernelMap.entrySet();
            for (Map.Entry entry : entrySet) {
                ConnectionFactoryKernel kernel = (ConnectionFactoryKernel)entry.getKey();
                Set userSet = (Set)entry.getValue();
                Iterator userItor = userSet.iterator();
                ConnectionFactoryKernel connectionFactoryKernel = kernel;
                synchronized (connectionFactoryKernel) {
                    while (userItor.hasNext()) {
                        Credential user = (Credential)userItor.next();
                        PlatformUserCacheUtil.remove(kernel, user);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void add(ConnectionFactoryKernel kernel, Credential user) {
        Map map = this.kernelMap;
        synchronized (map) {
            HashSet<Credential> userSet = (HashSet<Credential>)this.kernelMap.get(kernel);
            if (userSet == null) {
                userSet = new HashSet<Credential>(16);
                this.kernelMap.put(kernel, userSet);
            }
            userSet.add(user);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void remove(ConnectionFactoryKernel kernel, Credential user) {
        ConnectionFactoryKernel connectionFactoryKernel = kernel;
        synchronized (connectionFactoryKernel) {
            UserCacheUtil.pruneCache((ConnectionFactoryKernel)kernel, (Credential)user);
        }
    }
}

