/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.connection.platform;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.AssociationList;
import com.sas.metadata.remote.IdentityGroup;
import com.sas.metadata.remote.MdException;
import com.sas.services.ServiceException;
import com.sas.services.connection.AuthServer;
import com.sas.services.connection.ConnectionFactoryException;
import com.sas.services.connection.Credential;
import com.sas.services.connection.PasswordCredential;
import com.sas.services.connection.Puddle;
import com.sas.services.connection.PuddleEnvelope;
import com.sas.services.connection.platform.PlatformPasswordCredential;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.metadata.IdentityGroupInterface;
import com.sas.services.information.metadata.IdentityInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.services.user.UserInitializationException;
import com.sas.services.user.UserServiceInterface;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@SASScope
public class PlatformOMRAuthServer
extends AuthServer {
    private static final int _searchFlags = 10628;
    private static final String _searchFront = "<XMLSELECT search=\"*[IdentityGroups/*[@Id='";
    private static final String _searchMiddle = "']]\"/><Templates><IdentityGroup Name=\"\"><MemberIdentities search=\"";
    private static final String _searchBack = "\"/></IdentityGroup></Templates>";
    private static final int _queryFlags = 2052;
    private static final String _queryFront = "<Templates><IdentityGroup Name=\"\"><MemberIdentities search=\"";
    private static final String _queryBack = "@Name='PUBLIC'\"/></IdentityGroup></Templates>";
    private static final String _queryIDPrefix = "@Id='";
    private static final String _queryIDSuffix = "' or @Name='SASUSERS' or ";
    private static final String _groupPUBLIC = "PUBLIC";
    private static final String _groupSASUSERS = "SASUSERS";
    private static final String _unknownUserID = "UNKNOWN";
    private RepositoryInterface _repos;
    private UserServiceInterface _userService;
    private UserContextInterface _userContext;

    protected PlatformOMRAuthServer(PuddleEnvelope[] envs, RepositoryInterface repos, String poolDomain) {
        super(envs, false, true);
        this._repos = repos;
        ArrayList<String> domainList = new ArrayList<String>(1);
        domainList.add(poolDomain);
        this.setDomains(domainList);
    }

    protected void setUserService(UserServiceInterface userService) {
        this._userService = userService;
    }

    protected Object authenticate(Credential credential) throws ConnectionFactoryException {
        UserContextInterface userContext = null;
        if (credential instanceof PlatformPasswordCredential) {
            PlatformPasswordCredential ppc = (PlatformPasswordCredential)credential;
            userContext = ppc.getUserContext();
        } else if (credential instanceof PasswordCredential) {
            try {
                PasswordCredential pc = (PasswordCredential)credential;
                String userName = pc.getUserName();
                String password = pc.getPassword();
                String domain = pc.getDomain();
                this._userContext = this._userService.newUser(userName, password, domain);
            }
            catch (UserInitializationException uie) {
                this._userContext = uie.getUser();
            }
            catch (ServiceException se) {
                throw new ConnectionFactoryException((Throwable)se);
            }
            catch (RemoteException re) {
                throw new ConnectionFactoryException((Throwable)re);
            }
            userContext = this._userContext;
        } else {
            throw new IllegalArgumentException("\"credential\" must be an instance of PasswordCredential.");
        }
        try {
            IdentityInterface person = userContext.getPerson();
            return person != null ? person.getReposId() : _unknownUserID;
        }
        catch (RemoteException re) {
            throw new ConnectionFactoryException((Throwable)re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean authorizeUser(Object identity, Puddle puddle) throws ConnectionFactoryException {
        Set userSet = puddle.getUsers();
        if (userSet != null && userSet.contains(identity)) {
            return true;
        }
        String identityGroupName = puddle.getPuddleName();
        if (identityGroupName == null) {
            return false;
        }
        if (_groupPUBLIC.equals(identityGroupName)) {
            return true;
        }
        String userID = (String)identity;
        if (_groupSASUSERS.equals(identityGroupName) && userID.indexOf(_unknownUserID) < 0) {
            return true;
        }
        try {
            String identityGroupID = puddle.getPuddleID();
            String identityGroupReposID = "A0000001." + identityGroupID.substring(0, 8);
            String template = PlatformOMRAuthServer.composeQueryTemplate(userID);
            Filter filter = new Filter("Id", 0, identityGroupID);
            filter.setType("IdentityGroup");
            filter.setOMRTemplate(template);
            filter.setOMRRepository(identityGroupReposID);
            filter.setOMRFlags(2052);
            List groupList = this._repos.search((FilterInterface)filter);
            IdentityGroupInterface identityGroup = (IdentityGroupInterface)groupList.get(0);
            PlatformOMRAuthServer.forceQueryInCache(identityGroup);
            List memberList = null;
            try {
                memberList = identityGroup.getMembers();
            }
            finally {
                PlatformOMRAuthServer.clearQueryInCache(identityGroup);
            }
            if (PlatformOMRAuthServer.checkMemberIdentities(memberList, userID)) {
                return true;
            }
            int triedSetSize = memberList != null ? memberList.size() : 0;
            HashSet triedSet = new HashSet(triedSetSize);
            return PlatformOMRAuthServer.searchInGroups(this._repos, identityGroupReposID, userID, identityGroupID, triedSet);
        }
        catch (RemoteException re) {
            throw new ConnectionFactoryException((Throwable)re);
        }
        catch (ServiceException se) {
            throw new ConnectionFactoryException((Throwable)se);
        }
    }

    protected void closeIdentity(Object identity) {
        if (this._userContext != null) {
            try {
                this._userContext.destroy();
            }
            catch (RemoteException remoteException) {
            }
            finally {
                this._userContext = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean searchInGroups(RepositoryInterface repos, String reposID, String userID, String rootID, Set triedSet) throws RemoteException, ServiceException, ConnectionFactoryException {
        if (!triedSet.add(rootID)) {
            return false;
        }
        Filter filter = new Filter();
        filter.setType("IdentityGroup");
        String template = PlatformOMRAuthServer.composeSearchTemplate(userID, rootID);
        filter.setOMRTemplate(template);
        filter.setOMRRepository(reposID);
        filter.setOMRFlags(10628);
        List subGroupList = repos.search((FilterInterface)filter);
        if (subGroupList != null) {
            for (IdentityGroupInterface subGroup : subGroupList) {
                PlatformOMRAuthServer.forceQueryInCache(subGroup);
                List subGroupMemberList = null;
                try {
                    subGroupMemberList = subGroup.getMembers();
                }
                finally {
                    PlatformOMRAuthServer.clearQueryInCache(subGroup);
                }
                if (!PlatformOMRAuthServer.checkMemberIdentities(subGroupMemberList, userID)) continue;
                return true;
            }
            for (IdentityGroupInterface subGroup : subGroupList) {
                String subGroupID = subGroup.getReposId();
                if (!PlatformOMRAuthServer.searchInGroups(repos, reposID, userID, subGroupID, triedSet)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean checkMemberIdentities(List memberIdentitiesList, String userID) throws RemoteException {
        if (memberIdentitiesList == null) {
            return false;
        }
        for (IdentityInterface idnt : memberIdentitiesList) {
            String idntID;
            String idntName = idnt.getName();
            if (idnt instanceof IdentityGroupInterface) {
                if (_groupPUBLIC.equals(idntName)) {
                    return true;
                }
                if (_groupSASUSERS.equals(idntName) && userID.indexOf(_unknownUserID) < 0) {
                    return true;
                }
            }
            if (!userID.equals(idntID = idnt.getReposId())) continue;
            return true;
        }
        return false;
    }

    private static String composeQueryTemplate(String userID) {
        String queryMiddle = null;
        if (userID.indexOf(_unknownUserID) < 0) {
            int midBufLen = userID.length() + 29;
            StringBuffer midBuf = new StringBuffer(midBufLen);
            midBuf.append(_queryIDPrefix).append(userID).append(_queryIDSuffix);
            queryMiddle = midBuf.toString();
        } else {
            queryMiddle = "";
        }
        int bufLen = _queryFront.length() + queryMiddle.length() + _queryBack.length();
        StringBuffer buf = new StringBuffer(bufLen);
        buf.append(_queryFront).append(queryMiddle).append(_queryBack);
        String template = buf.toString();
        return template;
    }

    private static String composeSearchTemplate(String userID, String groupID) {
        int filterBufLen = userID.length() + 45;
        StringBuffer filterBuf = new StringBuffer(filterBufLen);
        if (userID.indexOf(_unknownUserID) < 0) {
            filterBuf.append(_queryIDPrefix).append(userID).append(_queryIDSuffix);
        }
        filterBuf.append("@Name='PUBLIC'");
        String filter = filterBuf.toString();
        int bufLen = _searchFront.length() + _searchMiddle.length() + _searchBack.length() + filter.length() + groupID.length();
        StringBuffer buf = new StringBuffer(bufLen);
        buf.append(_searchFront).append(groupID);
        buf.append(_searchMiddle).append(filter);
        buf.append(_searchBack);
        String template = buf.toString();
        return template;
    }

    private static void forceQueryInCache(IdentityGroupInterface identityGroup) throws RemoteException, ConnectionFactoryException {
        Object reposEntity = identityGroup.getRepositoryEntity();
        if (reposEntity instanceof IdentityGroup) {
            com.sas.metadata.remote.AssociationList memberList = null;
            try {
                memberList = ((IdentityGroup)reposEntity).getMemberIdentities(false);
            }
            catch (MdException me) {
                throw new ConnectionFactoryException((Throwable)me);
            }
            memberList.setState(1);
        } else {
            AssociationList memberList = null;
            try {
                memberList = ((com.sas.metadata.IdentityGroup)reposEntity).getMemberIdentities(false);
            }
            catch (com.sas.metadata.MdException me) {
                throw new ConnectionFactoryException((Throwable)me);
            }
            memberList.setState(1);
        }
    }

    private static void clearQueryInCache(IdentityGroupInterface identityGroup) throws RemoteException, ConnectionFactoryException {
        Object reposEntity = identityGroup.getRepositoryEntity();
        if (reposEntity instanceof IdentityGroup) {
            com.sas.metadata.remote.AssociationList memberList = null;
            try {
                memberList = ((IdentityGroup)reposEntity).getMemberIdentities(false);
            }
            catch (MdException me) {
                throw new ConnectionFactoryException((Throwable)me);
            }
            memberList.resetState(1);
        } else {
            AssociationList memberList = null;
            try {
                memberList = ((com.sas.metadata.IdentityGroup)reposEntity).getMemberIdentities(false);
            }
            catch (com.sas.metadata.MdException me) {
                throw new ConnectionFactoryException((Throwable)me);
            }
            memberList.resetState(1);
        }
    }
}

