/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.connection.omr;

import com.sas.codepolicy.SASScope;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iom.orb.SelectionHub;
import com.sas.meta.SASOMI.IOMI;
import com.sas.meta.SASOMI.ISecurity;
import com.sas.meta.SASOMI.ISecurityHelper;
import com.sas.meta.SASOMI.ISecurityPackage.InvalidCredHandle;
import com.sas.metadata.MetadataWorkspace;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Identity;
import com.sas.metadata.remote.IdentityGroup;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactoryImpl;
import com.sas.metadata.remote.MdOMIUtil;
import com.sas.metadata.remote.MdOMRConnection;
import com.sas.metadata.remote.MdStore;
import com.sas.net.brg.orb.BrgOrb;
import com.sas.services.connection.AuthServer;
import com.sas.services.connection.ConnectionFactoryException;
import com.sas.services.connection.ConnectionResources;
import com.sas.services.connection.Credential;
import com.sas.services.connection.PasswordCredential;
import com.sas.services.connection.Puddle;
import com.sas.services.connection.PuddleEnvelope;
import com.sas.services.connection.omr.OMRConnectionFactoryConfiguration;
import com.sas.services.connection.platform.PlatformPasswordCredential;
import com.sas.services.information.metadata.IdentityInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.Object;
import org.omg.CORBA.StringHolder;
import org.omg.CORBA.SystemException;

@SASScope
public class OMRAuthServer
extends AuthServer {
    private static final int queryFlags = 2052;
    private static final int searchFlags = 10628;
    private static final String _unknownUserID = "UNKNOWN";
    private static final UsageVersion _usageVersionCurrent = new UsageVersion(1, 0);
    private static final UsageVersion _usageVersionOldest = null;
    private IOMI _authMeta;
    private MdStore _store;
    private Properties _env;
    private boolean _noSecurity;
    private ConnectionResources _cxResources;
    private static final String queryFront = "<Templates><IdentityGroup Name=\"\" UsageVersion=\"\"><MemberIdentities search=\"";
    private static final String queryBack = "@Name='PUBLIC'\"/></IdentityGroup></Templates>";
    private static final String search1Front = "<XMLSELECT search=\"*[IdentityGroups/*[@Id='";
    private static final String search1Middle = "']]\"/><Templates><IdentityGroup Name=\"\"><MemberIdentities search=\"";
    private static final String search1Back = "\"/></IdentityGroup></Templates>";

    protected OMRAuthServer(IOMI authMeta, MdStore store, PuddleEnvelope[] envs, Properties env, String domain, boolean cacheUsers) {
        super(envs, false, cacheUsers);
        ArrayList<String> domains = new ArrayList<String>(1);
        if (domain != null) {
            domains.add(domain);
        } else {
            this._noSecurity = true;
            domains.add("");
        }
        this.setDomains(domains);
        this._authMeta = authMeta;
        this._store = store;
        this._env = env;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected java.lang.Object authenticate(Credential credential) throws ConnectionFactoryException {
        if (this._noSecurity) {
            return "noSecurity";
        }
        if (credential instanceof PlatformPasswordCredential) {
            PlatformPasswordCredential ppc = (PlatformPasswordCredential)credential;
            UserContextInterface userContext = ppc.getUserContext();
            try {
                IdentityInterface person = userContext.getPerson();
                return person != null ? person.getReposId() : _unknownUserID;
            }
            catch (RemoteException re) {
                throw new ConnectionFactoryException((Throwable)re);
            }
        }
        if (!(credential instanceof PasswordCredential)) {
            throw new IllegalArgumentException("\"credential\" must be an instance of PasswordCredential.");
        }
        PasswordCredential login = (PasswordCredential)credential;
        OMRAuthServer userContext = this;
        synchronized (userContext) {
            if (this._env == null) {
                if (this._store != null) {
                    try {
                        MdOMRConnection omrConnection = this._store.getFactory().getConnection();
                        this._env = omrConnection.getCMRProperties();
                    }
                    catch (MdException rmde) {
                        throw new ConnectionFactoryException((Throwable)rmde);
                    }
                    catch (RemoteException re) {
                        throw new ConnectionFactoryException((Throwable)re);
                    }
                }
                try {
                    MetadataWorkspace metadataWorkspace = MetadataWorkspace.getWorkspace();
                    this._authMeta = metadataWorkspace.getCMRHandle();
                    this._env = metadataWorkspace.getCMRProperties();
                }
                catch (com.sas.metadata.MdException mde) {
                    throw new ConnectionFactoryException((Throwable)mde);
                }
                this._env.remove("domain");
            }
        }
        Properties myEnv = (Properties)this._env.clone();
        myEnv.put("userName", login.getUserName());
        myEnv.put("password", login.getPassword());
        SelectionHub hub = this._cxResources != null ? this._cxResources.getSelectionHub() : null;
        BrgOrb orb = new BrgOrb(hub);
        try {
            Object obj = orb.propertiesToObject(myEnv);
            ISecurity iSecurity = ISecurityHelper.narrow((Object)obj);
            StringHolder idHolder = new StringHolder();
            iSecurity.GetIdentity("", idHolder);
            String urn = idHolder.value;
            if (urn.indexOf(_unknownUserID) >= 0) {
                String string = urn;
                return string;
            }
            int slashIndex = urn.lastIndexOf(47);
            String string = urn.substring(slashIndex + 1);
            return string;
        }
        catch (NO_PERMISSION np) {
            java.lang.Object var7_19 = null;
            return var7_19;
        }
        catch (SystemException se) {
            throw new ConnectionFactoryException((Throwable)se);
        }
        catch (GenericError ge) {
            throw new ConnectionFactoryException((Throwable)ge);
        }
        catch (InvalidCredHandle ice) {
            throw new ConnectionFactoryException((Throwable)ice);
        }
        finally {
            orb.shutdown(true);
        }
    }

    protected boolean authorizeUser(java.lang.Object identity, Puddle puddle) throws ConnectionFactoryException {
        if (this._noSecurity) {
            return true;
        }
        Set userSet = puddle.getUsers();
        if (userSet != null && userSet.contains(identity)) {
            return true;
        }
        String identityGroupName = puddle.getPuddleName();
        if (identityGroupName == null) {
            return false;
        }
        if ("PUBLIC".equals(identityGroupName)) {
            return true;
        }
        String userID = (String)identity;
        if ("SASUSERS".equals(identityGroupName) && userID.indexOf(_unknownUserID) < 0) {
            return true;
        }
        MdFactoryImpl myFactory = null;
        try {
            MdStore myStore = null;
            if (this._authMeta != null) {
                myFactory = new MdFactoryImpl();
                MdOMRConnection omrConnection = myFactory.getConnection();
                omrConnection.setCMRHandle(this._authMeta);
                myStore = myFactory.createObjectStore();
            } else {
                myStore = this._store;
            }
            String type = "IdentityGroup";
            String identityGroupID = puddle.getPuddleID();
            String template = OMRAuthServer.composeQueryTemplate(userID);
            MdOMIUtil mdOMIUtil = myStore.getFactory().getOMIUtil();
            IdentityGroup identityGroup = (IdentityGroup)mdOMIUtil.getMetadataAllDepths(myStore, type, identityGroupID, null, null, template, 2052);
            OMRAuthServer.checkUsageVersion(identityGroup);
            AssociationList memberList = identityGroup.getMemberIdentities(false);
            if (OMRAuthServer.checkMemberIdentities((List)memberList, userID)) {
                boolean bl = true;
                return bl;
            }
            String reposID = "A0000001." + identityGroup.getRepositoryID();
            int triedSetSize = memberList != null ? memberList.size() : 0;
            HashSet triedSet = new HashSet(triedSetSize);
            boolean bl = OMRAuthServer.searchInGroups(myStore, reposID, userID, identityGroupID, triedSet);
            return bl;
        }
        catch (RemoteException re) {
            throw new ConnectionFactoryException((Throwable)re);
        }
        catch (MdException me) {
            throw new ConnectionFactoryException((Throwable)me);
        }
        finally {
            if (myFactory != null) {
                try {
                    myFactory.dispose();
                }
                catch (RemoteException re) {
                    throw new ConnectionFactoryException((Throwable)re);
                }
            }
        }
    }

    protected List getDomains(Credential login) {
        PlatformPasswordCredential ppc;
        List tempDomains;
        if (login instanceof PlatformPasswordCredential && (tempDomains = (ppc = (PlatformPasswordCredential)login).getFactoryDomainList()) != null) {
            return tempDomains;
        }
        return super.getDomains();
    }

    protected void setConnectionResources(ConnectionResources cxResources) {
        this._cxResources = cxResources;
    }

    private static boolean searchInGroups(MdStore store, String reposID, String userID, String rootID, Set triedSet) throws RemoteException, MdException, ConnectionFactoryException {
        String template;
        String type;
        if (!triedSet.add(rootID)) {
            return false;
        }
        MdOMIUtil omiUtil = store.getFactory().getOMIUtil();
        List subGroupList = omiUtil.getMetadataObjectsSubset(null, reposID, type = "IdentityGroup", 10628, template = OMRAuthServer.composeSearch1Template(userID, rootID));
        if (subGroupList != null) {
            for (IdentityGroup subGroup : subGroupList) {
                OMRAuthServer.checkUsageVersion(subGroup);
                AssociationList subGroupMemberList = subGroup.getMemberIdentities(false);
                if (!OMRAuthServer.checkMemberIdentities((List)subGroupMemberList, userID)) continue;
                return true;
            }
            for (IdentityGroup subGroup : subGroupList) {
                String subGroupID = subGroup.getFQID();
                if (!OMRAuthServer.searchInGroups(store, reposID, userID, subGroupID, triedSet)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean checkMemberIdentities(List memberIdentitiesList, String userID) throws RemoteException {
        if (memberIdentitiesList == null) {
            return false;
        }
        for (Identity idnt : memberIdentitiesList) {
            String idntID;
            String idntName = idnt.getName();
            if (idnt instanceof IdentityGroup) {
                if ("PUBLIC".equals(idntName)) {
                    return true;
                }
                if ("SASUSERS".equals(idntName) && userID.indexOf(_unknownUserID) < 0) {
                    return true;
                }
            }
            if (!userID.equals(idntID = idnt.getFQID())) continue;
            return true;
        }
        return false;
    }

    private static void checkUsageVersion(IdentityGroup identityGroup) throws RemoteException, ConnectionFactoryException {
        double metadataVersionCoded = identityGroup.getUsageVersion();
        UsageVersion metadataVersion = UsageVersion.decode((double)metadataVersionCoded);
        if (!metadataVersion.isReadCompatible(_usageVersionOldest, _usageVersionCurrent)) {
            String metadataType = identityGroup.getCMetadataType();
            String fqid = identityGroup.getFQID();
            String message = OMRConnectionFactoryConfiguration.createUsageVersionErrorMessage(metadataType, fqid, metadataVersion, _usageVersionCurrent);
            throw new ConnectionFactoryException(message);
        }
    }

    private static String composeQueryTemplate(String userID) {
        String queryMiddle = null;
        if (userID.indexOf(_unknownUserID) < 0) {
            int midBufLen = userID.length() + 29;
            StringBuffer midBuf = new StringBuffer(midBufLen);
            midBuf.append("@Id='").append(userID).append("' or @Name='SASUSERS' or ");
            queryMiddle = midBuf.toString();
        } else {
            queryMiddle = "";
        }
        int bufLen = queryFront.length() + queryMiddle.length() + queryBack.length();
        StringBuffer buf = new StringBuffer(bufLen);
        buf.append(queryFront).append(queryMiddle).append(queryBack);
        String template = buf.toString();
        return template;
    }

    private static String composeSearch1Template(String userID, String groupID) {
        int filterBufLen = userID.length() + 45;
        StringBuffer filterBuf = new StringBuffer(filterBufLen);
        if (userID.indexOf(_unknownUserID) < 0) {
            filterBuf.append("@Id='").append(userID).append("'");
            filterBuf.append(" or @Name='SASUSERS' or ");
        }
        filterBuf.append("@Name='PUBLIC'");
        String filter = filterBuf.toString();
        int bufLen = search1Front.length() + search1Middle.length() + search1Back.length() + filter.length() + groupID.length();
        StringBuffer buf = new StringBuffer(bufLen);
        buf.append(search1Front).append(groupID);
        buf.append(search1Middle).append(filter);
        buf.append(search1Back);
        String template = buf.toString();
        return template;
    }
}

