/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.connection.omr;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.AssociationList;
import com.sas.metadata.AuthenticationDomain;
import com.sas.metadata.CMetadata;
import com.sas.metadata.Group;
import com.sas.metadata.Identity;
import com.sas.metadata.IdentityGroup;
import com.sas.metadata.LogicalServer;
import com.sas.metadata.Login;
import com.sas.metadata.Machine;
import com.sas.metadata.MdException;
import com.sas.metadata.Property;
import com.sas.metadata.ServerComponent;
import com.sas.metadata.ServiceType;
import com.sas.metadata.TCPIPConnection;
import com.sas.metadata.Transformation;
import com.sas.metadata.Tree;
import com.sas.services.connection.BridgeServer;
import com.sas.services.connection.Cluster;
import com.sas.services.connection.ConnectionFactoryException;
import com.sas.services.connection.ConnectionFactoryRequest;
import com.sas.services.connection.Credential;
import com.sas.services.connection.FailoverCluster;
import com.sas.services.connection.PasswordCredential;
import com.sas.services.connection.Puddle;
import com.sas.services.connection.Server;
import com.sas.services.connection.omr.OMRConnectionFactoryConfiguration;
import com.sas.services.connection.omr.RB;
import com.sas.services.connection.omr.RemoteUtil;
import com.sas.text.Message;
import com.sas.util.UsageVersion;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

@SASScope
public final class LocalUtil {
    private LocalUtil() {
    }

    public static Object resolve(LogicalServer target, ConnectionFactoryRequest cxfReq) throws ConnectionFactoryException {
        try {
            String fqid = target.getFQID();
            double metadataVersionCoded = target.getUsageVersion();
            UsageVersion metadataVersion = UsageVersion.decode((double)metadataVersionCoded);
            UsageVersion clientCurrent = OMRConnectionFactoryConfiguration.USAGE_VERSION_CURRENT;
            UsageVersion clientOldest = OMRConnectionFactoryConfiguration.USAGE_VERSION_OLDEST;
            if (!metadataVersion.isReadCompatible(clientOldest, clientCurrent)) {
                String metadataType = target.getCMetadataType();
                String message = OMRConnectionFactoryConfiguration.createUsageVersionErrorMessage(metadataType, fqid, metadataVersion, clientCurrent);
                throw new ConnectionFactoryException(message);
            }
            String classID = target.getClassIdentifier();
            AssociationList serviceTypeList = target.getServiceTypes(false);
            LocalUtil.checkServiceType((List)serviceTypeList, fqid);
            AssociationList serverComponents = target.getUsingComponents(false);
            int serverComponentsSize = LocalUtil.checkServerComponentList((List)serverComponents, fqid);
            HashMap clusterMap = new HashMap(serverComponentsSize);
            LocalUtil.resolveClusters((List)serverComponents, classID, clusterMap, cxfReq);
            int clusterType = 1;
            AssociationList transformationList = target.getInitProcesses(false);
            boolean triedPooling = false;
            if (transformationList != null && transformationList.size() > 0) {
                for (Transformation xform : transformationList) {
                    String transformRole = xform.getTransformRole();
                    if (!"Load Balancing".equals(transformRole)) continue;
                    clusterType = 0;
                    break;
                }
            } else {
                AssociationList treeList = target.getSoftwareTrees(false);
                if (treeList != null && treeList.size() > 0) {
                    for (Tree tree : treeList) {
                        String treeType = tree.getTreeType();
                        if (!"Pooling".equals(treeType) && !"Pool".equals(treeType)) continue;
                        triedPooling = true;
                        AssociationList memberList = tree.getMembers(false);
                        Puddle[] puddles = LocalUtil.resolvePuddles((List)memberList, clusterMap);
                        if (puddles == null) continue;
                        if (RemoteUtil.isUnrestrictedPoolAdmin(puddles)) {
                            if (cxfReq != null && cxfReq.isLoggableFINE()) {
                                String msg = "A standard factory will be created from pooling metadata because the Pool Administrator is an Unrestricted User or a User Administrator.";
                                cxfReq.logFINE(msg);
                            }
                            triedPooling = false;
                            break;
                        }
                        return puddles;
                    }
                }
            }
            if (triedPooling && cxfReq != null && cxfReq.isLoggableFINE()) {
                String msg = "A standard factory will be created from pooling metadata because the metadata was incomplete or because the reader did not have sufficient permission to read all the metadata elements.";
                cxfReq.logFINE(msg);
            }
            Set mapEntries = clusterMap.entrySet();
            Iterator entryItor = mapEntries.iterator();
            Cluster[] clusters = new Cluster[mapEntries.size()];
            int i = 0;
            while (entryItor.hasNext()) {
                Map.Entry entry = entryItor.next();
                Set serverSet = (Set)entry.getValue();
                int serverCount = serverSet.size();
                Server[] servers = new Server[serverCount];
                servers = serverSet.toArray(servers);
                boolean reverse = false;
                if (reverse) {
                    for (int j = 0; j < servers.length / 2; ++j) {
                        Server t = servers[j];
                        int n = servers.length - j - 1;
                        servers[j] = servers[n];
                        servers[n] = t;
                    }
                }
                clusters[i++] = Cluster.getInstance((Server[])servers, (int)clusterType);
            }
            return clusters;
        }
        catch (MdException e) {
            throw new ConnectionFactoryException((Throwable)e);
        }
    }

    public static String composeServerComponentURI(ServerComponent serverComponent) throws MdException {
        String uriType = serverComponent.getCMetadataType();
        String uriFQID = serverComponent.getFQID();
        String uri = RemoteUtil.composeURI(uriType, uriFQID);
        return uri;
    }

    private static void checkServiceType(List serviceTypeList, String fqid) throws ConnectionFactoryException {
        if (serviceTypeList != null) {
            for (ServiceType serviceType : serviceTypeList) {
                String serviceTypeName = serviceType.getName();
                if (!"Logical IOM Server".equals(serviceTypeName)) continue;
                return;
            }
        }
        String messageIndex = "cxo.000.ex.fmt";
        String messagePattern = RB.getStringResource(messageIndex);
        String message = Message.format((String)messagePattern, (Object)fqid);
        throw new ConnectionFactoryException(message);
    }

    private static int checkServerComponentList(List serverComponentList, String fqid) throws ConnectionFactoryException {
        int size;
        int n = size = serverComponentList != null ? serverComponentList.size() : 0;
        if (size == 0) {
            String messageIndex = "cxo.004.ex.fmt";
            String messagePattern = RB.getStringResource(messageIndex);
            String message = Message.format((String)messagePattern, (Object)fqid);
            throw new ConnectionFactoryException(message);
        }
        return size;
    }

    private static void resolveClusters(List serverComponents, String classID, Map clusterMap, ConnectionFactoryRequest cxfReq) throws ConnectionFactoryException {
        for (Object sc : serverComponents) {
            if (sc instanceof LogicalServer) {
                String messageIndex = "cxo.008.ex.txt";
                String message = RB.getStringResource(messageIndex);
                throw new ConnectionFactoryException(message);
            }
            Server[] serverArr = LocalUtil.resolveServer(sc, classID, true, cxfReq);
            if (serverArr == null || serverArr.length == 0) continue;
            String domain = serverArr[0].getDomain();
            HashSet<Server> serverSet = (HashSet<Server>)clusterMap.get(domain);
            if (serverSet == null) {
                int size = serverComponents.size();
                serverSet = new HashSet<Server>(size);
                clusterMap.put(domain, serverSet);
            }
            for (int i = 0; i < serverArr.length; ++i) {
                serverSet.add(serverArr[i]);
            }
        }
        int clusterMapL = clusterMap.size();
        if (clusterMapL == 0) {
            Object sc = serverComponents.get(0);
            LocalUtil.resolveServer(sc, classID, false, cxfReq);
        }
    }

    private static Puddle[] resolvePuddles(List puddleGroups, Map clusterMap) throws ConnectionFactoryException {
        int puddleGroupsSize = puddleGroups != null ? puddleGroups.size() : 0;
        HashSet<Puddle> puddleSet = new HashSet<Puddle>(puddleGroupsSize);
        for (int i = 0; i < puddleGroupsSize; ++i) {
            int j;
            Object o = puddleGroups.get(i);
            if (!(o instanceof Group)) continue;
            Group group = (Group)o;
            String groupID = group.getFQID();
            String pudDomain = null;
            PasswordCredential pudLogin = null;
            String pudID = null;
            String pudName = null;
            HashSet<String> userSet = null;
            HashSet<PasswordCredential> authorizedUserCredentials = null;
            int minSize = Integer.MIN_VALUE;
            int minAvail = Integer.MIN_VALUE;
            try {
                AssociationList memberList = group.getMembers(false);
                int memberListSize = memberList != null ? memberList.size() : 0;
                for (int j2 = 0; j2 < memberListSize; ++j2) {
                    String message;
                    String messagePattern;
                    Object z = memberList.get(j2);
                    if (z instanceof Login) {
                        if (pudLogin != null) {
                            String messageIndex = "cxo.010.ex.fmt";
                            messagePattern = RB.getStringResource(messageIndex);
                            message = Message.format((String)messagePattern, (Object)groupID);
                            throw new ConnectionFactoryException(message);
                        }
                        Login login = (Login)z;
                        AuthenticationDomain domain = login.getDomain();
                        if (domain != null) {
                            pudDomain = domain.getName();
                        }
                        String userName = login.getUserID();
                        String password = login.getPassword();
                        pudLogin = new PasswordCredential(userName, password, pudDomain);
                        Identity identity = login.getAssociatedIdentity();
                        String ownerID = identity.getFQID();
                        userSet = new HashSet<String>(1);
                        userSet.add(ownerID);
                        AssociationList loginList = identity.getLogins(false);
                        int loginListSize = loginList != null ? loginList.size() : 0;
                        authorizedUserCredentials = new HashSet<PasswordCredential>(loginListSize);
                        authorizedUserCredentials.add(pudLogin);
                        String loginID = login.getFQID();
                        LocalUtil.addAuthorizedCredentials(identity, authorizedUserCredentials, loginID);
                        continue;
                    }
                    if (z instanceof IdentityGroup) {
                        if (pudID != null) {
                            String messageIndex = "cxo.011.ex.fmt";
                            messagePattern = RB.getStringResource(messageIndex);
                            message = Message.format((String)messagePattern, (Object)groupID);
                            throw new ConnectionFactoryException(message);
                        }
                        IdentityGroup pudIDGroup = (IdentityGroup)z;
                        pudID = pudIDGroup.getFQID();
                        pudName = pudIDGroup.getName();
                        continue;
                    }
                    String messageIndex = "cxo.012.ex.fmt";
                    messagePattern = RB.getStringResource(messageIndex);
                    message = Message.format((String)messagePattern, (Object)groupID);
                    throw new ConnectionFactoryException(message);
                }
                if (pudLogin == null) continue;
                AssociationList propertyList = group.getProperties(false);
                int propertyListSize = propertyList != null ? propertyList.size() : 0;
                for (j = 0; j < propertyListSize; ++j) {
                    Property property = (Property)propertyList.get(j);
                    String propertyName = property.getPropertyName();
                    String propertyValue = property.getDefaultValue();
                    try {
                        if (propertyValue == null) continue;
                        if ("MinSize".equals(propertyName)) {
                            minSize = Integer.parseInt(propertyValue);
                            continue;
                        }
                        if (!"MinAvail".equals(propertyName)) continue;
                        minAvail = Integer.parseInt(propertyValue);
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        String messageIndex = "cxo.001.ex.fmt";
                        String messagePattern = RB.getStringResource(messageIndex);
                        String message = Message.format((String)messagePattern, (Object)property.getFQID());
                        throw new ConnectionFactoryException(message);
                    }
                }
            }
            catch (MdException me) {
                throw new ConnectionFactoryException((Throwable)me);
            }
            Set serverSet = (Set)clusterMap.get(pudDomain);
            if (serverSet == null) continue;
            int serverCount = serverSet.size();
            Cluster[] clusters = new Cluster[serverCount];
            Iterator serverItor = serverSet.iterator();
            j = 0;
            while (serverItor.hasNext()) {
                Server server = (Server)serverItor.next();
                clusters[j++] = new FailoverCluster(server);
            }
            Puddle puddle = new Puddle(clusters, (Credential)pudLogin);
            if (minSize != Integer.MIN_VALUE) {
                puddle.setMinSize(minSize);
            }
            if (minAvail != Integer.MIN_VALUE) {
                puddle.setMinAvail(minAvail);
            }
            if (authorizedUserCredentials != null) {
                puddle.setUserCredentials(authorizedUserCredentials);
            }
            if (pudID != null) {
                puddle.setPuddleID(pudID);
            }
            if (pudName != null) {
                puddle.setPuddleName(pudName);
            }
            if (userSet != null) {
                puddle.setUsers(userSet);
            }
            puddleSet.add(puddle);
        }
        int puddleCount = puddleSet.size();
        if (puddleCount == 0) {
            return null;
        }
        Puddle[] puddles = new Puddle[puddleCount];
        puddles = puddleSet.toArray(puddles);
        return puddles;
    }

    private static Server[] resolveServer(Object sc, String classID, boolean ignoreConfigError, ConnectionFactoryRequest cxfReq) throws ConnectionFactoryException {
        try {
            String serverName;
            if (!(sc instanceof ServerComponent)) {
                String messageIndex = "cxo.005.ex.fmt";
                String messagePattern = RB.getStringResource(messageIndex);
                String message = Message.format((String)messagePattern, (Object)((CMetadata)sc).getFQID());
                throw new ConnectionFactoryException(message);
            }
            ServerComponent serverComponent = (ServerComponent)sc;
            AssociationList serviceTypeList = serverComponent.getServiceTypes(false);
            String serviceTypeName = null;
            if (serviceTypeList != null && serviceTypeList.size() > 0) {
                ServiceType serviceType = (ServiceType)serviceTypeList.get(0);
                serviceTypeName = serviceType.getName();
            }
            if (serviceTypeName == null || !"IOM Server".equals(serviceTypeName)) {
                String messageIndex = "cxo.006.ex.fmt";
                String messagePattern = RB.getStringResource(messageIndex);
                String message = Message.format((String)messagePattern, (Object)serverComponent.getFQID());
                throw new ConnectionFactoryException(message);
            }
            String host = null;
            int port = -1;
            String encryptionPolicy = null;
            String encryptionContent = null;
            String encryptionAlgorithms = null;
            String domainName = null;
            AssociationList cxList = serverComponent.getSourceConnections(false);
            int cxListSize = cxList != null ? cxList.size() : 0;
            for (int j = 0; j < cxListSize; ++j) {
                AuthenticationDomain domain;
                TCPIPConnection cx;
                String protocol;
                Object o = cxList.get(j);
                if (!(o instanceof TCPIPConnection) || !"Bridge".equals(protocol = (cx = (TCPIPConnection)o).getApplicationProtocol())) continue;
                host = cx.getHostName();
                port = cx.getPort();
                AssociationList propertyList = cx.getProperties(false);
                if (propertyList != null) {
                    int propertyListSize = propertyList.size();
                    HashMap cxProperties = new HashMap(propertyListSize);
                    LocalUtil.addProperties((List)propertyList, cxProperties);
                    String requiredEncryptionLevel = (String)cxProperties.get("RequiredEncryptionLevel");
                    if ("credentials".equals(requiredEncryptionLevel) || "authentication".equals(requiredEncryptionLevel)) {
                        encryptionPolicy = "required";
                        encryptionContent = "authentication";
                    } else if ("everything".equals(requiredEncryptionLevel) || "all".equals(requiredEncryptionLevel)) {
                        encryptionPolicy = "required";
                        encryptionContent = "all";
                    }
                    encryptionAlgorithms = (String)cxProperties.get("ServerEncryptionAlgorithms");
                }
                if ((domain = cx.getDomain()) == null) break;
                domainName = domain.getName();
                break;
            }
            AssociationList treeLst = serverComponent.getSoftwareTrees(false);
            ArrayList<String> hostLst = null;
            if (treeLst != null && !treeLst.isEmpty()) {
                for (Tree tree : treeLst) {
                    int machineLstL;
                    String treeType = tree.getTreeType();
                    if (!"MachineGroup".equals(treeType)) continue;
                    AssociationList machineLst = tree.getMembers(false);
                    int n = machineLstL = machineLst != null ? machineLst.size() : 0;
                    if (machineLstL <= 0) break;
                    hostLst = new ArrayList(machineLstL);
                    for (Machine machine : machineLst) {
                        String name = machine.getName();
                        hostLst.add(name);
                    }
                }
            }
            if (hostLst == null) {
                hostLst = new ArrayList<String>(1);
                hostLst.add(host);
            }
            int maxClients = Integer.MIN_VALUE;
            int reactivationLimit = Integer.MIN_VALUE;
            int shutdownAfterMinutes = Integer.MIN_VALUE;
            AssociationList propertyList = serverComponent.getProperties(false);
            if (propertyList != null) {
                String shutdownAfterMinutesString;
                String reactivationLimitString;
                int propertyListSize = propertyList.size();
                HashMap serverInfo = new HashMap(propertyListSize);
                LocalUtil.addProperties((List)propertyList, serverInfo);
                String maxClientsString = (String)serverInfo.get("MaxClients");
                if (maxClientsString != null) {
                    maxClients = Integer.parseInt(maxClientsString);
                }
                if ((reactivationLimitString = (String)serverInfo.get("RecycleActivationLimit")) != null) {
                    reactivationLimit = Integer.parseInt(reactivationLimitString);
                }
                if ((shutdownAfterMinutesString = (String)serverInfo.get("ServerShutdownAfter")) != null) {
                    shutdownAfterMinutes = Integer.parseInt(shutdownAfterMinutesString);
                }
            }
            int serverNameL = (serverName = serverComponent.getName()) != null ? serverName.length() : 0;
            int hostLstL = hostLst.size();
            ArrayList<BridgeServer> serverLst = new ArrayList<BridgeServer>(hostLstL);
            block9: for (int i = 0; i < hostLstL; ++i) {
                String h = (String)hostLst.get(i);
                BridgeServer server = null;
                try {
                    server = new BridgeServer(classID, h, port);
                }
                catch (IllegalArgumentException iae) {
                    if (ignoreConfigError) {
                        if (cxfReq == null || !cxfReq.isLoggableWARNING()) continue;
                        String msg = "ignoring error configuring factory for connections to " + h + ":" + port;
                        cxfReq.logWARNING(msg, (Throwable)iae);
                        continue;
                    }
                    throw iae;
                }
                serverLst.add(server);
                if (encryptionPolicy != null) {
                    server.setEncryptionPolicy(encryptionPolicy);
                }
                if (encryptionContent != null) {
                    server.setEncryptionContent(encryptionContent);
                }
                if (encryptionAlgorithms != null) {
                    server.setEncryptionAlgorithms(encryptionAlgorithms);
                }
                if (maxClients != Integer.MIN_VALUE) {
                    server.setMaxClients(maxClients);
                }
                if (reactivationLimit != Integer.MIN_VALUE) {
                    server.setReactivationLimit(reactivationLimit);
                }
                if (shutdownAfterMinutes != Integer.MIN_VALUE) {
                    server.setShutdownAfterMinutes(shutdownAfterMinutes);
                }
                if (domainName != null) {
                    server.setDomain(domainName);
                }
                if (serverNameL > 0 && !RemoteUtil.isIgnoreServerName()) {
                    server.setServerName(serverName);
                }
                String uri = LocalUtil.composeServerComponentURI(serverComponent);
                server.setServerComponentURI(uri);
                AssociationList usedByLst = serverComponent.getUsedByComponents(false);
                Iterator usedByItr = usedByLst.iterator();
                while (usedByItr.hasNext()) {
                    String spn;
                    String securityPackageList;
                    String securityPackage;
                    LogicalServer logSrv = null;
                    try {
                        logSrv = (LogicalServer)usedByItr.next();
                    }
                    catch (ClassCastException cce) {
                        continue;
                    }
                    AssociationList logSrvPropLst = logSrv.getProperties(false);
                    if (logSrvPropLst == null) continue block9;
                    int logSrvPropLstL = logSrvPropLst.size();
                    HashMap serverInfo = new HashMap(logSrvPropLstL);
                    LocalUtil.addProperties((List)logSrvPropLst, serverInfo);
                    String authService = (String)serverInfo.get("AuthService");
                    if (authService != null && authService.length() > 0) {
                        server.setAuthService(authService);
                    }
                    if ((securityPackage = (String)serverInfo.get("SecurityPackage")) != null && securityPackage.length() > 0) {
                        server.setSecurityPackage(securityPackage);
                    }
                    if ((securityPackageList = (String)serverInfo.get("SecurityPackageList")) != null && securityPackageList.length() > 0) {
                        server.setSecurityPackageList(securityPackageList);
                    }
                    if ((spn = (String)serverInfo.get("SPN")) == null || spn.length() <= 0) continue block9;
                    server.setSPN(spn);
                    continue block9;
                }
            }
            int serverLstL = serverLst.size();
            Server[] serverArr = new Server[serverLstL];
            serverArr = serverLst.toArray(serverArr);
            return serverArr;
        }
        catch (MdException e) {
            throw new ConnectionFactoryException((Throwable)e);
        }
    }

    private static void addAuthorizedCredentials(Identity identity, Set authorizedUserCredentials, String knownID) throws ConnectionFactoryException {
        try {
            if (identity instanceof IdentityGroup) {
                IdentityGroup identityGroup = (IdentityGroup)identity;
                AssociationList nestedIdentityList = identityGroup.getMemberIdentities();
                int nestedIdentityListSize = nestedIdentityList != null ? nestedIdentityList.size() : 0;
                for (int i = 0; i < nestedIdentityListSize; ++i) {
                    Identity nestedIdentity = (Identity)nestedIdentityList.get(i);
                    LocalUtil.addAuthorizedCredentials(nestedIdentity, authorizedUserCredentials, knownID);
                }
            } else {
                AssociationList loginList = identity.getLogins(false);
                for (Login login : loginList) {
                    String ID = login.getFQID();
                    if (knownID.equals(ID)) continue;
                    AuthenticationDomain domain = login.getDomain();
                    String domainName = domain != null ? domain.getName() : "";
                    String userName = login.getUserID();
                    String password = login.getPassword();
                    PasswordCredential credential = new PasswordCredential(userName, password, domainName);
                    authorizedUserCredentials.add(credential);
                }
            }
        }
        catch (MdException e) {
            throw new ConnectionFactoryException((Throwable)e);
        }
    }

    private static void addProperties(List propertyList, Map table) {
        int propertyListSize = propertyList.size();
        for (int i = 0; i < propertyListSize; ++i) {
            Property property = (Property)propertyList.get(i);
            table.put(property.getPropertyName(), property.getDefaultValue());
        }
    }
}

