/*
 * Decompiled with CFR 0.152.
 */
package com.sas.testcontainer;

import com.sas.editor.CodeEditor;
import com.sas.editor.CodeEditorDefaults;
import com.sas.editor.CodeEditorDocument;
import com.sas.editor.CodeLanguage;
import com.sas.editor.EditableRegion;
import com.sas.editor.EditorSubmit;
import com.sas.editor.LogAutoRollingFileStorageConfigData;
import com.sas.editor.LogListDocument;
import com.sas.editor.LogListHolder;
import com.sas.editor.LogListViewer;
import com.sas.editor.LogMemoryStorageConfigData;
import com.sas.editor.LogStorageConfigDataInterface;
import com.sas.editor.LogTemporaryRollingFileStorageConfigData;
import com.sas.iom.SAS.ILanguageServicePackage.CarriageControl;
import com.sas.iom.SAS.ILanguageServicePackage.CarriageControlSeqHolder;
import com.sas.iom.SAS.ILanguageServicePackage.LineType;
import com.sas.iom.SAS.ILanguageServicePackage.LineTypeSeqHolder;
import com.sas.iom.SAS.IWorkspace;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iom.SASIOMDefs.StringSeqHolder;
import com.sas.testcontainer.ChooseLogAppendSizeDlg;
import com.sas.testcontainer.CodeEditorTest;
import com.sas.testcontainer.SetDiskLogSizeParms;
import com.sas.testcontainer.SetMemoryLogSizeParms;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.visuals.adapters.SpacePartitionerInterface;
import java.awt.Color;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.ActionMap;
import javax.swing.JApplet;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.filechooser.FileFilter;

public class CodeEditorTestContainer
extends JApplet
implements MenuListener {
    protected CodeEditor mEditor = null;
    protected IWorkspace m_workspace = null;
    protected EditorSubmit m_EditorSubmit = null;
    protected JFrame m_LogFrame = null;
    protected LogListViewer m_Log = null;
    protected JFrame m_OutputFrame = null;
    protected LogListViewer m_Output = null;
    protected CodeEditorDefaults m_Defaults = null;
    protected static JFrame f;
    protected static JFrame htmlFrame;
    protected JMenu file = null;
    protected JMenu edit = null;
    protected JMenu view = null;
    protected JMenu iom = null;
    protected JMenuItem open = null;
    protected JMenuItem save = null;
    protected JMenuItem saveas = null;
    protected JMenuItem append = null;
    protected JMenuItem print = null;
    protected JMenuItem pageSetup = null;
    protected JMenuItem printFold = null;
    protected JMenuItem fileExit = null;
    protected JMenuItem dump = null;
    protected JMenuItem cut = null;
    protected JMenuItem copy = null;
    protected JMenuItem paste = null;
    protected JMenuItem selectall = null;
    protected JMenuItem clearall = null;
    protected JMenuItem coloron = null;
    protected JMenuItem coloroff = null;
    protected JMenuItem undo = null;
    protected JMenuItem redo = null;
    protected JMenuItem find = null;
    protected JMenuItem gotoline = null;
    protected JMenuItem options = null;
    protected JMenuItem keys = null;
    protected JCheckBoxMenuItem langSas = null;
    protected JCheckBoxMenuItem langHtml = null;
    protected JCheckBoxMenuItem langJava = null;
    protected JCheckBoxMenuItem langText = null;
    protected JCheckBoxMenuItem langLog = null;
    protected JCheckBoxMenuItem langList = null;
    protected JCheckBoxMenuItem lineNumbers = null;
    protected JMenuItem scrollSelectionToTop = null;
    protected JCheckBoxMenuItem readOnlyMenuItem = null;
    protected JMenuItem connect = null;
    protected JMenuItem showlog = null;
    static int mLastGroupSize;
    static int mLastNumGroups;

    public static void main(String[] args) {
        boolean memTest = false;
        if (!memTest) {
            f = new JFrame("Code Editor Test Container");
            f.setDefaultCloseOperation(3);
            final CodeEditorTestContainer testApp = new CodeEditorTestContainer();
            testApp.init();
            testApp.start();
            f.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    testApp.stop();
                    testApp.destroy();
                }
            });
            f.getContentPane().add("Center", testApp);
            f.setSize(300, 300);
            f.setVisible(true);
        } else {
            CodeEditorTest test = new CodeEditorTest();
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                SwingUtilities.updateComponentTreeUI(test);
            }
            catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    @Override
    public void init() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            SwingUtilities.updateComponentTreeUI(this);
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        this.m_Defaults = new CodeEditorDefaults();
        JPanel p = new JPanel();
        AutoSizingGridLayout windowLayout = new AutoSizingGridLayout(1, 1, 0, 0, true, true, true);
        this.getContentPane().setLayout((LayoutManager)windowLayout);
        this.getContentPane().add(p);
        AutoSizingGridLayout panelLayout = new AutoSizingGridLayout(1, 2, 0, 0, true, true, true);
        panelLayout.setColumnSpacePartitioner(new SpacePartitionerInterface(){

            public int getPartitionedSpace(int[] sizes, int totalSize, int[] preferredSizes) {
                sizes[0] = totalSize / 2;
                sizes[1] = totalSize / 2;
                return totalSize - (sizes[0] + sizes[1]);
            }
        });
        p.setLayout((LayoutManager)panelLayout);
        this.mEditor = new CodeEditor(this.m_Defaults);
        p.add(this.mEditor);
        CodeEditor ed2 = new CodeEditor(this.m_Defaults);
        p.add(ed2);
        if (this.mEditor.getEditorPane().getCodeEditorDocument() instanceof LogListDocument) {
            LogTemporaryRollingFileStorageConfigData data = null;
            try {
                data = new LogTemporaryRollingFileStorageConfigData(60000, 10);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ((LogListDocument)this.mEditor.getEditorPane().getCodeEditorDocument()).setStorageParameters(data);
        }
        this.addMenus();
        StringSeqHolder seqtext = new StringSeqHolder();
        seqtext.value = new String[2];
        CarriageControlSeqHolder cc = new CarriageControlSeqHolder();
        cc.value = new CarriageControl[2];
        cc.value[0] = CarriageControl.CarriageControlNormal;
        cc.value[1] = CarriageControl.CarriageControlNormal;
        LineTypeSeqHolder lt = new LineTypeSeqHolder();
        lt.value = new LineType[2];
        lt.value[0] = LineType.LineTypeError;
        lt.value[1] = LineType.LineTypeWarning;
        seqtext.value[0] = "some error text";
        seqtext.value[1] = "some warning text";
    }

    @Override
    public void destroy() {
        if (this.m_Defaults != null) {
            this.m_Defaults.saveProperties();
        }
        this.mEditor.cleanup();
        if (null != this.m_workspace) {
            try {
                this.m_workspace.Close();
            }
            catch (GenericError genericError) {
                // empty catch block
            }
        }
    }

    protected void addMenus() {
        ActionMap am = this.mEditor.getEditorPane().getActionMap();
        this.file = new JMenu("File");
        this.file.setMnemonic('F');
        this.file.addMenuListener(this);
        this.edit = new JMenu("Edit");
        this.edit.setMnemonic('E');
        this.edit.addMenuListener(this);
        this.view = new JMenu("View");
        this.view.setMnemonic('V');
        this.view.addMenuListener(this);
        this.iom = new JMenu("IOM");
        this.iom.setMnemonic('I');
        this.open = new JMenuItem("Open...", 79);
        this.open.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String fileToOpen = CodeEditorTestContainer.this.getFileNameFromUser(CodeEditorTestContainer.this.mEditor.getFilename(), "Open File", 0, false);
                    if (fileToOpen != null && CodeEditorTestContainer.this.mEditor.checkSaveContents()) {
                        CodeEditorTestContainer.this.mEditor.getEditorPane().setText("");
                        CodeEditorTestContainer.this.mEditor.openFile(fileToOpen);
                        CodeEditorTestContainer.this.UpdateFilename();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.open.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.save = new JMenuItem("Save", 83);
        this.save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    CodeEditorTestContainer.this.mEditor.save();
                    CodeEditorTestContainer.this.UpdateFilename();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.saveas = new JMenuItem("Save As...", 65);
        this.saveas.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String fileToSave = CodeEditorTestContainer.this.getFileNameFromUser(CodeEditorTestContainer.this.mEditor.getFilename(), "Save File", 0, true);
                    if (fileToSave != null) {
                        CodeEditorTestContainer.this.mEditor.saveFile(fileToSave);
                        CodeEditorTestContainer.this.UpdateFilename();
                    }
                }
                catch (Exception ex) {
                    System.out.println("Exception thrown in CodeEditor.dlgSaveAs");
                }
            }
        });
        this.saveas.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.append = new JMenuItem("Append...", 69);
        this.append.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String fileName = CodeEditorTestContainer.this.getFileNameFromUser(CodeEditorTestContainer.this.mEditor.getFilename(), "File to Append", -1, false);
                if (fileName != null) {
                    CodeEditorTestContainer.this.mEditor.appendFile(fileName);
                }
            }
        });
        this.print = new JMenuItem("Print", 80);
        this.print.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodeEditorTestContainer.this.printDlg();
            }
        });
        this.printFold = new JMenuItem("Print Folding", 70);
        this.printFold.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodeEditorTestContainer.this.printFold();
            }
        });
        this.pageSetup = new JMenuItem("Page Setup", 85);
        this.pageSetup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodeEditorTestContainer.this.pageSetupDlg();
            }
        });
        this.fileExit = new JMenuItem("Exit", 88);
        this.fileExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodeEditorTestContainer.this.stop();
                CodeEditorTestContainer.this.destroy();
            }
        });
        this.dump = new JMenuItem(am.get("dump-debug-info"));
        this.dump.setText("Dump Debug Info");
        this.dump.setMnemonic('D');
        this.cut = new JMenuItem(am.get("cut-to-clipboard"));
        this.cut.setText("Cut");
        this.cut.setMnemonic('T');
        this.copy = new JMenuItem(am.get("copy-to-clipboard"));
        this.copy.setText("Copy");
        this.copy.setMnemonic('C');
        this.paste = new JMenuItem(am.get("paste-from-clipboard"));
        this.paste.setText("Paste");
        this.paste.setMnemonic('P');
        this.selectall = new JMenuItem(am.get("select-all"));
        this.selectall.setText("Select All");
        this.selectall.setMnemonic('S');
        this.clearall = new JMenuItem(am.get("clear-all"));
        this.clearall.setText("Clear All");
        this.clearall.setMnemonic('R');
        this.coloron = new JMenuItem(am.get("enable-coloring"));
        this.coloron.setText("Color On");
        this.coloron.setMnemonic('N');
        this.coloroff = new JMenuItem(am.get("disable-coloring"));
        this.coloroff.setText("Color Off");
        this.coloroff.setMnemonic('L');
        this.undo = new JMenuItem(am.get("undo"));
        this.undo.setText("Undo");
        this.undo.setMnemonic('U');
        this.redo = new JMenuItem(am.get("redo"));
        this.redo.setText("Redo");
        this.redo.setMnemonic('D');
        this.find = new JMenuItem(am.get("find-dialog"));
        this.find.setText("Find...");
        this.find.setMnemonic('F');
        this.readOnlyMenuItem = new JCheckBoxMenuItem("Read Only", false);
        this.readOnlyMenuItem.setMnemonic('O');
        this.readOnlyMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodeEditorTestContainer.this.toggleReadOnly();
            }
        });
        this.gotoline = new JMenuItem(am.get("goto-line"));
        this.gotoline.setText("Go To Line...");
        this.gotoline.setMnemonic('G');
        this.options = new JMenuItem("Editor Options...");
        this.options.setMnemonic('P');
        this.options.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodeEditorTestContainer.this.displayOptionsDialog();
            }
        });
        this.keys = new JMenuItem("Assign Keys...");
        this.keys.setMnemonic('K');
        this.keys.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodeEditorTestContainer.this.displayKeysDialog();
            }
        });
        this.scrollSelectionToTop = new JMenuItem("Scroll selection to top");
        this.scrollSelectionToTop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selStart = CodeEditorTestContainer.this.mEditor.getEditorPane().getSelectionStart();
                try {
                    Rectangle offsetRect = CodeEditorTestContainer.this.mEditor.getEditorPane().modelToView(selStart);
                    CodeEditorTestContainer.this.mEditor.getEditorPane().getScrollPane().getViewport().setViewPosition(offsetRect.getLocation());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.lineNumbers = new JCheckBoxMenuItem("Line Numbers", false);
        this.lineNumbers.setMnemonic('L');
        this.lineNumbers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodeEditorTestContainer.this.toggleLineNumbers();
            }
        });
        this.langSas = new JCheckBoxMenuItem("SAS Language");
        this.langSas.setMnemonic('S');
        this.langSas.setState(CodeLanguage.SAS == this.mEditor.getLanguage());
        this.langSas.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodeEditorTestContainer.this.setLanguageAndSwapEditorIfNecessary(CodeLanguage.SAS);
                CodeEditorTestContainer.this.clearLanguageStates();
                CodeEditorTestContainer.this.langSas.setState(true);
            }
        });
        this.langHtml = new JCheckBoxMenuItem("Html Language");
        this.langHtml.setMnemonic('H');
        this.langHtml.setState(CodeLanguage.HTML == this.mEditor.getLanguage());
        this.langHtml.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodeEditorTestContainer.this.setLanguageAndSwapEditorIfNecessary(CodeLanguage.HTML);
                CodeEditorTestContainer.this.clearLanguageStates();
                CodeEditorTestContainer.this.langHtml.setState(true);
            }
        });
        this.langJava = new JCheckBoxMenuItem("Java Language");
        this.langJava.setMnemonic('J');
        this.langJava.setState(CodeLanguage.JAVA == this.mEditor.getLanguage());
        this.langJava.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodeEditorTestContainer.this.setLanguageAndSwapEditorIfNecessary(CodeLanguage.JAVA);
                CodeEditorTestContainer.this.clearLanguageStates();
                CodeEditorTestContainer.this.langJava.setState(true);
            }
        });
        this.langText = new JCheckBoxMenuItem("Text Language");
        this.langText.setMnemonic('T');
        this.langText.setState(CodeLanguage.TEXT == this.mEditor.getLanguage());
        this.langText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodeEditorTestContainer.this.setLanguageAndSwapEditorIfNecessary(CodeLanguage.TEXT);
                CodeEditorTestContainer.this.clearLanguageStates();
                CodeEditorTestContainer.this.langText.setState(true);
            }
        });
        this.langLog = new JCheckBoxMenuItem("Log Language");
        this.langLog.setMnemonic('G');
        this.langLog.setState(CodeLanguage.LOG == this.mEditor.getLanguage());
        this.langLog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodeEditorTestContainer.this.setLanguageAndSwapEditorIfNecessary(CodeLanguage.LOG);
                CodeEditorTestContainer.this.clearLanguageStates();
                CodeEditorTestContainer.this.langLog.setState(true);
            }
        });
        this.langList = new JCheckBoxMenuItem("List Language");
        this.langList.setMnemonic('I');
        this.langList.setState(CodeLanguage.LIST == this.mEditor.getLanguage());
        this.langList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodeEditorTestContainer.this.setLanguageAndSwapEditorIfNecessary(CodeLanguage.LIST);
                CodeEditorTestContainer.this.clearLanguageStates();
                CodeEditorTestContainer.this.langList.setState(true);
            }
        });
        this.connect = new JMenuItem("Connect...", 67);
        this.connect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodeEditorTestContainer.this.connect();
            }
        });
        this.showlog = new JMenuItem("Submit", 83);
        this.showlog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodeEditorTestContainer.this.submit();
            }
        });
        JMenuItem deleteLog = new JMenuItem("Delete Log");
        deleteLog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!(CodeEditorTestContainer.this.mEditor instanceof LogListViewer)) {
                    return;
                }
                LogListDocument doc = (LogListDocument)((LogListViewer)CodeEditorTestContainer.this.mEditor).getDocument();
                doc.deleteStorage();
            }
        });
        JMenuItem setDiskLogParms = new JMenuItem("Set Auto Disk Log Parameters");
        setDiskLogParms.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!(CodeEditorTestContainer.this.mEditor instanceof LogListViewer)) {
                    return;
                }
                LogListDocument doc = (LogListDocument)((LogListViewer)CodeEditorTestContainer.this.mEditor).getDocument();
                LogStorageConfigDataInterface storage = doc.getStorageParameters();
                if (!(storage instanceof LogAutoRollingFileStorageConfigData)) {
                    return;
                }
                LogAutoRollingFileStorageConfigData storageData = (LogAutoRollingFileStorageConfigData)storage;
                SetDiskLogSizeParms dlg = new SetDiskLogSizeParms(CodeEditorTestContainer.this.m_LogFrame, storageData);
                dlg.setVisible(true);
                if (dlg.isOkay()) {
                    doc.setStorageParameters(storageData);
                }
            }
        });
        JMenuItem setMemoryLogParms = new JMenuItem("Set Memory Log Parameters");
        setMemoryLogParms.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!(CodeEditorTestContainer.this.mEditor instanceof LogListViewer)) {
                    return;
                }
                LogListDocument doc = (LogListDocument)((LogListViewer)CodeEditorTestContainer.this.mEditor).getDocument();
                LogStorageConfigDataInterface storage = doc.getStorageParameters();
                if (!(storage instanceof LogMemoryStorageConfigData)) {
                    return;
                }
                LogMemoryStorageConfigData storageData = (LogMemoryStorageConfigData)storage;
                SetMemoryLogSizeParms dlg = new SetMemoryLogSizeParms(CodeEditorTestContainer.this.m_LogFrame, storageData);
                dlg.setVisible(true);
                if (dlg.isOkay()) {
                    doc.setStorageParameters(storageData);
                }
            }
        });
        JMenuItem addInteractiveLogLines = new JMenuItem("Add Interactive Number of  Log Lines");
        addInteractiveLogLines.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChooseLogAppendSizeDlg dlg = new ChooseLogAppendSizeDlg(CodeEditorTestContainer.this.m_LogFrame, mLastGroupSize, mLastNumGroups);
                dlg.setVisible(true);
                if (dlg.isOkay()) {
                    mLastGroupSize = dlg.getGroupSize();
                    mLastNumGroups = dlg.getNumGroups();
                    CodeEditorTestContainer.this.addLogLines(mLastGroupSize, mLastNumGroups);
                }
            }
        });
        JMenuItem add150000LogLines = new JMenuItem("Add 1500000 Log Lines");
        add150000LogLines.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodeEditorTestContainer.this.addLogLines(5, 30000);
            }
        });
        JMenuItem addLogLines = new JMenuItem("Add 1000 Log Lines");
        addLogLines.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodeEditorTestContainer.this.addLogLines(5, 200);
            }
        });
        JMenuItem add2LogLines = new JMenuItem("Add 2 Log Lines");
        add2LogLines.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodeEditorTestContainer.this.addLogLines(2, 1);
            }
        });
        JMenuItem testValidation = new JMenuItem("ValidateLength", 86);
        testValidation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int length;
                CodeEditorDocument doc = CodeEditorTestContainer.this.mEditor.getEditorPane().getCodeEditorDocument();
                Integer longerLine = doc.validateLineLengths(length = 100);
                if (longerLine != null) {
                    System.out.println("Line #" + (longerLine + 1) + " has length: " + doc.getLineLength(longerLine) + " which is longer than " + Integer.toString(length));
                    System.out.println("Text = " + doc.getLine(longerLine));
                }
            }
        });
        JMenuItem testEditableRegion = new JMenuItem("CreateEditableRegion", 67);
        testEditableRegion.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditableRegion region = new EditableRegion(5, 10);
                Color fgColor = new Color(255, 0, 0);
                Color bgColor = new Color(0, 255, 0);
                CodeEditorTestContainer.this.mEditor.setEditableRegion(region, null, null);
            }
        });
        this.edit.add(testValidation);
        JMenuBar mb = new JMenuBar();
        this.setJMenuBar(mb);
        this.file.add(this.open);
        this.file.add(this.save);
        this.file.add(this.saveas);
        this.file.add(this.append);
        this.file.add(this.print);
        this.file.add(this.printFold);
        this.file.add(this.pageSetup);
        this.file.addSeparator();
        this.file.add(this.fileExit);
        this.file.add(this.dump);
        this.edit.add(this.undo);
        this.edit.add(this.redo);
        this.edit.addSeparator();
        this.edit.add(this.cut);
        this.edit.add(this.copy);
        this.edit.add(this.paste);
        this.edit.addSeparator();
        this.edit.add(this.selectall);
        this.edit.add(this.clearall);
        this.edit.addSeparator();
        this.edit.add(this.find);
        this.edit.addSeparator();
        this.edit.add(this.coloron);
        this.edit.add(this.coloroff);
        this.edit.addSeparator();
        this.edit.add(this.readOnlyMenuItem);
        this.edit.add(this.gotoline);
        this.edit.addSeparator();
        this.edit.add(this.options);
        this.edit.add(this.keys);
        this.edit.addSeparator();
        this.edit.add(add2LogLines);
        this.edit.add(addLogLines);
        this.edit.add(add150000LogLines);
        this.edit.add(addInteractiveLogLines);
        this.edit.add(setMemoryLogParms);
        this.edit.add(setDiskLogParms);
        this.edit.addSeparator();
        this.edit.add(deleteLog);
        this.view.add(this.lineNumbers);
        this.view.add(this.scrollSelectionToTop);
        this.view.addSeparator();
        this.view.add(this.langSas);
        this.view.add(this.langHtml);
        this.view.add(this.langJava);
        this.view.add(this.langText);
        this.view.add(this.langList);
        this.view.add(this.langLog);
        this.view.addSeparator();
        this.view.add(testEditableRegion);
        this.iom.add(this.connect);
        this.iom.add(this.showlog);
        mb.add(this.file);
        mb.add(this.edit);
        mb.add(this.view);
        mb.add(this.iom);
    }

    private void addLogLines(int linesPerGroup, int numberOfGroups) {
        int i;
        if (!(this.mEditor instanceof LogListViewer)) {
            return;
        }
        StringSeqHolder seqtext = new StringSeqHolder();
        seqtext.value = new String[linesPerGroup];
        CarriageControlSeqHolder cc = new CarriageControlSeqHolder();
        cc.value = new CarriageControl[linesPerGroup];
        for (int i2 = 0; i2 < cc.value.length; ++i2) {
            cc.value[i2] = CarriageControl.CarriageControlNormal;
        }
        LineTypeSeqHolder lt = new LineTypeSeqHolder();
        lt.value = new LineType[linesPerGroup];
        for (i = 0; i < lt.value.length; ++i) {
            lt.value[i] = i % 2 == 0 ? LineType.LineTypeError : LineType.LineTypeWarning;
        }
        for (i = 0; i < numberOfGroups; ++i) {
            for (int j = 0; j < seqtext.value.length; ++j) {
                seqtext.value[j] = "\u0143some text with type: " + lt.value[j].value() + " group #" + i;
            }
            LogListHolder logData = new LogListHolder(seqtext, cc, lt);
            ((LogListViewer)this.mEditor).append(logData);
        }
    }

    private void setLanguageAndSwapEditorIfNecessary(CodeLanguage newLanguage) {
        boolean willBeLog;
        boolean wasLog = this.mEditor.getLanguage() == CodeLanguage.LOG || this.mEditor.getLanguage() == CodeLanguage.LIST;
        boolean bl = willBeLog = newLanguage == CodeLanguage.LOG || newLanguage == CodeLanguage.LIST;
        if (wasLog != willBeLog) {
            this.getContentPane().remove(this.mEditor);
            this.mEditor.cleanup();
            this.mEditor = null;
            this.mEditor = willBeLog ? new LogListViewer(5, null, this.m_Defaults) : new CodeEditor(this.m_Defaults);
            this.getContentPane().add(this.mEditor);
            this.getContentPane().doLayout();
            this.mEditor.setFocus();
            this.UpdateFilename();
        }
        this.mEditor.setLanguage(newLanguage);
    }

    private void clearLanguageStates() {
        this.langSas.setState(false);
        this.langHtml.setState(false);
        this.langJava.setState(false);
        this.langLog.setState(false);
        this.langList.setState(false);
        this.langText.setState(false);
    }

    protected void connect() {
    }

    protected void submit() {
    }

    public void toggleLineNumbers() {
        if (this.mEditor.isLineNumbers()) {
            this.mEditor.setLineNumbers(false, true);
        } else {
            this.mEditor.setLineNumbers(true, true);
        }
    }

    public void toggleReadOnly() {
        if (this.mEditor.isReadOnly()) {
            this.mEditor.SetReadOnly(false);
        } else {
            this.mEditor.SetReadOnly(true);
        }
    }

    @Override
    public void menuCanceled(MenuEvent e) {
    }

    @Override
    public void menuDeselected(MenuEvent e) {
        this.mEditor.getEditorPane().repaint();
    }

    @Override
    public void menuSelected(MenuEvent e) {
        this.save.setEnabled(this.mEditor.canSave());
        this.coloron.setEnabled(!this.mEditor.isDocumentColoringEnabled());
        this.coloroff.setEnabled(this.mEditor.isDocumentColoringEnabled());
        this.cut.setEnabled(this.mEditor.canCut());
        this.copy.setEnabled(this.mEditor.canCopy());
        this.paste.setEnabled(this.mEditor.canPaste());
        this.selectall.setEnabled(this.mEditor.canSelectAll());
        this.clearall.setEnabled(this.mEditor.canClearAll());
        this.lineNumbers.setState(this.mEditor.isLineNumbers());
        this.undo.setEnabled(this.mEditor.canUndo());
        this.redo.setEnabled(this.mEditor.canRedo());
        this.readOnlyMenuItem.setSelected(this.mEditor.isReadOnly());
        this.langSas.setSelected(this.mEditor.getLanguage() == CodeLanguage.SAS);
        this.langHtml.setSelected(this.mEditor.getLanguage() == CodeLanguage.HTML);
        this.langJava.setSelected(this.mEditor.getLanguage() == CodeLanguage.JAVA);
    }

    public void displayOptionsDialog() {
        this.mEditor.dlgOptions(false, true);
    }

    public void displayKeysDialog() {
        this.mEditor.dlgKeys();
    }

    public void UpdateFilename() {
        String filename = this.mEditor.getEditorPane().getCodeEditorDocument().getFilename();
        if (filename != null) {
            f.setTitle(filename);
        } else {
            f.setTitle("");
        }
    }

    public void printDlg() {
        this.mEditor.printDlg();
    }

    public void printFold() {
        this.mEditor.printCodeFolding(true);
    }

    public void pageSetupDlg() {
        this.mEditor.pageSetupDlg();
    }

    public static FixingFileFilter createFilter(final String extension, final String filterName, final boolean caseInsensitive, final boolean fix) {
        return new FixingFileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String fileName = f.getName();
                String testExtension = extension;
                if (caseInsensitive) {
                    fileName = fileName.toLowerCase();
                    testExtension = testExtension.toLowerCase();
                }
                return fileName.endsWith(testExtension);
            }

            @Override
            public String getDescription() {
                return filterName;
            }

            @Override
            public File fix(File f) {
                if (!fix) {
                    return f;
                }
                String fileName = f.getName();
                String testExtension = extension;
                if (caseInsensitive) {
                    fileName = fileName.toLowerCase();
                    testExtension = testExtension.toLowerCase();
                }
                if (fileName.endsWith(testExtension)) {
                    return f;
                }
                return new File(f.getAbsolutePath() + extension);
            }
        };
    }

    private String getFileNameFromUser(String initialFile, String title, int defaultFilterIndex, boolean save) {
        FileFilter[] filters = new FileFilter[]{CodeEditorTestContainer.createFilter(".sAs", "SAS files", true, true), CodeEditorTestContainer.createFilter(".html", "HTML files", true, true), CodeEditorTestContainer.createFilter(".java", "Java files", true, true), CodeEditorTestContainer.createFilter(".log", "LOG files", true, true), CodeEditorTestContainer.createFilter(".list", "List files", true, true)};
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setSelectedFile(new File(initialFile));
        fileChooser.setDialogTitle(title);
        for (int i = 0; i < filters.length; ++i) {
            fileChooser.addChoosableFileFilter(filters[i]);
        }
        if (defaultFilterIndex >= 0 && defaultFilterIndex < filters.length) {
            fileChooser.setFileFilter(filters[defaultFilterIndex]);
        } else {
            fileChooser.setFileFilter(fileChooser.getAcceptAllFileFilter());
        }
        int returnValue = 0;
        returnValue = save ? fileChooser.showSaveDialog(f) : fileChooser.showOpenDialog(f);
        if (returnValue != 0) {
            return null;
        }
        File selectedFile = fileChooser.getSelectedFile();
        if (selectedFile == null) {
            return null;
        }
        FileFilter currentFilter = fileChooser.getFileFilter();
        if (save && currentFilter instanceof FixingFileFilter) {
            selectedFile = ((FixingFileFilter)currentFilter).fix(selectedFile);
        }
        return selectedFile.getAbsolutePath();
    }

    static {
        mLastGroupSize = 1;
        mLastNumGroups = 100;
    }

    public static abstract class FixingFileFilter
    extends FileFilter {
        public abstract File fix(File var1);
    }
}

