/*
 * Decompiled with CFR 0.152.
 */
package com.sas.testcontainer;

import com.sas.editor.CodeEditor;
import com.sas.editor.CodeEditorDefaults;
import com.sas.editor.CodeEditorGeneralPane;
import java.awt.Dialog;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class CodeEditorTest
extends JFrame {
    JMenuBar menubar;
    OpenEditorAction openEditorAction = null;
    OptionsAction optionsAction = null;
    WindowListener windowListener = null;
    CodeEditorDefaults m_defs = new CodeEditorDefaults();

    public CodeEditorTest() throws HeadlessException {
        super("Code Editor Test");
        this.menubar = new JMenuBar();
        JMenu menu = new JMenu("File");
        this.menubar.add(menu);
        this.openEditorAction = new OpenEditorAction();
        JMenuItem openMenuItem = new JMenuItem(this.openEditorAction);
        menu.add(openMenuItem);
        this.optionsAction = new OptionsAction(this);
        menu.add(this.optionsAction);
        this.windowListener = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (e.getWindow() instanceof JFrame) {
                    CodeEditorTest.this.openEditorAction.cleanup();
                }
            }
        };
        this.setDefaultCloseOperation(3);
        this.setJMenuBar(this.menubar);
        this.setSize(500, 100);
        this.setVisible(true);
    }

    public static void main(String[] args) {
        CodeEditorTest test = new CodeEditorTest();
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            SwingUtilities.updateComponentTreeUI(test);
        }
        catch (UnsupportedLookAndFeelException ex) {
            ex.printStackTrace();
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (InstantiationException ex) {
            ex.printStackTrace();
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
    }

    class OptionsAction
    extends AbstractAction {
        JFrame f;

        public OptionsAction(JFrame fin) {
            super("Options...");
            this.f = fin;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JDialog jd = new JDialog(this.f);
            CodeEditorGeneralPane gp = new CodeEditorGeneralPane((Dialog)jd, new CodeEditorDefaults(), true, true);
            jd.getContentPane().add(gp);
            jd.setSize(400, 400);
            jd.setModal(true);
            jd.setVisible(true);
            jd.getContentPane().removeAll();
            gp.cleanup();
            gp = null;
            jd = null;
        }
    }

    class OpenEditorAction
    extends AbstractAction {
        CodeEditor codeEditor;
        JFrame f;

        public OpenEditorAction() {
            super("Open Editor");
            this.codeEditor = null;
            this.f = null;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.f = new JFrame("Editor");
            this.f.setDefaultCloseOperation(2);
            this.f.setSize(200, 200);
            this.codeEditor = new CodeEditor(CodeEditorTest.this.m_defs);
            this.f.getContentPane().add(this.codeEditor);
            System.out.println("Adding listener for window : " + this.f.getTitle() + " to window: " + CodeEditorTest.this.getTitle());
            this.f.addWindowListener(CodeEditorTest.this.windowListener);
            this.f.setVisible(true);
        }

        public void cleanup() {
            this.f.removeWindowListener(CodeEditorTest.this.windowListener);
            this.codeEditor.cleanup();
            this.codeEditor = null;
            this.f = null;
        }
    }
}

