/*
 * Decompiled with CFR 0.152.
 */
package com.sas.editor.language;

import com.sas.editor.ICodeDocument;
import com.sas.editor.language.SasScannerTable;
import com.sas.editor.language.SasToken;
import javax.swing.text.Segment;

public class SasTokenizer {
    public static final int MAX_TOKENS = 5;
    public static final int YTSTARTSTATE = 27;
    public static final int YTNCLASSES = 44;
    public static final int YTNSTATES = 46;
    protected static SasToken nullToken;
    protected static Segment m_docText;
    protected static SasToken[] m_qTokens;
    protected static int m_nQHead;
    protected static int m_nQTail;
    protected static char[][] comment_state_table;
    protected int m_nStartState;
    protected int m_nCharacterClasses;
    protected int m_nStates;
    protected int m_nCLSDQuote;
    protected int m_nCLSSQuote;
    protected int m_nCLSOtherLetter;
    protected int m_ntEOF;
    protected int m_ntLiteral;
    protected int m_ntOther;
    protected boolean m_bEOF;
    protected boolean bEOF;
    protected boolean m_bEOL;
    protected int m_nInCharacterClass;
    protected boolean m_bInStarComment;
    protected boolean m_bInComment;
    protected boolean m_bInMacroQuotingFunction;
    protected int m_nBracketNesting;
    protected StringBuffer m_strBuffer = new StringBuffer(500);
    protected int m_nCodePage;
    protected int m_nStartingOffset;
    protected int m_nCurrentOffset;
    protected ICodeDocument m_Doc;
    protected int mDocTextBeginOffset;

    public SasTokenizer() {
        nullToken = new SasToken();
        m_docText = new Segment();
        m_nQHead = 0;
        m_nQTail = 0;
        for (int i = 0; i < 5; ++i) {
            SasTokenizer.m_qTokens[i] = new SasToken();
        }
    }

    public void Initialize(ICodeDocument doc) {
        try {
            doc.getText(0, doc.getLength(), m_docText);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.mDocTextBeginOffset = m_docText.getBeginIndex();
        this.m_nStartingOffset = 0;
        this.m_nStartState = 27;
        this.m_nCharacterClasses = 44;
        this.m_nStates = 46;
        this.m_nCLSDQuote = 20;
        this.m_nCLSSQuote = 19;
        this.m_nCLSOtherLetter = 10;
        this.m_ntEOF = -1;
        this.m_ntLiteral = 3;
        this.m_ntOther = 22;
        this.m_Doc = doc;
        this.Reset();
    }

    public void Reset() {
        this.bEOF = false;
        this.m_nInCharacterClass = 0;
        this.m_bInComment = false;
        this.m_bInStarComment = false;
        this.m_bEOF = false;
        this.m_bEOL = false;
        this.m_bInMacroQuotingFunction = false;
        this.m_nBracketNesting = 0;
        this.m_strBuffer.delete(0, this.m_strBuffer.length());
    }

    protected final int QIndexFromHead(int n) {
        return (m_nQHead + n) % 5;
    }

    protected void BackUpToken(SasToken token) {
        this.m_nStartingOffset = token.GetStartOffset();
        this.m_bEOF = false;
        this.m_bEOL = false;
        this.bEOF = false;
    }

    public void SetInStarComment(boolean b) {
        SasToken temp = new SasToken();
        this.BackUpToken(m_qTokens[this.QIndexFromHead(1)]);
        this.m_bInStarComment = b;
        temp.Copy(m_qTokens[this.QIndexFromHead(0)]);
        this.EmptyTokenPipeline();
        m_qTokens[this.QIndexFromHead(0)].Copy(temp);
        m_nQTail = this.nextQueueIndex(m_nQHead);
    }

    public boolean GetInStarComment() {
        return this.m_bInStarComment;
    }

    public void SetInMacroQuotingFunction(boolean b) {
        SasToken temp = new SasToken();
        this.BackUpToken(m_qTokens[this.QIndexFromHead(1)]);
        this.m_bInMacroQuotingFunction = b;
        temp.Copy(m_qTokens[this.QIndexFromHead(0)]);
        this.EmptyTokenPipeline();
        m_qTokens[this.QIndexFromHead(0)].Copy(temp);
        m_nQTail = this.nextQueueIndex(m_nQHead);
    }

    public boolean GetInMacroQuotingFunction() {
        return this.m_bInMacroQuotingFunction;
    }

    protected final void internalSetPosition(int NewOffset) {
        this.m_nStartingOffset = NewOffset;
    }

    public void SetPosition(int NewOffset) {
        this.m_nStartingOffset = NewOffset;
        this.EmptyTokenPipeline();
    }

    public int GetPosition() {
        this.GetTokenForSlot(this.QIndexFromHead(1), true);
        return m_qTokens[this.QIndexFromHead(1)].GetStartOffset();
    }

    protected void AdvanceTokenQueue() {
        if (this.isQueueEmpty()) {
            return;
        }
        m_qTokens[m_nQHead].Reset();
        m_nQHead = (m_nQHead + 1) % 5;
    }

    protected void EmptyTokenPipeline() {
        for (int i = 0; i < 5; ++i) {
            m_qTokens[i].Reset();
        }
        m_nQHead = 0;
        m_nQTail = 0;
    }

    protected int MapCharToClass(int c) {
        return c * this.m_nStates;
    }

    protected int IsCharInClass(char c, int cls) {
        int b;
        int a = this.GetCharacterClass(c);
        if (a == (b = this.MapCharToClass(cls))) {
            return 1;
        }
        return 0;
    }

    protected final int GetCharacterClass(int c) {
        if (c > 255) {
            return this.MapCharToClass(this.m_nCLSOtherLetter);
        }
        return SasScannerTable.Sascls[c & 0xFF];
    }

    protected final char GetCharacter(int Offset) {
        char c = Offset < SasTokenizer.m_docText.count ? SasTokenizer.m_docText.array[Offset + this.mDocTextBeginOffset] : (char)'\u0000';
        if (c == '\u0000') {
            this.bEOF = true;
        }
        return c;
    }

    public boolean tokenEqualsString(SasToken token, String compareString) {
        int length = compareString.length();
        if (token.GetLength() != length) {
            return false;
        }
        int startOffset = token.GetStartOffset() + this.mDocTextBeginOffset;
        for (int i = 0; i < length; ++i) {
            if (SasTokenizer.m_docText.array[startOffset + i] == compareString.charAt(i)) continue;
            return false;
        }
        return true;
    }

    protected void GetToken(SasToken Token) {
        char cCurrentCharacter = ' ';
        int nCurrentState = this.m_nStartState;
        this.m_nInCharacterClass = 0;
        this.m_nBracketNesting = 0;
        this.m_nCurrentOffset = this.m_nStartingOffset;
        Token.SetType(this.m_ntEOF);
        Token.SetSubType(-1);
        Token.SetStartOffset(this.m_nCurrentOffset);
        this.m_strBuffer.delete(0, this.m_strBuffer.length());
        if (this.m_bEOF) {
            Token.SetEndOffset(this.m_nStartingOffset);
            Token.SetValue("");
            return;
        }
        cCurrentCharacter = this.GetCharacter(this.m_nCurrentOffset);
        block10: while (true) {
            if (this.bEOF) {
                if (this.m_nInCharacterClass != 0) {
                    Token.SetType(this.m_ntLiteral);
                    Token.SetSubType(this.m_nInCharacterClass);
                }
                if (!this.m_bEOF) {
                    Token.SetEndOffset(this.m_nCurrentOffset);
                }
                if (this.m_bEOF) {
                    Token.SetValue(this.m_strBuffer.substring(0, this.m_strBuffer.length()));
                    return;
                }
                this.m_bEOF = true;
            }
            int nCharacterClass = cCurrentCharacter <= '\u00ff' ? SasScannerTable.Sascls[cCurrentCharacter & 0xFF] : this.MapCharToClass(10);
            int nState = SasScannerTable.Sasscn[nCharacterClass + nCurrentState];
            int nAction = nState & 0xF;
            nState >>= 4;
            if (this.m_nInCharacterClass == 0) {
                this.m_nInCharacterClass = nCharacterClass == 920 ? 1 : (nCharacterClass == 874 ? 2 : 0);
            }
            if ((this.m_bInComment || this.m_bInStarComment || this.m_bInMacroQuotingFunction) && this.m_nInCharacterClass != 0) {
                nState = this.m_ntOther << 4;
                nAction = 3;
            }
            switch (nAction) {
                case 0: {
                    char cError;
                    int nCharacterClassError;
                    int i;
                    Token.SetType(this.m_ntOther);
                    this.m_strBuffer.append('\u0000');
                    Token.SetValue(this.m_strBuffer.substring(0, this.m_strBuffer.length()));
                    cCurrentCharacter = this.m_strBuffer.charAt(0);
                    nCharacterClass = this.GetCharacterClass(cCurrentCharacter);
                    int tokLength = Token.GetValue().length();
                    for (i = 1; i < tokLength && nCharacterClass == (nCharacterClassError = (cError = Token.GetValue().charAt(i)) > '\u00ff' ? this.MapCharToClass(this.m_nCLSOtherLetter) : SasScannerTable.Sascls[cError & 0xFF]); ++i) {
                    }
                    try {
                        Token.SetValue(Token.GetValue().substring(0, i));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    this.m_nCurrentOffset = Token.GetStartOffset() + i;
                    Token.SetEndOffset(this.m_nCurrentOffset);
                    this.m_bEOL = false;
                    return;
                }
                case 1: {
                    nCurrentState = nState;
                    if (Token.GetType() != 3) {
                        this.m_strBuffer.append(cCurrentCharacter);
                    }
                    ++this.m_nCurrentOffset;
                    cCurrentCharacter = this.GetCharacter(this.m_nCurrentOffset);
                    continue block10;
                }
                case 2: {
                    nCurrentState = nState;
                    ++this.m_nCurrentOffset;
                    cCurrentCharacter = this.GetCharacter(this.m_nCurrentOffset);
                    continue block10;
                }
                case 3: {
                    Token.AppendValue(cCurrentCharacter);
                    this.m_strBuffer.append(cCurrentCharacter);
                }
                case 4: {
                    ++this.m_nCurrentOffset;
                }
                case 5: {
                    Token.SetType(nState >> 4);
                    Token.SetSubType(nState & 0xF);
                    Token.SetEndOffset(this.m_nCurrentOffset);
                    this.m_bEOL = false;
                    if (Token.GetType() == 21 && Token.GetSubType() == 1 && !this.m_bInStarComment) {
                        int cls = this.IsCharInClass(cCurrentCharacter, 24);
                        char st = comment_state_table[0][cls];
                        do {
                            cCurrentCharacter = this.GetCharacter(this.m_nCurrentOffset);
                            if (this.bEOF) break;
                            cls = this.IsCharInClass(cCurrentCharacter, 24) == 1 ? 1 : (this.IsCharInClass(cCurrentCharacter, 28) == 1 ? 2 : 0);
                            st = comment_state_table[st][cls];
                            ++this.m_nCurrentOffset;
                        } while (st < '\u0002');
                        Token.SetEndOffset(this.m_nCurrentOffset);
                    }
                    Token.SetValue(this.m_strBuffer.substring(0, this.m_strBuffer.length()));
                    return;
                }
            }
        }
    }

    protected boolean isQueueFull() {
        return this.nextQueueIndex(m_nQTail) == m_nQHead;
    }

    protected boolean isQueueEmpty() {
        return m_nQTail == m_nQHead;
    }

    protected int nextQueueIndex(int index) {
        return (index + 1) % 5;
    }

    protected final void GetTokenForSlot(int slot, boolean bOnlyIfInvalid) {
        if (this.isQueueFull()) {
            return;
        }
        if (m_nQTail != slot) {
            return;
        }
        m_nQTail = this.nextQueueIndex(m_nQTail);
        m_qTokens[slot].Reset();
        this.GetToken(m_qTokens[slot]);
        m_qTokens[slot].SetValid(true);
        m_qTokens[slot].SetLength(m_qTokens[slot].GetEndOffset() - m_qTokens[slot].GetStartOffset());
        this.internalSetPosition(m_qTokens[slot].GetEndOffset());
    }

    public SasToken CurrentToken() {
        this.GetTokenForSlot(m_nQHead, true);
        SasToken token = m_qTokens[m_nQHead];
        return token;
    }

    public SasToken NextToken() {
        this.AdvanceTokenQueue();
        this.GetTokenForSlot(m_nQHead, true);
        SasToken token = m_qTokens[m_nQHead];
        return token;
    }

    public SasToken PeekNextToken() {
        this.GetTokenForSlot(this.QIndexFromHead(1), true);
        SasToken token = m_qTokens[this.QIndexFromHead(1)];
        return token;
    }

    public SasToken PeekNextNonWhitespaceToken() {
        boolean bDone = false;
        int i = 1;
        int qindex = 0;
        while (!bDone) {
            qindex = this.QIndexFromHead(i);
            this.GetTokenForSlot(qindex, true);
            if (i < 5) {
                if (m_qTokens[qindex].GetType() != 0 || m_qTokens[qindex].GetType() == -1) {
                    bDone = true;
                }
            } else {
                bDone = true;
            }
            if (bDone) continue;
            ++i;
        }
        if (i < 5) {
            return m_qTokens[qindex];
        }
        return nullToken;
    }

    static {
        m_qTokens = new SasToken[5];
        m_nQHead = 0;
        m_nQTail = 0;
        comment_state_table = new char[][]{{'\u0000', '\u0001', '\u0000'}, {'\u0000', '\u0001', '\u0002'}};
    }
}

