/*
 * Decompiled with CFR 0.152.
 */
package com.sas.editor.language;

import com.sas.iom.SAS.ILanguageServicePackage.CarriageControl;
import com.sas.iom.SAS.ILanguageServicePackage.LineType;

public class SasLineDisplayInfo {
    public static final int LINEFLAG_HIDDEN = 1;
    public static final int LINEFLAG_ERROR = 2;
    public static final int LINEFLAG_EXPAND = 4;
    public static final int LINEFLAG_COLLAPSE = 8;
    public static final int LINEFLAG_MARKED = 16;
    public static final int LINEFLAG_HELP = 32;
    public static final int LINEFLAG_POINT = 64;
    public static final int LINEFLAG_EXTRA1 = 128;
    public static final int LINEFLAG_EXTRA2 = 256;
    public static final int LINEFLAG_EXTRA3 = 512;
    public static final int LINEFLAG_EXTRA4 = 1024;
    public static final int LINEFLAG_EXTRA5 = 2048;
    public static final int LINEFLAG_NEWSECTION = 4096;
    public static final int LINEFLAG_ENDSECTION = 8192;
    public static final String ATTRIBUTE_KEY = "SasLDF";
    public int m_LineDisplayFlags;
    public CarriageControl m_LineCarriageControl;
    public LineType m_LineType;
    public short m_DefaultDisplayType;
    public int m_LineIndentFlags;
    public int m_Offset;

    public SasLineDisplayInfo() {
        this.m_LineDisplayFlags = 0;
        this.m_LineCarriageControl = CarriageControl.CarriageControlNormal;
        this.m_LineType = LineType.LineTypeNormal;
        this.m_DefaultDisplayType = (short)14;
        this.m_LineIndentFlags = 0;
        this.m_Offset = 0;
    }

    public SasLineDisplayInfo(int offset, CarriageControl cc, LineType lt) {
        this.m_Offset = offset;
        this.m_LineCarriageControl = cc;
        this.m_LineType = lt;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SasLineDisplayInfo)) {
            return false;
        }
        SasLineDisplayInfo info = (SasLineDisplayInfo)obj;
        if (this.m_DefaultDisplayType != info.m_DefaultDisplayType) {
            return false;
        }
        int tempMyLineDisplayFlags = this.m_LineDisplayFlags & 0xFFFFFFF3;
        int tempInfoLineDisplayFlags = info.m_LineDisplayFlags & 0xFFFFFFF3;
        if (tempMyLineDisplayFlags != tempInfoLineDisplayFlags) {
            return false;
        }
        if (this.m_LineIndentFlags != info.m_LineIndentFlags) {
            return false;
        }
        if (this.m_Offset != info.m_Offset) {
            return false;
        }
        if (this.m_LineType != info.m_LineType) {
            return false;
        }
        return this.m_LineCarriageControl == info.m_LineCarriageControl;
    }
}

