/*
 * Decompiled with CFR 0.152.
 */
package com.sas.editor.language;

import com.sas.editor.language.BufferedRandomAccessFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;

class RollingFileHandler {
    private static final String FileOptsString = "rw";
    private List mFileArray;
    private int mBufSize;

    public RollingFileHandler(File[] files, int bufSize) throws FileNotFoundException {
        this.mBufSize = Math.max(bufSize, 256);
        this.mFileArray = new ArrayList(files.length);
        for (int i = 0; i < files.length; ++i) {
            BufferedRandomAccessFile rFile = null;
            rFile = new BufferedRandomAccessFile(files[i], FileOptsString, this.mBufSize);
            FileHolder holder = new FileHolder(files[i], rFile);
            this.mFileArray.add(holder);
        }
    }

    public RandomAccessFile getFile(int index) {
        if (index < 0 || index >= this.mFileArray.size()) {
            return null;
        }
        FileHolder holder = (FileHolder)this.mFileArray.get(index);
        RandomAccessFile file = holder.getFileChannel();
        return file;
    }

    public void setData(int index, Object data) {
        if (index < 0 || index >= this.mFileArray.size()) {
            return;
        }
        FileHolder holder = (FileHolder)this.mFileArray.get(index);
        holder.setData(data);
    }

    public Object getData(int index) {
        if (index < 0 || index >= this.mFileArray.size()) {
            return null;
        }
        FileHolder holder = (FileHolder)this.mFileArray.get(index);
        return holder.getData();
    }

    public Object getLastData() {
        return this.getData(this.mFileArray.size() - 1);
    }

    public void shiftFiles() {
        try {
            String lastFilePath = ((FileHolder)this.mFileArray.get(this.mFileArray.size() - 1)).getDiskFile().getAbsolutePath();
            FileHolder lastHolder = (FileHolder)this.mFileArray.get(0);
            RandomAccessFile firstFile = lastHolder.getFileChannel();
            File previousFile = new File(lastHolder.getDiskFile().getAbsolutePath());
            firstFile.close();
            lastHolder.getDiskFile().delete();
            for (int i = 1; i < this.mFileArray.size(); ++i) {
                FileHolder nextHolder = (FileHolder)this.mFileArray.get(i);
                nextHolder.getFileChannel().close();
                String savedPath = nextHolder.getDiskFile().getAbsolutePath();
                File tempFile = nextHolder.getDiskFile().getAbsoluteFile();
                tempFile.renameTo(previousFile);
                File newFileObject = previousFile.getAbsoluteFile();
                BufferedRandomAccessFile nextFile = new BufferedRandomAccessFile(newFileObject, FileOptsString, this.mBufSize);
                nextHolder.setFiles(newFileObject, nextFile);
                previousFile = new File(savedPath);
            }
            this.mFileArray.remove(0);
            File newLogFile = new File(lastFilePath);
            BufferedRandomAccessFile rFile = new BufferedRandomAccessFile(newLogFile, FileOptsString, this.mBufSize);
            FileHolder holder = new FileHolder(newLogFile, rFile);
            this.mFileArray.add(holder);
            ((RandomAccessFile)rFile).setLength(0L);
            this.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void flush() throws IOException {
        for (FileHolder holder : this.mFileArray) {
            holder.getFileChannel().getChannel().force(true);
        }
    }

    public void close() throws IOException {
        for (FileHolder holder : this.mFileArray) {
            holder.getFileChannel().close();
        }
    }

    public int getFileCount() {
        return this.mFileArray.size();
    }

    public void clear() throws IOException {
        for (FileHolder holder : this.mFileArray) {
            holder.getFileChannel().setLength(0L);
        }
        this.flush();
    }

    public RandomAccessFile getLastFile() {
        FileHolder holder = (FileHolder)this.mFileArray.get(this.mFileArray.size() - 1);
        return holder.getFileChannel();
    }

    public void delete() throws IOException {
        this.close();
        for (FileHolder holder : this.mFileArray) {
            holder.getDiskFile().delete();
        }
    }

    public File[] getFiles() {
        File[] returnVal = new File[this.mFileArray.size()];
        int i = 0;
        for (FileHolder holder : this.mFileArray) {
            returnVal[i] = holder.getDiskFile().getAbsoluteFile();
            ++i;
        }
        return returnVal;
    }

    private static class FileHolder {
        private RandomAccessFile mFileChannel;
        private File mDiskFile;
        private Object mData;

        public FileHolder(File diskFile, RandomAccessFile channel) {
            this.mFileChannel = channel;
            this.mDiskFile = diskFile;
            this.mData = null;
        }

        public Object getData() {
            return this.mData;
        }

        public void setData(Object data) {
            this.mData = data;
        }

        public File getDiskFile() {
            return this.mDiskFile;
        }

        public void setFiles(File diskFile, RandomAccessFile rFile) {
            this.mDiskFile = diskFile;
            this.mFileChannel = rFile;
        }

        public RandomAccessFile getFileChannel() {
            return this.mFileChannel;
        }
    }
}

