/*
 * Decompiled with CFR 0.152.
 */
package com.sas.editor.language;

import com.sas.editor.LogRollingFileStorageConfigDataInterface;
import com.sas.editor.LogStorageConfigDataInterface;
import com.sas.editor.LogSuppliedRollingFileStorageConfigData;
import com.sas.editor.MRUList;
import com.sas.editor.MRUListNode;
import com.sas.editor.language.LogLineInfo;
import com.sas.editor.language.RepositoryChangedListener;
import com.sas.editor.language.RepositoryIndexInterface;
import com.sas.editor.language.RollingFileHandler;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.Map;

public class LogRollingFileRepository
implements RepositoryIndexInterface {
    private static final int IndexRecordSize = 6;
    private static final int IndexHeaderSize = 8;
    private static LogLineInfo DefaultLogLineInfo = new LogLineInfo(0, 0, 0);
    private static final short BytesPerCharacter = 2;
    private RollingFileHandler mIndexFiles;
    private RollingFileHandler mRollingLogFiles;
    private Map mLineInfoCache;
    protected MRUList mLineInfoMRUCache;
    private int mMaxMemoryLineCacheSize = 1000;
    private int mCharLength;
    private LogLineInfo mCurrentLogInfo;
    private int mLinesPerFile;
    private int mTotalLineCount;
    private int mMaxFileCount;
    private Map mListeners;
    private boolean mDeleteOnClose;
    private static final int mMinLinesPerFile = 1000;
    private int mLastLineStartOffset;
    private byte[] mIndexRecordBuffer = new byte[6];
    private LogLineInfo mHashedLogInfo = new LogLineInfo(0, 0, 0);
    private static final int mDataBufferSize = 800;
    private byte[] mDataBuffer = new byte[800];

    public LogRollingFileRepository(LogRollingFileStorageConfigDataInterface storageInfo, Map listeners) throws IOException {
        this.mLineInfoCache = new HashMap();
        this.mLineInfoMRUCache = new MRUList();
        this.clearCacheInfo();
        LogSuppliedRollingFileStorageConfigData suppliedStorageInfo = (LogSuppliedRollingFileStorageConfigData)storageInfo;
        this.mMaxFileCount = suppliedStorageInfo.getDataFiles().length;
        this.mLinesPerFile = Math.max(1000, suppliedStorageInfo.getLinesPerFile());
        this.mDeleteOnClose = suppliedStorageInfo.isDeleteOnClose();
        this.mIndexFiles = new RollingFileHandler(suppliedStorageInfo.getIndexFiles(), 512);
        this.mRollingLogFiles = new RollingFileHandler(suppliedStorageInfo.getDataFiles(), 16384);
        boolean truncated = false;
        RandomAccessFile firstIndexFile = this.mIndexFiles.getFile(0);
        if (firstIndexFile.length() >= 8L) {
            firstIndexFile.seek(0L);
            int charLength = firstIndexFile.readInt();
            int oldLinesPerFile = firstIndexFile.readInt();
            if (oldLinesPerFile != this.mLinesPerFile) {
                if (charLength == 0) {
                    truncated = true;
                } else {
                    this.mLinesPerFile = Math.max(1000, oldLinesPerFile);
                }
            }
        }
        this.mListeners = listeners;
        this.mTotalLineCount = 0;
        this.mCharLength = 0;
        this.mLastLineStartOffset = -1;
        for (int i = 0; i < this.mMaxFileCount; ++i) {
            RandomAccessFile indexFile = this.mIndexFiles.getFile(i);
            RandomAccessFile logFile = this.mRollingLogFiles.getFile(i);
            if (truncated) {
                indexFile.setLength(0L);
                indexFile.writeInt(0);
                indexFile.writeInt(this.mLinesPerFile);
                this.mIndexFiles.setData(i, new FileLengthHolder(0));
                logFile.setLength(0L);
                continue;
            }
            indexFile.seek(0L);
            if (indexFile.length() < 8L || (indexFile.length() - 8L) % 6L != 0L) {
                indexFile.setLength(0L);
                indexFile.writeInt(0);
                indexFile.writeInt(this.mLinesPerFile);
                logFile.setLength(0L);
                this.mIndexFiles.setData(i, new FileLengthHolder(0));
                truncated = true;
                continue;
            }
            truncated = this.truncateIndexFileToLength(indexFile);
            indexFile.seek(0L);
            int fileCharLength = indexFile.readInt();
            int logFileLength = (int)logFile.length();
            if (logFileLength % 2 != 0) {
                logFileLength -= logFileLength % 2;
                logFile.setLength(logFileLength);
            }
            if (logFileLength > fileCharLength * 2) {
                logFile.setLength(fileCharLength * 2);
                truncated = true;
            } else if (logFileLength < fileCharLength * 2) {
                indexFile.seek(0L);
                fileCharLength = logFileLength / 2;
                indexFile.writeInt(fileCharLength);
                this.truncateIndexFileToLength(indexFile);
                truncated = true;
            }
            int linesInThisFile = (int)(indexFile.length() - 8L) / 6;
            if (linesInThisFile < this.mLinesPerFile) {
                truncated = true;
            }
            this.mCharLength += fileCharLength;
            this.mIndexFiles.setData(i, new FileLengthHolder(fileCharLength));
            this.mTotalLineCount += linesInThisFile;
        }
        this.seek(this.mTotalLineCount - 1);
        this.mLastLineStartOffset = this.getCurrentDocOffset();
    }

    @Override
    public LogStorageConfigDataInterface getStorageInfo() {
        LogSuppliedRollingFileStorageConfigData data = new LogSuppliedRollingFileStorageConfigData(this.mLinesPerFile, this.mRollingLogFiles.getFiles(), this.mIndexFiles.getFiles(), this.mDeleteOnClose);
        return data;
    }

    private boolean truncateIndexFileToLength(RandomAccessFile indexFile) throws IOException {
        long startIndex;
        indexFile.seek(0L);
        int fileCharLength = indexFile.readInt();
        if (fileCharLength == 0 && indexFile.length() > 8L) {
            indexFile.setLength(8L);
            return true;
        }
        LogLineInfo lineInfo = new LogLineInfo(0, 0, 0);
        for (startIndex = indexFile.length(); startIndex >= 14L; startIndex -= 6L) {
            indexFile.seek(startIndex - 6L);
            indexFile.readFully(this.mIndexRecordBuffer);
            this.fillInLineInfoFromData(this.mIndexRecordBuffer, lineInfo);
            if (lineInfo.getLocalDocStartOffset() >= fileCharLength) continue;
            if (startIndex == indexFile.length()) {
                return false;
            }
            indexFile.setLength(startIndex);
            return true;
        }
        if (startIndex <= 8L) {
            indexFile.setLength(8L);
            indexFile.seek(0L);
            indexFile.writeInt(0);
            return true;
        }
        return false;
    }

    @Override
    public void clear() throws IOException {
        this.mTotalLineCount = 0;
        this.mCharLength = 0;
        this.clearCacheInfo();
        this.mRollingLogFiles.clear();
        this.mIndexFiles.clear();
        for (int i = 0; i < this.mIndexFiles.getFileCount(); ++i) {
            RandomAccessFile file = this.mIndexFiles.getFile(i);
            file.writeInt(0);
            file.writeInt(this.mLinesPerFile);
            FileLengthHolder lengthHolder = (FileLengthHolder)this.mIndexFiles.getData(i);
            lengthHolder.mFileCharacterLength = 0;
        }
    }

    public void truncate(int firstLineToRemove) {
    }

    @Override
    public void seek(int index) {
        this.mCurrentLogInfo = this.getLineInfo(index);
    }

    @Override
    public int getCurrentDocOffset() {
        if (this.mCurrentLogInfo != null) {
            return this.mCurrentLogInfo.getGlobalDocStartOffset();
        }
        return DefaultLogLineInfo.getGlobalDocStartOffset();
    }

    @Override
    public short getCurrentLineType() {
        if (this.mCurrentLogInfo != null) {
            return (short)this.mCurrentLogInfo.getLineType();
        }
        return (short)DefaultLogLineInfo.getLineType();
    }

    @Override
    public int getSize() {
        return this.mTotalLineCount + 1;
    }

    private void writeRecordToByteArray(byte[] utilityArray, int currentOffset, int docOffset, int fileOffset, short lineType) {
        this.writeIntToLineInfoBuffer(utilityArray, currentOffset, docOffset);
        utilityArray[currentOffset + 4] = (byte)(lineType >> 16);
        utilityArray[currentOffset + 5] = (byte)lineType;
    }

    private void writeIntToLineInfoBuffer(byte[] byteBuffer, int bufferOffset, int newValue) {
        byteBuffer[bufferOffset] = (byte)(newValue >> 24);
        byteBuffer[bufferOffset + 1] = (byte)(newValue >> 16);
        byteBuffer[bufferOffset + 2] = (byte)(newValue >> 8);
        byteBuffer[bufferOffset + 3] = (byte)newValue;
    }

    private void fillInLineInfoFromData(byte[] buffer, LogLineInfo lineInfo) {
        int docOffset = this.getIntFromLineInfoBuffer(buffer, 0);
        lineInfo.setLocalDocStartOffset(docOffset);
        int lineType = LogRollingFileRepository.unsignedByteToInt(buffer[4]);
        lineType <<= 8;
        lineInfo.setLineType(lineType += LogRollingFileRepository.unsignedByteToInt(buffer[5]));
    }

    private static int unsignedByteToInt(byte b) {
        return b & 0xFF;
    }

    private int getIntFromLineInfoBuffer(byte[] buffer, int bufferOffset) {
        int intValue = (((LogRollingFileRepository.unsignedByteToInt(buffer[bufferOffset]) << 8) + LogRollingFileRepository.unsignedByteToInt(buffer[bufferOffset + 1]) << 8) + LogRollingFileRepository.unsignedByteToInt(buffer[bufferOffset + 2]) << 8) + LogRollingFileRepository.unsignedByteToInt(buffer[bufferOffset + 3]);
        return intValue;
    }

    public void shiftToZero(int linesShifted) throws IOException {
        FileLengthHolder fileLengthHolder = (FileLengthHolder)this.mIndexFiles.getData(0);
        int fileCharLength = fileLengthHolder.mFileCharacterLength;
        this.mCharLength -= fileCharLength;
        this.mIndexFiles.shiftFiles();
        this.mTotalLineCount -= this.mLinesPerFile;
        RandomAccessFile file = this.mIndexFiles.getLastFile();
        if (file.length() > 0L) {
            System.out.println("ERROR: file not cleared.");
        }
        file.writeInt(0);
        file.writeInt(this.mLinesPerFile);
        this.mIndexFiles.setData(this.mIndexFiles.getFileCount() - 1, new FileLengthHolder(0));
        this.mLineInfoCache.clear();
        this.mLineInfoMRUCache.clear();
    }

    private void addLine(short lineType, int lineLength) throws IOException {
        int fileIndex = this.getFileIndex(this.mTotalLineCount);
        RandomAccessFile file = this.mIndexFiles.getFile(fileIndex);
        FileLengthHolder fileCharLength = (FileLengthHolder)this.mIndexFiles.getData(fileIndex);
        int docOffset = fileCharLength.mFileCharacterLength;
        this.writeRecordToByteArray(this.mIndexRecordBuffer, 0, docOffset, 0, lineType);
        file.seek(file.length());
        file.write(this.mIndexRecordBuffer);
        ++this.mTotalLineCount;
        this.mCharLength += lineLength;
        fileCharLength.mFileCharacterLength += lineLength;
    }

    private LogLineInfo getLineInfo(int lineNumber) {
        this.mHashedLogInfo.setLineNumber(lineNumber);
        LogLineInfo lineInfo = (LogLineInfo)this.mLineInfoCache.get(this.mHashedLogInfo);
        if (lineInfo != null) {
            return lineInfo;
        }
        try {
            LogLineInfo oldInfo;
            Object removedItem;
            MRUListNode lastNode;
            int fileIndex = this.getFileIndex(lineNumber);
            RandomAccessFile file = this.mIndexFiles.getFile(fileIndex);
            int fileLocalLineNumber = lineNumber % this.mLinesPerFile;
            file.seek(8 + fileLocalLineNumber * 6);
            if (file.getFilePointer() + (long)this.mIndexRecordBuffer.length > file.length()) {
                return DefaultLogLineInfo;
            }
            file.readFully(this.mIndexRecordBuffer);
            lineInfo = new LogLineInfo(lineNumber, 0, 0);
            this.fillInLineInfoFromData(this.mIndexRecordBuffer, lineInfo);
            lineInfo.setGlobalDocStartOffset(this.makeDocIndexGlobal(fileIndex, lineInfo.getLocalDocStartOffset()));
            if (lineNumber > 0 && lineInfo.getGlobalDocStartOffset() == 0) {
                System.out.println("Error: internal line offset consistency error");
            }
            this.mLineInfoCache.put(lineInfo, lineInfo);
            this.mLineInfoMRUCache.prepend(lineInfo);
            if (this.mLineInfoCache.size() > this.mMaxMemoryLineCacheSize && (lastNode = this.mLineInfoMRUCache.removeLast()) != null && (removedItem = this.mLineInfoCache.remove(oldInfo = (LogLineInfo)lastNode.getUserData())) == null) {
                System.out.println("Error: no item found for " + Integer.toString(oldInfo.getLineNumber()));
            }
            return lineInfo;
        }
        catch (IOException e) {
            e.printStackTrace();
            return DefaultLogLineInfo;
        }
    }

    private int makeDocIndexGlobal(int fileIndex, int localDocStartOffset) {
        int correctedIndex = localDocStartOffset;
        for (int i = 0; i < fileIndex; ++i) {
            FileLengthHolder holder = (FileLengthHolder)this.mIndexFiles.getData(i);
            correctedIndex += holder.mFileCharacterLength;
        }
        return correctedIndex;
    }

    @Override
    public int getMaxSize() {
        return this.mLinesPerFile * this.mMaxFileCount;
    }

    @Override
    public void flush() throws IOException {
        for (int i = 0; i < this.mMaxFileCount; ++i) {
            RandomAccessFile file = this.mIndexFiles.getFile(i);
            if (file == null) continue;
            FileLengthHolder fileCharLength = (FileLengthHolder)this.mIndexFiles.getData(i);
            file.seek(0L);
            file.writeInt(fileCharLength.mFileCharacterLength);
        }
        this.mIndexFiles.flush();
        this.mRollingLogFiles.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.mDeleteOnClose) {
            this.delete();
        } else {
            this.flush();
            this.mIndexFiles.close();
            this.mRollingLogFiles.close();
        }
    }

    @Override
    public int getCharLength() {
        return this.mCharLength;
    }

    @Override
    public void dump() {
    }

    @Override
    public String getText(int lineNumber, int offsetOnLine, int length) {
        int fileIndex = this.getFileIndex(lineNumber);
        if (fileIndex < 0) {
            return "";
        }
        RandomAccessFile file = this.mRollingLogFiles.getFile(fileIndex);
        if (file == null) {
            return "";
        }
        this.seek(lineNumber);
        try {
            file.seek((this.mCurrentLogInfo.getLocalDocStartOffset() + offsetOnLine) * 2);
            if (file.getFilePointer() > file.length()) {
                System.out.println("ERROR: length= " + file.length() + " pointer=" + file.getFilePointer());
            }
            StringBuffer buffer = new StringBuffer(length + 1);
            while (buffer.length() < length) {
                long amountLeftInFile = (file.length() - file.getFilePointer()) / 2L;
                int amountToGrab = Math.min((int)amountLeftInFile, length - buffer.length()) * 2;
                byte[] byteArray = new byte[amountToGrab];
                file.readFully(byteArray);
                for (int k = 0; k < byteArray.length; k += 2) {
                    int highByte = byteArray[k] & 0xFF;
                    int lowByte = byteArray[k + 1] & 0xFF;
                    char character = (char)(highByte << 8 | lowByte);
                    buffer.append(character);
                }
                if (file.getFilePointer() < file.length()) continue;
                if ((file = this.mRollingLogFiles.getFile(++fileIndex)) == null) break;
                file.seek(0L);
                if (file.length() != 0L) continue;
                break;
            }
            return buffer.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    @Override
    public int append(String line, int lineAttrs) throws IOException {
        int lastIndex = this.mTotalLineCount / this.mLinesPerFile;
        RandomAccessFile lastFile = null;
        int stringLength = line.length() + 1;
        if (lastIndex < this.mRollingLogFiles.getFileCount()) {
            lastFile = this.mRollingLogFiles.getFile(lastIndex);
        } else {
            this.mRollingLogFiles.shiftFiles();
            this.shiftToZero(this.mLinesPerFile);
            this.updateListenersForRepositoryShift();
            lastFile = this.mRollingLogFiles.getLastFile();
        }
        if (lastFile != null) {
            try {
                this.mLastLineStartOffset = this.getCharLength();
                this.addLine((short)lineAttrs, stringLength);
                lastFile.seek(lastFile.length());
                int bytesWritten = 0;
                for (int i = 0; i < stringLength - 1; ++i) {
                    char character = line.charAt(i);
                    this.mDataBuffer[bytesWritten] = (byte)(character >> 8);
                    this.mDataBuffer[bytesWritten + 1] = (byte)character;
                    if ((bytesWritten += 2) != 800) continue;
                    lastFile.write(this.mDataBuffer, 0, bytesWritten);
                    bytesWritten = 0;
                }
                this.mDataBuffer[bytesWritten] = 0;
                this.mDataBuffer[bytesWritten + 1] = 10;
                lastFile.write(this.mDataBuffer, 0, bytesWritten += 2);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return stringLength;
    }

    private void clearCacheInfo() {
        this.mCurrentLogInfo = null;
        this.mLineInfoCache.clear();
        this.mLastLineStartOffset = -1;
        this.mLineInfoMRUCache.clear();
    }

    private void updateListenersForRepositoryShift() {
        this.clearCacheInfo();
        for (RepositoryChangedListener listener : this.mListeners.keySet()) {
            listener.repositoryChanged();
        }
    }

    private int getFileIndex(int lineNumber) {
        int fileIndex = lineNumber / this.mLinesPerFile;
        if (fileIndex >= this.mIndexFiles.getFileCount()) {
            return -1;
        }
        if (fileIndex < 0) {
            return -1;
        }
        return fileIndex;
    }

    @Override
    public int quickFindLineForOffset(int offset) {
        if (offset >= this.getCharLength()) {
            return this.mTotalLineCount;
        }
        if (this.mLastLineStartOffset >= 0 && offset >= this.mLastLineStartOffset) {
            return this.mTotalLineCount - 1;
        }
        return -1;
    }

    @Override
    public void delete() throws IOException {
        this.clear();
        this.mRollingLogFiles.delete();
        this.mIndexFiles.delete();
    }

    private static class FileLengthHolder {
        public int mFileCharacterLength;

        public FileLengthHolder(int length) {
            this.mFileCharacterLength = length;
        }
    }
}

