/*
 * Decompiled with CFR 0.152.
 */
package com.sas.editor.language;

import com.sas.editor.LogListHolder;
import com.sas.editor.language.LogRepository;
import com.sas.iom.SAS.ILanguageServicePackage.CarriageControl;
import com.sas.iom.SAS.ILanguageServicePackage.LineType;
import java.io.IOException;

public class LogRepositoryHelper {
    protected LogRepository mRepository;
    protected int mMaxLineLength;
    protected int mDefaultLineType;

    public LogRepositoryHelper(LogRepository repository) {
        this.mRepository = repository;
    }

    public int getMaxLineLength() {
        return this.mMaxLineLength;
    }

    public int getDefaultLineType() {
        return this.mDefaultLineType;
    }

    public void setDefaultLineType(int defaultLineType) {
        this.mDefaultLineType = defaultLineType;
    }

    public void setMaxLineLength(int maxLineLength) {
        this.mMaxLineLength = maxLineLength;
    }

    public int appendText(LogListHolder logData) throws IOException {
        int charsAdded = 0;
        String[] lines = logData.getLineArray();
        CarriageControl[] cc = logData.getCarriageControl();
        LineType[] lt = logData.getLineTypes();
        for (int i = 0; i < lines.length; ++i) {
            if (cc[i] == CarriageControl.CarriageControlSkipLine) {
                charsAdded += this.appendStringToRepository("", this.getDefaultLineType());
            } else if (cc[i] == CarriageControl.CarriageControlSkipTwoLines) {
                charsAdded += this.appendStringToRepository("", this.getDefaultLineType());
                charsAdded += this.appendStringToRepository("", this.getDefaultLineType());
            } else if (cc[i] == CarriageControl.CarriageControlOverPrint) continue;
            charsAdded += this.appendStringToRepository(lines[i], lt[i].value());
        }
        return charsAdded;
    }

    private int appendStringToRepository(String line, int lineTypeCodes) throws IOException {
        if (line.length() == 0) {
            int charsAdded = this.mRepository.append(line, lineTypeCodes);
            return charsAdded;
        }
        int totalCharsAdded = 0;
        while (line.length() > 0) {
            String textToInsert = line;
            if (line.length() > this.mMaxLineLength) {
                textToInsert = line.substring(0, this.mMaxLineLength);
                line = line.substring(this.mMaxLineLength);
            } else {
                line = "";
            }
            int charsAdded = this.mRepository.append(textToInsert, lineTypeCodes);
            totalCharsAdded += charsAdded;
        }
        return totalCharsAdded;
    }
}

