/*
 * Decompiled with CFR 0.152.
 */
package com.sas.editor.language;

import com.sas.editor.AttributeMap;
import com.sas.editor.CodeEditorAttributeManager;
import com.sas.editor.CodeEditorDocument;
import com.sas.editor.CodeEditorSchemeManager;
import com.sas.editor.CodeEditorTextPosition;
import com.sas.editor.LineTokenInfo;
import com.sas.editor.SasColor;
import com.sas.editor.TokenInfo;
import com.sas.editor.TokenMap;
import com.sas.editor.TokenMapInterface;
import com.sas.editor.language.DefaultLanguageParser;
import com.sas.editor.language.JavaLineTokenInfo;
import java.awt.Font;
import java.util.Hashtable;
import javax.swing.text.Element;
import javax.swing.text.Segment;

public class JavaLanguageParser
extends DefaultLanguageParser {
    protected boolean m_bNoEditScan;
    protected CodeEditorAttributeManager attrManager = new CodeEditorAttributeManager(this.m_Doc.getDefaults());
    protected static final Hashtable mReservedWordHash = new Hashtable(59);
    protected TokenMap mNewTokenMap = null;
    protected static final String mBookmarkBeginMarker = "//{{~SAS~";
    protected static final String mBookmarkEndMarker = "//}}~SAS~";
    public static final short JAVA_REGULAR_CODE = 2;
    public static final short JAVA_STAR_COMMENT = 3;
    public static final short JAVA_LINE_COMMENT = 4;
    public static final short JAVA_DOC_COMMENT = 5;
    public static final short JAVA_STRING_LITERAL = 6;
    public static final short JAVA_CHARACTER = 7;
    public static final short JAVA_RESERVED_WORD = 8;
    public static final short JAVA_BOOKMARKED_CODE = 9;

    public JavaLanguageParser(CodeEditorDocument doc, boolean doXML) {
        super(doc);
        this.updateElementAttributeMap();
        this.initReservedWords();
    }

    public JavaLanguageParser(CodeEditorDocument doc) {
        this(doc, true);
    }

    public void initReservedWords() {
        if (mReservedWordHash.isEmpty()) {
            mReservedWordHash.put("public", mReservedWordHash);
            mReservedWordHash.put("static", mReservedWordHash);
            mReservedWordHash.put("abstract", mReservedWordHash);
            mReservedWordHash.put("boolean", mReservedWordHash);
            mReservedWordHash.put("break", mReservedWordHash);
            mReservedWordHash.put("byte", mReservedWordHash);
            mReservedWordHash.put("byvalue", mReservedWordHash);
            mReservedWordHash.put("case", mReservedWordHash);
            mReservedWordHash.put("cast", mReservedWordHash);
            mReservedWordHash.put("default", mReservedWordHash);
            mReservedWordHash.put("do", mReservedWordHash);
            mReservedWordHash.put("double", mReservedWordHash);
            mReservedWordHash.put("else", mReservedWordHash);
            mReservedWordHash.put("extends", mReservedWordHash);
            mReservedWordHash.put("false", mReservedWordHash);
            mReservedWordHash.put("final", mReservedWordHash);
            mReservedWordHash.put("goto", mReservedWordHash);
            mReservedWordHash.put("if", mReservedWordHash);
            mReservedWordHash.put("implements", mReservedWordHash);
            mReservedWordHash.put("import", mReservedWordHash);
            mReservedWordHash.put("inner", mReservedWordHash);
            mReservedWordHash.put("instanceof", mReservedWordHash);
            mReservedWordHash.put("int", mReservedWordHash);
            mReservedWordHash.put("operator", mReservedWordHash);
            mReservedWordHash.put("outer", mReservedWordHash);
            mReservedWordHash.put("package", mReservedWordHash);
            mReservedWordHash.put("private", mReservedWordHash);
            mReservedWordHash.put("protected", mReservedWordHash);
            mReservedWordHash.put("rest", mReservedWordHash);
            mReservedWordHash.put("synchronized", mReservedWordHash);
            mReservedWordHash.put("this", mReservedWordHash);
            mReservedWordHash.put("throw", mReservedWordHash);
            mReservedWordHash.put("throws", mReservedWordHash);
            mReservedWordHash.put("transient", mReservedWordHash);
            mReservedWordHash.put("true", mReservedWordHash);
            mReservedWordHash.put("try", mReservedWordHash);
            mReservedWordHash.put("catch", mReservedWordHash);
            mReservedWordHash.put("char", mReservedWordHash);
            mReservedWordHash.put("class", mReservedWordHash);
            mReservedWordHash.put("const", mReservedWordHash);
            mReservedWordHash.put("continue", mReservedWordHash);
            mReservedWordHash.put("finally", mReservedWordHash);
            mReservedWordHash.put("float", mReservedWordHash);
            mReservedWordHash.put("for", mReservedWordHash);
            mReservedWordHash.put("future", mReservedWordHash);
            mReservedWordHash.put("generic", mReservedWordHash);
            mReservedWordHash.put("interface", mReservedWordHash);
            mReservedWordHash.put("long", mReservedWordHash);
            mReservedWordHash.put("native", mReservedWordHash);
            mReservedWordHash.put("new", mReservedWordHash);
            mReservedWordHash.put("null", mReservedWordHash);
            mReservedWordHash.put("return", mReservedWordHash);
            mReservedWordHash.put("short", mReservedWordHash);
            mReservedWordHash.put("super", mReservedWordHash);
            mReservedWordHash.put("switch", mReservedWordHash);
            mReservedWordHash.put("var", mReservedWordHash);
            mReservedWordHash.put("void", mReservedWordHash);
            mReservedWordHash.put("volatile", mReservedWordHash);
            mReservedWordHash.put("while", mReservedWordHash);
        }
    }

    @Override
    public void updateElementAttributeMap() {
        this.m_AttrMap = this.attrManager.getAttributeMap(4);
        if (this.m_AttrMap == null) {
            this.initAttributes();
            this.attrManager.setAttributeMap(this.m_AttrMap, 4, true);
        }
    }

    public void initAttributes() {
        this.m_AttrMap = new AttributeMap(8);
        this.m_AttrMap.addElementAttributes((short)2, SasColor.black, SasColor.white, false, false);
        this.m_AttrMap.addElementAttributes((short)3, SasColor.burgandy, SasColor.white, false, false);
        this.m_AttrMap.addElementAttributes((short)4, SasColor.green, SasColor.white, false, false);
        this.m_AttrMap.addElementAttributes((short)5, SasColor.burgandy, SasColor.white, false, false);
        this.m_AttrMap.addElementAttributes((short)6, SasColor.purple, SasColor.white, false, false);
        this.m_AttrMap.addElementAttributes((short)7, SasColor.cyan, SasColor.white, false, false);
        this.m_AttrMap.addElementAttributes((short)8, SasColor.blue, SasColor.white, false, false);
        this.m_AttrMap.addElementAttributes((short)9, SasColor.burgandy, SasColor.white, false, false);
        this.m_AttrMap.addFontAttributes(CodeEditorSchemeManager.PREDEFINED_FONT);
        Font f = this.attrManager.getFont(4);
        if (f == null) {
            f = CodeEditorSchemeManager.PREDEFINED_FONT;
        }
        this.m_AttrMap.addFontAttributes(f);
    }

    @Override
    public void interactiveInsert(int changeStartOffset, int changeLength) {
        if (this.m_Doc.isEmpty()) {
            this.m_Doc.getTokenMap().clear();
            return;
        }
        if (this.m_Doc.getTokenMap().getRangeCount() == 0) {
            this.color();
            return;
        }
        try {
            this.m_Doc.getTokenMap().shiftPositionsForInsert(changeStartOffset, changeLength);
            int startLine = this.lineOf(changeStartOffset);
            int endLine = this.lineOf(changeStartOffset + changeLength);
            int startPos = this.m_Doc.getStartOffsetForLine(startLine);
            int length = this.m_Doc.getStartOffsetForLine(endLine) + this.m_Doc.getLineLength(endLine) - startPos;
            this.color(startPos, length);
        }
        catch (Exception e) {
            this.color();
        }
    }

    @Override
    public void interactiveDelete(int changeStartOffset, int changeLength) {
        if (this.m_Doc.isEmpty()) {
            this.m_Doc.getTokenMap().clear();
            return;
        }
        if (this.m_Doc.getTokenMap().getRangeCount() == 0) {
            this.color();
            return;
        }
        try {
            this.m_Doc.getTokenMap().shiftPositionsForDelete(changeStartOffset, changeStartOffset + changeLength);
            CodeEditorTextPosition changeStartPos = this.m_Doc.getPositionFromOffset(changeStartOffset);
            CodeEditorTextPosition changeEndPos = new CodeEditorTextPosition(changeStartPos);
            if (changeStartPos.mColumn == 1) {
                this.m_Doc.goToPreviousChar(changeStartPos);
            } else {
                changeStartPos.mColumn = 1;
            }
            changeEndPos.mColumn = this.m_Doc.getLineLength(changeEndPos.mLine - 1) + 1;
            this.m_Doc.goToNextChar(changeEndPos);
            this.color(this.m_Doc.getOffset(changeStartPos), this.m_Doc.getOffset(changeEndPos) - this.m_Doc.getOffset(changeStartPos));
        }
        catch (Exception e) {
            this.color();
        }
    }

    @Override
    public void color() {
        if (this.m_Doc.getLength() == 0) {
            this.m_Doc.getTokenMap().clear();
            return;
        }
        int colorEnd = this.m_Doc.getLength();
        this.EditScan(0, colorEnd);
        this.m_Doc.getTokenMap().patchRanges(this.mNewTokenMap);
        this.mNewTokenMap = null;
        this.m_Doc.syntaxColorUpdate(0, colorEnd);
    }

    @Override
    public void color(int offset, int length) {
        try {
            int colorStart = this.getFirstOffsetInRange(offset);
            int colorEnd = this.getLastOffsetInRange(offset + length);
            colorEnd = this.EditScan(colorStart, colorEnd);
            this.m_Doc.getTokenMap().patchRanges(this.mNewTokenMap);
            this.m_Doc.syntaxColorUpdate(colorStart, colorEnd);
            this.mNewTokenMap = null;
        }
        catch (Exception e) {
            this.color();
        }
    }

    @Override
    public boolean IsDocumentColoringEnabled() {
        return !this.m_bNoEditScan;
    }

    @Override
    public void EnableDocumentColoring(boolean b) {
        if (this.m_bNoEditScan != b) {
            return;
        }
        this.m_bNoEditScan = !b;
        boolean isMyLock = this.m_Doc.RequestLock();
        if (this.m_bNoEditScan) {
            TokenMapInterface tokenMap = this.m_Doc.getTokenMap();
            tokenMap.clear();
            TokenInfo tokenInfo = new TokenInfo(0, this.m_Doc.getLength(), 2, null);
            tokenMap.append(tokenInfo, false);
        } else {
            this.color();
        }
        if (isMyLock) {
            this.m_Doc.ReleaseLock();
        }
    }

    protected short getTokenTypeForOffset(int offset) {
        if (offset < 0 || offset > this.m_Doc.getLength()) {
            return 0;
        }
        TokenInfo tok = this.m_Doc.getTokenMap().getTokenInfo(offset);
        if (tok == null) {
            return 0;
        }
        return tok.getTokenType();
    }

    @Override
    public boolean isCharacterLiteralType(int offset) {
        short type = this.getTokenTypeForOffset(offset);
        return type == 6 || type == 7;
    }

    @Override
    public boolean isCommentType(int offset) {
        short type = this.getTokenTypeForOffset(offset);
        return type == 5 || type == 4 || type == 3;
    }

    @Override
    public boolean isCodeType(int offset) {
        short type = this.getTokenTypeForOffset(offset);
        return type == 2 || type == 8;
    }

    @Override
    public boolean isReservedWordType(int offset) {
        short type = this.getTokenTypeForOffset(offset);
        return type == 8;
    }

    @Override
    public boolean isLineCommentType(int offset) {
        short type = this.getTokenTypeForOffset(offset);
        return type == 4;
    }

    public int lineOf(int offset) {
        return this.m_Doc.getLineNumberFromOffset(offset);
    }

    public int columnOf(int offset) {
        return offset - this.m_Doc.getCurrentLineStartOffset(offset);
    }

    public int EditScan(int startOffset, int endOffset) {
        this.mNewTokenMap = new TokenMap(this.m_Doc);
        CodeEditorTextPosition currentPos = this.m_Doc.getPositionFromOffset(startOffset);
        CodeEditorTextPosition prevPos = new CodeEditorTextPosition();
        int documentEnd = this.m_Doc.getLength();
        int searchEndBoundary = endOffset;
        CodeEditorTextPosition endJazzBookmark = new CodeEditorTextPosition(0, 0);
        CodeEditorTextPosition endOfReservedWordPos = new CodeEditorTextPosition();
        CodeEditorTextPosition starSlashPos = new CodeEditorTextPosition();
        CodeEditorTextPosition positionAfterComment = new CodeEditorTextPosition();
        CodeEditorTextPosition stringEndPos = new CodeEditorTextPosition();
        CodeEditorTextPosition currentPosPlus = new CodeEditorTextPosition();
        CodeEditorTextPosition charEndPos = new CodeEditorTextPosition();
        int cc = 32;
        if (this.m_bNoEditScan) {
            return startOffset;
        }
        Segment textSeg = new Segment();
        Element rootElement = this.m_Doc.getDefaultRootElement();
        prevPos.copyFrom(currentPos);
        Element currentElement = null;
        while (currentPos.mLine <= this.m_Doc.getLineCount() && this.m_Doc.getOffset(currentPos) < searchEndBoundary && this.m_Doc.getOffset(currentPos) < documentEnd) {
            currentElement = rootElement.getElement(currentPos.mLine - 1);
            int lineLength = currentElement.getEndOffset() - currentElement.getStartOffset() - 1;
            try {
                this.m_Doc.getText(currentElement.getStartOffset(), lineLength, textSeg);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            while (this.m_Doc.getOffset(currentPos) < searchEndBoundary && currentPos.mColumn <= lineLength) {
                cc = textSeg.array[textSeg.getBeginIndex() + currentPos.mColumn - 1];
                if (cc == 47 && currentPos.mColumn < lineLength && textSeg.array[textSeg.getBeginIndex() + currentPos.mColumn] == '*') {
                    CodeEditorTextPosition posPlusTwo;
                    boolean foundEnd;
                    boolean posPlusTwoOkay;
                    if (prevPos.lessThan(currentPos)) {
                        this.ColorToken(this.m_Doc.getOffset(prevPos), this.m_Doc.getOffset(currentPos), (short)2);
                    }
                    char possibleStar = '\u0000';
                    boolean bl = posPlusTwoOkay = currentPos.mColumn + 2 <= lineLength;
                    if (posPlusTwoOkay) {
                        possibleStar = textSeg.array[textSeg.getBeginIndex() + currentPos.mColumn + 1];
                    }
                    if (foundEnd = this.findStarSlash(posPlusTwo = new CodeEditorTextPosition(currentPos.mLine, currentPos.mColumn + 2), starSlashPos)) {
                        ++starSlashPos.mColumn;
                    }
                    if (posPlusTwoOkay && possibleStar == '*') {
                        this.ColorToken(this.m_Doc.getOffset(currentPos), this.m_Doc.getOffset(starSlashPos), (short)5);
                    } else {
                        this.ColorToken(this.m_Doc.getOffset(currentPos), this.m_Doc.getOffset(starSlashPos), (short)3);
                    }
                    currentPos.copyFrom(starSlashPos);
                    prevPos.copyFrom(starSlashPos);
                    currentElement = rootElement.getElement(currentPos.mLine - 1);
                    lineLength = currentElement.getEndOffset() - currentElement.getStartOffset() - 1;
                    try {
                        this.m_Doc.getText(currentElement.getStartOffset(), lineLength, textSeg);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    continue;
                }
                if (cc == 47 && currentPos.mColumn < lineLength && textSeg.array[textSeg.getBeginIndex() + currentPos.mColumn] == '/') {
                    boolean foundEndMarker;
                    if (prevPos.lessThan(currentPos)) {
                        this.ColorToken(this.m_Doc.getOffset(prevPos), this.m_Doc.getOffset(currentPos), (short)2);
                    }
                    boolean possiblyJazzMark = false;
                    StringBuffer docData = new StringBuffer();
                    if (currentPos.mColumn + mBookmarkBeginMarker.length() - 1 <= lineLength) {
                        possiblyJazzMark = true;
                        docData.append(textSeg.array, currentPos.mColumn - 1, mBookmarkBeginMarker.length());
                    }
                    if (possiblyJazzMark && mBookmarkBeginMarker.compareTo(docData.toString()) == 0 && (foundEndMarker = this.findEndCodeMarker(currentPos, endJazzBookmark))) {
                        if (endJazzBookmark.mLine < this.m_Doc.getLineCount()) {
                            ++endJazzBookmark.mLine;
                            endJazzBookmark.mColumn = 1;
                        } else {
                            endJazzBookmark.mColumn = this.m_Doc.getLineLength(endJazzBookmark.mLine - 1) + 1;
                        }
                        if (searchEndBoundary < this.m_Doc.getOffset(endJazzBookmark)) {
                            searchEndBoundary = this.m_Doc.getOffset(endJazzBookmark);
                        }
                    }
                    positionAfterComment.copyFrom(currentPos);
                    positionAfterComment.mColumn = this.m_Doc.getLineLength(positionAfterComment.mLine - 1) - 1;
                    this.m_Doc.goToNextChar(positionAfterComment);
                    this.ColorToken(this.m_Doc.getOffset(currentPos), this.m_Doc.getOffset(positionAfterComment), (short)4);
                    currentPos.copyFrom(positionAfterComment);
                    prevPos.copyFrom(positionAfterComment);
                    currentElement = rootElement.getElement(currentPos.mLine - 1);
                    lineLength = currentElement.getEndOffset() - currentElement.getStartOffset() - 1;
                    try {
                        this.m_Doc.getText(currentElement.getStartOffset(), lineLength, textSeg);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    continue;
                }
                if (cc == 34) {
                    if (prevPos.lessThan(currentPos)) {
                        this.ColorToken(this.m_Doc.getOffset(prevPos), this.m_Doc.getOffset(currentPos), (short)2);
                    }
                    currentPosPlus.copyFrom(currentPos);
                    ++currentPosPlus.mColumn;
                    ++stringEndPos.mColumn;
                    this.ColorToken(this.m_Doc.getOffset(currentPos), this.m_Doc.getOffset(stringEndPos), (short)6);
                    currentPos.copyFrom(stringEndPos);
                    prevPos.copyFrom(stringEndPos);
                    continue;
                }
                if (cc == 39) {
                    if (prevPos.lessThan(currentPos)) {
                        this.ColorToken(this.m_Doc.getOffset(prevPos), this.m_Doc.getOffset(currentPos), (short)2);
                    }
                    currentPosPlus.copyFrom(currentPos);
                    ++currentPosPlus.mColumn;
                    ++charEndPos.mColumn;
                    this.ColorToken(this.m_Doc.getOffset(currentPos), this.m_Doc.getOffset(charEndPos), (short)6);
                    currentPos.copyFrom(charEndPos);
                    prevPos.copyFrom(charEndPos);
                    continue;
                }
                if (this.findReservedWord(currentPos, textSeg, endOfReservedWordPos)) {
                    if (prevPos.lessThan(currentPos)) {
                        this.ColorToken(this.m_Doc.getOffset(prevPos), this.m_Doc.getOffset(currentPos), (short)2);
                    }
                    this.ColorToken(this.m_Doc.getOffset(currentPos), this.m_Doc.getOffset(endOfReservedWordPos), (short)8);
                    prevPos.copyFrom(endOfReservedWordPos);
                    currentPos.copyFrom(endOfReservedWordPos);
                    continue;
                }
                ++currentPos.mColumn;
                if (!endOfReservedWordPos.greaterThan(currentPos)) continue;
                currentPos.copyFrom(endOfReservedWordPos);
            }
            if (this.m_Doc.getOffset(currentPos) >= searchEndBoundary) break;
            ++currentPos.mLine;
            currentPos.mColumn = 1;
        }
        int currentOffset = 0;
        if (currentPos.mLine > this.m_Doc.getLineCount()) {
            currentOffset = this.m_Doc.getLength();
        } else {
            currentOffset = this.m_Doc.getOffset(currentPos);
            if (currentOffset > this.m_Doc.getLength()) {
                currentOffset = this.m_Doc.getLength();
            }
        }
        if (this.m_Doc.getOffset(prevPos) < currentOffset) {
            this.ColorToken(this.m_Doc.getOffset(prevPos), currentOffset, (short)2);
        }
        return currentOffset;
    }

    protected int getFirstOffsetInRange(int offset) {
        TokenInfo token = this.m_Doc.getTokenMap().getTokenInfo(offset);
        if (token == null) {
            return 0;
        }
        return token.getStartOffset();
    }

    protected int getLastOffsetInRange(int offset) {
        TokenInfo token = this.m_Doc.getTokenMap().getTokenInfo(offset);
        if (token == null) {
            return this.m_Doc.getLength();
        }
        return token.getEndOffset();
    }

    protected boolean ColorToken(int startOffset, int endOffset, short tokenType) {
        TokenInfo newToken = new TokenInfo(startOffset, endOffset, tokenType, null);
        this.mNewTokenMap.append(newToken, false);
        return true;
    }

    protected boolean isIdentifierChar(char character) {
        return Character.isLetterOrDigit(character) || character == '-' || character == '\'' || character == '.' || character == '_';
    }

    protected boolean findEndOfChar(CodeEditorTextPosition pos, Segment lineData, CodeEditorTextPosition foundPos) {
        foundPos.mLine = pos.mLine;
        int index = this.findEndMarker('\'', pos.mColumn - 1, lineData);
        if (index < 0) {
            foundPos.mColumn = lineData.count;
            return false;
        }
        foundPos.mColumn = index + 1;
        return true;
    }

    protected int findEndMarker(char marker, int startIndex, Segment lineData) {
        int lineLength = lineData.count;
        for (int index = startIndex; index < lineLength; ++index) {
            char current = lineData.array[lineData.getBeginIndex() + index];
            if (current == '\\') {
                index += 2;
                break;
            }
            if (current != marker) continue;
            return index;
        }
        return -1;
    }

    protected boolean findStarSlash(CodeEditorTextPosition pos, CodeEditorTextPosition foundPos) {
        int maxLine = this.m_Doc.getLineCount();
        int column = pos.mColumn;
        Element rootElement = this.m_Doc.getDefaultRootElement();
        Segment textSeg = new Segment();
        for (int line = pos.mLine; line <= maxLine; ++line) {
            Element currentElement = rootElement.getElement(line - 1);
            int lineLength = currentElement.getEndOffset() - currentElement.getStartOffset() - 1;
            try {
                this.m_Doc.getText(currentElement.getStartOffset(), lineLength, textSeg);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            while (column < lineLength) {
                if (textSeg.array[textSeg.getBeginIndex() + column] == '/' && textSeg.array[textSeg.getBeginIndex() + column - 1] == '*') {
                    foundPos.mLine = line;
                    foundPos.mColumn = column + 1;
                    return true;
                }
                ++column;
            }
            column = 1;
        }
        this.m_Doc.getDocumentEnd(foundPos);
        return false;
    }

    protected boolean findEndCodeMarker(CodeEditorTextPosition startPos, CodeEditorTextPosition foundPos) {
        int maxLine = this.m_Doc.getLineCount();
        int column = startPos.mColumn;
        Element rootElement = this.m_Doc.getDefaultRootElement();
        Segment textSeg = new Segment();
        for (int line = startPos.mLine; line <= maxLine; ++line) {
            Element currentElement = rootElement.getElement(line - 1);
            int lineLength = currentElement.getEndOffset() - currentElement.getStartOffset() - 1;
            try {
                this.m_Doc.getText(currentElement.getStartOffset(), lineLength, textSeg);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            while (column < lineLength - mBookmarkEndMarker.length()) {
                if (textSeg.array[textSeg.getBeginIndex() + column] == '/' && textSeg.array[textSeg.getBeginIndex() + column + 1] == '}') {
                    StringBuffer docData = new StringBuffer();
                    docData.append(textSeg.array, textSeg.getBeginIndex() + column - 1, textSeg.getBeginIndex() + column - 1 + mBookmarkEndMarker.length());
                    if (mBookmarkEndMarker.compareTo(docData.toString()) == 0) {
                        foundPos.mLine = line;
                        foundPos.mColumn = column + 1;
                        return true;
                    }
                }
                ++column;
            }
            column = 1;
        }
        this.m_Doc.getDocumentEnd(foundPos);
        return false;
    }

    protected boolean findReservedWord(CodeEditorTextPosition pos, Segment lineData, CodeEditorTextPosition foundPos) {
        String tempString;
        char ch;
        int column;
        foundPos.copyFrom(pos);
        int lineLength = lineData.count;
        if (column > lineLength) {
            return false;
        }
        boolean possibleReservedWord = true;
        for (column = pos.mColumn; column <= lineLength && Character.isJavaIdentifierPart(ch = lineData.array[lineData.getBeginIndex() + column - 1]); ++column) {
            if (Character.isLowerCase(ch)) continue;
            possibleReservedWord = false;
        }
        if (column == pos.mColumn) {
            return false;
        }
        foundPos.mColumn = column;
        return possibleReservedWord && mReservedWordHash.containsKey(tempString = new String(lineData.array, lineData.getBeginIndex() + pos.mColumn - 1, column - pos.mColumn));
    }

    protected boolean findEndOfString(CodeEditorTextPosition pos, Segment lineData, CodeEditorTextPosition foundPos) {
        foundPos.mLine = pos.mLine;
        int index = this.findEndMarker('\"', pos.mColumn - 1, lineData);
        if (index < 0) {
            foundPos.mColumn = lineData.count;
            return false;
        }
        foundPos.mColumn = index + 1;
        return true;
    }

    @Override
    public LineTokenInfo createLineTokenInfoObject(Element elem) {
        return new JavaLineTokenInfo(elem);
    }
}

