/*
 * Decompiled with CFR 0.152.
 */
package com.sas.editor.border;

import com.sas.editor.border.BorderManager;
import com.sas.editor.border.CodeEditorLineBasedBorderPane;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;

public class LineNumberPane
extends CodeEditorLineBasedBorderPane {
    private static final int LINENUMBER_MAX_DIGITS = 10;
    private int m_Digits = 0;
    private Color m_ForeColor;
    protected int mCurrentLine = 0;
    protected int[] mVisibleLines = null;
    private int mCurrentLine1;
    private boolean mCurrentLinesMoreThanOne;
    static int TempYOffset = 0;

    public LineNumberPane(BorderManager mgr, int digits, int width, Color fg, Color bg) {
        super(mgr, width, bg);
        this.m_Digits = digits;
        this.m_ForeColor = fg;
        this.resetCachedCurrentLines();
    }

    private void resetCachedCurrentLines() {
        this.mCurrentLine1 = -1;
        this.mCurrentLinesMoreThanOne = false;
    }

    private boolean determineChanges(Rectangle clipRect) {
        int[] oldVisibleLines = this.mVisibleLines;
        this.mVisibleLines = this.getVisibleLines();
        int oldCurrentLine = this.mCurrentLine;
        this.mCurrentLine = this.getRedLine();
        boolean repaintAll = false;
        if (this.mCurrentLinesMoreThanOne) {
            repaintAll = true;
        } else if (this.mCurrentLine1 >= 0 && this.mCurrentLine1 != this.mCurrentLine && this.mCurrentLine1 != oldCurrentLine) {
            repaintAll = true;
        }
        this.resetCachedCurrentLines();
        if (this.m_Digits > 10) {
            return false;
        }
        if (this.mVisibleLines == null) {
            return false;
        }
        try {
            if (repaintAll || oldVisibleLines == null || this.mVisibleLines[0] != oldVisibleLines[0]) {
                Rectangle rect = this.getVisibleRect();
                clipRect.setRect(rect);
                return true;
            }
            int oldCurrentScreenLine = -1;
            int newCurrentScreenLine = -1;
            for (int i = 0; i < this.mVisibleLines.length; ++i) {
                int value = this.mVisibleLines[i];
                if (value == oldCurrentLine) {
                    oldCurrentScreenLine = i;
                }
                if (value != this.mCurrentLine) continue;
                newCurrentScreenLine = i;
            }
            int[] differences = new int[2];
            boolean differencesExist = this.getDifferences(oldVisibleLines, this.mVisibleLines, oldCurrentScreenLine, newCurrentScreenLine, differences);
            if (differencesExist) {
                Rectangle textRect = new Rectangle();
                this.getRectForRangeOfScreenLines(differences[0], differences[1], textRect);
                Rectangle clientRect = this.m_Mgr.getScrollPane().getRowHeader().getViewRect();
                textRect.translate(clientRect.x, clientRect.y);
                if (clipRect.contains(textRect)) {
                    return false;
                }
                clipRect.setRect(textRect);
                return true;
            }
        }
        catch (NullPointerException e) {
            return false;
        }
        return false;
    }

    @Override
    protected void drawLine(int screenLineNumber, Rectangle drawRect, Graphics g) {
        if (screenLineNumber < 0 || this.mVisibleLines == null || screenLineNumber >= this.mVisibleLines.length) {
            return;
        }
        int lineNumber = this.mVisibleLines[screenLineNumber];
        if (this.mCurrentLine == lineNumber) {
            g.setColor(Color.red);
        } else {
            g.setColor(this.m_ForeColor);
        }
        String lineNumberString = String.valueOf(lineNumber + 1);
        if (lineNumberString == null) {
            return;
        }
        FontMetrics metrics = g.getFontMetrics();
        int leftX = this.getUsableWidth() - metrics.stringWidth(lineNumberString);
        g.drawString(lineNumberString, leftX, drawRect.y + this.m_Mgr.getEditorFontMetrics().getAscent());
    }

    protected int getRedLine() {
        int caretLine = this.m_Mgr.getCaretLine() - 1;
        if (this.m_Mgr.usePreviousCaretLine()) {
            --caretLine;
        }
        if (caretLine < 0) {
            caretLine = 0;
        }
        return caretLine;
    }

    protected boolean getDifferences(int[] oldVisibleLines, int[] newVisibleLines, int oldCurrentLine, int newCurrentLine, int[] differences) {
        int firstDifferentOffset = -1;
        int lastDifferentOffset = -1;
        int lineCount = Math.min(oldVisibleLines.length, newVisibleLines.length);
        for (int offset = 0; offset < lineCount; ++offset) {
            if (oldVisibleLines[offset] == newVisibleLines[offset]) continue;
            if (firstDifferentOffset == -1) {
                firstDifferentOffset = offset;
            }
            lastDifferentOffset = offset;
        }
        if (oldVisibleLines.length != newVisibleLines.length) {
            if (firstDifferentOffset < 0) {
                firstDifferentOffset = lineCount;
            }
            lastDifferentOffset = Math.max(oldVisibleLines.length - 1, newVisibleLines.length - 1);
        }
        if (oldCurrentLine != newCurrentLine) {
            if (oldCurrentLine >= 0) {
                if (firstDifferentOffset < 0) {
                    firstDifferentOffset = oldCurrentLine;
                    lastDifferentOffset = oldCurrentLine;
                } else if (oldCurrentLine < firstDifferentOffset || oldCurrentLine > lastDifferentOffset) {
                    firstDifferentOffset = Math.min(firstDifferentOffset, oldCurrentLine);
                    lastDifferentOffset = Math.max(lastDifferentOffset, oldCurrentLine);
                }
            }
            if (newCurrentLine >= 0) {
                if (firstDifferentOffset < 0) {
                    firstDifferentOffset = newCurrentLine;
                    lastDifferentOffset = newCurrentLine;
                } else if (newCurrentLine < firstDifferentOffset || newCurrentLine > lastDifferentOffset) {
                    firstDifferentOffset = Math.min(firstDifferentOffset, newCurrentLine);
                    lastDifferentOffset = Math.max(lastDifferentOffset, newCurrentLine);
                }
            }
        }
        differences[0] = firstDifferentOffset;
        differences[1] = lastDifferentOffset;
        return firstDifferentOffset != -1;
    }

    @Override
    public void paintComponent(Graphics g) {
        Rectangle clipRect = g.getClipBounds();
        if (this.determineChanges(clipRect)) {
            this.repaint(clipRect);
            return;
        }
        super.paintComponent(g);
        Color oldColor = g.getColor();
        this.clearBackground(g);
        if (this.m_Digits > 10) {
            return;
        }
        int[] lineRange = new int[2];
        this.getScreenLinesAffected(clipRect, lineRange);
        g.setFont(this.m_Mgr.getEditorPane().getFont());
        Rectangle clientRect = this.m_Mgr.getScrollPane().getRowHeader().getViewRect();
        TempYOffset = clientRect.y;
        g.translate(this.m_LeftMargin, clientRect.y);
        this.paintRangeOfScreenLines(g, lineRange[0], lineRange[1]);
        g.translate(-this.m_LeftMargin, -clientRect.y);
        g.setColor(oldColor);
    }

    public void cachePaintInfo() {
        if (this.mCurrentLinesMoreThanOne) {
            return;
        }
        int newCurrentLine = this.getRedLine();
        if (this.mCurrentLine1 < 0) {
            this.mCurrentLine1 = newCurrentLine;
        } else if (this.mCurrentLine1 != newCurrentLine) {
            this.mCurrentLinesMoreThanOne = true;
        }
    }
}

