/*
 * Decompiled with CFR 0.152.
 */
package com.sas.editor.border;

import com.sas.editor.border.BorderManager;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JPanel;

public class FlatMarginPane
extends JPanel
implements ComponentListener {
    private Color m_BackColor;
    private BorderManager m_Mgr;

    public FlatMarginPane(BorderManager mgr, int width, Color bg) {
        this.m_Mgr = mgr;
        this.m_BackColor = bg;
        this.setSize(width, 1);
        this.setPreferredSize(new Dimension(width, 1));
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.m_Mgr.getScrollPane() == null) {
            return;
        }
        Rectangle r = this.m_Mgr.getScrollPane().getRowHeader().getViewRect();
        g.translate(0, r.y);
        if (this.m_BackColor != null) {
            g.setColor(this.m_BackColor);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        g.translate(0, -r.y);
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.setSize(this.getWidth(), this.getParent().getHeight());
        this.setPreferredSize(new Dimension(this.getWidth(), this.getParent().getHeight()));
        this.setMinimumSize(new Dimension(this.getWidth(), this.getParent().getHeight()));
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }
}

