/*
 * Decompiled with CFR 0.152.
 */
package com.sas.editor.border;

import com.sas.editor.border.BorderManager;
import com.sas.editor.border.CodeEditorBorderPane;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;

public abstract class CodeEditorLineBasedBorderPane
extends CodeEditorBorderPane {
    int m_LeftMargin = 0;
    int m_RightMargin = 0;

    public CodeEditorLineBasedBorderPane(BorderManager mgr, int width, Color backgroundColor) {
        super(mgr, width, backgroundColor);
    }

    public void setLeftMargin(int margin) {
        this.m_LeftMargin = margin;
    }

    public void setRightMargin(int margin) {
        this.m_RightMargin = margin;
    }

    public int getUsableWidth() {
        return this.getWidth() - this.m_LeftMargin - this.m_RightMargin;
    }

    protected void eraseRangeOfScreenLines(Graphics g, int firstLine, int lastLine) {
        Rectangle clipRect = new Rectangle();
        this.getRectForRangeOfScreenLines(firstLine, lastLine, clipRect);
        if (this.m_BackColor != null) {
            Color oldColor = g.getColor();
            g.setColor(this.m_BackColor);
            g.fillRect(clipRect.x, clipRect.y, clipRect.width, clipRect.height);
            g.setColor(oldColor);
        }
    }

    protected boolean getRectForRangeOfScreenLines(int startLine, int endLine, Rectangle textRect) {
        textRect.x = this.m_LeftMargin;
        textRect.y = this.m_Mgr.getEditorPane().getView().getYCoordForTopOfDeviceLine(startLine);
        textRect.height = this.m_Mgr.getEditorPane().getView().getYCoordForBottomOfDeviceLine(endLine) - textRect.y;
        textRect.width = this.getUsableWidth();
        return true;
    }

    protected abstract void drawLine(int var1, Rectangle var2, Graphics var3);

    protected void paintRangeOfScreenLines(Graphics g, int firstLine, int lastLine) {
        g.setFont(this.m_Mgr.getEditorPane().getFont());
        Rectangle clipRect = new Rectangle();
        for (int i = firstLine; i <= lastLine; ++i) {
            this.getRectForRangeOfScreenLines(i, i, clipRect);
            this.eraseRangeOfScreenLines(g, i, i);
            this.drawLine(i, clipRect, g);
        }
    }

    protected int[] getVisibleLines() {
        int[] visibleLines = this.m_Mgr.getEditorPane().getView().getVisibleLines();
        if (visibleLines == null || visibleLines.length == 0) {
            return null;
        }
        return visibleLines;
    }

    void getScreenLinesAffected(Rectangle clipRect, int[] outputLineRange) {
        Rectangle clientRect = this.m_Mgr.getScrollPane().getRowHeader().getViewRect();
        int lineHeight = this.m_Mgr.getEditorPane().getView().getDeviceLineHeight();
        int firstScreenLineAffected = (clipRect.y - clientRect.y) / lineHeight;
        firstScreenLineAffected = Math.max(firstScreenLineAffected, 0);
        int lastScreenLineAffected = (clipRect.y - clientRect.y + clipRect.height) / lineHeight;
        if ((clipRect.y - clientRect.y + clipRect.height) % lineHeight == 0) {
            --lastScreenLineAffected;
        }
        int partiallyVisibleLineCount = this.m_Mgr.getEditorPane().getView().getPartiallyVisibleLineCount() - 1;
        lastScreenLineAffected = Math.min(lastScreenLineAffected, partiallyVisibleLineCount);
        lastScreenLineAffected = Math.max(lastScreenLineAffected, 0);
        outputLineRange[0] = firstScreenLineAffected = Math.min(firstScreenLineAffected, partiallyVisibleLineCount);
        outputLineRange[1] = lastScreenLineAffected;
    }
}

