/*
 * Decompiled with CFR 0.152.
 */
package com.sas.editor;

import com.sas.editor.CodeEditorDefaults;
import com.sas.editor.CodeEditorPane;
import com.sas.editor.CodeEditorResource;
import com.sas.swing.util.SASJavaHelp;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.text.CollationKey;
import java.text.Collator;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;

public class UserKeywordsDialog
extends JDialog
implements KeyEventDispatcher {
    CodeEditorResource resource;
    CodeEditorDefaults defaults;
    DefaultListModel dlm = new DefaultListModel();
    SASJavaHelp jHelp = new SASJavaHelp();
    JScrollPane keywordsPane = new JScrollPane();
    JList keywordsList = new JList();
    JButton OKButton = new JButton();
    JButton CancelButton = new JButton();
    JButton AddButton = new JButton();
    JButton RenameButton = new JButton();
    JButton DeleteButton = new JButton();
    JButton HelpButton = new JButton();

    public static UserKeywordsDialog CreateDialog(Component startComponent, CodeEditorDefaults defaults) {
        Component parent = CodeEditorPane.getParentFrameOrDialog(startComponent);
        if (parent instanceof Frame) {
            return new UserKeywordsDialog((Frame)parent, defaults);
        }
        if (parent instanceof Dialog) {
            return new UserKeywordsDialog((Dialog)parent, defaults);
        }
        return null;
    }

    private UserKeywordsDialog(Dialog dlg, CodeEditorDefaults defs) {
        super(dlg);
        this.resource = new CodeEditorResource(UserKeywordsDialog.class);
        this.defaults = defs;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private UserKeywordsDialog(Frame frame, CodeEditorDefaults defs) {
        super(frame);
        this.resource = new CodeEditorResource(UserKeywordsDialog.class);
        this.defaults = defs;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this);
        this.getContentPane().setLayout(new GridBagLayout());
        this.keywordsPane = new JScrollPane(this.keywordsList);
        this.PopulateKeywordList();
        this.OKButton.setText(this.resource.getString("Common.OK.txt"));
        this.CancelButton.setText(this.resource.getString("Common.Cancel.txt"));
        this.setupMnemonics(this.AddButton, "Common.Add.txt");
        this.setupMnemonics(this.RenameButton, "Common.Rename.txt");
        this.setupMnemonics(this.DeleteButton, "Common.Delete.txt");
        this.setupMnemonics(this.HelpButton, "Common.Help.txt");
        this.OKButton.setDefaultCapable(true);
        this.getRootPane().setDefaultButton(this.OKButton);
        Dimension btnSize = new Dimension(120, 25);
        this.setStaticComponentSize(this.OKButton, btnSize);
        this.setStaticComponentSize(this.CancelButton, btnSize);
        this.setStaticComponentSize(this.AddButton, btnSize);
        this.setStaticComponentSize(this.RenameButton, btnSize);
        this.setStaticComponentSize(this.DeleteButton, btnSize);
        this.setStaticComponentSize(this.HelpButton, btnSize);
        Box btnBox = Box.createVerticalBox();
        btnBox.add(this.OKButton);
        btnBox.add(Box.createVerticalStrut(5));
        btnBox.add(this.CancelButton);
        btnBox.add(Box.createVerticalStrut(15));
        btnBox.add(this.AddButton);
        btnBox.add(Box.createVerticalStrut(5));
        btnBox.add(this.RenameButton);
        btnBox.add(Box.createVerticalStrut(5));
        btnBox.add(this.DeleteButton);
        btnBox.add(Box.createVerticalStrut(5));
        btnBox.add(this.HelpButton);
        btnBox.add(Box.createVerticalGlue());
        Box box = Box.createHorizontalBox();
        box.add(this.keywordsPane);
        box.add(Box.createHorizontalStrut(5));
        box.add(btnBox);
        this.getContentPane().add((Component)box, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(7, 7, 7, 7), 0, 0));
        this.setSize(260, 230);
        this.setTitle(this.resource.getString("UserKeywordsDialog.Title.txt"));
        this.setModal(true);
        this.setResizable(false);
        this.OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserKeywordsDialog.this.onOK();
            }
        });
        this.CancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserKeywordsDialog.this.onCancel();
            }
        });
        this.AddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserKeywordsDialog.this.onAdd();
            }
        });
        this.RenameButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserKeywordsDialog.this.onRename();
            }
        });
        this.DeleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserKeywordsDialog.this.onDelete();
            }
        });
        this.HelpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserKeywordsDialog.this.onHelp();
            }
        });
    }

    private void setStaticComponentSize(JComponent jc, Dimension d) {
        jc.setMinimumSize(d);
        jc.setPreferredSize(d);
        jc.setMaximumSize(d);
    }

    protected void PopulateKeywordList() {
        this.keywordsList.removeAll();
        this.dlm.clear();
        int numberOfUserKeywords = this.defaults.getPropertyInt("SasKeywordManager.numberOfUserDefinedKeywords.txt", 0);
        for (int i = 0; i < numberOfUserKeywords; ++i) {
            this.dlm.addElement(this.defaults.getPropertyString("SasKeywordManager.UserDefinedKeyword." + i + ".txt"));
        }
        this.keywordsList.setModel(this.dlm);
        this.keywordsList.setBorder(null);
        this.sortKeywords();
    }

    protected void onOK() {
        int i;
        int numberOfUserKeywords = this.defaults.getPropertyInt("SasKeywordManager.numberOfUserDefinedKeywords.txt", 0);
        for (i = 0; i < numberOfUserKeywords; ++i) {
            this.defaults.removePropertyString("SasKeywordManager.UserDefinedKeyword." + i + ".txt");
        }
        this.defaults.setPropertyInt("SasKeywordManager.numberOfUserDefinedKeywords.txt", this.dlm.getSize());
        for (i = 0; i < this.dlm.getSize(); ++i) {
            this.defaults.setPropertyString("SasKeywordManager.UserDefinedKeyword." + i + ".txt", (String)this.dlm.get(i));
        }
        this.defaults.saveProperties();
        this.dispose();
    }

    protected void onCancel() {
        this.dispose();
    }

    @Override
    public void dispose() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this);
        this.getContentPane().removeAll();
        super.dispose();
    }

    protected void onAdd() {
        String dlgTitle = this.resource.getString("UserKeywordsDialog.AddOptionPaneTitle.txt");
        String message = this.resource.getString("UserKeywordsDialog.EnterUserDefinedKeyword.txt");
        String name = this.getKeywordFromUser(message, dlgTitle, "");
        if (name == null) {
            return;
        }
        this.dlm.insertElementAt(name, 0);
        this.sortKeywords();
        int select = this.NameToIndex(name);
        if (select >= 0) {
            this.keywordsList.setSelectedIndex(select);
        }
    }

    protected void onRename() {
        int doomedKeyword = this.keywordsList.getSelectedIndex();
        if (doomedKeyword < 0) {
            return;
        }
        String dlgTitle = this.resource.getString("UserKeywordsDialog.RenameOptionPaneTitle.txt");
        String message = this.resource.getString("UserKeywordsDialog.EnterUserDefinedKeyword.txt");
        String name = this.getKeywordFromUser(message, dlgTitle, "");
        if (name == null) {
            return;
        }
        this.dlm.removeElementAt(doomedKeyword);
        this.dlm.insertElementAt(name, 0);
        this.sortKeywords();
        int select = this.NameToIndex(name);
        if (select >= 0) {
            this.keywordsList.setSelectedIndex(select);
        }
    }

    protected void onDelete() {
        int doomedKeyword = this.keywordsList.getSelectedIndex();
        if (doomedKeyword < 0) {
            return;
        }
        int select = doomedKeyword;
        if (select == this.dlm.getSize() - 1) {
            --select;
        }
        this.dlm.removeElementAt(doomedKeyword);
        this.keywordsList.setSelectedIndex(select);
    }

    protected void onHelp() {
        SASJavaHelp jh = new SASJavaHelp("texteditor");
        jh.setActivationWindow((Window)this);
        jh.showContext("userkeywords");
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent e) {
        if (e.getID() != 402) {
            return false;
        }
        if (e.getKeyCode() == 27 && this.isActive()) {
            this.onCancel();
            return true;
        }
        return false;
    }

    protected void sortKeywords() {
        int i;
        Collator coll = Collator.getInstance(Locale.getDefault());
        CollationKey[] keys = new CollationKey[this.dlm.getSize()];
        for (i = 0; i < this.dlm.getSize(); ++i) {
            keys[i] = coll.getCollationKey((String)this.dlm.elementAt(i));
        }
        this.sort(keys);
        this.dlm.clear();
        for (i = 0; i < keys.length; ++i) {
            this.dlm.addElement(keys[i].getSourceString());
        }
    }

    protected void sort(CollationKey[] keys) {
        boolean readyToQuit;
        do {
            readyToQuit = true;
            for (int i = 0; i < keys.length - 1; ++i) {
                if (keys[i].compareTo(keys[i + 1]) <= 0) continue;
                CollationKey temp = keys[i + 1];
                keys[i + 1] = keys[i];
                keys[i] = temp;
                readyToQuit = false;
            }
        } while (!readyToQuit);
    }

    protected String getKeywordFromUser(String msg, String title, String initialText) {
        String name = (String)JOptionPane.showInputDialog(null, msg, title, 3, null, null, initialText);
        if (name == null || name.length() == 0) {
            return null;
        }
        if (name.indexOf(32) >= 0) {
            String nospaces = this.resource.getString("UserKeywordsDialog.NoSpacesAllowed.txt");
            JOptionPane.showMessageDialog(null, nospaces, title, 2);
            return this.getKeywordFromUser(msg, title, initialText);
        }
        if (this.keywordExists(name)) {
            String exists = this.resource.getString("UserKeywordsDialog.KeywordAlreadyExists.txt");
            JOptionPane.showMessageDialog(null, exists, title, 2);
            return this.getKeywordFromUser(msg, title, initialText);
        }
        return name;
    }

    protected boolean keywordExists(String s) {
        Collator coll = Collator.getInstance(Locale.getDefault());
        for (int i = 0; i < this.dlm.getSize(); ++i) {
            if (coll.compare((Object)s, this.dlm.get(i)) != 0) continue;
            return true;
        }
        return false;
    }

    protected int NameToIndex(String s) {
        Collator coll = Collator.getInstance(Locale.getDefault());
        for (int i = 0; i < this.dlm.getSize(); ++i) {
            if (coll.compare((Object)s, this.dlm.get(i)) != 0) continue;
            return i;
        }
        return -1;
    }

    protected void setupMnemonics(JButton btn, String key) {
        String buttonItem = this.resource.getString(key);
        String buttonText = Util.getLabelWithoutMnemonic((String)buttonItem);
        btn.setText(buttonText);
        int index = Util.getDisplayedMnemonicIndex((String)buttonItem);
        if (index > -1) {
            btn.setMnemonic(Util.getDisplayedMnemonic((String)buttonItem));
            btn.setDisplayedMnemonicIndex(index);
        }
    }
}

