/*
 * Decompiled with CFR 0.152.
 */
package com.sas.editor;

import com.sas.editor.CodeEditorResource;
import com.sas.editor.GoToLineDialog;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class UserInputDialog
extends JDialog
implements Runnable,
KeyEventDispatcher {
    protected CodeEditorResource resource;
    private GridBagLayout layout = new GridBagLayout();
    private JLabel msg = new JLabel();
    private JTextField textField = new JTextField();
    private JButton okButton = new JButton();
    private JButton cancelButton = new JButton();
    private String m_Message;
    private String m_Title;
    private String m_Data;
    protected int m_MaxCharacters;
    protected Thread m_thrd;
    protected boolean m_ThreadRun;

    public UserInputDialog(Frame parent, String title, String message) {
        super(parent);
        this.m_Message = message;
        this.m_Title = title;
        this.m_Data = null;
        this.m_MaxCharacters = -1;
        this.resource = new CodeEditorResource(GoToLineDialog.class);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.m_thrd = new Thread(this);
        this.m_thrd.setDaemon(true);
        this.m_thrd.setName("Size Monitor");
        this.m_ThreadRun = true;
        this.m_thrd.start();
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(this.layout);
        this.msg.setText(this.m_Message);
        this.okButton.setText(this.resource.getString("Common.OK.txt"));
        this.cancelButton.setText(this.resource.getString("Common.Cancel.txt"));
        this.cancelButton.setDefaultCapable(true);
        GridLayout btnLayout = new GridLayout(1, 2);
        JPanel btnPanel = new JPanel(btnLayout);
        btnPanel.add(this.okButton);
        btnPanel.add(this.cancelButton);
        btnLayout.setHgap(10);
        GridLayout dlgLayout = new GridLayout(3, 1);
        JPanel contentPanel = new JPanel(dlgLayout);
        dlgLayout.setVgap(10);
        contentPanel.add(this.msg);
        contentPanel.add(this.textField);
        contentPanel.add(btnPanel);
        this.getContentPane().setLayout(this.layout);
        this.getContentPane().add((Component)contentPanel, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(7, 7, 7, 7), 0, 0));
        this.setTitle(this.m_Title);
        this.setModal(true);
        this.setResizable(false);
        this.setSize(250, 135);
        this.setLocationRelativeTo(this.getParent());
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserInputDialog.this.OnOK();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserInputDialog.this.OnCancel();
            }
        });
        this.textField.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
                UserInputDialog.this.OnKey(e);
            }
        });
    }

    public void OnOK() {
        this.m_Data = this.textField.getText();
        this.dispose();
    }

    public void OnCancel() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this);
        this.dispose();
    }

    public void OnKey(KeyEvent e) {
        char c = e.getKeyChar();
        if (c == '\n') {
            this.OnOK();
        }
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent e) {
        if (e.getID() != 402) {
            return false;
        }
        if (e.getKeyCode() == 27 && this.isActive()) {
            this.OnCancel();
            return true;
        }
        return false;
    }

    public void setMnemonic(char c) {
        this.msg.setDisplayedMnemonic(c);
        this.msg.setLabelFor(this.textField);
    }

    public String prompt() {
        this.setVisible(true);
        this.m_ThreadRun = false;
        return this.m_Data;
    }

    public void setMaxCharacters(int limit) {
        this.m_MaxCharacters = limit;
    }

    @Override
    public void run() {
        if (this.m_MaxCharacters < 0) {
            return;
        }
        while (this.m_ThreadRun) {
            try {
                this.getToolkit().beep();
                Thread.sleep(10L);
                String data = this.textField.getText();
                if (data.length() <= this.m_MaxCharacters) continue;
                this.textField.setText(data.substring(0, this.m_MaxCharacters));
                this.textField.setCaretPosition(this.m_MaxCharacters);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

