/*
 * Decompiled with CFR 0.152.
 */
package com.sas.editor;

import com.sas.editor.TokenInfo;
import com.sas.editor.TokenMapInterface;

public class TokenMapIterator {
    private TokenMapInterface m_TokenMap = null;

    public void setTokenMap(TokenMapInterface myMap, int startOffset) {
        this.m_TokenMap = myMap;
        if (this.m_TokenMap != null) {
            this.rewind();
        }
    }

    public void rewind() {
        this.seek(0);
    }

    public TokenInfo seek(int docOffset) {
        if (this.m_TokenMap == null) {
            return null;
        }
        TokenInfo token = this.m_TokenMap.seek(docOffset);
        return token;
    }

    public TokenInfo nextToken() {
        TokenInfo info = this.m_TokenMap.next();
        return info;
    }

    public int getStartOffset() {
        return this.m_TokenMap.getCurrent().getStartOffset();
    }

    public int getEndOffset() {
        return this.m_TokenMap.getCurrent().getEndOffset();
    }

    public TokenInfo getTokenInfo() {
        TokenInfo ti = this.m_TokenMap.getCurrent();
        if (ti == null) {
            return null;
        }
        return ti;
    }

    public boolean currentValid() {
        return this.m_TokenMap.isCurrentValid();
    }
}

