/*
 * Decompiled with CFR 0.152.
 */
package com.sas.editor;

import com.sas.editor.AttributeMap;
import com.sas.editor.CodeEditorDocument;
import com.sas.editor.CodeEditorView;
import com.sas.editor.GapList;
import com.sas.editor.ICodeDocument;
import com.sas.editor.TokenInfo;
import com.sas.editor.TokenMapInterface;
import java.awt.FontMetrics;
import java.util.Iterator;
import javax.swing.text.AttributeSet;
import javax.swing.text.Segment;

public class TokenMap
implements TokenMapInterface {
    protected GapList mRanges = null;
    protected boolean mValidateOperations = false;
    protected int mCurrentRangeIndex = -1;
    protected ICodeDocument mDocument = null;

    public TokenMap(ICodeDocument doc) {
        this.mDocument = doc;
        this.mRanges = new GapList(100);
    }

    @Override
    public void cleanup() {
        this.clear();
    }

    @Override
    public void clear() {
        this.mRanges = new GapList(100);
        this.mCurrentRangeIndex = -1;
    }

    @Override
    public void removeLast() {
        if (this.getRangeCount() > 0) {
            this.mRanges.remove(this.getRangeCount() - 1);
        }
    }

    @Override
    public int getRangeCount() {
        return this.mRanges.size();
    }

    @Override
    public void patchRanges(TokenMapInterface newRanges) {
        TokenInfo newToken = newRanges.seekEnd();
        if (newToken == null) {
            return;
        }
        TokenInfo oldToken = this.seek(newToken.getStartOffset());
        while (newToken != null && oldToken != null && newToken.equals(oldToken)) {
            ((TokenMap)newRanges).deleteCurrent();
            newToken = newRanges.previous();
            oldToken = this.previous();
        }
        if (newRanges.getRangeCount() == 0) {
            return;
        }
        newToken = newRanges.seekStart();
        oldToken = this.seek(newToken.getStartOffset());
        while (newToken != null && oldToken != null && newToken.equals(oldToken)) {
            ((TokenMap)newRanges).deleteCurrent();
            newToken = newRanges.getCurrent();
            oldToken = this.next();
        }
        newToken = newRanges.seekStart();
        if (newToken == null) {
            return;
        }
        oldToken = this.seek(newToken.getStartOffset());
        if (oldToken == null) {
            this.insert(this.getRangeCount(), newRanges);
            newRanges.clear();
            return;
        }
        newToken = newRanges.seekStart();
        int begin = newToken.getStartOffset();
        newToken = newRanges.seekEnd();
        int end = newToken.getEndOffset();
        oldToken = this.seek(begin);
        if (oldToken.getStartOffset() < begin) {
            oldToken = this.next();
        }
        while (oldToken != null && oldToken.getStartOffset() >= begin && oldToken.getEndOffset() <= end) {
            this.deleteCurrent();
            oldToken = this.getCurrent();
        }
        newToken = newRanges.seekStart();
        oldToken = this.seek(newToken.getStartOffset());
        if (oldToken != null && oldToken.getStartOffset() < newToken.getStartOffset()) {
            if (oldToken.canMerge(newToken)) {
                oldToken.setEndOffset(newToken.getEndOffset());
                oldToken = this.next();
                while (oldToken != null && oldToken.getStartOffset() < newToken.getEndOffset() && oldToken.getEndOffset() <= newToken.getEndOffset()) {
                    this.deleteCurrent();
                    oldToken = this.getCurrent();
                }
                if (oldToken != null && oldToken.getStartOffset() <= newToken.getEndOffset()) {
                    oldToken.setStartOffset(newToken.getEndOffset());
                }
                ((TokenMap)newRanges).deleteCurrent();
            } else {
                oldToken.setEndOffset(newToken.getStartOffset());
                if (oldToken.getEndOffset() <= newToken.getStartOffset()) {
                    this.deleteCurrent();
                }
            }
        }
        if (newRanges.getRangeCount() == 0) {
            return;
        }
        newToken = newRanges.seekEnd();
        oldToken = this.seek(newToken.getEndOffset() - 1);
        if (oldToken != null && oldToken.getEndOffset() >= newToken.getEndOffset() && oldToken.getStartOffset() < newToken.getEndOffset()) {
            if (oldToken.canMerge(newToken)) {
                oldToken.setStartOffset(newToken.getStartOffset());
                oldToken = this.previous();
                while (oldToken != null && oldToken.getStartOffset() >= newToken.getStartOffset() && oldToken.getEndOffset() <= newToken.getEndOffset()) {
                    this.deleteCurrent();
                    oldToken = this.previous();
                }
                if (oldToken != null && oldToken.getEndOffset() > newToken.getStartOffset()) {
                    oldToken.setEndOffset(newToken.getStartOffset());
                }
                ((TokenMap)newRanges).deleteCurrent();
            } else {
                oldToken.setStartOffset(newToken.getEndOffset());
                if (oldToken.getEndOffset() <= oldToken.getStartOffset()) {
                    this.deleteCurrent();
                }
            }
        }
        if (newRanges.getRangeCount() == 0) {
            return;
        }
        newToken = newRanges.seekStart();
        oldToken = this.seek(newToken.getStartOffset());
        if (this.getRangeCount() > 0) {
            this.previous();
        }
        int currentIndex = this.mCurrentRangeIndex;
        newToken = newRanges.seekStart();
        oldToken = this.seekEnd();
        if (oldToken != null && oldToken.getEndOffset() <= newToken.getStartOffset() || this.getRangeCount() == 0) {
            this.insert(this.getRangeCount(), newRanges);
            newRanges.clear();
            return;
        }
        this.mCurrentRangeIndex = currentIndex;
        oldToken = this.getCurrent();
        if (oldToken == null) {
            this.insert(0, newRanges);
            newRanges.clear();
        } else {
            this.insert(this.mCurrentRangeIndex + 1, newRanges);
            newRanges.clear();
        }
        if (this.mValidateOperations && !this.validate(true)) {
            this.dump();
        }
    }

    @Override
    public TokenInfo getCurrent() {
        if (this.mCurrentRangeIndex < 0 || this.mCurrentRangeIndex >= this.getRangeCount()) {
            return null;
        }
        return (TokenInfo)this.mRanges.get(this.mCurrentRangeIndex);
    }

    protected void deleteCurrent() {
        if (this.mCurrentRangeIndex < 0 || this.mCurrentRangeIndex >= this.getRangeCount()) {
            return;
        }
        this.mRanges.remove(this.mCurrentRangeIndex);
    }

    @Override
    public TokenInfo seekEnd() {
        this.mCurrentRangeIndex = this.getRangeCount() - 1;
        if (this.mCurrentRangeIndex < 0) {
            return null;
        }
        return (TokenInfo)this.mRanges.get(this.mCurrentRangeIndex);
    }

    @Override
    public TokenInfo seekStart() {
        this.mCurrentRangeIndex = 0;
        if (this.mCurrentRangeIndex >= this.getRangeCount()) {
            return null;
        }
        return (TokenInfo)this.mRanges.get(this.mCurrentRangeIndex);
    }

    @Override
    public TokenInfo seek(int offset) {
        int currentRangeIndex;
        this.mCurrentRangeIndex = currentRangeIndex = this.findTokenIndex(offset);
        if (this.mCurrentRangeIndex < 0 || this.mCurrentRangeIndex >= this.getRangeCount()) {
            return null;
        }
        return (TokenInfo)this.mRanges.get(this.mCurrentRangeIndex);
    }

    @Override
    public TokenInfo next() {
        ++this.mCurrentRangeIndex;
        if (this.mCurrentRangeIndex < 0 || this.mCurrentRangeIndex >= this.getRangeCount()) {
            return null;
        }
        return (TokenInfo)this.mRanges.get(this.mCurrentRangeIndex);
    }

    @Override
    public TokenInfo previous() {
        --this.mCurrentRangeIndex;
        if (this.mCurrentRangeIndex < 0 || this.mCurrentRangeIndex >= this.getRangeCount()) {
            return null;
        }
        return (TokenInfo)this.mRanges.get(this.mCurrentRangeIndex);
    }

    protected int findTokenIndex(int offset) {
        TokenInfo currentInfo = null;
        currentInfo = this.getCurrent();
        if (currentInfo != null) {
            if (currentInfo.getStartOffset() <= offset && currentInfo.getEndOffset() > offset) {
                return this.mCurrentRangeIndex;
            }
            currentInfo = this.next();
            if (currentInfo != null && currentInfo.getStartOffset() <= offset && currentInfo.getEndOffset() > offset) {
                return this.mCurrentRangeIndex;
            }
        }
        int lower = 0;
        int upper = this.getRangeCount() - 1;
        int middle = lower;
        if (upper < 0) {
            return -1;
        }
        while (lower <= upper) {
            middle = lower + upper >> 1;
            currentInfo = (TokenInfo)this.mRanges.get(middle);
            if (currentInfo.getStartOffset() <= offset && currentInfo.getEndOffset() > offset) {
                this.mCurrentRangeIndex = middle;
                return middle;
            }
            if (currentInfo.getStartOffset() >= offset) {
                upper = middle - 1;
                continue;
            }
            lower = middle + 1;
        }
        if (lower >= this.getRangeCount()) {
            return lower;
        }
        TokenInfo info = (TokenInfo)this.mRanges.get(lower);
        int returnVal = 0;
        returnVal = info.getStartOffset() <= offset ? lower + 1 : lower;
        this.mCurrentRangeIndex = returnVal;
        return returnVal;
    }

    @Override
    public TokenInfo getTokenInfo(int offset) {
        int middle = this.findTokenIndex(offset);
        if (middle >= 0 && middle < this.getRangeCount()) {
            TokenInfo testToken = (TokenInfo)this.mRanges.get(middle);
            return testToken;
        }
        return null;
    }

    protected void insert(int location, TokenMapInterface newMap) {
        for (int i = 0; i < newMap.getRangeCount(); ++i) {
            this.mRanges.add(location, ((TokenMap)newMap).mRanges.get(i));
            ++location;
        }
    }

    @Override
    public void append(TokenInfo info, boolean mergeIfPossible) {
        if (this.mValidateOperations && !this.validate(false)) {
            this.dump();
        }
        if (mergeIfPossible) {
            TokenInfo previousRange = null;
            int rangeCount = this.getRangeCount();
            boolean merged = false;
            if (rangeCount > 0 && (previousRange = (TokenInfo)this.mRanges.get(rangeCount - 1)).canMerge(info)) {
                previousRange.setEndOffset(info.getEndOffset());
                merged = true;
            }
            if (!merged) {
                this.mRanges.add(info);
            }
        } else {
            this.mRanges.add(info);
        }
        if (!this.mValidateOperations || !this.validate(false)) {
            // empty if block
        }
    }

    @Override
    public boolean containsRange(TokenInfo testToken) {
        TokenInfo foundToken = this.seek(testToken.getStartOffset());
        if (foundToken == null) {
            return false;
        }
        return foundToken.equals(testToken);
    }

    @Override
    public boolean validate(boolean completenessCheck) {
        TokenInfo prevInfo = null;
        int rangeCount = this.getRangeCount();
        for (int i = 0; i < rangeCount; ++i) {
            TokenInfo currentInfo = (TokenInfo)this.mRanges.get(i);
            if (prevInfo != null) {
                if (completenessCheck && prevInfo.getEndOffset() != currentInfo.getStartOffset()) {
                    return false;
                }
                if (prevInfo.getStartOffset() == currentInfo.getStartOffset() || prevInfo.getEndOffset() == currentInfo.getEndOffset()) {
                    return false;
                }
                if (prevInfo.getEndOffset() > currentInfo.getStartOffset()) {
                    return false;
                }
            }
            if (currentInfo.getStartOffset() >= currentInfo.getEndOffset()) {
                return false;
            }
            prevInfo = currentInfo;
        }
        if (completenessCheck && rangeCount > 0) {
            TokenInfo firstRange = (TokenInfo)this.mRanges.get(0);
            if (firstRange.getStartOffset() != 0) {
                return false;
            }
            TokenInfo lastRange = (TokenInfo)this.mRanges.get(rangeCount - 1);
            if (lastRange.getEndOffset() != this.mDocument.getLength()) {
                System.out.println("Actual document length is " + this.mDocument.getLength());
                return false;
            }
        }
        return true;
    }

    @Override
    public void shiftPositionsForInsert(int insertStart, int insertLength) {
        int rangeCount = this.getRangeCount();
        if (rangeCount == 0) {
            return;
        }
        int index = this.findTokenIndex(insertStart);
        if (index < 0) {
            return;
        }
        if (index >= rangeCount) {
            TokenInfo lastToken = (TokenInfo)this.mRanges.get(rangeCount - 1);
            lastToken.setEndOffset(lastToken.getEndOffset() + insertLength);
        }
        TokenInfo currentInfo = null;
        for (int i = index; i < rangeCount; ++i) {
            currentInfo = (TokenInfo)this.mRanges.get(i);
            int startOffset = currentInfo.getStartOffset();
            int endOffset = currentInfo.getEndOffset();
            if (startOffset > insertStart) {
                currentInfo.setStartOffset(startOffset + insertLength);
            }
            if (endOffset <= insertStart) continue;
            currentInfo.setEndOffset(endOffset + insertLength);
        }
        if (this.mValidateOperations && !this.validate(true)) {
            System.out.println("Error inserting ranges");
        }
    }

    @Override
    public void shiftPositionsForDelete(int deleteStart, int deleteEnd) {
        int deleteAmount = deleteEnd - deleteStart;
        TokenInfo currentInfo = null;
        int firstDeletedRange = -1;
        int lastDeletedRange = -1;
        int index = this.findTokenIndex(deleteStart);
        if (index < 0) {
            return;
        }
        currentInfo = (TokenInfo)this.mRanges.get(index);
        if (deleteEnd >= currentInfo.getEndOffset()) {
            currentInfo.setEndOffset(deleteStart);
        } else {
            currentInfo.setEndOffset(currentInfo.getEndOffset() - deleteAmount);
        }
        if (currentInfo.getStartOffset() == currentInfo.getEndOffset()) {
            firstDeletedRange = index;
            lastDeletedRange = index;
        }
        ++index;
        int rangeCount = this.getRangeCount();
        while (index < rangeCount) {
            currentInfo = (TokenInfo)this.mRanges.get(index);
            if (currentInfo.getEndOffset() > deleteEnd) {
                if (currentInfo.getStartOffset() > deleteEnd) break;
                currentInfo.setStartOffset(deleteStart);
                currentInfo.setEndOffset(currentInfo.getEndOffset() - deleteAmount);
                ++index;
                break;
            }
            if (firstDeletedRange < 0) {
                firstDeletedRange = index;
            }
            lastDeletedRange = index++;
        }
        while (index < rangeCount) {
            currentInfo = (TokenInfo)this.mRanges.get(index);
            currentInfo.setStartOffset(currentInfo.getStartOffset() - deleteAmount);
            currentInfo.setEndOffset(currentInfo.getEndOffset() - deleteAmount);
            ++index;
        }
        if (firstDeletedRange >= 0 && lastDeletedRange >= 0) {
            for (int i = firstDeletedRange; i <= lastDeletedRange; ++i) {
                this.mRanges.remove(firstDeletedRange);
            }
        }
        if (!this.mValidateOperations || !this.validate(false)) {
            // empty if block
        }
    }

    public static int getTabbedTextWidth(Segment s, FontMetrics metrics, int x, int startOffset, CodeEditorView view, TokenMapInterface tokenMap) {
        int i;
        int nextX = x;
        char[] txt = s.array;
        int txtOffset = s.offset;
        int n = s.offset + s.count;
        AttributeMap map = ((CodeEditorDocument)view.getDocument()).getLanguageParser().getElementAttributeMap();
        FontMetrics fm = metrics;
        int nTokenInfoExpires = startOffset;
        int measureStart = txtOffset;
        if (map == null) {
            return -1;
        }
        if (fm == null) {
            return -1;
        }
        FontMetrics currentFM = null;
        map.createFontMetricsIfNecesssary(view.getContainer());
        for (i = txtOffset; i < n; ++i) {
            if (startOffset + (i - txtOffset) >= nTokenInfoExpires) {
                FontMetrics tempFM;
                AttributeSet attrs;
                if (i > measureStart) {
                    nextX += currentFM.charsWidth(txt, measureStart, i - measureStart);
                }
                measureStart = i;
                TokenInfo ti = i == txtOffset ? tokenMap.seek(startOffset + (i - txtOffset)) : tokenMap.next();
                int endOffset = 0;
                if (ti != null) {
                    endOffset = ti.getEndOffset();
                    attrs = map.getElementAttributes(ti.getTokenType());
                } else {
                    endOffset = n;
                    attrs = null;
                }
                currentFM = fm;
                if (attrs != null && (tempFM = (FontMetrics)attrs.getAttribute("FontMetric")) != null) {
                    currentFM = tempFM;
                }
                nTokenInfoExpires = endOffset;
            }
            if (txt[i] != '\t') continue;
            if (i > measureStart) {
                nextX += currentFM.charsWidth(txt, measureStart, i - measureStart);
            }
            measureStart = i + 1;
            if (view != null) {
                nextX = (int)view.nextTabStop(nextX, startOffset + i - txtOffset);
                continue;
            }
            nextX += fm.charWidth(' ');
        }
        if (i > measureStart) {
            nextX += currentFM.charsWidth(txt, measureStart, i - measureStart);
        }
        return nextX - x;
    }

    @Override
    public void dump() {
        System.out.println("*************************************");
        int rangeCount = this.getRangeCount();
        for (int i = 0; i < rangeCount; ++i) {
            TokenInfo token = (TokenInfo)this.mRanges.get(i);
            String data = "";
            try {
                data = this.mDocument.getText(token.getStartOffset(), token.getEndOffset() - token.getStartOffset());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            System.out.println(token.getStartOffset() + ".." + token.getEndOffset() + " (" + token.getTokenType() + ")");
            System.out.println(data);
        }
    }

    @Override
    public boolean isCurrentValid() {
        return this.getCurrent() != null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TokenMap)) {
            return false;
        }
        TokenMap map = (TokenMap)obj;
        if (this.mValidateOperations != map.mValidateOperations) {
            return false;
        }
        Iterator myIterator = this.mRanges.iterator();
        Iterator otherIterator = map.mRanges.iterator();
        if (this.mRanges.size() != map.mRanges.size()) {
            return false;
        }
        while (myIterator.hasNext()) {
            TokenInfo otherToken;
            TokenInfo myToken = (TokenInfo)myIterator.next();
            if (myToken.equals(otherToken = (TokenInfo)otherIterator.next())) continue;
            return false;
        }
        return true;
    }
}

