/*
 * Decompiled with CFR 0.152.
 */
package com.sas.editor;

import com.sas.editor.CodeEditorDefaults;
import com.sas.editor.CodeEditorDocument;
import com.sas.editor.CodeLanguage;
import com.sas.editor.LogListView;
import com.sas.editor.LogMemoryStorageConfigData;
import com.sas.editor.LogStorageConfigDataInterface;
import com.sas.editor.LongLineListener;
import com.sas.editor.MRUList;
import com.sas.editor.MRUListNode;
import com.sas.editor.VirtualLogElement;
import com.sas.editor.VirtualLogListTokenMap;
import com.sas.editor.language.ILanguageParser;
import com.sas.editor.language.LogRepository;
import com.sas.editor.language.RepositoryChangedListener;
import com.sas.iom.SAS.ILanguageServicePackage.CarriageControl;
import com.sas.iom.SAS.ILanguageServicePackage.LineType;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Segment;
import javax.swing.text.SimpleAttributeSet;

public class LogListDocument
extends CodeEditorDocument
implements RepositoryChangedListener {
    protected int mMaxMemoryLineCacheSize;
    protected Map mLineHash;
    protected MRUList mLogLineInfoCache;
    protected LogRootElement mRootElement = new LogRootElement();
    protected List mLongLineListeners;
    protected int mMaxLineLength;
    protected LogRepository mRepository;
    private static final int mDefaultMemoryLogSize = 2500;
    private boolean m_bLogListColoringEnabled = true;
    private final VirtualLogElement mHashLogElement = new VirtualLogElement(null, 0, -1, -1);
    private final VirtualLogElement mLastLineLogElement = new VirtualLogElement(null, 0, -1, -1);

    public LogListDocument(CodeLanguage logOrList) {
        this.m_defaults = new CodeEditorDefaults();
        this.initializeStuff(logOrList);
    }

    protected void initializeStuff(CodeLanguage logOrList) {
        if (logOrList == CodeLanguage.LOG || logOrList == CodeLanguage.LIST) {
            this.setLanguage(logOrList);
        } else {
            this.setLanguage(CodeLanguage.LOG);
        }
        try {
            this.mRepository = new LogRepository(new LogMemoryStorageConfigData(2500, 50));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.mRepository.addListener(this);
        this.mMaxMemoryLineCacheSize = 300;
        this.mLineHash = new HashMap();
        this.mTokenMap = new VirtualLogListTokenMap(this);
        this.mLogLineInfoCache = new MRUList();
        this.mLongLineListeners = new ArrayList();
        this.mMaxLineLength = 255;
    }

    public LogListDocument(CodeLanguage logOrList, CodeEditorDefaults defaults) {
        this.m_defaults = defaults;
        this.initializeStuff(logOrList);
    }

    public void setContents(String[] lines, CarriageControl[] cc, LineType[] lt) {
        try {
            this.insertTextAttributeBased(0, lines, cc, lt);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public boolean setStorageParameters(LogStorageConfigDataInterface storageInfo) {
        try {
            this.mRepository.flush();
            LogRepository newRepository = new LogRepository(storageInfo);
            newRepository.addListener(this);
            if (this.mRepository != null) {
                this.mRepository.removeListener(this);
                this.mRepository.close();
            }
            this.mRepository = newRepository;
            this.syntaxColorUpdate(0, this.mRepository.getCharLength());
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public LogStorageConfigDataInterface getStorageParameters() {
        return this.mRepository.getStorageParameters();
    }

    public void EnableLogListColoring(boolean b) {
        this.m_bLogListColoringEnabled = b;
        ILanguageParser lp = this.getLanguageParser();
        lp.EnableDocumentColoring(b);
        this.syntaxColorUpdate(0, this.getLength());
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
    }

    public boolean isLogListColoringEnabled() {
        return this.m_bLogListColoringEnabled;
    }

    @Override
    public boolean openFile(String strFile) throws FileNotFoundException {
        File fname = new File(strFile);
        StringBuffer sb = new StringBuffer((int)Math.min(500000L, fname.length()));
        this.m_Filename = strFile;
        int bufferLength = 500000;
        char[] buffer = new char[bufferLength];
        int bytesRead = 0;
        boolean origColor = this.IsDocumentColoringEnabled();
        this.EnableDocumentColoring(false);
        this.clear();
        try {
            BufferedReader d = new BufferedReader(new InputStreamReader(new FileInputStream(fname)));
            do {
                if ((bytesRead = d.read(buffer, 0, bufferLength)) <= 0) continue;
                for (int i = 0; i < bytesRead; ++i) {
                    char character = buffer[i];
                    if (character == '\r') continue;
                    sb.append(character);
                }
                this.insertString(this.getLength(), sb.toString(), SimpleAttributeSet.EMPTY);
                sb.delete(0, sb.length());
            } while (bytesRead > 0);
        }
        catch (FileNotFoundException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        this.clearUndoStack();
        this.EnableDocumentColoring(origColor);
        return true;
    }

    protected int insertTextAttributeBased(int startOffset, String[] lines, CarriageControl[] cc, LineType[] lt) throws BadLocationException, IOException {
        if (lines == null || cc == null || lt == null) {
            return 0;
        }
        int previousLength = this.getLength();
        int charsAdded = 0;
        int defaultLineType = 2;
        if (this.getLanguage().getID() == 6) {
            defaultLineType = 0;
        }
        for (int i = 0; i < lines.length; ++i) {
            if (cc[i] == CarriageControl.CarriageControlSkipLine) {
                charsAdded += this.appendStringToRepository("", defaultLineType);
            } else if (cc[i] == CarriageControl.CarriageControlSkipTwoLines) {
                charsAdded += this.appendStringToRepository("", defaultLineType);
                charsAdded += this.appendStringToRepository("", defaultLineType);
            } else if (cc[i] == CarriageControl.CarriageControlOverPrint) continue;
            charsAdded += this.appendStringToRepository(lines[i], lt[i].value());
        }
        int startChange = previousLength;
        int endChange = previousLength + charsAdded;
        if (endChange != this.mRepository.getCharLength()) {
            startChange = 0;
            endChange = this.mRepository.getCharLength();
        }
        this.syntaxColorUpdate(startChange, endChange);
        return charsAdded;
    }

    private int appendStringToRepository(String line, int lineTypeCodes) throws IOException {
        if (line.length() == 0) {
            int charsAdded = this.mRepository.append(line, lineTypeCodes);
            return charsAdded;
        }
        int totalCharsAdded = 0;
        while (line.length() > 0) {
            String textToInsert = line;
            if (line.length() > this.mMaxLineLength) {
                textToInsert = line.substring(0, this.mMaxLineLength);
                line = line.substring(this.mMaxLineLength);
            } else {
                line = "";
            }
            int charsAdded = this.mRepository.append(textToInsert, lineTypeCodes);
            totalCharsAdded += charsAdded;
        }
        return totalCharsAdded;
    }

    private void fireLineAddedEvent(int lineNumber) {
        for (LongLineListener listener : this.mLongLineListeners) {
            listener.lineAdded(lineNumber);
        }
    }

    @Override
    public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
        int oldLength = this.mRepository.getCharLength();
        int charsAdded = 0;
        int currentIndex = 0;
        int firstCR = 0;
        do {
            firstCR = str.indexOf(10, currentIndex);
            try {
                String lineData = null;
                if (firstCR >= 0) {
                    lineData = str.substring(currentIndex, firstCR);
                    currentIndex = firstCR + 1;
                } else {
                    lineData = str.substring(currentIndex);
                    currentIndex = str.length();
                }
                charsAdded += this.appendStringToRepository(lineData, 0);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } while (currentIndex < str.length());
        if (oldLength + charsAdded == this.mRepository.getCharLength()) {
            this.syntaxColorUpdate(oldLength, this.mRepository.getCharLength());
        } else {
            this.syntaxColorUpdate(0, this.mRepository.getCharLength());
        }
    }

    public void deleteStorage() {
        try {
            this.mRepository.delete();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.setStorageParameters(new LogMemoryStorageConfigData(2500, 50));
        }
    }

    @Override
    public void cleanup() {
        super.cleanup();
        this.mRepository.removeListener(this);
        try {
            this.mRepository.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                this.mRepository = new LogRepository(new LogMemoryStorageConfigData(2500, 50));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void getText(int startOffset, int length, Segment segment) throws BadLocationException {
        String data = this.getText(startOffset, length);
        segment.array = data.toCharArray();
        segment.count = segment.array.length;
        segment.offset = 0;
    }

    protected String internalGetText(int startOffset, int length) throws BadLocationException {
        return this.mRepository.getText(startOffset, length);
    }

    @Override
    public String getText(int startOffset, int length) throws BadLocationException {
        String lineData;
        VirtualLogElement element;
        int lineNumber = this.getLineForOffset(startOffset);
        if (lineNumber >= 0 && (element = (VirtualLogElement)this.getElement(lineNumber)) != null && element.getEndOffset() >= startOffset + length && (lineData = element.getLineData()) != null) {
            if (lineData.length() == 0) {
                return "";
            }
            int start = startOffset - element.getStartOffset();
            if (start > lineData.length()) {
                start = lineData.length();
            }
            int endOffset = start + length;
            if (start + length > lineData.length()) {
                endOffset = lineData.length();
            }
            return lineData.substring(start, endOffset);
        }
        return this.internalGetText(startOffset, length);
    }

    private int internalGetLineLength(int lineNumber) {
        if (lineNumber >= this.mRepository.getLineCount() - 1) {
            return 0;
        }
        return this.mRepository.getLineLength(lineNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Element getElement(int index) {
        Map map = this.mLineHash;
        synchronized (map) {
            VirtualLogElement logElement;
            Object removedItem;
            MRUListNode lastNode;
            if (index == this.mRepository.getLineCount() - 1) {
                this.mLastLineLogElement.setStartOffset(-1);
                this.mLastLineLogElement.setEndOffset(-1);
                this.mLastLineLogElement.setLineData("");
                this.mLastLineLogElement.setLineWidth(0);
                this.mLastLineLogElement.setLineIndex(index);
                this.mLastLineLogElement.setStartOffset(this.mRepository.getCharLength());
                this.mLastLineLogElement.setEndOffset(this.mRepository.getCharLength());
                return this.mLastLineLogElement;
            }
            if (index >= this.mRepository.getLineCount()) {
                return null;
            }
            this.mHashLogElement.setLineIndex(index);
            VirtualLogElement element = (VirtualLogElement)this.mLineHash.get(this.mHashLogElement);
            if (element != null) {
                return element;
            }
            int startOffset = this.mRepository.getLineStart(index);
            element = new VirtualLogElement(this, index, startOffset, startOffset + this.internalGetLineLength(index));
            try {
                element.setLineData(this.internalGetText(startOffset, this.internalGetLineLength(index)));
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            this.mLineHash.put(element, element);
            this.mLogLineInfoCache.prepend(element);
            if (this.mLogLineInfoCache.size() > this.mMaxMemoryLineCacheSize && (lastNode = this.mLogLineInfoCache.removeLast()) != null && (removedItem = this.mLineHash.remove(logElement = (VirtualLogElement)lastNode.getUserData())) == null) {
                System.out.println("Error: no item found for " + Integer.toString(logElement.getLineIndex()));
            }
            this.fireLineAddedEvent(index);
            return element;
        }
    }

    @Override
    public int getLength() {
        return this.mRepository.getCharLength();
    }

    public int getLineType(int line) {
        if (line >= this.mRepository.getLineCount()) {
            return 0;
        }
        short lineType = this.mRepository.getLineType(line);
        return lineType;
    }

    private String findChunk(int startOffset, int chunkSize, boolean downwardSearch, int[] resultStartPosition) {
        int accumulatedChars;
        int startPos;
        int line = this.getLineForOffset(startOffset);
        if (downwardSearch) {
            startPos = startOffset;
            int offsetOnLine = startOffset - this.getStartOffsetForLine(line);
            accumulatedChars = this.getLineLength(line) - offsetOnLine;
            int docLineCount = this.getLineCount();
            ++line;
            while (accumulatedChars < chunkSize && line < docLineCount) {
                accumulatedChars += this.getLineLength(line);
                ++line;
            }
        } else {
            startPos = this.getStartOffsetForLine(line);
            --line;
            for (accumulatedChars = startOffset - startPos; accumulatedChars < chunkSize && line >= 0; accumulatedChars += this.getLineLength(line), --line) {
                startPos = this.getStartOffsetForLine(line);
            }
        }
        try {
            String searchText = this.getText(startPos, accumulatedChars);
            resultStartPosition[0] = startPos;
            return searchText;
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return "";
        }
    }

    @Override
    public int FindText(String TextToFind, int Offset, boolean SearchDown, boolean MatchCase, boolean MatchWord, boolean SearchCode, boolean SearchComments) {
        if (!MatchCase) {
            TextToFind = TextToFind.toUpperCase(Locale.getDefault());
        }
        int originalOffset = Offset;
        int FoundPosition = 0;
        int chunkSize = 50000;
        int currentBufferStart = Offset;
        int currentBufferOffset = 0;
        int bufferFoundPos = 0;
        String searchText = null;
        int[] resultStartPosition = new int[1];
        while (true) {
            if (searchText == null) {
                if (SearchDown) {
                    searchText = this.findChunk(currentBufferStart, chunkSize, true, resultStartPosition);
                    currentBufferStart = resultStartPosition[0];
                    currentBufferOffset = 0;
                } else {
                    int bufferEndPos = Math.min(currentBufferStart + TextToFind.length(), this.getLength());
                    searchText = this.findChunk(bufferEndPos, chunkSize, false, resultStartPosition);
                    currentBufferStart = resultStartPosition[0];
                    currentBufferOffset = searchText.length() - 1;
                }
                if (searchText.length() == 0) {
                    return -1;
                }
                if (!MatchCase) {
                    searchText = searchText.toUpperCase();
                }
            }
            if ((bufferFoundPos = SearchDown ? searchText.indexOf(TextToFind, currentBufferOffset) : searchText.lastIndexOf(TextToFind, currentBufferOffset)) < 0) {
                if (SearchDown) {
                    currentBufferStart += searchText.length();
                } else if ((currentBufferStart -= searchText.length()) < 0) {
                    return -1;
                }
                searchText = null;
                continue;
            }
            FoundPosition = currentBufferStart + bufferFoundPos;
            if (!(this.isInComment(FoundPosition) && SearchComments || !this.isInComment(FoundPosition) && SearchCode)) {
                if (SearchDown) {
                    currentBufferOffset = bufferFoundPos + 1;
                    continue;
                }
                currentBufferOffset = bufferFoundPos - 1;
                continue;
            }
            if (FoundPosition < 0) {
                return -1;
            }
            if (!MatchWord) {
                return FoundPosition;
            }
            if (bufferFoundPos > 0 || currentBufferStart != originalOffset) {
                boolean afterOkay;
                boolean beforeOkay = Character.isWhitespace(searchText.charAt(bufferFoundPos - 1));
                int afterPos = bufferFoundPos + TextToFind.length();
                boolean bl = afterOkay = afterPos >= searchText.length() || Character.isWhitespace(searchText.charAt(afterPos));
                if (beforeOkay && afterOkay) {
                    return FoundPosition;
                }
            } else if (this.VerifyMatchWord(TextToFind, FoundPosition)) {
                return FoundPosition;
            }
            if (SearchDown) {
                currentBufferOffset = bufferFoundPos + 1;
                continue;
            }
            currentBufferOffset = bufferFoundPos - 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void repositoryChanged() {
        Map map = this.mLineHash;
        synchronized (map) {
            this.mLogLineInfoCache.clear();
            this.mLineHash.clear();
            for (LongLineListener listener : this.mLongLineListeners) {
                listener.linesRemoved();
            }
        }
    }

    @Override
    public Element getDefaultRootElement() {
        return this.mRootElement;
    }

    @Override
    public Element getParagraphElement(int docOffset) {
        int elementIndex = this.mRootElement.getElementIndex(docOffset);
        if (elementIndex < 0) {
            return new VirtualLogElement(this, 0, 0, 0);
        }
        return this.mRootElement.getElement(elementIndex);
    }

    @Override
    public void remove(int offset, int length) throws BadLocationException {
    }

    @Override
    public void clear() {
        if (this.mRepository != null) {
            try {
                this.mRepository.clear();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.syntaxColorUpdate(0, 0);
    }

    @Override
    protected void resetLineTokenInfo() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element getLongestLineInCache(LogListView view) {
        Map map = this.mLineHash;
        synchronized (map) {
            try {
                VirtualLogElement longestElement = null;
                int longestWidth = -1;
                for (VirtualLogElement element : this.mLineHash.values()) {
                    int newWidth = element.getLineWidth();
                    if (newWidth < 0) {
                        newWidth = view.getLineWidth(element);
                        element.setLineWidth(newWidth);
                    }
                    if (newWidth <= longestWidth) continue;
                    longestWidth = newWidth;
                    longestElement = element;
                }
                return longestElement;
            }
            catch (ConcurrentModificationException e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    void addLongLineListener(LongLineListener listener) {
        this.mLongLineListeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeLineWidthCaching() {
        Map map = this.mLineHash;
        synchronized (map) {
            for (VirtualLogElement element : this.mLineHash.values()) {
                element.setLineWidth(-1);
            }
        }
    }

    @Override
    public boolean canCopyAmount(int numberOfChars) {
        if (numberOfChars > 1000000) {
            return false;
        }
        return super.canCopyAmount(numberOfChars);
    }

    public void setMaxLineLength(int maxLength) {
        if (maxLength > 0) {
            this.mMaxLineLength = maxLength;
        }
    }

    private class LogRootElement
    implements Element {
        private LogRootElement() {
        }

        @Override
        public int getElementCount() {
            return LogListDocument.this.mRepository.getLineCount();
        }

        @Override
        public int getEndOffset() {
            return LogListDocument.this.mRepository.getCharLength() + 1;
        }

        @Override
        public int getStartOffset() {
            return 0;
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        @Override
        public int getElementIndex(int docOffset) {
            return LogListDocument.this.mRepository.getLineForOffset(docOffset);
        }

        @Override
        public String getName() {
            return "";
        }

        @Override
        public AttributeSet getAttributes() {
            return null;
        }

        @Override
        public Document getDocument() {
            return LogListDocument.this;
        }

        @Override
        public Element getParentElement() {
            return null;
        }

        @Override
        public Element getElement(int arg0) {
            return LogListDocument.this.getElement(arg0);
        }
    }
}

