/*
 * Decompiled with CFR 0.152.
 */
package com.sas.editor;

import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

class KeyStrokeTextField
extends JTextField {
    @Override
    protected Document createDefaultModel() {
        return new ReadOnlyTextDocument();
    }

    @Override
    public void setText(String t) {
        try {
            ((ReadOnlyTextDocument)this.getDocument()).setProtectionMode(false);
            super.setText(t);
        }
        finally {
            ((ReadOnlyTextDocument)this.getDocument()).setProtectionMode(true);
        }
    }

    static class ReadOnlyTextDocument
    extends PlainDocument {
        private boolean mProtected = false;

        public void setProtectionMode(boolean on) {
            this.mProtected = on;
        }

        @Override
        public void remove(int offs, int len) throws BadLocationException {
            if (this.mProtected) {
                return;
            }
            super.remove(offs, len);
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (this.mProtected) {
                return;
            }
            super.insertString(offs, str, a);
        }
    }
}

