/*
 * Decompiled with CFR 0.152.
 */
package com.sas.editor;

import com.sas.editor.AttributeMap;
import com.sas.editor.CodeEditorAttributeManager;
import com.sas.editor.CodeEditorDefaults;
import com.sas.editor.CodeEditorResource;
import com.sas.editor.SasColor;
import com.sas.editor.UserInputDialog;
import com.sas.swing.visuals.util.Util;
import java.awt.Font;
import java.text.Collator;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JOptionPane;

public class CodeEditorSchemeManager {
    private String m_strDefault;
    private String m_strFusion;
    private String m_strRetro;
    private String m_strSwing;
    CodeEditorDefaults defaults;
    CodeEditorResource resource;
    CodeEditorAttributeManager attrManager;
    Collator coll = Collator.getInstance(Locale.getDefault());
    int numberOfSasUserSchemes = 0;
    int numberOfHtmlUserSchemes = 0;
    int numberOfJavaUserSchemes = 0;
    int numberOfLogUserSchemes = 0;
    int numberOfListUserSchemes = 0;
    Vector CurrentSchemeList = new Vector();
    Vector SasSchemeList = new Vector();
    Vector HtmlSchemeList = new Vector();
    Vector JavaSchemeList = new Vector();
    Vector LogSchemeList = new Vector();
    Vector ListSchemeList = new Vector();
    String[] SasBasicSchemes;
    String[] HtmlBasicSchemes;
    String[] JavaBasicSchemes;
    String[] LogBasicSchemes;
    String[] ListBasicSchemes;
    String m_WorkingSasScheme = "";
    String m_WorkingHtmlScheme = "";
    String m_WorkingJavaScheme = "";
    String m_WorkingLogScheme = "";
    String m_WorkingListScheme = "";
    public static final Font PREDEFINED_FONT = new Font("monospaced", 0, 12);

    public CodeEditorSchemeManager(CodeEditorAttributeManager manager) {
        this.resource = new CodeEditorResource(CodeEditorSchemeManager.class);
        this.InitializeStrings();
        this.attrManager = manager;
        this.defaults = this.attrManager.defaults;
        this.m_WorkingSasScheme = this.defaults.getPropertyString("CodeEditorSchemeManager.WorkingSasScheme.txt");
        this.m_WorkingHtmlScheme = this.defaults.getPropertyString("CodeEditorSchemeManager.WorkingHtmlScheme.txt");
        this.m_WorkingJavaScheme = this.defaults.getPropertyString("CodeEditorSchemeManager.WorkingJavaScheme.txt");
        this.m_WorkingLogScheme = this.defaults.getPropertyString("CodeEditorSchemeManager.WorkingLogScheme.txt");
        this.m_WorkingListScheme = this.defaults.getPropertyString("CodeEditorSchemeManager.WorkingListScheme.txt");
    }

    private void InitializeStrings() {
        this.m_strDefault = this.resource.getString("CodeEditorSchemeManager.Default.txt");
        this.m_strFusion = this.resource.getString("CodeEditorSchemeManager.Fusion.txt");
        this.m_strRetro = this.resource.getString("CodeEditorSchemeManager.Retro.txt");
        this.m_strSwing = this.resource.getString("CodeEditorSchemeManager.Swing.txt");
        String[] sasSchemes = new String[]{this.m_strDefault, this.m_strFusion, this.m_strRetro, this.m_strSwing};
        String[] htmlSchemes = new String[]{this.m_strDefault};
        String[] javaSchemes = new String[]{this.m_strDefault};
        String[] logSchemes = new String[]{this.m_strDefault};
        String[] listSchemes = new String[]{this.m_strDefault};
        this.SasBasicSchemes = sasSchemes;
        this.HtmlBasicSchemes = htmlSchemes;
        this.JavaBasicSchemes = javaSchemes;
        this.LogBasicSchemes = logSchemes;
        this.ListBasicSchemes = listSchemes;
    }

    public void setWorkingScheme(String scheme, int langID) {
        switch (langID) {
            case 2: {
                this.m_WorkingSasScheme = scheme;
                break;
            }
            case 3: {
                this.m_WorkingHtmlScheme = scheme;
                break;
            }
            case 4: {
                this.m_WorkingJavaScheme = scheme;
                break;
            }
            case 5: {
                this.m_WorkingLogScheme = scheme;
                break;
            }
            case 6: {
                this.m_WorkingListScheme = scheme;
            }
        }
    }

    public void saveWorkingSchemes() {
        this.defaults.setPropertyString("CodeEditorSchemeManager.WorkingSasScheme.txt", this.m_WorkingSasScheme);
        this.defaults.setPropertyString("CodeEditorSchemeManager.WorkingHtmlScheme.txt", this.m_WorkingHtmlScheme);
        this.defaults.setPropertyString("CodeEditorSchemeManager.WorkingJavaScheme.txt", this.m_WorkingJavaScheme);
        this.defaults.setPropertyString("CodeEditorSchemeManager.WorkingLogScheme.txt", this.m_WorkingLogScheme);
        this.defaults.setPropertyString("CodeEditorSchemeManager.WorkingListScheme.txt", this.m_WorkingListScheme);
    }

    public String getWorkingScheme(int langID) {
        switch (langID) {
            case 2: {
                return this.m_WorkingSasScheme;
            }
            case 3: {
                return this.m_WorkingHtmlScheme;
            }
            case 4: {
                return this.m_WorkingJavaScheme;
            }
            case 5: {
                return this.m_WorkingLogScheme;
            }
            case 6: {
                return this.m_WorkingListScheme;
            }
        }
        return null;
    }

    public Object[] getSchemeList(int langID) {
        int i;
        int numUserDefinedSchemes;
        String[] basicSchemes;
        Vector langSpecificSchemeList;
        String UserDefinedScheme = "";
        switch (langID) {
            case 2: {
                langSpecificSchemeList = this.SasSchemeList;
                this.SasSchemeList.clear();
                basicSchemes = this.SasBasicSchemes;
                this.numberOfSasUserSchemes = numUserDefinedSchemes = this.defaults.getPropertyInt("UserDefinedScheme.NumberOfSasSchemes.txt", 0);
                UserDefinedScheme = "UserDefinedScheme.Sas.";
                break;
            }
            case 3: {
                langSpecificSchemeList = this.HtmlSchemeList;
                this.HtmlSchemeList.clear();
                basicSchemes = this.HtmlBasicSchemes;
                this.numberOfHtmlUserSchemes = numUserDefinedSchemes = this.defaults.getPropertyInt("UserDefinedScheme.NumberOfHtmlSchemes.txt", 0);
                UserDefinedScheme = "UserDefinedScheme.Html.";
                break;
            }
            case 4: {
                langSpecificSchemeList = this.JavaSchemeList;
                this.JavaSchemeList.clear();
                basicSchemes = this.JavaBasicSchemes;
                this.numberOfJavaUserSchemes = numUserDefinedSchemes = this.defaults.getPropertyInt("UserDefinedScheme.NumberOfJavaSchemes.txt", 0);
                UserDefinedScheme = "UserDefinedScheme.Java.";
                break;
            }
            case 5: {
                langSpecificSchemeList = this.LogSchemeList;
                this.LogSchemeList.clear();
                basicSchemes = this.LogBasicSchemes;
                this.numberOfLogUserSchemes = numUserDefinedSchemes = this.defaults.getPropertyInt("UserDefinedScheme.NumberOfLogSchemes.txt", 0);
                UserDefinedScheme = "UserDefinedScheme.Log.";
                break;
            }
            case 6: {
                langSpecificSchemeList = this.ListSchemeList;
                this.ListSchemeList.clear();
                basicSchemes = this.ListBasicSchemes;
                this.numberOfListUserSchemes = numUserDefinedSchemes = this.defaults.getPropertyInt("UserDefinedScheme.NumberOfListSchemes.txt", 0);
                UserDefinedScheme = "UserDefinedScheme.List.";
                break;
            }
            default: {
                return null;
            }
        }
        this.CurrentSchemeList.clear();
        langSpecificSchemeList.clear();
        for (i = 0; i < basicSchemes.length; ++i) {
            this.CurrentSchemeList.add(basicSchemes[i]);
        }
        for (i = 1; i <= numUserDefinedSchemes; ++i) {
            this.CurrentSchemeList.add(this.defaults.getPropertyString(UserDefinedScheme + i + ".txt"));
            langSpecificSchemeList.add(this.defaults.getPropertyString(UserDefinedScheme + i + ".txt"));
        }
        return this.CurrentSchemeList.toArray();
    }

    public AttributeMap getScheme(String schemeName, int langID) {
        if (this.coll.compare(schemeName, "") == 0) {
            return null;
        }
        if (this.coll.compare(schemeName, this.m_strDefault) == 0) {
            switch (langID) {
                case 2: {
                    return this.getSasDefaultScheme();
                }
                case 3: {
                    return this.getHtmlDefaultScheme();
                }
                case 4: {
                    return this.getJavaDefaultScheme();
                }
                case 5: {
                    return this.getLogDefaultScheme();
                }
                case 6: {
                    return this.getListDefaultScheme();
                }
            }
        }
        if (this.coll.compare(schemeName, this.m_strFusion) == 0 && langID == 2) {
            return this.getSasFusionScheme();
        }
        if (this.coll.compare(schemeName, this.m_strRetro) == 0 && langID == 2) {
            return this.getSasRetroScheme();
        }
        if (this.coll.compare(schemeName, this.m_strSwing) == 0 && langID == 2) {
            return this.getSasSwingScheme();
        }
        return this.attrManager.getUserDefinedScheme(schemeName, langID);
    }

    protected AttributeMap getSasDefaultScheme() {
        AttributeMap attrMap = new AttributeMap();
        attrMap.addElementAttributes((short)4, SasColor.darkGreen, SasColor.white, false, false);
        attrMap.addElementAttributes((short)15, SasColor.black, SasColor.lightYellow, false, false);
        attrMap.addElementAttributes((short)12, SasColor.teal, SasColor.white, true, false);
        attrMap.addElementAttributes((short)10, SasColor.black, SasColor.white, false, false);
        attrMap.addElementAttributes((short)11, SasColor.black, SasColor.white, false, false);
        attrMap.addElementAttributes((short)13, SasColor.teal, SasColor.white, false, false);
        attrMap.addElementAttributes((short)8, SasColor.purple, SasColor.white, false, false);
        attrMap.addElementAttributes((short)3, SasColor.blue, SasColor.white, false, false);
        attrMap.addElementAttributes((short)17, SasColor.black, SasColor.white, true, true);
        attrMap.addElementAttributes((short)6, SasColor.blue, SasColor.white, false, false);
        attrMap.addElementAttributes((short)18, SasColor.black, SasColor.white, true, true);
        attrMap.addElementAttributes((short)20, SasColor.navy, SasColor.white, true, false);
        attrMap.addElementAttributes((short)21, SasColor.black, SasColor.white, false, false);
        attrMap.addElementAttributes((short)1, SasColor.black, SasColor.white, false, false);
        attrMap.addElementAttributes((short)7, SasColor.teal, SasColor.white, true, false);
        attrMap.addElementAttributes((short)16, SasColor.navy, SasColor.offWhite, true, false);
        attrMap.addElementAttributes((short)9, SasColor.navy, SasColor.white, true, false);
        attrMap.addElementAttributes((short)2, SasColor.green, SasColor.white, false, false);
        attrMap.addElementAttributes((short)22, SasColor.green, SasColor.white, false, false);
        attrMap.addElementAttributes((short)5, SasColor.purple, SasColor.white, false, true);
        attrMap.addElementAttributes((short)19, SasColor.red, SasColor.white, false, false);
        attrMap.addElementAttributes((short)14, SasColor.red, SasColor.white, false, true);
        attrMap.addElementAttributes((short)23, SasColor.blue, SasColor.white, false, false);
        attrMap.addFontAttributes(PREDEFINED_FONT);
        return attrMap;
    }

    protected AttributeMap getHtmlDefaultScheme() {
        AttributeMap attrMap = new AttributeMap();
        attrMap.addElementAttributes((short)25, SasColor.green, SasColor.white, false, false);
        attrMap.addElementAttributes((short)26, SasColor.red, SasColor.white, false, false);
        attrMap.addElementAttributes((short)27, SasColor.blue, SasColor.white, false, false);
        attrMap.addElementAttributes((short)28, SasColor.purple, SasColor.white, false, false);
        attrMap.addElementAttributes((short)29, SasColor.black, SasColor.white, false, false);
        attrMap.addElementAttributes((short)30, SasColor.black, SasColor.white, false, false);
        attrMap.addElementAttributes((short)31, SasColor.purple, SasColor.white, false, false);
        attrMap.addElementAttributes((short)32, SasColor.cyan, SasColor.white, false, false);
        attrMap.addFontAttributes(PREDEFINED_FONT);
        return attrMap;
    }

    protected AttributeMap getJavaDefaultScheme() {
        AttributeMap attrMap = new AttributeMap();
        attrMap.addElementAttributes((short)2, SasColor.black, SasColor.white, false, false);
        attrMap.addElementAttributes((short)3, SasColor.burgandy, SasColor.white, false, false);
        attrMap.addElementAttributes((short)4, SasColor.green, SasColor.white, false, false);
        attrMap.addElementAttributes((short)5, SasColor.burgandy, SasColor.white, false, false);
        attrMap.addElementAttributes((short)6, SasColor.purple, SasColor.white, false, false);
        attrMap.addElementAttributes((short)7, SasColor.cyan, SasColor.white, false, false);
        attrMap.addElementAttributes((short)8, SasColor.blue, SasColor.white, false, false);
        attrMap.addElementAttributes((short)9, SasColor.burgandy, SasColor.white, false, false);
        attrMap.addFontAttributes(PREDEFINED_FONT);
        return attrMap;
    }

    protected AttributeMap getLogDefaultScheme() {
        AttributeMap attrMap = new AttributeMap();
        attrMap.addElementAttributes((short)9, SasColor.blue, SasColor.white, false, false);
        attrMap.addElementAttributes((short)8, SasColor.darkGreen, SasColor.white, false, false);
        attrMap.addElementAttributes((short)7, SasColor.red, SasColor.white, false, false);
        attrMap.addElementAttributes((short)6, SasColor.black, SasColor.white, false, false);
        attrMap.addElementAttributes((short)10, SasColor.black, SasColor.white, false, false);
        attrMap.addElementAttributes((short)5, SasColor.blue, SasColor.white, false, false);
        attrMap.addFontAttributes(PREDEFINED_FONT);
        return attrMap;
    }

    protected AttributeMap getListDefaultScheme() {
        AttributeMap attrMap = new AttributeMap();
        attrMap.addElementAttributes((short)5, SasColor.blue, SasColor.white, false, false);
        attrMap.addElementAttributes((short)1, SasColor.black, SasColor.white, false, false);
        attrMap.addElementAttributes((short)2, SasColor.blue, SasColor.white, false, false);
        attrMap.addElementAttributes((short)3, SasColor.black, SasColor.white, false, false);
        attrMap.addElementAttributes((short)4, SasColor.teal, SasColor.white, false, false);
        attrMap.addFontAttributes(PREDEFINED_FONT);
        return attrMap;
    }

    protected AttributeMap getSasFusionScheme() {
        AttributeMap attrMap = new AttributeMap();
        attrMap.addElementAttributes((short)4, SasColor.teal, SasColor.white, false, false);
        attrMap.addElementAttributes((short)15, SasColor.gray, SasColor.white, false, false);
        attrMap.addElementAttributes((short)12, SasColor.teal, SasColor.yellow, false, false);
        attrMap.addElementAttributes((short)10, SasColor.black, SasColor.white, false, false);
        attrMap.addElementAttributes((short)11, SasColor.black, SasColor.white, false, false);
        attrMap.addElementAttributes((short)13, SasColor.black, SasColor.white, false, false);
        attrMap.addElementAttributes((short)8, SasColor.magenta, SasColor.white, false, false);
        attrMap.addElementAttributes((short)3, SasColor.blue, SasColor.white, false, false);
        attrMap.addElementAttributes((short)17, SasColor.green, SasColor.white, false, false);
        attrMap.addElementAttributes((short)6, SasColor.magenta, SasColor.white, false, false);
        attrMap.addElementAttributes((short)18, SasColor.navy, SasColor.white, false, false);
        attrMap.addElementAttributes((short)20, SasColor.purple, SasColor.white, false, false);
        attrMap.addElementAttributes((short)21, SasColor.gray, SasColor.white, false, false);
        attrMap.addElementAttributes((short)1, SasColor.black, SasColor.white, false, false);
        attrMap.addElementAttributes((short)7, SasColor.green, SasColor.white, false, false);
        attrMap.addElementAttributes((short)16, SasColor.purple, SasColor.white, true, false);
        attrMap.addElementAttributes((short)9, SasColor.purple, SasColor.white, false, false);
        attrMap.addElementAttributes((short)2, SasColor.green, SasColor.white, false, false);
        attrMap.addElementAttributes((short)22, SasColor.green, SasColor.white, false, false);
        attrMap.addElementAttributes((short)5, SasColor.red, SasColor.white, false, false);
        attrMap.addElementAttributes((short)19, SasColor.black, SasColor.white, false, false);
        attrMap.addElementAttributes((short)14, SasColor.red, SasColor.white, false, false);
        attrMap.addElementAttributes((short)23, SasColor.blue, SasColor.white, false, false);
        attrMap.addFontAttributes(PREDEFINED_FONT);
        return attrMap;
    }

    protected AttributeMap getSasRetroScheme() {
        AttributeMap attrMap = new AttributeMap();
        attrMap.addElementAttributes((short)4, SasColor.burgandy, SasColor.white, false, false);
        attrMap.addElementAttributes((short)15, SasColor.navy, SasColor.white, false, false);
        attrMap.addElementAttributes((short)12, SasColor.purple, SasColor.white, false, false);
        attrMap.addElementAttributes((short)10, SasColor.black, SasColor.white, false, false);
        attrMap.addElementAttributes((short)11, SasColor.black, SasColor.white, false, false);
        attrMap.addElementAttributes((short)13, SasColor.black, SasColor.white, false, false);
        attrMap.addElementAttributes((short)8, SasColor.green, SasColor.white, false, false);
        attrMap.addElementAttributes((short)3, SasColor.burgandy, SasColor.white, false, false);
        attrMap.addElementAttributes((short)17, SasColor.teal, SasColor.white, false, false);
        attrMap.addElementAttributes((short)6, SasColor.blue, SasColor.white, true, false);
        attrMap.addElementAttributes((short)18, SasColor.teal, SasColor.white, false, false);
        attrMap.addElementAttributes((short)20, SasColor.purple, SasColor.white, true, false);
        attrMap.addElementAttributes((short)21, SasColor.navy, SasColor.white, false, false);
        attrMap.addElementAttributes((short)1, SasColor.black, SasColor.white, false, false);
        attrMap.addElementAttributes((short)7, SasColor.burgandy, SasColor.white, false, false);
        attrMap.addElementAttributes((short)16, SasColor.purple, SasColor.white, true, false);
        attrMap.addElementAttributes((short)9, SasColor.purple, SasColor.white, true, false);
        attrMap.addElementAttributes((short)2, SasColor.black, SasColor.white, false, false);
        attrMap.addElementAttributes((short)22, SasColor.black, SasColor.white, false, false);
        attrMap.addElementAttributes((short)5, SasColor.purple, SasColor.white, false, false);
        attrMap.addElementAttributes((short)19, SasColor.red, SasColor.white, false, false);
        attrMap.addElementAttributes((short)14, SasColor.white, SasColor.red, false, false);
        attrMap.addElementAttributes((short)23, SasColor.burgandy, SasColor.white, false, false);
        attrMap.addFontAttributes(PREDEFINED_FONT);
        return attrMap;
    }

    protected AttributeMap getSasSwingScheme() {
        AttributeMap attrMap = new AttributeMap();
        attrMap.addElementAttributes((short)4, SasColor.teal, SasColor.white, false, false);
        attrMap.addElementAttributes((short)15, SasColor.black, SasColor.white, false, false);
        attrMap.addElementAttributes((short)12, SasColor.blue, SasColor.white, false, false);
        attrMap.addElementAttributes((short)10, SasColor.black, SasColor.white, false, false);
        attrMap.addElementAttributes((short)11, SasColor.black, SasColor.white, false, false);
        attrMap.addElementAttributes((short)13, SasColor.blue, SasColor.white, false, false);
        attrMap.addElementAttributes((short)8, SasColor.blue, SasColor.white, false, false);
        attrMap.addElementAttributes((short)3, SasColor.purple, SasColor.white, false, false);
        attrMap.addElementAttributes((short)17, SasColor.black, SasColor.white, true, true);
        attrMap.addElementAttributes((short)6, SasColor.navy, SasColor.white, true, false);
        attrMap.addElementAttributes((short)18, SasColor.black, SasColor.white, true, true);
        attrMap.addElementAttributes((short)20, SasColor.black, SasColor.lightGray, false, false);
        attrMap.addElementAttributes((short)21, SasColor.black, SasColor.white, false, false);
        attrMap.addElementAttributes((short)1, SasColor.black, SasColor.white, false, false);
        attrMap.addElementAttributes((short)7, SasColor.blue, SasColor.white, false, false);
        attrMap.addElementAttributes((short)16, SasColor.blue, SasColor.white, false, false);
        attrMap.addElementAttributes((short)9, SasColor.navy, SasColor.white, true, false);
        attrMap.addElementAttributes((short)2, SasColor.black, SasColor.white, false, false);
        attrMap.addElementAttributes((short)22, SasColor.black, SasColor.white, false, false);
        attrMap.addElementAttributes((short)5, SasColor.blue, SasColor.white, false, false);
        attrMap.addElementAttributes((short)19, SasColor.red, SasColor.white, false, false);
        attrMap.addElementAttributes((short)14, SasColor.red, SasColor.white, false, true);
        attrMap.addElementAttributes((short)23, SasColor.purple, SasColor.white, false, false);
        attrMap.addFontAttributes(PREDEFINED_FONT);
        return attrMap;
    }

    public String saveUserDefinedScheme(AttributeMap map, int langID, boolean saveAttrs) {
        String name = this.promptUserForName(langID);
        if (name == null || name.compareTo("") == 0) {
            return null;
        }
        switch (langID) {
            case 2: {
                ++this.numberOfSasUserSchemes;
                this.saveSchemeSettings(langID, false);
                this.attrManager.saveScheme(map, "Sas." + name, langID, false);
                break;
            }
            case 3: {
                ++this.numberOfHtmlUserSchemes;
                this.saveSchemeSettings(langID, false);
                this.attrManager.saveScheme(map, "Html." + name, langID, false);
                break;
            }
            case 4: {
                ++this.numberOfJavaUserSchemes;
                this.saveSchemeSettings(langID, false);
                this.attrManager.saveScheme(map, "Java." + name, langID, false);
                break;
            }
            case 5: {
                ++this.numberOfLogUserSchemes;
                this.saveSchemeSettings(langID, false);
                this.attrManager.saveScheme(map, "Log." + name, langID, false);
                break;
            }
            case 6: {
                ++this.numberOfListUserSchemes;
                this.saveSchemeSettings(langID, false);
                this.attrManager.saveScheme(map, "List." + name, langID, false);
            }
        }
        this.setWorkingScheme(name, langID);
        if (saveAttrs) {
            this.defaults.saveProperties();
        }
        return name;
    }

    public void saveSchemeSettings(int langID, boolean saveAttrs) {
        Vector schemeList;
        String strNumberOfSchemes = "";
        String strUserDefinedScheme = "";
        int numSchemes = 0;
        switch (langID) {
            case 2: {
                strNumberOfSchemes = "UserDefinedScheme.NumberOfSasSchemes.txt";
                strUserDefinedScheme = "UserDefinedScheme.Sas.";
                numSchemes = this.numberOfSasUserSchemes;
                schemeList = this.SasSchemeList;
                break;
            }
            case 3: {
                strNumberOfSchemes = "UserDefinedScheme.NumberOfHtmlSchemes.txt";
                strUserDefinedScheme = "UserDefinedScheme.Html.";
                numSchemes = this.numberOfHtmlUserSchemes;
                schemeList = this.HtmlSchemeList;
                break;
            }
            case 4: {
                strNumberOfSchemes = "UserDefinedScheme.NumberOfJavaSchemes.txt";
                strUserDefinedScheme = "UserDefinedScheme.Java.";
                numSchemes = this.numberOfJavaUserSchemes;
                schemeList = this.JavaSchemeList;
                break;
            }
            case 5: {
                strNumberOfSchemes = "UserDefinedScheme.NumberOfLogSchemes.txt";
                strUserDefinedScheme = "UserDefinedScheme.Log.";
                numSchemes = this.numberOfLogUserSchemes;
                schemeList = this.LogSchemeList;
                break;
            }
            case 6: {
                strNumberOfSchemes = "UserDefinedScheme.NumberOfListSchemes.txt";
                strUserDefinedScheme = "UserDefinedScheme.List.";
                numSchemes = this.numberOfListUserSchemes;
                schemeList = this.ListSchemeList;
                break;
            }
            default: {
                return;
            }
        }
        this.defaults.setPropertyInt(strNumberOfSchemes, numSchemes);
        for (int i = 0; i < schemeList.size(); ++i) {
            this.defaults.setPropertyString(strUserDefinedScheme + (i + 1) + ".txt", (String)schemeList.get(i));
        }
        if (saveAttrs) {
            this.defaults.saveProperties();
        }
    }

    public String promptUserForName(int lang) {
        String dlgTitle = this.resource.getString("CodeEditorSchemeManager.DialogTitle.txt");
        String msgExists = this.resource.getString("CodeEditorSchemeManager.SchemeExists.txt");
        String msgIllegal = this.resource.getString("CodeEditorSchemeManager.NoReplace.txt");
        String uidItem = this.resource.getString("CodeEditorSchemeManager.SaveSchemeAs.txt");
        String uidText = Util.getLabelWithoutMnemonic((String)uidItem);
        UserInputDialog uid = new UserInputDialog(null, dlgTitle, uidText);
        int index = Util.getDisplayedMnemonicIndex((String)uidItem);
        if (index > -1) {
            uid.setMnemonic(uidText.charAt(index));
        }
        String name = uid.prompt();
        int replace = 0;
        if (name == null || name.compareTo("") == 0) {
            return null;
        }
        if (this.isSchemePredefined(name, lang)) {
            JOptionPane.showMessageDialog(null, msgIllegal, dlgTitle, 1);
            return this.promptUserForName(lang);
        }
        if (this.doesSchemeExist(name)) {
            replace = JOptionPane.showConfirmDialog(null, msgExists, dlgTitle, 0);
            if (replace == 0) {
                switch (lang) {
                    case 2: {
                        --this.numberOfSasUserSchemes;
                        break;
                    }
                    case 3: {
                        --this.numberOfHtmlUserSchemes;
                        break;
                    }
                    case 4: {
                        --this.numberOfJavaUserSchemes;
                        break;
                    }
                    case 5: {
                        --this.numberOfLogUserSchemes;
                        break;
                    }
                    case 6: {
                        --this.numberOfListUserSchemes;
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                return name;
            }
            if (replace == 1) {
                return this.promptUserForName(lang);
            }
        }
        switch (lang) {
            case 2: {
                this.SasSchemeList.add(name);
                break;
            }
            case 3: {
                this.HtmlSchemeList.add(name);
                break;
            }
            case 4: {
                this.JavaSchemeList.add(name);
                break;
            }
            case 5: {
                this.LogSchemeList.add(name);
                break;
            }
            case 6: {
                this.ListSchemeList.add(name);
                break;
            }
            default: {
                return null;
            }
        }
        this.CurrentSchemeList.add(name);
        return name;
    }

    public boolean doesSchemeExist(String name) {
        for (int i = 0; i < this.CurrentSchemeList.size(); ++i) {
            if (this.coll.compare(name, (String)this.CurrentSchemeList.get(i)) != 0) continue;
            return true;
        }
        return false;
    }

    public boolean isSchemePredefined(String name, int lang) {
        if (name == null) {
            return true;
        }
        String[] invalid = null;
        switch (lang) {
            case 2: {
                invalid = this.SasBasicSchemes;
                break;
            }
            case 3: {
                invalid = this.HtmlBasicSchemes;
                break;
            }
            case 4: {
                invalid = this.JavaBasicSchemes;
                break;
            }
            case 5: {
                invalid = this.LogBasicSchemes;
                break;
            }
            case 6: {
                invalid = this.ListBasicSchemes;
            }
        }
        for (int i = 0; i < invalid.length; ++i) {
            if (this.coll.compare(name, invalid[i]) != 0) continue;
            return true;
        }
        return false;
    }

    public void deleteScheme(String name, int langID) {
        int numSchemes;
        Vector schemeList;
        String dlgTitle = this.resource.getString("CodeEditorSchemeManager.DialogTitle.txt");
        String msgNoDelete = this.resource.getString("CodeEditorSchemeManager.NoDelete.txt");
        String UserDefinedScheme = "";
        if (this.isSchemePredefined(name, langID)) {
            JOptionPane.showMessageDialog(null, msgNoDelete, dlgTitle, 1);
            return;
        }
        switch (langID) {
            case 2: {
                schemeList = this.SasSchemeList;
                UserDefinedScheme = "UserDefinedScheme.Sas.";
                numSchemes = this.numberOfSasUserSchemes;
                break;
            }
            case 3: {
                schemeList = this.HtmlSchemeList;
                UserDefinedScheme = "UserDefinedScheme.Html.";
                numSchemes = this.numberOfHtmlUserSchemes;
                break;
            }
            case 4: {
                schemeList = this.JavaSchemeList;
                UserDefinedScheme = "UserDefinedScheme.Java.";
                numSchemes = this.numberOfJavaUserSchemes;
                break;
            }
            case 5: {
                schemeList = this.LogSchemeList;
                UserDefinedScheme = "UserDefinedScheme.Log.";
                numSchemes = this.numberOfLogUserSchemes;
                break;
            }
            case 6: {
                schemeList = this.ListSchemeList;
                UserDefinedScheme = "UserDefinedScheme.List.";
                numSchemes = this.numberOfListUserSchemes;
                break;
            }
            default: {
                return;
            }
        }
        for (int i = 0; i < schemeList.size(); ++i) {
            if (this.coll.compare(name, (String)schemeList.get(i)) != 0) continue;
            schemeList.removeElementAt(i);
        }
        this.attrManager.removeScheme(name, langID, false);
        this.defaults.removePropertyString(UserDefinedScheme + numSchemes + ".txt");
        switch (langID) {
            case 2: {
                --this.numberOfSasUserSchemes;
                break;
            }
            case 3: {
                --this.numberOfHtmlUserSchemes;
                break;
            }
            case 4: {
                --this.numberOfJavaUserSchemes;
                break;
            }
            case 5: {
                --this.numberOfLogUserSchemes;
                break;
            }
            case 6: {
                --this.numberOfListUserSchemes;
            }
        }
        this.saveSchemeSettings(langID, false);
        this.setWorkingScheme(this.m_strDefault, langID);
        this.defaults.saveProperties();
    }
}

