/*
 * Decompiled with CFR 0.152.
 */
package com.sas.editor;

import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.StringCharacterIterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class CodeEditorResource {
    protected ResourceBundle m_bundle;

    public CodeEditorResource(Class source) {
        String strClassName = source.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        this.m_bundle = this.getBundle(strPackageName + ".PropertyBundle", Locale.getDefault());
    }

    public CodeEditorResource(String resourceFileName) {
        this.m_bundle = this.getBundle(resourceFileName, Locale.getDefault());
    }

    public CodeEditorResource(Class source, Locale locale) {
        String strClassName = source.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        this.m_bundle = this.getBundle(strPackageName + ".PropertyBundle", locale);
    }

    public ResourceBundle getBundle(String baseName, Locale locale) {
        return PropertyResourceBundle.getBundle(baseName, locale);
    }

    public char getChar(String key) {
        String sValue = this.getString(key);
        StringCharacterIterator sci = new StringCharacterIterator(sValue);
        return sci.first();
    }

    public int getInteger(String key) {
        String strTemp = this.getString(key);
        int ret_val = 0;
        try {
            NumberFormat nf = NumberFormat.getInstance(Locale.getDefault());
            Number n = nf.parse(strTemp);
            ret_val = n.intValue();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return ret_val;
    }

    public String getString(String key) {
        String value;
        try {
            value = this.m_bundle.getString(key);
        }
        catch (MissingResourceException ex) {
            value = null;
        }
        return value;
    }

    public String getMessageString(String key, Object param1) {
        String pattern = this.getString(key);
        Object[] args = new Object[]{param1.toString()};
        return MessageFormat.format(pattern, args);
    }

    public String messageString(String key, Object param1, Object param2) {
        String pattern = this.getString(key);
        Object[] args = new Object[]{param1.toString(), param2.toString()};
        return MessageFormat.format(pattern, args);
    }
}

