/*
 * Decompiled with CFR 0.152.
 */
package com.sas.editor;

import com.sas.editor.CodeEditor;
import com.sas.editor.CodeEditorAppearancePane;
import com.sas.editor.TokenInfo;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.NumberFormat;
import java.text.StringCharacterIterator;
import java.util.Locale;

public class CodeEditorPreview
extends CodeEditor {
    protected CodeEditorAppearancePane m_AppPane;

    public CodeEditorPreview(CodeEditorAppearancePane appPane) {
        super(appPane.getWorkingDefaults());
        this.m_AppPane = appPane;
        this.getPopupMenu().setEnabled(false);
        this.m_EditPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                block5: {
                    block4: {
                        if (e.getID() == 500) break block4;
                        if (e.getID() == 501) break block4;
                        if (e.getID() != 502) break block5;
                    }
                    if (e.getModifiers() == 16) {
                        CodeEditorPreview.this.setSelectedElement();
                    }
                }
            }
        });
        this.m_EditPane.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                block3: {
                    block2: {
                        if (e.getKeyCode() == 37) break block2;
                        if (e.getKeyCode() == 39) break block2;
                        if (e.getKeyCode() == 38) break block2;
                        if (e.getKeyCode() != 40) break block3;
                    }
                    CodeEditorPreview.this.setSelectedElement();
                }
            }
        });
    }

    @Override
    public void cleanup() {
        super.cleanup();
    }

    public CodeEditorAppearancePane getAppPane() {
        return this.m_AppPane;
    }

    protected void setSelectedElement() {
        int pos = this.m_EditPane.getCaretPosition();
        char cc = ' ';
        try {
            StringCharacterIterator sci = new StringCharacterIterator(this.m_EditPane.getText(pos, 1));
            cc = sci.setIndex(0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (Character.isWhitespace(cc)) {
            return;
        }
        TokenInfo ti = this.m_EditPane.getCodeEditorDocument().getTokenInfo(pos);
        short type = ti.getTokenType();
        this.getAppPane().setClickedElement(type);
    }

    void setDisplayText(int langID) {
        String strNumLines = "";
        String strSampleCode = "";
        switch (langID) {
            case 2: {
                strNumLines = "CodeEditorPreviewPane.NumberOfSasLines.txt";
                strSampleCode = "CodeEditorPreviewPane.SampleSasCode.";
                break;
            }
            case 3: {
                strNumLines = "CodeEditorPreviewPane.NumberOfHtmlLines.txt";
                strSampleCode = "CodeEditorPreviewPane.SampleHtmlCode.";
                break;
            }
            case 4: {
                strNumLines = "CodeEditorPreviewPane.NumberOfJavaLines.txt";
                strSampleCode = "CodeEditorPreviewPane.SampleJavaCode.";
                break;
            }
            default: {
                return;
            }
        }
        StringBuffer sb = new StringBuffer();
        int num = 0;
        String res = this.m_EditPane.resource.getString(strNumLines);
        try {
            NumberFormat nf = NumberFormat.getInstance(Locale.getDefault());
            Number n = nf.parse(res);
            num = n.intValue();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        for (int i = 1; i <= num; ++i) {
            sb.append(this.m_EditPane.resource.getString(strSampleCode + i + ".txt"));
        }
        this.setText(sb.toString());
        this.m_EditPane.setSelectionStart(0);
        this.m_EditPane.setSelectionEnd(0);
    }
}

