/*
 * Decompiled with CFR 0.152.
 */
package com.sas.editor;

import com.sas.editor.AssignEditorKeysDialog;
import com.sas.editor.CodeEditor;
import com.sas.editor.CodeEditorDefaults;
import com.sas.editor.CodeEditorKeyManager;
import com.sas.editor.CodeEditorPane;
import com.sas.editor.CodeEditorResource;
import com.sas.editor.CommandWrapper;
import com.sas.swing.util.SASJavaHelp;
import com.sas.swing.visuals.WideComboBox;
import com.sas.swing.visuals.util.Util;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Color;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;

public class CodeEditorKeysPane
extends JPanel {
    CodeEditorResource resource = new CodeEditorResource(CodeEditorKeysPane.class);
    CodeEditorDefaults defaults;
    Collator coll = Collator.getInstance(Locale.getDefault());
    CodeEditorKeyManager keyManager;
    CodeEditorPane m_EditorPane;
    private CodeEditor m_Editor = null;
    JDialog dlgParent = null;
    DefaultTableModel dtm = null;
    JTable table = null;
    JLabel CategoryLabel = new JLabel();
    JComboBox CategoryCombo = new WideComboBox();
    JLabel CommandsLabel = new JLabel();
    JScrollPane TableScrollPane = null;
    JCheckBox ShowAllCheckbox = new JCheckBox();
    JLabel DescriptionLabel = new JLabel();
    JTextArea DescriptionText = new JTextArea(){

        @Override
        public boolean isFocusTraversable() {
            return false;
        }
    };
    JButton CloseButton = new JButton();
    JButton AssignButton = new JButton();
    JButton ResetButton = new JButton();
    JButton HelpButton = new JButton();
    BoxLayout boxLayout = new BoxLayout(this, 1);

    public CodeEditorKeysPane(JDialog jd, CodeEditorPane editorPane) {
        this.dlgParent = jd;
        this.m_EditorPane = editorPane;
        this.keyManager = editorPane.getKeyManager();
        this.defaults = this.keyManager.defaults;
        this.keyManager.InitializeData();
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public CodeEditorKeysPane(JDialog jd, CodeEditorDefaults defs) {
        this.m_Editor = new CodeEditor(defs);
        this.dlgParent = jd;
        this.m_EditorPane = this.m_Editor.getEditorPane();
        this.keyManager = this.m_EditorPane.getKeyManager();
        this.defaults = defs;
        this.keyManager.InitializeData();
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.keyManager.PopulateCategoryComboBox(this.CategoryCombo);
        this.initializeTable();
        this.setupMnemonics(this.CategoryLabel, "CodeEditorKeyManager.CategoryLabel.txt");
        this.setupMnemonics(this.CommandsLabel, "CodeEditorKeyManager.CommandsLabel.txt");
        String ShowAllCheckboxItem = this.resource.getString("CodeEditorKeyManager.ShowAllCommandsLabel.txt");
        String ShowAllCheckboxText = Util.getLabelWithoutMnemonic((String)ShowAllCheckboxItem);
        this.ShowAllCheckbox.setText(ShowAllCheckboxText);
        int index = Util.getDisplayedMnemonicIndex((String)ShowAllCheckboxItem);
        if (index > -1) {
            int mnemonic = Util.getDisplayedMnemonic((String)ShowAllCheckboxItem);
            this.ShowAllCheckbox.setMnemonic(mnemonic);
            this.ShowAllCheckbox.setDisplayedMnemonicIndex(index);
        }
        this.DescriptionLabel.setText(this.resource.getString("CodeEditorKeyManager.DescriptionLabel.txt"));
        this.setupMnemonics(this.CloseButton, "Common.Close.txt");
        this.setupMnemonics(this.AssignButton, "CodeEditorKeyManager.AssignKeysButtonLabel.txt");
        this.setupMnemonics(this.ResetButton, "CodeEditorKeyManager.ResetAllButtonLabel.txt");
        this.setupMnemonics(this.HelpButton, "Common.Help.txt");
        this.ShowAllCheckbox.setSelected(this.defaults.getPropertyBoolean("CodeEditorKeyManager.ShowAllCommands.txt", false));
        this.CategoryCombo.setSelectedIndex(this.defaults.getPropertyInt("CodeEditorKeyManager.LastUsedCategory.txt", 0));
        this.TableScrollPane.getViewport().setBackground(Color.white);
        this.DescriptionText.setBorder(BorderFactory.createEtchedBorder());
        this.DescriptionText.setBackground(UIManager.getColor("control"));
        this.DescriptionText.setEditable(false);
        this.DescriptionText.setLineWrap(true);
        this.DescriptionText.setWrapStyleWord(true);
        this.CategoryLabel.setLabelFor(this.CategoryCombo);
        this.CommandsLabel.setLabelFor(this.table);
        EmptyBorder spaceBorder = new EmptyBorder(10, 10, 10, 10);
        this.setBorder(spaceBorder);
        AutoSizingGridLayout mainLayout = new AutoSizingGridLayout(5, 2, 10, 2, true, true, true);
        mainLayout.setRemainderColumn(1);
        mainLayout.setRemainderRow(4);
        this.setLayout((LayoutManager)mainLayout);
        this.add(this.CategoryLabel);
        this.add(new JLabel());
        this.add(this.CategoryCombo);
        this.add(this.CloseButton);
        this.add(this.CommandsLabel);
        this.add(new JLabel());
        JPanel listPanel = new JPanel();
        AutoSizingGridLayout listLayout = new AutoSizingGridLayout(2, 1, 0, 10, true, true, true);
        listLayout.setRemainderRow(1);
        listLayout.setRemainderColumn(1);
        listPanel.setLayout((LayoutManager)listLayout);
        listPanel.add(this.TableScrollPane);
        listPanel.add(this.ShowAllCheckbox);
        JPanel listButtonPanel = new JPanel();
        AutoSizingGridLayout buttonLayout = new AutoSizingGridLayout(3, 1, 0, 5);
        buttonLayout.setFillCell(true);
        listButtonPanel.setLayout((LayoutManager)buttonLayout);
        listButtonPanel.add(this.AssignButton);
        listButtonPanel.add(this.ResetButton);
        listButtonPanel.add(this.HelpButton);
        this.add(listPanel);
        this.add(listButtonPanel);
        JPanel descriptionPanel = new JPanel();
        AutoSizingGridLayout descriptionLayout = new AutoSizingGridLayout(2, 1, 0, 2, true, true, true);
        descriptionLayout.setRemainderRow(2);
        descriptionPanel.setLayout((LayoutManager)descriptionLayout);
        descriptionPanel.add(this.DescriptionLabel);
        descriptionPanel.add(this.DescriptionText);
        this.add(descriptionPanel);
        this.populateTable();
        this.CloseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodeEditorKeysPane.this.onClose();
            }
        });
        this.AssignButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodeEditorKeysPane.this.onAssign();
            }
        });
        this.ResetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodeEditorKeysPane.this.onReset();
            }
        });
        this.HelpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodeEditorKeysPane.this.onHelp();
            }
        });
        this.CategoryCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodeEditorKeysPane.this.populateTable();
            }
        });
        this.ShowAllCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodeEditorKeysPane.this.populateTable();
            }
        });
        this.table.addKeyListener(new KeyListener(){

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 9) {
                    if (e.isShiftDown()) {
                        CodeEditorKeysPane.this.CategoryCombo.requestFocus();
                    } else {
                        CodeEditorKeysPane.this.ShowAllCheckbox.requestFocus();
                    }
                    e.setKeyCode(37);
                }
                if (e.getKeyCode() == 39) {
                    e.setKeyCode(37);
                }
            }
        });
    }

    public void initializeTable() {
        this.dtm = new DefaultTableModel();
        this.dtm.addColumn(this.resource.getString("CodeEditorKeysPane.NameColumn.Title.txt"));
        this.dtm.addColumn(this.resource.getString("CodeEditorKeysPane.KeysColumn.Title.txt"));
        this.table = new JTable(this.dtm);
        this.table.setSelectionMode(0);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                CodeEditorKeysPane.this.onTableClick();
            }
        });
        this.TableScrollPane = new JScrollPane(this.table);
    }

    public void populateTable() {
        for (int i = this.dtm.getRowCount(); i > 0; --i) {
            this.dtm.removeRow(i - 1);
        }
        String selectedType = (String)this.CategoryCombo.getSelectedItem();
        boolean allTypes = this.coll.compare(selectedType, this.resource.getString("CodeEditorKeyManager.CategoryComboItem.0.txt")) == 0;
        CodeEditorKeyManager.KeyInfoItem[] allItems = this.keyManager.getCommandItems();
        ArrayList<Object[]> allTableItems = new ArrayList<Object[]>();
        for (int i = 0; i < allItems.length; ++i) {
            Object[] row;
            CodeEditorKeyManager.KeyInfoItem infoItem = allItems[i];
            String groupName = infoItem.getGroup();
            if (groupName.length() <= 0 || !allTypes && this.coll.compare(selectedType, groupName) != 0 || this.coll.compare((row = new Object[]{new CommandWrapper(infoItem), infoItem.getKeystrokeString()})[1], (Object)"") == 0 && !this.ShowAllCheckbox.isSelected()) continue;
            allTableItems.add(row);
        }
        Collections.sort(allTableItems, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                Object[] row0 = (Object[])arg0;
                Object[] row1 = (Object[])arg1;
                CommandWrapper c0 = (CommandWrapper)row0[0];
                CommandWrapper c1 = (CommandWrapper)row1[0];
                return c0.getCommandInfo().getTranslatedName().compareTo(c1.getCommandInfo().getTranslatedName());
            }
        });
        for (Object[] row : allTableItems) {
            this.dtm.addRow(row);
        }
        this.table.setSelectionBackground(Color.white);
        this.table.setSelectionForeground(Color.black);
        this.table.setBackground(UIManager.getColor("control"));
        this.table.setForeground(Color.black);
        if (this.table.getRowCount() > 0) {
            this.table.setRowSelectionInterval(0, 0);
        }
    }

    public void onClose() {
        this.defaults.setPropertyBoolean("CodeEditorKeyManager.ShowAllCommands.txt", this.ShowAllCheckbox.isSelected());
        this.defaults.setPropertyInt("CodeEditorKeyManager.LastUsedCategory.txt", this.CategoryCombo.getSelectedIndex());
        this.defaults.saveProperties();
        if (this.dlgParent != null) {
            this.dlgParent.dispose();
        }
    }

    public void cleanup() {
        if (this.m_Editor != null) {
            this.m_Editor.cleanup();
        }
    }

    public void onAssign() {
        AssignEditorKeysDialog jd = AssignEditorKeysDialog.CreateDialog(this, this.m_EditorPane);
        if (jd == null) {
            return;
        }
        jd.setLocationRelativeTo(null);
        jd.assignPane.CategoryCombo.setSelectedIndex(this.CategoryCombo.getSelectedIndex());
        jd.setVisible(true);
        this.populateTable();
    }

    public void onReset() {
        this.keyManager.ResetAll();
        this.populateTable();
    }

    public void onHelp() {
        SASJavaHelp jh = new SASJavaHelp("texteditor");
        jh.setActivationWindow((Window)this.dlgParent);
        jh.showContext("editorkeys");
    }

    public void onTableClick() {
        try {
            CommandWrapper wrapper = (CommandWrapper)this.dtm.getValueAt(this.table.getSelectedRow(), 0);
            String desc = wrapper.getCommandInfo().getDescription();
            this.DescriptionText.setText(desc);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            this.DescriptionText.setText("");
        }
    }

    protected void setupMnemonics(JLabel lbl, String key) {
        String lblItem = this.resource.getString(key);
        String lblText = Util.getLabelWithoutMnemonic((String)lblItem);
        lbl.setText(lblText);
        int index = Util.getDisplayedMnemonicIndex((String)lblItem);
        if (index > -1) {
            lbl.setDisplayedMnemonic(Util.getDisplayedMnemonic((String)lblItem));
            lbl.setDisplayedMnemonicIndex(index);
        }
    }

    protected void setupMnemonics(JButton btn, String key) {
        String buttonItem = this.resource.getString(key);
        String buttonText = Util.getLabelWithoutMnemonic((String)buttonItem);
        btn.setText(buttonText);
        int index = Util.getDisplayedMnemonicIndex((String)buttonItem);
        if (index > -1) {
            btn.setMnemonic(Util.getDisplayedMnemonic((String)buttonItem));
            btn.setDisplayedMnemonicIndex(index);
        }
    }
}

