/*
 * Decompiled with CFR 0.152.
 */
package com.sas.editor;

import com.sas.editor.CodeEditorDefaults;
import com.sas.editor.CodeEditorDocumentEvent;
import com.sas.editor.CodeEditorTextPosition;
import com.sas.editor.CodeEditorUndoManager;
import com.sas.editor.CodeLanguage;
import com.sas.editor.ColorChangeListener;
import com.sas.editor.EditableRegion;
import com.sas.editor.ICodeDocument;
import com.sas.editor.LineOffsets;
import com.sas.editor.LineTokenInfo;
import com.sas.editor.TokenInfo;
import com.sas.editor.TokenMap;
import com.sas.editor.TokenMapInterface;
import com.sas.editor.language.HtmlLanguageParser;
import com.sas.editor.language.ILanguageParser;
import com.sas.editor.language.JavaLanguageParser;
import com.sas.editor.language.LogListLanguageParser;
import com.sas.editor.language.SasLanguageParser;
import java.awt.Color;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.Collator;
import java.text.StringCharacterIterator;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Locale;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.PlainDocument;
import javax.swing.text.Segment;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.undo.UndoableEdit;

public class CodeEditorDocument
extends PlainDocument
implements DocumentListener,
ICodeDocument {
    public static final int DONE_SEARCHING = -2;
    protected ILanguageParser m_LanguageParser;
    protected CodeLanguage m_Language;
    public String m_Filename;
    protected CodeEditorUndoManager m_UndoManager;
    protected TokenMapInterface mTokenMap;
    protected CodeEditorDefaults m_defaults;
    protected int m_TabSize;
    protected boolean m_DoIndent;
    protected long m_MassReplaceCode = 0L;
    protected Collator coll = Collator.getInstance(Locale.getDefault());
    protected int m_FirstFoundPosition = -1;
    protected boolean OldSearchDown = false;
    protected boolean OldMatchCase = false;
    protected boolean OldMatchWord = false;
    protected String OldTextToFind = null;
    protected boolean OldSearchCode = false;
    protected boolean OldSearchComments = false;
    protected EventListenerList m_ListenerList = new EventListenerList();
    private Color m_readonlyFgColor;
    private Color m_readonlyBgColor;
    private EditableRegion m_rgn;
    private int m_previousLineCount = 0;

    public CodeEditorDocument() {
        this.m_Filename = new String();
        this.addDocumentListener(this);
        this.m_UndoManager = new CodeEditorUndoManager();
        this.mTokenMap = new TokenMap(this);
    }

    public Integer validateLineLengths(int maxLineLength) {
        int lineCount = this.getLineCount();
        for (int i = 0; i < lineCount; ++i) {
            int lineLength = this.getLineLength(i);
            if (lineLength <= maxLineLength) continue;
            return new Integer(i);
        }
        return null;
    }

    public void cleanup() {
        if (this.mTokenMap != null) {
            this.mTokenMap.cleanup();
        }
        this.removeDocumentListener(this);
        this.clearListenerList(this.listenerList);
        this.clearListenerList(this.m_ListenerList);
        if (this.m_LanguageParser != null) {
            this.m_LanguageParser.cleanup();
        }
    }

    private void clearListenerList(EventListenerList aListenerList) {
        int i;
        Object[] listeners = aListenerList.getListenerList();
        Object[] listCopy = new Object[listeners.length];
        for (i = 0; i < listeners.length; ++i) {
            listCopy[i] = listeners[i];
        }
        for (i = 0; i < listCopy.length; i += 2) {
            Object listenerClass = listCopy[i];
            Object listener = listCopy[i + 1];
            if (!(listenerClass instanceof Class) || !(listener instanceof EventListener)) continue;
            aListenerList.remove((Class)listenerClass, (EventListener)listener);
        }
    }

    @Override
    public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
        if (this.isInReadonlyRegion(offset)) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        super.insertString(offset, str, a);
    }

    @Override
    public void remove(int offset, int length) throws BadLocationException {
        if (this.isInReadonlyRegion(offset) || this.isInReadonlyRegion(offset + length)) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        super.remove(offset, length);
    }

    public void clear() {
        try {
            if (this.getEditableRegion() != null) {
                int length = this.getNextLineStartOffsetFromLine(this.getEditableRegion().getLastEditableLine()) - 1 - this.getStartOffsetForLine(this.getEditableRegion().getFirstEditableLine());
                this.remove(this.getStartOffsetForLine(this.getEditableRegion().getFirstEditableLine()), length);
            } else {
                this.remove(0, this.getLength());
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public final void setupDefaults(CodeEditorDefaults defs) {
        this.setupDefaults(defs, CodeLanguage.SAS);
    }

    public void setupDefaults(CodeEditorDefaults defs, CodeLanguage lang) {
        this.m_defaults = defs;
        this.setTabSize(this.m_defaults.getTabSize());
        this.setSmartIndent(this.m_defaults.getSmartIndent());
        this.setLanguage(lang);
    }

    @Override
    public final CodeEditorDefaults getDefaults() {
        return this.m_defaults;
    }

    public final void saveDefaults() {
        this.m_defaults.saveProperties();
    }

    public final String getDefaultPropertyString(String key) {
        return this.m_defaults.getPropertyString(key);
    }

    public final int getDefaultPropertyInt(String key) {
        return this.m_defaults.getPropertyInt(key);
    }

    public final int getDefaultPropertyInt(String key, int defValue) {
        return this.m_defaults.getPropertyInt(key, defValue);
    }

    public final boolean getDefaultPropertyBoolean(String key) {
        return this.m_defaults.getPropertyBoolean(key);
    }

    public final boolean getDefaultPropertyBoolean(String key, boolean defValue) {
        return this.m_defaults.getPropertyBoolean(key, defValue);
    }

    public final void setDefaultPropertyString(String key, String value) {
        this.m_defaults.setPropertyString(key, value);
        this.m_defaults.saveProperties();
    }

    public final void setDefaultPropertyInt(String key, int value) {
        this.m_defaults.setPropertyInt(key, value);
        this.m_defaults.saveProperties();
    }

    public void setLanguage(CodeLanguage language) {
        if (this.m_Language != language) {
            this.m_Language = language;
            switch (this.m_Language.getID()) {
                case 2: {
                    this.setLanguageParser(new SasLanguageParser(this));
                    break;
                }
                case 5: {
                    this.setLanguageParser(new LogListLanguageParser(this));
                    break;
                }
                case 6: {
                    this.setLanguageParser(new LogListLanguageParser(this));
                    break;
                }
                case 3: {
                    this.setLanguageParser(new HtmlLanguageParser(this));
                    break;
                }
                case 4: {
                    this.setLanguageParser(new JavaLanguageParser(this));
                }
            }
            this.resetLineTokenInfo();
            this.getLanguageParser().color();
        }
    }

    @Override
    public final CodeLanguage getLanguage() {
        return this.m_Language;
    }

    public final void setLanguageParser(ILanguageParser lp) {
        this.m_LanguageParser = lp;
    }

    public final ILanguageParser getLanguageParser() {
        return this.m_LanguageParser;
    }

    public final void updateAttributes() {
        this.m_LanguageParser.updateElementAttributeMap();
        this.m_LanguageParser.color();
    }

    @Override
    public final boolean lineTokenInfoExists(int offset) {
        Element line = this.getParagraphElement(offset);
        LineTokenInfo lti = this.getLineTokenInfoInternal(line);
        return lti != null;
    }

    @Override
    public TokenMapInterface getTokenMap() {
        return this.mTokenMap;
    }

    @Override
    public LineTokenInfo getLineTokenInfo(int offset, boolean bNoCreate) {
        Element line = this.getParagraphElement(offset);
        LineTokenInfo lti = this.getLineTokenInfoInternal(line);
        if (lti != null) {
            return lti;
        }
        if (!bNoCreate) {
            return this.createLineTokenInfo(line);
        }
        return null;
    }

    @Override
    public LineTokenInfo getLineTokenInfoForLine(int line, boolean bNoCreate) {
        Element elem = this.getElement(line);
        LineTokenInfo lti = this.getLineTokenInfoInternal(elem);
        if (lti != null) {
            return lti;
        }
        if (!bNoCreate) {
            return this.createLineTokenInfo(elem);
        }
        return null;
    }

    @Override
    public final TokenInfo getTokenInfo(int offset) {
        TokenInfo info = this.mTokenMap.getTokenInfo(offset);
        return info;
    }

    protected LineTokenInfo getLineTokenInfoInternal(Element line) {
        AttributeSet attrs = line.getAttributes();
        Object lti = attrs.getAttribute("LineTokenInfo");
        if (lti != null) {
            return (LineTokenInfo)lti;
        }
        return null;
    }

    protected void resetLineTokenInfo() {
        boolean isMyLock = this.RequestLock();
        int lineCount = this.getLineCount();
        for (int i = 0; i < lineCount; ++i) {
            Element line = this.getElement(i);
            this.createLineTokenInfo(line);
        }
        if (isMyLock) {
            this.ReleaseLock();
        }
    }

    protected LineTokenInfo createLineTokenInfo(Element lineElement) {
        LineTokenInfo lti = this.m_LanguageParser.createLineTokenInfoObject(lineElement);
        try {
            MutableAttributeSet attrs = (MutableAttributeSet)lineElement.getAttributes();
            attrs.removeAttribute("LineTokenInfo");
            attrs.addAttribute("LineTokenInfo", lti);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return lti;
    }

    @Override
    public final boolean IsDocumentColoringEnabled() {
        return this.m_LanguageParser.IsDocumentColoringEnabled();
    }

    public final void EnableDocumentColoring(boolean b) {
        this.m_LanguageParser.EnableDocumentColoring(b);
    }

    @Override
    public final boolean onSameLine(int offset1, int offset2) {
        Element pg1 = this.getParagraphElement(offset1);
        return offset2 >= pg1.getStartOffset() && offset2 < pg1.getEndOffset();
    }

    @Override
    public final int getStartOffsetForLine(int line) {
        Element myLine = this.getElement(line);
        if (myLine == null) {
            return -1;
        }
        return myLine.getStartOffset();
    }

    @Override
    public final int getCurrentLineStartOffset(int offset) {
        int line = this.getLineForOffset(offset);
        Element pg = this.getElement(line);
        return pg.getStartOffset();
    }

    public final boolean atEOL(int offset) {
        int nextLineStart = this.getNextLineStartOffset(offset);
        if (nextLineStart - 1 == offset || nextLineStart == offset) {
            return true;
        }
        return nextLineStart < 0 && offset == this.getLength();
    }

    public int getCurrentLineNumber(int offset) {
        return this.getLineForOffset(offset);
    }

    @Override
    public final int getNextLineStartOffset(int offset) {
        int line = this.getLineForOffset(offset);
        Element pg = this.getElement(line);
        return pg.getEndOffset();
    }

    @Override
    public final int getNextLineStartOffsetFromLine(int line) {
        Element element = this.getElement(line);
        return element.getEndOffset();
    }

    @Override
    public int getPrevLineStartOffset(int offset) {
        Element pg = this.getParagraphElement(offset);
        int prevLineStart = pg.getStartOffset() - 1;
        if (prevLineStart < 0) {
            return -1;
        }
        return this.getParagraphElement(pg.getStartOffset() - 1).getStartOffset();
    }

    @Override
    public final int getPrevLineEndOffset(int offset) {
        Element pg = this.getParagraphElement(offset);
        return pg.getStartOffset() - 1;
    }

    public final Object getAttributeAtOffset(int offset, Object key) {
        Element run = this.getParagraphElement(offset);
        AttributeSet attrs = run.getAttributes();
        return attrs.getAttribute(key);
    }

    public CodeEditorTextPosition getDocumentStart() {
        CodeEditorTextPosition pos = new CodeEditorTextPosition(1, 1);
        return pos;
    }

    public final CodeEditorTextPosition getDocumentEnd() {
        CodeEditorTextPosition pos = new CodeEditorTextPosition();
        this.getDocumentEnd(pos);
        return pos;
    }

    @Override
    public void getDocumentEnd(CodeEditorTextPosition docEnd) {
        docEnd.mLine = this.getLineCount();
        Element line = this.getElement(docEnd.mLine - 1);
        docEnd.mColumn = line.getEndOffset() - line.getStartOffset();
    }

    @Override
    public int getOffset(CodeEditorTextPosition textPos) {
        Element lineElement = this.getElement(textPos.mLine - 1);
        return lineElement.getStartOffset() + textPos.mColumn - 1;
    }

    @Override
    public boolean goToNextChar(CodeEditorTextPosition textPos) {
        if (textPos.mColumn <= this.getLineLength(textPos.mLine - 1)) {
            ++textPos.mColumn;
            return true;
        }
        if (textPos.mLine == this.getLineCount()) {
            return false;
        }
        ++textPos.mLine;
        textPos.mColumn = 1;
        return true;
    }

    @Override
    public boolean goToPreviousChar(CodeEditorTextPosition textPos) {
        if (textPos.mColumn > 1) {
            --textPos.mColumn;
            return true;
        }
        if (textPos.mLine == 1) {
            return false;
        }
        --textPos.mLine;
        textPos.mColumn = this.getLineLength(textPos.mLine - 1) + 1;
        return true;
    }

    public String getLine(int line) {
        int start = this.getStartOffsetForLine(line);
        int len = this.getLineLength(line);
        String lineData = null;
        try {
            lineData = this.getText(start, len);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return lineData;
    }

    @Override
    public int getLineCount() {
        Element root = this.getDefaultRootElement();
        return root.getElementCount();
    }

    @Override
    public final int getLineLength(int line) {
        Element l = this.getElement(line);
        return l.getEndOffset() - l.getStartOffset();
    }

    protected Element getElement(int index) {
        return this.getDefaultRootElement().getElement(index);
    }

    public final int getLineLengthForOffset(int offset) {
        Element pg = this.getParagraphElement(offset);
        return pg.getEndOffset() - pg.getStartOffset();
    }

    @Override
    public CodeEditorTextPosition getPositionFromOffset(int offset) {
        int index = this.getLineForOffset(offset);
        Element lineElement = this.getElement(index);
        CodeEditorTextPosition pos = new CodeEditorTextPosition();
        pos.mLine = index + 1;
        pos.mColumn = offset - lineElement.getStartOffset() + 1;
        return pos;
    }

    @Override
    public final int getLineNumberFromOffset(int offset) {
        return this.getLineForOffset(offset);
    }

    @Override
    public boolean getLineOffsets(int line, LineOffsets offsets) {
        int adjLine = line;
        if (adjLine > this.getLineCount()) {
            return false;
        }
        Element l = this.getElement(adjLine);
        if (l == null) {
            return false;
        }
        offsets.mStart = l.getStartOffset();
        offsets.mEnd = l.getEndOffset();
        return true;
    }

    @Override
    public int getLineForOffset(int offset) {
        Element root = this.getDefaultRootElement();
        int line = root.getElementIndex(offset);
        return line;
    }

    public boolean getLineOffsetsForOffset(int offset, LineOffsets offsets) {
        int line = this.getLineForOffset(offset);
        Element l = this.getElement(line);
        if (l == null) {
            return false;
        }
        offsets.mStart = l.getStartOffset();
        offsets.mEnd = l.getEndOffset();
        return true;
    }

    public CodeEditorTextPosition getTextPositionFromOffset(int offset) {
        CodeEditorTextPosition pos = new CodeEditorTextPosition();
        Element line = this.getParagraphElement(offset);
        int lineStart = line.getStartOffset();
        pos.mLine = this.getLineNumberFromOffset(offset) + 1;
        pos.mColumn = offset - lineStart + 1;
        return pos;
    }

    public boolean isValidDocumentPosition(CodeEditorTextPosition pos) {
        return this.isValidDocumentPosition(pos.mLine, pos.mColumn);
    }

    public boolean isValidDocumentPosition(int line, int column) {
        if (line < 1 || line > this.getLineCount()) {
            return false;
        }
        return column >= 1 && column <= this.getLineLength(line) + 1;
    }

    @Override
    public final boolean isEmpty() {
        return this.getLength() == 0;
    }

    public boolean openFile(String strFile) throws FileNotFoundException {
        File fname = new File(strFile);
        StringBuffer sb = new StringBuffer((int)Math.min(Integer.MAX_VALUE, fname.length()));
        int bufferLength = 20000;
        char[] buffer = new char[bufferLength];
        int bytesRead = 0;
        try {
            BufferedReader d = new BufferedReader(new InputStreamReader(new FileInputStream(fname)));
            do {
                if ((bytesRead = d.read(buffer, 0, bufferLength)) <= 0) continue;
                for (int i = 0; i < bytesRead; ++i) {
                    char character = buffer[i];
                    if (character == '\r') continue;
                    sb.append(character);
                }
            } while (bytesRead > 0);
            this.clear();
            this.insertString(0, sb.substring(0, sb.length()), SimpleAttributeSet.EMPTY);
        }
        catch (FileNotFoundException fileEx) {
            throw fileEx;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        this.clearUndoStack();
        this.m_Filename = strFile;
        return true;
    }

    public void appendFile(String strFile) throws FileNotFoundException {
        File fname = new File(strFile);
        String s = new String();
        StringBuffer sb = new StringBuffer(5000);
        boolean shouldWeClearUndoStack = this.checkForNewDocument();
        if (this.getLastEditableLine() < 0) {
            return;
        }
        Element e = this.getElement(this.getLastEditableLine());
        int nLength = e.getEndOffset() - 1;
        BufferedReader d = new BufferedReader(new InputStreamReader(new FileInputStream(fname)));
        do {
            try {
                s = d.readLine();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            if (s == null) continue;
            sb.append(s);
            sb.append('\n');
        } while (s != null);
        try {
            this.insertString(nLength, sb.toString(), SimpleAttributeSet.EMPTY);
        }
        catch (BadLocationException ex) {
            ex.printStackTrace();
        }
        if (shouldWeClearUndoStack) {
            this.clearUndoStack();
        }
    }

    public boolean saveFile(String strFile) throws IOException {
        String outText = "";
        int prev = 0;
        try {
            outText = this.getText(0, this.getLength());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            boolean bEOF = false;
            BufferedWriter fw = new BufferedWriter(new FileWriter(strFile));
            do {
                int next;
                if ((next = outText.indexOf(10, prev)) == -1) {
                    next = outText.length();
                    bEOF = true;
                }
                if (next < prev) continue;
                fw.write(outText, prev, next - prev);
                fw.newLine();
                prev = next + 1;
            } while (!bEOF);
            fw.close();
        }
        catch (IOException ioEx) {
            throw ioEx;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        this.markUndoStack();
        return true;
    }

    public boolean VerifyMatchWord(String StringToVerify, int index) {
        char c;
        int before = index - 1;
        int after = index + StringToVerify.length();
        boolean okbefore = false;
        boolean okafter = false;
        Segment seg = new Segment();
        if (before == -1) {
            okbefore = true;
        } else {
            try {
                this.getText(before, 1, seg);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            c = seg.setIndex(seg.getBeginIndex());
            boolean bl = okbefore = !Character.isLetterOrDigit(c);
        }
        if (!okbefore) {
            return false;
        }
        if (after >= this.getLength()) {
            return true;
        }
        try {
            this.getText(after, 1, seg);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        c = seg.setIndex(seg.getBeginIndex());
        okafter = !Character.isLetterOrDigit(c);
        return okafter;
    }

    public final void ResetFoundPosition() {
        this.m_FirstFoundPosition = -1;
    }

    public int repeatFind(int offset, boolean shiftIsDown) {
        if (shiftIsDown) {
            offset -= this.OldTextToFind.length() + 1;
        }
        if (offset < 0) {
            offset = this.getLength();
        }
        return this.Find(this.OldTextToFind, offset, !shiftIsDown, this.OldMatchCase, this.OldMatchWord, this.OldSearchCode, this.OldSearchComments);
    }

    public int Find(String TextToFind, int Offset, boolean SearchDown, boolean MatchCase, boolean MatchWord, boolean SearchCode, boolean SearchComments) {
        int FoundAt = 0;
        if (this.coll.compare(TextToFind, "") == 0) {
            return Offset;
        }
        if (this.m_FirstFoundPosition >= 0 && (this.coll.compare(TextToFind, this.OldTextToFind) != 0 || this.OldSearchDown != SearchDown || this.OldMatchCase != MatchCase || this.OldMatchWord != MatchWord || this.OldSearchCode != SearchCode || this.OldSearchComments != SearchComments)) {
            this.ResetFoundPosition();
        }
        FoundAt = this.FindText(TextToFind, Offset, SearchDown, MatchCase, MatchWord, SearchCode, SearchComments);
        this.OldTextToFind = TextToFind;
        this.OldSearchDown = SearchDown;
        this.OldMatchCase = MatchCase;
        this.OldMatchWord = MatchWord;
        this.OldSearchCode = SearchCode;
        this.OldSearchComments = SearchComments;
        if (FoundAt >= 0) {
            if (this.m_FirstFoundPosition < 0) {
                this.m_FirstFoundPosition = FoundAt;
            } else if (this.m_FirstFoundPosition == FoundAt) {
                this.ResetFoundPosition();
                return -2;
            }
            return FoundAt;
        }
        FoundAt = SearchDown ? this.FindText(TextToFind, 0, SearchDown, MatchCase, MatchWord, SearchCode, SearchComments) : this.FindText(TextToFind, this.getLength(), SearchDown, MatchCase, MatchWord, SearchCode, SearchComments);
        if (this.m_FirstFoundPosition < 0) {
            this.m_FirstFoundPosition = FoundAt;
        } else if (this.m_FirstFoundPosition == FoundAt) {
            this.ResetFoundPosition();
            return -2;
        }
        return FoundAt;
    }

    public final boolean isInComment(int offset) {
        return this.m_LanguageParser.isCommentType(offset);
    }

    public final boolean isKeyword(int offset) {
        return this.m_LanguageParser.isCodeType(offset);
    }

    public int areWeSittingOnWord(String word, int index) {
        String searchArea = "";
        int lenToSearch = word.length() * 2;
        if ((index -= word.length()) + lenToSearch > this.getLength()) {
            lenToSearch = this.getLength() - index;
        }
        if (index < 0) {
            lenToSearch += index;
            index = 0;
        }
        try {
            searchArea = this.getText(index, lenToSearch).toUpperCase(Locale.getDefault());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        int foundAt = searchArea.indexOf(word.toUpperCase(Locale.getDefault()));
        if (foundAt < 0) {
            return -1;
        }
        if (this.VerifyMatchWord(word, index + foundAt)) {
            return index + foundAt;
        }
        return -1;
    }

    public int MatchDoEnd(int index) {
        boolean onDo;
        int nestingLevel = 1;
        String docText = "";
        int currentIndex = this.areWeSittingOnWord("do", index);
        if (currentIndex > 0) {
            onDo = true;
        } else {
            currentIndex = this.areWeSittingOnWord("end", index);
            if (currentIndex > 0) {
                onDo = false;
            } else {
                return -1;
            }
        }
        if (!this.isKeyword(currentIndex)) {
            return -1;
        }
        try {
            docText = this.getText(0, this.getLength());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (!onDo) {
            while (nestingLevel > 0) {
                int indexOfSame;
                int indexOfOpp;
                if (index == 0) {
                    return -1;
                }
                int holdIndex = currentIndex;
                while ((indexOfOpp = docText.lastIndexOf("do", currentIndex - 1)) >= 0 && !this.isKeyword(indexOfOpp)) {
                    currentIndex = indexOfOpp;
                }
                if (indexOfOpp < 0) {
                    return -1;
                }
                currentIndex = holdIndex;
                while ((indexOfSame = docText.lastIndexOf("end", currentIndex - 1)) >= 0 && !this.isKeyword(indexOfSame)) {
                    currentIndex = indexOfSame;
                }
                if (indexOfOpp > indexOfSame) {
                    --nestingLevel;
                    currentIndex = indexOfOpp;
                    continue;
                }
                if (indexOfSame <= indexOfOpp) continue;
                ++nestingLevel;
                currentIndex = indexOfSame;
            }
        } else {
            while (nestingLevel > 0) {
                int indexOfSame;
                int indexOfOpp;
                if (index >= this.getLength()) {
                    return -1;
                }
                int holdIndex = currentIndex;
                while ((indexOfOpp = docText.indexOf("end", currentIndex + 1)) >= 0 && !this.isKeyword(indexOfOpp)) {
                    currentIndex = indexOfOpp;
                }
                if (indexOfOpp < 0) {
                    return -1;
                }
                currentIndex = holdIndex;
                while ((indexOfSame = docText.indexOf("do", currentIndex + 1)) >= 0 && !this.isKeyword(indexOfSame)) {
                    currentIndex = indexOfSame;
                }
                if (indexOfSame < 0) {
                    indexOfSame = this.getLength() + 1;
                }
                if (indexOfOpp < indexOfSame) {
                    --nestingLevel;
                    currentIndex = indexOfOpp;
                    continue;
                }
                if (indexOfSame >= indexOfOpp) continue;
                ++nestingLevel;
                currentIndex = indexOfSame;
            }
        }
        return currentIndex;
    }

    public int findMatchingChar(char c, int index) {
        boolean searchAhead;
        int charToFind;
        String docText = "";
        int nestingLevel = 1;
        if (this.isInComment(index)) {
            return -1;
        }
        try {
            docText = this.getText(0, this.getLength());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        switch (c) {
            case '[': {
                charToFind = 93;
                searchAhead = true;
                break;
            }
            case ']': {
                charToFind = 91;
                searchAhead = false;
                break;
            }
            case '{': {
                charToFind = 125;
                searchAhead = true;
                break;
            }
            case '}': {
                charToFind = 123;
                searchAhead = false;
                break;
            }
            case '(': {
                charToFind = 41;
                searchAhead = true;
                break;
            }
            case ')': {
                charToFind = 40;
                searchAhead = false;
                break;
            }
            default: {
                return -1;
            }
        }
        if (!searchAhead) {
            while (nestingLevel > 0) {
                int indexOfSame;
                int indexOfOpp;
                if (index == 0) {
                    return -1;
                }
                while ((indexOfOpp = docText.lastIndexOf(charToFind, index - 1)) >= 0 && this.isInComment(indexOfOpp)) {
                    index = indexOfOpp;
                }
                if (indexOfOpp < 0) {
                    return -1;
                }
                while ((indexOfSame = docText.lastIndexOf(c, index - 1)) >= 0 && this.isInComment(indexOfSame)) {
                    index = indexOfSame;
                }
                if (indexOfOpp > indexOfSame) {
                    --nestingLevel;
                    index = indexOfOpp;
                    continue;
                }
                if (indexOfSame <= indexOfOpp) continue;
                ++nestingLevel;
                index = indexOfSame;
            }
        } else {
            while (nestingLevel > 0) {
                int indexOfSame;
                int indexOfOpp;
                if (index >= this.getLength()) {
                    return -1;
                }
                while ((indexOfOpp = docText.indexOf(charToFind, index + 1)) >= 0 && this.isInComment(indexOfOpp)) {
                    index = indexOfOpp;
                }
                if (indexOfOpp < 0) {
                    return -1;
                }
                while ((indexOfSame = docText.indexOf(c, index + 1)) >= 0 && this.isInComment(indexOfSame)) {
                    index = indexOfSame;
                }
                if (indexOfSame < 0) {
                    indexOfSame = this.getLength() + 1;
                }
                if (indexOfOpp < indexOfSame) {
                    --nestingLevel;
                    index = indexOfOpp;
                    continue;
                }
                if (indexOfSame >= indexOfOpp) continue;
                ++nestingLevel;
                index = indexOfSame;
            }
        }
        return index;
    }

    public final boolean isMatchableChar(char c) {
        return c == '[' || c == ']' || c == '{' || c == '}' || c == '(' || c == ')';
    }

    public char getCharAt(int offset) {
        String s = "";
        try {
            s = this.getText(offset, 1);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return '\u0000';
        }
        StringCharacterIterator sci = new StringCharacterIterator(s);
        return sci.setIndex(0);
    }

    public int FindText(String TextToFind, int Offset, boolean SearchDown, boolean MatchCase, boolean MatchWord, boolean SearchCode, boolean SearchComments) {
        String DocumentText = "";
        try {
            DocumentText = this.getText(0, this.getLength());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return -1;
        }
        if (!MatchCase) {
            DocumentText = DocumentText.toUpperCase(Locale.getDefault());
            TextToFind = TextToFind.toUpperCase(Locale.getDefault());
        }
        int FoundPosition = -1;
        while (true) {
            if (!((FoundPosition = SearchDown ? DocumentText.indexOf(TextToFind, Offset) : DocumentText.lastIndexOf(TextToFind, Offset)) < 0 || this.isInComment(FoundPosition) && SearchComments || !this.isInComment(FoundPosition) && SearchCode)) {
                if (SearchDown) {
                    Offset = FoundPosition + 1;
                    continue;
                }
                Offset = FoundPosition - 1;
                continue;
            }
            if (FoundPosition < 0) {
                return -1;
            }
            if (!MatchWord) {
                return FoundPosition;
            }
            if (this.VerifyMatchWord(TextToFind, FoundPosition)) {
                return FoundPosition;
            }
            if (SearchDown) {
                Offset = FoundPosition + 1;
                continue;
            }
            Offset = FoundPosition - 1;
        }
    }

    public int ReplaceText(String TextToFind, String TextToReplace, int Offset, boolean SearchDown, boolean MatchCase, boolean MatchWord, boolean SearchCode, boolean SearchComments) {
        this.ResetFoundPosition();
        int index = this.Find(TextToFind, Offset, SearchDown, MatchCase, MatchWord, SearchCode, SearchComments);
        if (index >= 0) {
            try {
                boolean createdMassReplace;
                boolean bl = createdMassReplace = this.getMassReplaceCode() == 0L;
                if (createdMassReplace) {
                    this.setMassReplaceCode(System.currentTimeMillis());
                }
                this.remove(index, TextToFind.length());
                this.insertString(index, TextToReplace, SimpleAttributeSet.EMPTY);
                if (createdMassReplace) {
                    this.setMassReplaceCode(0L);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            return -1;
        }
        return index;
    }

    public int ReplaceInSelection(String TextToFind, String TextToReplace, int StartPos, int EndPos, boolean MatchCase, boolean MatchWord, boolean SearchCode, boolean SearchComments) {
        int new_end = EndPos;
        boolean found = false;
        this.ResetFoundPosition();
        EndPos -= TextToFind.length();
        while (true) {
            int index;
            if ((index = this.FindText(TextToFind, StartPos, true, MatchCase, MatchWord, SearchCode, SearchComments)) < StartPos || index > EndPos) {
                if (found) {
                    return new_end;
                }
                return -1;
            }
            try {
                this.remove(index, TextToFind.length());
                this.insertString(index, TextToReplace, SimpleAttributeSet.EMPTY);
                EndPos += TextToReplace.length() - TextToFind.length();
                new_end += TextToReplace.length() - TextToFind.length();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            found = true;
            StartPos = index + TextToReplace.length();
        }
    }

    @Override
    public final boolean RequestLock() {
        boolean lockHere = this.getCurrentWriter() == null;
        try {
            if (lockHere) {
                this.writeLock();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return lockHere;
    }

    @Override
    public final void ReleaseLock() {
        this.writeUnlock();
    }

    public final void setUndoManager(CodeEditorUndoManager manager) {
        this.m_UndoManager = manager;
    }

    public final CodeEditorUndoManager getUndoManager() {
        return this.m_UndoManager;
    }

    public final void clearUndoStack() {
        CodeEditorUndoManager manager = this.getUndoManager();
        if (manager != null) {
            manager.ClearUndoStack();
        }
    }

    public final void markUndoStack() {
        CodeEditorUndoManager manager = this.getUndoManager();
        if (manager != null) {
            manager.MarkUndoStack();
        }
    }

    public final boolean checkForNewDocument() {
        return !this.isDocumentModified() && this.isEmpty();
    }

    public final boolean isDocumentModified() {
        CodeEditorUndoManager manager = this.getUndoManager();
        if (manager != null) {
            return manager.isDocumentModified();
        }
        return false;
    }

    public final String getFilename() {
        return this.m_Filename;
    }

    public final void setFilename(String s) {
        this.m_Filename = s;
    }

    public final void setTabSize(int newTabSize) {
        if (newTabSize >= 1) {
            this.m_TabSize = newTabSize;
        }
    }

    public final int getTabSize() {
        return this.m_TabSize;
    }

    protected void updateCollapseExpandLineMap(DocumentEvent e) {
        int startLine;
        Element root = this.getDefaultRootElement();
        DocumentEvent.ElementChange ec = e.getChange(root);
        if (ec == null) {
            return;
        }
        Element[] added = ec.getChildrenAdded();
        Element[] removed = ec.getChildrenRemoved();
        if (removed.length == added.length) {
            return;
        }
        if (removed.length > 0) {
            startLine = this.getLineForOffset(removed[0].getStartOffset());
            this.fireRemoveLines(startLine, removed.length);
        }
        if (added.length > 0) {
            startLine = this.getLineForOffset(added[0].getStartOffset());
            this.fireInsertLines(startLine, added.length);
        }
    }

    @Override
    public void syntaxColorUpdate(int p0, int p1) {
        AbstractDocument.DefaultDocumentEvent e = new AbstractDocument.DefaultDocumentEvent(this, p0, p1 - p0, DocumentEvent.EventType.CHANGE);
        e.end();
        this.fireChangedUpdate(e);
        this.fireColorChangeUpdate(e);
    }

    protected void fireElementUpdate(Element line) {
        int p0 = line.getStartOffset();
        int p1 = line.getEndOffset();
        AbstractDocument.DefaultDocumentEvent e = new AbstractDocument.DefaultDocumentEvent(this, p0, p1 - p0, DocumentEvent.EventType.CHANGE);
        e.end();
        this.fireChangedUpdate(e);
    }

    public void DumpElementHierarchy() {
        Element[] rootElements = new Element[]{this.getDefaultRootElement()};
        System.out.println("-------------------- Element Hierarchy --------------------");
        for (int i = 0; i < rootElements.length; ++i) {
            this.DumpElement(rootElements[i], 1);
        }
        System.out.println("-----------------------------------------------------------");
    }

    public void DumpElement(Element e, int nLevel) {
        AttributeSet as = e.getAttributes();
        StringBuffer strAttrs = new StringBuffer(80);
        strAttrs.append(nLevel + " " + e.getName() + " [" + e.getStartOffset() + ", " + e.getEndOffset() + "] Attributes: [");
        if (as != null) {
            Enumeration<?> names = as.getAttributeNames();
            while (names.hasMoreElements()) {
                Object nextName = names.nextElement();
                if (nextName == StyleConstants.ResolveAttribute) continue;
                strAttrs.append(" ");
                strAttrs.append(nextName);
                strAttrs.append("=");
                strAttrs.append(as.getAttribute(nextName));
            }
        }
        strAttrs.append(" ]");
        System.out.println(strAttrs.toString());
        for (int i = 0; i < e.getElementCount(); ++i) {
            this.DumpElement(e.getElement(i), nLevel + 1);
        }
    }

    public void deleteLine(int offset) {
        int end;
        int len;
        int start = this.getCurrentLineStartOffset(offset);
        if (start + (len = (end = this.getNextLineStartOffset(offset)) - start) > this.getLength()) {
            return;
        }
        try {
            this.remove(start, len);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void deleteEndLine(int offset) {
        int end = this.getNextLineStartOffset(offset) - 1;
        int len = end - offset;
        try {
            this.remove(offset, len);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void deleteBegLine(int offset) {
        int start = this.getCurrentLineStartOffset(offset);
        int len = offset - start;
        try {
            this.remove(start, len);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public int doBlockIndent(int startPos, int endPos) {
        int lineStart = this.getLineNumberFromOffset(startPos);
        int lineEnd = this.getLineNumberFromOffset(endPos);
        for (int line = lineStart; line <= lineEnd; ++line) {
            try {
                this.insertString(this.getStartOffsetForLine(line), "\t", SimpleAttributeSet.EMPTY);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        int newEnd = this.getStartOffsetForLine(lineEnd);
        newEnd += this.getLineLengthForOffset(newEnd);
        return newEnd;
    }

    public int doBlockUnIndent(int startPos, int endPos) {
        int lineStart = this.getLineNumberFromOffset(startPos);
        int lineEnd = this.getLineNumberFromOffset(endPos);
        block2: for (int line = lineStart; line <= lineEnd; ++line) {
            int pos = this.getStartOffsetForLine(line);
            try {
                if (this.getCharAt(pos) == '\t') {
                    this.remove(pos, 1);
                    continue;
                }
                for (int i = 0; i < this.getTabSize(); ++i) {
                    if (this.getCharAt(pos) != ' ') {
                        if (this.getCharAt(pos) != '\t') continue block2;
                        this.remove(pos, 1);
                        continue block2;
                    }
                    this.remove(pos, 1);
                }
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        int newEnd = this.getStartOffsetForLine(lineEnd);
        newEnd += this.getLineLengthForOffset(newEnd);
        return newEnd;
    }

    public int doBlockComment(int startPos, int endPos) {
        String comEnd;
        String comStart;
        switch (this.getLanguage().getID()) {
            case 3: {
                comStart = "<!--";
                comEnd = "-->";
                break;
            }
            default: {
                comStart = "/*";
                comEnd = "*/";
            }
        }
        int lineStart = this.getLineNumberFromOffset(startPos);
        int lineEnd = this.getLineNumberFromOffset(endPos);
        for (int line = lineStart; line <= lineEnd; ++line) {
            try {
                this.insertString(this.getStartOffsetForLine(line), comStart, SimpleAttributeSet.EMPTY);
                int lastPos = this.getLength();
                if (line + 1 < this.getLineCount()) {
                    lastPos = this.getStartOffsetForLine(line + 1) - 1;
                }
                this.insertString(lastPos, comEnd, SimpleAttributeSet.EMPTY);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        int newEnd = this.getStartOffsetForLine(lineEnd);
        newEnd += this.getLineLengthForOffset(newEnd);
        return newEnd;
    }

    public int doBlockUncomment(int startPos, int endPos) {
        String comEnd;
        String comStart;
        switch (this.getLanguage().getID()) {
            case 3: {
                comStart = "<!--";
                comEnd = "-->";
                break;
            }
            default: {
                comStart = "/*";
                comEnd = "*/";
            }
        }
        int lineStart = this.getLineNumberFromOffset(startPos);
        int lineEnd = this.getLineNumberFromOffset(endPos);
        String lineText = "";
        for (int line = lineStart; line <= lineEnd; ++line) {
            int pos = this.getStartOffsetForLine(line);
            lineText = this.getLine(line);
            try {
                int index;
                StringCharacterIterator sci;
                if (lineText.startsWith(comStart)) {
                    this.remove(pos, comStart.length());
                } else {
                    int col = 0;
                    sci = new StringCharacterIterator(lineText);
                    while (sci.setIndex(col) == ' ' || sci.setIndex(col) == '\t') {
                        ++col;
                    }
                    if (lineText.indexOf(comStart) == col) {
                        this.remove(pos + col, comStart.length());
                    }
                }
                lineText = this.getLine(line);
                sci = new StringCharacterIterator(lineText);
                for (index = lineText.length() - 2; index > 0 && (sci.setIndex(index) == ' ' || sci.setIndex(index) == '\t'); --index) {
                }
                if ((index = index - comEnd.length() + 1) < 0 || lineText.lastIndexOf(comEnd) != index) continue;
                this.remove(pos + index, comEnd.length());
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        int newEnd = this.getStartOffsetForLine(lineEnd);
        newEnd += this.getLineLengthForOffset(newEnd);
        return newEnd;
    }

    public final void doClearAll() {
        try {
            this.clear();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public final void setSmartIndent(boolean b) {
        this.m_DoIndent = b;
    }

    public final boolean isSmartIndent() {
        return this.m_DoIndent;
    }

    public void doSmartIndent(int offset) {
        int i;
        int indentSize = 0;
        String szIndent = "\n";
        indentSize = this.getCurrentLineIndent(offset);
        for (i = 0; i < indentSize / this.getTabSize(); ++i) {
            szIndent = szIndent.concat("\t");
        }
        for (i = 0; i < indentSize % this.getTabSize(); ++i) {
            szIndent = szIndent.concat(" ");
        }
        try {
            this.insertString(offset, szIndent, SimpleAttributeSet.EMPTY);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public int getCurrentLineIndent(int offset) {
        if (offset < 0) {
            return 0;
        }
        int lineStart = this.getCurrentLineStartOffset(offset);
        int indentSize = 0;
        int column = -1;
        if (lineStart < 0) {
            return 0;
        }
        block5: while (++column >= 0) {
            char c = this.getCharAt(lineStart + column);
            switch (c) {
                case ' ': {
                    ++indentSize;
                    continue block5;
                }
                case '\t': {
                    indentSize += this.getTabSize();
                    continue block5;
                }
                case '\n': {
                    return this.getCurrentLineIndent(lineStart - 1);
                }
            }
            return indentSize;
        }
        return 0;
    }

    public void updatePreferences() {
        this.setTabSize(this.m_defaults.getTabSize());
        this.setSmartIndent(this.m_defaults.getSmartIndent());
        ILanguageParser langParser = this.getLanguageParser();
        if (langParser != null) {
            langParser.updateKeywords();
        }
    }

    private final void addEdit(DocumentEvent e) {
        CodeEditorUndoManager undoManager = this.getUndoManager();
        if (undoManager != null && e instanceof UndoableEdit) {
            CodeEditorDocumentEvent event = new CodeEditorDocumentEvent(e);
            event.setMassReplaceCode(this.getMassReplaceCode());
            undoManager.addEdit(event);
        }
    }

    public long getMassReplaceCode() {
        return this.m_MassReplaceCode;
    }

    public void setMassReplaceCode(long n) {
        this.m_MassReplaceCode = n;
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        int changeLine;
        this.addEdit(e);
        this.updateCollapseExpandLineMap(e);
        this.m_LanguageParser.interactiveInsert(e.getOffset(), e.getLength());
        if (this.getEditableRegion() != null && (changeLine = this.getLineCount() - this.m_previousLineCount) > 0) {
            this.getEditableRegion().expandEditableRegion(changeLine);
        }
        this.m_previousLineCount = this.getLineCount();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        int changeLine;
        this.addEdit(e);
        this.updateCollapseExpandLineMap(e);
        this.m_LanguageParser.interactiveDelete(e.getOffset(), e.getLength());
        if (this.getEditableRegion() != null && (changeLine = this.m_previousLineCount - this.getLineCount()) > 0) {
            this.getEditableRegion().reduceEditableRegion(changeLine);
        }
        this.m_previousLineCount = this.getLineCount();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    public void addColorChangeListener(ColorChangeListener listener) {
        this.m_ListenerList.add(ColorChangeListener.class, listener);
    }

    public void removeColorChangeListener(ColorChangeListener listener) {
        this.m_ListenerList.remove(ColorChangeListener.class, listener);
    }

    protected void fireColorChangeUpdate(DocumentEvent e) {
        Object[] listeners = this.m_ListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ColorChangeListener.class) continue;
            ((ColorChangeListener)listeners[i + 1]).colorChangeUpdate(e);
        }
    }

    protected void fireInsertLines(int startLine, int count) {
        Object[] listeners = this.m_ListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ColorChangeListener.class) continue;
            ((ColorChangeListener)listeners[i + 1]).insertLines(startLine, count);
        }
    }

    protected void fireRemoveLines(int startLine, int count) {
        Object[] listeners = this.m_ListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ColorChangeListener.class) continue;
            ((ColorChangeListener)listeners[i + 1]).removeLines(startLine, count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replace(int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
        boolean usedMassReplace = false;
        try {
            if (this.getMassReplaceCode() == 0L && length > 0 && text.length() > 0) {
                this.setMassReplaceCode(System.currentTimeMillis());
                usedMassReplace = true;
            }
            super.replace(offset, length, text, attrs);
        }
        finally {
            if (usedMassReplace) {
                this.setMassReplaceCode(0L);
            }
        }
    }

    public boolean canCopyAmount(int numberOfChars) {
        return numberOfChars > 0;
    }

    public EditableRegion getEditableRegion() {
        return this.m_rgn;
    }

    public Color getReadonlyFgColor() {
        if (this.m_readonlyFgColor != null) {
            return this.m_readonlyFgColor;
        }
        return Color.DARK_GRAY;
    }

    public Color getReadonlyBgColor() {
        if (this.m_readonlyBgColor != null) {
            return this.m_readonlyBgColor;
        }
        return Color.LIGHT_GRAY;
    }

    public void setEditableRegion(EditableRegion rgn, Color fgColor, Color bgColor) {
        this.setEditableRegion(rgn);
        this.setReadonlyFgColor(fgColor);
        this.setReadonlyBgColor(bgColor);
    }

    public void setEditableRegion(EditableRegion rgn) {
        this.m_rgn = rgn;
    }

    public void setReadonlyFgColor(Color fgColor) {
        this.m_readonlyFgColor = fgColor;
    }

    public void setReadonlyBgColor(Color bgColor) {
        this.m_readonlyBgColor = bgColor;
    }

    public boolean isInReadonlyRegion(int offset) {
        int line = this.getLineForOffset(offset);
        return this.isReadonlyLine(line);
    }

    public boolean isReadonlyLine(int lineNumber) {
        if (this.getEditableRegion() == null) {
            return false;
        }
        return lineNumber < this.getEditableRegion().getFirstEditableLine() || lineNumber > this.getEditableRegion().getLastEditableLine();
    }

    public int getFirstEditableLine() {
        if (this.getEditableRegion() != null) {
            return this.getEditableRegion().getFirstEditableLine();
        }
        return 0;
    }

    public int getLastEditableLine() {
        if (this.getEditableRegion() != null) {
            return this.getEditableRegion().getLastEditableLine();
        }
        return this.getLineCount() - 1;
    }
}

