/*
 * Decompiled with CFR 0.152.
 */
package com.sas.editor;

import com.sas.editor.CodeEditorDocument;
import com.sas.editor.ICodeDocument;

public class CodeEditorDocLine {
    protected ICodeDocument m_Doc;
    protected int m_Index;
    protected int m_MaxIndex;
    protected int m_StartOffset;
    protected int m_EndOffset;

    public CodeEditorDocLine() {
    }

    public CodeEditorDocLine(ICodeDocument doc, int offset) {
        this.Reset(doc, offset);
    }

    public final void Reset(ICodeDocument doc, int offset) {
        this.m_Doc = doc;
        this.m_MaxIndex = this.m_Doc.getLineCount() - 1;
        this.setIndex(this.m_Doc.getLineForOffset(offset));
    }

    public final void ResetWithLine(CodeEditorDocument doc, int lineIndex) {
        this.m_Doc = doc;
        this.m_MaxIndex = this.m_Doc.getLineCount() - 1;
        this.setIndex(lineIndex);
    }

    protected final void setIndex(int newIndex) {
        this.m_Index = newIndex;
        this.m_StartOffset = this.m_Doc.getStartOffsetForLine(this.m_Index);
        this.m_EndOffset = this.m_StartOffset + this.m_Doc.getLineLength(this.m_Index);
    }

    public final int length() {
        return this.m_EndOffset - this.m_StartOffset - 1;
    }

    public final int start() {
        return this.m_StartOffset;
    }

    public final int end() {
        return this.m_EndOffset;
    }

    public final int lastCharOffset() {
        return this.end() - 1;
    }

    public final boolean isAfter(CodeEditorDocLine otherLine) {
        return this.start() > otherLine.start();
    }

    public final CodeEditorDocLine next() {
        if (this.m_Index >= this.m_MaxIndex) {
            return null;
        }
        this.setIndex(this.m_Index + 1);
        return this;
    }

    public final CodeEditorDocLine previous() {
        if (this.m_Index == 0) {
            return null;
        }
        this.setIndex(this.m_Index - 1);
        return this;
    }

    public int getLineIndex() {
        return this.m_Index;
    }
}

