/*
 * Decompiled with CFR 0.152.
 */
package com.sas.editor;

import com.sas.editor.CodeEditorResource;
import com.sas.editor.PreferenceChangeListener;
import java.awt.Font;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterJob;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.Collator;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Properties;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import javax.swing.event.EventListenerList;

public class CodeEditorDefaults {
    public static final String Key_TabSize = "CodeEditorDocument.TabSize.txt";
    public static final String Key_SmartIndent = "CodeEditorDocument.SmartIndent.txt";
    public static final String Key_FontName = "CodeEditorDefaults.FontName.txt";
    public static final String Key_FontSize = "CodeEditorDefaults.FontSize.txt";
    public static final String Key_CodeFoldingEnabled = "CodeEditorGeneralPane.CodeFoldingEnabled.txt";
    public static final String Key_ShowSectionLines = "CodeEditorGeneralPane.ShowSectionLines.txt";
    public static final String Key_ShowSectionBrackets = "CodeEditorGeneralPane.ShowSectionBrackets.txt";
    public static final String Key_ShowLineNumbers = "CodeEditorGeneralPane.ShowLineNumbers.txt";
    public static final String Key_DocumentColoringEnabled = "CodeEditorGeneralPane.DocumentColoringEnabled.txt";
    public static final String Key_ReadOnly = "CodeEditorGeneralPane.ReadOnly.txt";
    public static final String Key_ImageableX = "CodeEditorPrintManager.Imageable.x.txt";
    public static final String Key_ImageableY = "CodeEditorPrintManager.Imageable.y.txt";
    public static final String Key_ImageableHeight = "CodeEditorPrintManager.Imageable.height.txt";
    public static final String Key_ImageableWidth = "CodeEditorPrintManager.Imageable.width.txt";
    public static final String Key_Height = "CodeEditorPrintManager.Height.txt";
    public static final String Key_Width = "CodeEditorPrintManager.Width.txt";
    public static final String Key_Orientation = "CodeEditorPrintManager.Orientation.txt";
    static final String Key_Find_History = "CodeEditorFindDialog.FindHistory.txt";
    static final String Key_Replace_History = "CodeEditorFindDialog.ReplaceHistory.txt";
    static final String Key_FindHistorySize = "CodeEditorGeneralPane.FindHistorySize.txt";
    protected String m_strFileName;
    private static final String filename = "JavaCodeEditorDefs.txt";
    protected Properties m_properties;
    protected CodeEditorResource m_bundle;
    protected Collator mCollator = Collator.getInstance(Locale.getDefault());
    protected EventListenerList m_ListenerList = new EventListenerList();

    public CodeEditorDefaults() {
        this.m_bundle = new CodeEditorResource(CodeEditorDefaults.class);
        this.m_properties = new Properties();
        try {
            StringBuffer sb = new StringBuffer();
            if (System.getProperty("os.name").indexOf("Windows") >= 0) {
                sb.append(System.getenv("APPDATA"));
                sb.append(System.getProperty("file.separator"));
                sb.append("SAS");
                sb.append(System.getProperty("file.separator"));
            } else {
                sb.append(System.getProperty("user.home"));
                sb.append(System.getProperty("file.separator"));
                sb.append(".SASAppData");
                sb.append(System.getProperty("file.separator"));
            }
            sb.append("SharedSettings");
            sb.append(System.getProperty("file.separator"));
            sb.append("4.2");
            sb.append(System.getProperty("file.separator"));
            sb.append(filename);
            this.m_strFileName = sb.toString();
        }
        catch (Exception ex) {
            this.m_strFileName = null;
        }
        this.loadProperties(this.m_strFileName);
    }

    public CodeEditorDefaults(String filename) {
        this.m_bundle = new CodeEditorResource(CodeEditorDefaults.class);
        this.m_properties = new Properties();
        this.m_strFileName = filename;
        this.loadProperties(this.m_strFileName);
    }

    public CodeEditorDefaults(InputStream stream) throws IOException {
        this.m_bundle = new CodeEditorResource(CodeEditorDefaults.class);
        this.m_properties = new Properties();
        this.m_strFileName = null;
        this.loadProperties(stream);
    }

    protected void loadProperties(String strFile) {
        if (strFile == null) {
            return;
        }
        boolean newFile = false;
        FileInputStream input = null;
        try {
            try {
                input = new FileInputStream(strFile);
            }
            catch (FileNotFoundException e) {
                File oldfile = new File(System.getProperty("user.home") + System.getProperty("file.separator") + "CodeEditorDefs.txt");
                if (oldfile.exists()) {
                    this.upgradeDefsfile(oldfile.getPath(), strFile);
                } else {
                    this.createDefsfileDir(strFile);
                    File f = new File(strFile);
                    try {
                        f.createNewFile();
                        newFile = true;
                    }
                    catch (Exception e2) {
                        System.out.println(this.m_bundle.getMessageString("CodeEditorDefaults.CouldNotCreateFile.fmt.txt", strFile));
                        return;
                    }
                }
                input = new FileInputStream(strFile);
            }
            catch (SecurityException e) {
                System.out.print(this.m_bundle.getMessageString("CodeEditorDefaults.ReadError.fmt.txt", strFile));
            }
            this.m_properties.load(input);
            input.close();
        }
        catch (Exception e) {
            System.out.print(this.m_bundle.getMessageString("CodeEditorDefaults.LoadError.fmt.txt", strFile));
            return;
        }
        if (newFile) {
            this.setPropertyString("CodeEditorSchemeManager.WorkingSasScheme.txt", "Default");
            this.setPropertyString("CodeEditorSchemeManager.WorkingHtmlScheme.txt", "Default");
            this.setPropertyString("CodeEditorSchemeManager.WorkingLogScheme.txt", "Default");
            this.setPropertyString("CodeEditorSchemeManager.WorkingListScheme.txt", "Default");
        }
    }

    public void saveProperties() {
        FileOutputStream output;
        if (this.m_strFileName == null) {
            this.firePreferenceChangeUpdate();
            return;
        }
        try {
            this.createDefsfileDir(this.m_strFileName);
            output = new FileOutputStream(this.m_strFileName);
        }
        catch (FileNotFoundException ex) {
            System.out.println(this.m_bundle.getMessageString("CodeEditorDefaults.FileNotFound.fmt.txt", this.m_strFileName));
            return;
        }
        String strHeader = this.m_bundle.getString("CodeEditorDefaults.FileHeader.txt");
        try {
            this.m_properties.store(output, strHeader);
            output.close();
        }
        catch (IOException ex) {
            System.out.println(this.m_bundle.getMessageString("CodeEditorDefaults.IOError.fmt.txt", this.m_strFileName));
        }
        this.firePreferenceChangeUpdate();
    }

    public void setPropertyString(String strKeyName, String strValue) {
        this.m_properties.setProperty(strKeyName, strValue);
    }

    public String getPropertyString(String strKeyName) {
        try {
            String strValue = this.m_properties.getProperty(strKeyName);
            if (strValue == null) {
                return new String("");
            }
            return strValue;
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
            return null;
        }
    }

    public int getPropertyInt(String strKeyName, int defValue) {
        String strValue = this.m_properties.getProperty(strKeyName);
        if (strValue != null && strValue.length() != 0) {
            try {
                NumberFormat nf = NumberFormat.getInstance(Locale.getDefault());
                Number n = nf.parse(strValue);
                return n.intValue();
            }
            catch (Exception ex) {
                return defValue;
            }
        }
        return defValue;
    }

    public int getPropertyInt(String strKeyName) {
        return this.getPropertyInt(strKeyName, 0);
    }

    public void setPropertyInt(String keyName, int intValue) {
        this.setPropertyString(keyName, String.valueOf(intValue));
    }

    public double getPropertyDouble(String strKeyName, double defValue) {
        String strValue = this.m_properties.getProperty(strKeyName);
        if (strValue != null && strValue.length() != 0) {
            try {
                NumberFormat nf = NumberFormat.getInstance(Locale.getDefault());
                Number n = nf.parse(strValue);
                return n.doubleValue();
            }
            catch (Exception ex) {
                return defValue;
            }
        }
        return defValue;
    }

    public double getPropertyDouble(String strKeyName) {
        return this.getPropertyDouble(strKeyName, 0.0);
    }

    public void setPropertyDouble(String keyName, double doubleValue) {
        this.setPropertyString(keyName, String.valueOf(doubleValue));
    }

    public boolean getPropertyBoolean(String keyName, boolean defValue) {
        String strValue = this.m_properties.getProperty(keyName);
        if (strValue != null && strValue.length() != 0) {
            try {
                Collator coll = Collator.getInstance(Locale.getDefault());
                return coll.compare(strValue, String.valueOf(true)) == 0;
            }
            catch (Exception ex) {
                return false;
            }
        }
        return defValue;
    }

    public boolean getPropertyBoolean(String keyName) {
        return this.getPropertyBoolean(keyName, false);
    }

    public void setPropertyBoolean(String keyName, boolean bValue) {
        this.setPropertyString(keyName, String.valueOf(bValue));
    }

    public void removePropertyString(String keyName) {
        this.m_properties.remove(keyName);
    }

    public void storeFont(Font f, int langID, boolean saveAttrs) {
        if (f == null) {
            return;
        }
        this.setPropertyString("CodeEditorDefaults." + langID + ".FontName.txt", f.getName());
        this.setPropertyInt("CodeEditorDefaults." + langID + ".FontSize.txt", f.getSize());
        if (saveAttrs) {
            this.saveProperties();
        }
    }

    public Font getFont(int langID) {
        String name = this.getPropertyString("CodeEditorDefaults." + langID + ".FontName.txt");
        int size = this.getPropertyInt("CodeEditorDefaults." + langID + ".FontSize.txt", 12);
        if (name == null || this.mCollator.compare(name, "") == 0) {
            return null;
        }
        return new Font(name, 0, size);
    }

    public boolean getCodeFoldingEnabled() {
        return this.getPropertyBoolean(Key_CodeFoldingEnabled, true);
    }

    public void setCodeFoldingEnabled(boolean newValue, boolean saveAttrs) {
        this.setPropertyBoolean(Key_CodeFoldingEnabled, newValue);
        if (saveAttrs) {
            this.saveProperties();
        }
    }

    public boolean getShowSectionLines() {
        return this.getPropertyBoolean(Key_ShowSectionLines, true);
    }

    public void setShowSectionLines(boolean newValue, boolean saveAttrs) {
        this.setPropertyBoolean(Key_ShowSectionLines, newValue);
        if (saveAttrs) {
            this.saveProperties();
        }
    }

    public boolean getShowSectionBrackets() {
        return this.getPropertyBoolean(Key_ShowSectionBrackets, true);
    }

    public void setShowSectionBrackets(boolean newValue, boolean saveAttrs) {
        this.setPropertyBoolean(Key_ShowSectionBrackets, newValue);
        if (saveAttrs) {
            this.saveProperties();
        }
    }

    public boolean getShowLineNumbers() {
        return this.getPropertyBoolean(Key_ShowLineNumbers, false);
    }

    public void setShowLineNumbers(boolean newValue, boolean saveAttrs) {
        this.setPropertyBoolean(Key_ShowLineNumbers, newValue);
        if (saveAttrs) {
            this.saveProperties();
        }
    }

    public String[] getFindHistory() {
        String encodedData = this.getPropertyString(Key_Find_History);
        String[] histories = this.interpretEncodedHistoryString(encodedData);
        return histories;
    }

    public String[] getReplaceHistory() {
        String encodedData = this.getPropertyString(Key_Replace_History);
        String[] histories = this.interpretEncodedHistoryString(encodedData);
        return histories;
    }

    private String createEncodedHistoryString(String[] historyStrings) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < historyStrings.length; ++i) {
            String item = historyStrings[i];
            buffer.append(item.length());
            buffer.append('|');
            buffer.append(item);
            buffer.append('|');
        }
        return buffer.toString();
    }

    private String[] interpretEncodedHistoryString(String encodedData) {
        int firstBar;
        ArrayList<String> results = new ArrayList<String>();
        int currentPos = 0;
        while ((firstBar = encodedData.indexOf(124, currentPos)) >= 0) {
            String lengthString = encodedData.substring(currentPos, firstBar);
            try {
                int historyStringLength = Integer.parseInt(lengthString);
                String historyString = encodedData.substring(firstBar + 1, firstBar + 1 + historyStringLength);
                results.add(historyString);
                currentPos = firstBar + 1 + historyStringLength + 1;
            }
            catch (NumberFormatException e) {
                break;
            }
        }
        return results.toArray(new String[0]);
    }

    public void setFindHistory(String[] historyStrings, boolean saveAttrs) {
        String encodedString = this.createEncodedHistoryString(historyStrings);
        this.setPropertyString(Key_Find_History, encodedString);
        if (saveAttrs) {
            this.saveProperties();
        }
    }

    public void setReplaceHistory(String[] historyStrings, boolean saveAttrs) {
        String encodedString = this.createEncodedHistoryString(historyStrings);
        this.setPropertyString(Key_Replace_History, encodedString);
        if (saveAttrs) {
            this.saveProperties();
        }
    }

    public int getFindHistorySize() {
        return this.getPropertyInt(Key_FindHistorySize, 10);
    }

    public void setFindHistorySize(int size, boolean saveAttrs) {
        this.setPropertyInt(Key_FindHistorySize, Math.max(1, size));
        if (saveAttrs) {
            this.saveProperties();
        }
    }

    public boolean getSmartIndent() {
        return this.getPropertyBoolean(Key_SmartIndent, false);
    }

    public void setSmartIndent(boolean newValue, boolean saveAttrs) {
        this.setPropertyBoolean(Key_SmartIndent, newValue);
        if (saveAttrs) {
            this.saveProperties();
        }
    }

    public int getTabSize() {
        return this.getPropertyInt(Key_TabSize, 3);
    }

    public void setTabSize(int newValue, boolean saveAttrs) {
        this.setPropertyInt(Key_TabSize, newValue);
        if (saveAttrs) {
            this.saveProperties();
        }
    }

    public boolean getDocumentColoring() {
        return this.getPropertyBoolean(Key_DocumentColoringEnabled, true);
    }

    public void setDocumentColoring(boolean newValue, boolean saveAttrs) {
        this.setPropertyBoolean(Key_DocumentColoringEnabled, newValue);
        if (saveAttrs) {
            this.saveProperties();
        }
    }

    public boolean getReadOnly() {
        return false;
    }

    public void setReadOnly(boolean newValue, boolean saveAttrs) {
    }

    public void savePrinterFormat(PrintRequestAttributeSet attributes) {
        MediaSizeName mediaType;
        OrientationRequested orientation;
        MediaPrintableArea mediaArea = (MediaPrintableArea)attributes.get(MediaPrintableArea.class);
        if (mediaArea != null) {
            float height = mediaArea.getHeight(1000);
            float width = mediaArea.getWidth(1000);
            float x = mediaArea.getX(1000);
            float y = mediaArea.getY(1000);
            this.setPropertyDouble(Key_ImageableX, x);
            this.setPropertyDouble(Key_ImageableY, y);
            this.setPropertyDouble(Key_ImageableHeight, height);
            this.setPropertyDouble(Key_ImageableWidth, width);
        }
        if ((orientation = (OrientationRequested)attributes.get(OrientationRequested.class)) != null) {
            int orientationCode = orientation.getValue();
            this.setPropertyInt(Key_Orientation, orientationCode);
        }
        if ((mediaType = (MediaSizeName)attributes.get(MediaSizeName.class)) != null) {
            // empty if block
        }
    }

    public PrintRequestAttributeSet loadPrinterFormat() {
        float x = (float)this.getPropertyDouble(Key_ImageableX, -1.0);
        float y = (float)this.getPropertyDouble(Key_ImageableY, -1.0);
        float width = (float)this.getPropertyDouble(Key_ImageableWidth, -1.0);
        float height = (float)this.getPropertyDouble(Key_ImageableHeight, -1.0);
        int orientation = this.getPropertyInt(Key_Orientation, -1);
        HashPrintRequestAttributeSet attributes = new HashPrintRequestAttributeSet();
        if (x > 0.0f && y > 0.0f && width > 0.0f && height > 0.0f) {
            MediaPrintableArea printableArea = new MediaPrintableArea(x, y, width, height, 1000);
            attributes.add(printableArea);
        }
        if (orientation > 0) {
            if (orientation == OrientationRequested.LANDSCAPE.getValue()) {
                attributes.add(OrientationRequested.LANDSCAPE);
            } else if (orientation == OrientationRequested.REVERSE_LANDSCAPE.getValue()) {
                attributes.add(OrientationRequested.REVERSE_LANDSCAPE);
            } else if (orientation == OrientationRequested.REVERSE_PORTRAIT.getValue()) {
                attributes.add(OrientationRequested.REVERSE_PORTRAIT);
            } else {
                attributes.add(OrientationRequested.PORTRAIT);
            }
        }
        return attributes;
    }

    public void savePageFormat(PageFormat format) {
        Paper paper = format.getPaper();
        this.setPropertyDouble(Key_ImageableX, paper.getImageableX());
        this.setPropertyDouble(Key_ImageableY, paper.getImageableY());
        this.setPropertyDouble(Key_ImageableHeight, paper.getImageableHeight());
        this.setPropertyDouble(Key_ImageableWidth, paper.getImageableWidth());
        this.setPropertyDouble(Key_Height, paper.getHeight());
        this.setPropertyDouble(Key_Width, paper.getWidth());
        this.setPropertyInt(Key_Orientation, format.getOrientation());
        this.saveProperties();
    }

    public PageFormat loadPageFormat() {
        PrinterJob job = PrinterJob.getPrinterJob();
        PageFormat format = job.defaultPage();
        Paper paper = format.getPaper();
        double imagex = this.getPropertyDouble(Key_ImageableX, paper.getImageableX());
        double imagey = this.getPropertyDouble(Key_ImageableY, paper.getImageableY());
        double imagew = this.getPropertyDouble(Key_ImageableWidth, paper.getImageableWidth());
        double imageh = this.getPropertyDouble(Key_ImageableHeight, paper.getImageableHeight());
        double height = this.getPropertyDouble(Key_Height, paper.getHeight());
        double width = this.getPropertyDouble(Key_Width, paper.getWidth());
        int orientation = this.getPropertyInt(Key_Orientation, format.getOrientation());
        paper.setImageableArea(imagex, imagey, imagew, imageh);
        paper.setSize(width, height);
        format.setPaper(paper);
        format.setOrientation(orientation);
        return format;
    }

    public void loadProperties(InputStream stream) throws IOException {
        if (this.m_properties == null) {
            this.m_properties = new Properties();
        }
        this.m_properties.load(stream);
    }

    public void saveProperties(OutputStream stream) throws IOException {
        if (this.m_properties == null) {
            return;
        }
        this.m_properties.store(stream, null);
    }

    protected void firePreferenceChangeUpdate() {
        Object[] listeners = this.m_ListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != PreferenceChangeListener.class) continue;
            ((PreferenceChangeListener)listeners[i + 1]).preferenceChangeUpdate();
        }
    }

    public void addPreferenceChangeListener(PreferenceChangeListener listener) {
        this.m_ListenerList.add(PreferenceChangeListener.class, listener);
    }

    public void removePreferenceChangeListener(PreferenceChangeListener listener) {
        this.m_ListenerList.remove(PreferenceChangeListener.class, listener);
    }

    public void copyPropertiesFrom(CodeEditorDefaults source) {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        BufferedOutputStream oStream = new BufferedOutputStream(byteStream);
        try {
            source.saveProperties(oStream);
            byteStream.flush();
            ByteArrayInputStream bis = new ByteArrayInputStream(byteStream.toByteArray());
            this.loadProperties(bis);
            byteStream.close();
            bis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public CodeEditorDefaults newDataCopy() {
        CodeEditorDefaults def = new CodeEditorDefaults((String)null);
        def.copyPropertiesFrom(this);
        return def;
    }

    void dump() {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        BufferedOutputStream oStream = new BufferedOutputStream(byteStream);
        try {
            this.saveProperties(oStream);
            byteStream.flush();
            String s = new String(byteStream.toByteArray());
            System.out.println("**********************************");
            System.out.print(s);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void upgradeDefsfile(String oldFile, String newFile) throws Exception {
        BufferedInputStream bis = null;
        FilterOutputStream bos = null;
        try {
            int b;
            bis = new BufferedInputStream(new FileInputStream(oldFile));
            this.createDefsfileDir(newFile);
            bos = new BufferedOutputStream(new FileOutputStream(newFile));
            while ((b = bis.read()) != -1) {
                ((BufferedOutputStream)bos).write(b);
            }
        }
        catch (FileNotFoundException fnfe) {
            throw fnfe;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        finally {
            if (bis != null) {
                bis.close();
            }
            if (bos != null) {
                bos.close();
            }
        }
    }

    private void createDefsfileDir(String filePath) {
        File dir = new File(filePath.substring(0, filePath.length() - filename.length()));
        if (!dir.exists()) {
            dir.mkdirs();
        }
    }
}

