/*
 * Decompiled with CFR 0.152.
 */
package com.sas.editor;

import com.sas.editor.CodeEditor;
import com.sas.editor.CodeEditorAppearancePane;
import com.sas.editor.CodeEditorDefaults;
import com.sas.editor.CodeEditorPane;
import com.sas.editor.CodeEditorResource;
import com.sas.editor.CodeLanguage;
import com.sas.swing.util.SASJavaHelp;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;

public class CodeEditorAppearanceDialog
extends JDialog
implements KeyEventDispatcher {
    JButton OKButton = new JButton();
    JButton CancelButton = new JButton();
    JButton HelpButton = new JButton();
    CodeEditorAppearancePane appPane;
    protected CodeEditorDefaults mRealDefaults;
    CodeEditorResource resource = new CodeEditorResource(CodeEditorAppearanceDialog.class);
    GridBagLayout gridBagLayout1 = new GridBagLayout();

    public static CodeEditorAppearanceDialog CreateDialog(Component startComponent, CodeEditorDefaults workingDefaults, CodeEditor editor) {
        Component parent = CodeEditorPane.getParentFrameOrDialog(startComponent);
        if (parent instanceof Frame) {
            return new CodeEditorAppearanceDialog(editor, workingDefaults, (Frame)parent);
        }
        if (parent instanceof Dialog) {
            return new CodeEditorAppearanceDialog(editor, workingDefaults, (Dialog)parent);
        }
        return null;
    }

    private CodeEditorAppearanceDialog(CodeEditor editor, CodeEditorDefaults defaults, Dialog owner) {
        super(owner);
        this.mRealDefaults = defaults;
        this.appPane = new CodeEditorAppearancePane(editor, this.mRealDefaults.newDataCopy());
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private CodeEditorAppearanceDialog(CodeEditor editor, CodeEditorDefaults defaults, Frame owner) {
        super(owner);
        this.mRealDefaults = defaults;
        this.appPane = new CodeEditorAppearancePane(editor, this.mRealDefaults.newDataCopy());
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this);
        this.getContentPane().setLayout(this.gridBagLayout1);
        this.OKButton.setText(this.resource.getString("Common.OK.txt"));
        this.CancelButton.setText(this.resource.getString("Common.Cancel.txt"));
        String HelpButtonItem = this.resource.getString("Common.Help.txt");
        String HelpButtonText = Util.getLabelWithoutMnemonic((String)HelpButtonItem);
        this.HelpButton.setText(HelpButtonText);
        int index = Util.getDisplayedMnemonicIndex((String)HelpButtonItem);
        if (index > -1) {
            this.HelpButton.setMnemonic(Util.getDisplayedMnemonic((String)HelpButtonItem));
            this.HelpButton.setDisplayedMnemonicIndex(index);
        }
        Dimension boxSize = new Dimension(100, 25);
        this.OKButton.setMinimumSize(boxSize);
        this.OKButton.setPreferredSize(boxSize);
        this.OKButton.setMaximumSize(boxSize);
        this.CancelButton.setMinimumSize(boxSize);
        this.CancelButton.setPreferredSize(boxSize);
        this.CancelButton.setMaximumSize(boxSize);
        this.HelpButton.setMinimumSize(boxSize);
        this.HelpButton.setPreferredSize(boxSize);
        this.HelpButton.setMaximumSize(boxSize);
        Box box = Box.createHorizontalBox();
        box.add(this.OKButton);
        box.add(Box.createHorizontalStrut(7));
        box.add(this.CancelButton);
        box.add(Box.createHorizontalStrut(7));
        box.add(this.HelpButton);
        this.getContentPane().add((Component)this.appPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(10, 10, 0, 10), 0, 0));
        this.getContentPane().add((Component)box, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 14, 0, new Insets(0, 10, 10, 10), 0, 0));
        this.setTitle(this.resource.getString("CodeEditorAppearanceDialog.Title.txt"));
        this.setResizable(false);
        this.setModal(true);
        this.setSize(600, 500);
        this.OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodeEditorAppearanceDialog.this.onOK();
            }
        });
        this.HelpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodeEditorAppearanceDialog.this.onHelp();
            }
        });
        this.CancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodeEditorAppearanceDialog.this.onCancel();
            }
        });
    }

    protected void onOK() {
        this.appPane.onApplyChanges(this.mRealDefaults);
        this.dispose();
    }

    protected void onCancel() {
        this.dispose();
    }

    protected void onHelp() {
        SASJavaHelp jh = new SASJavaHelp("texteditor");
        jh.setActivationWindow((Window)this);
        jh.showContext("appearance");
    }

    @Override
    public void dispose() {
        if (this.OKButton == null) {
            return;
        }
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this);
        if (this.appPane != null) {
            this.appPane.cleanup();
            this.appPane.removeAll();
            this.appPane = null;
        }
        this.getContentPane().removeAll();
        this.getContentPane().setLayout(null);
        this.getRootPane().removeAll();
        this.rootPane = null;
        this.removeListeners(this.OKButton);
        this.OKButton = null;
        this.removeListeners(this.CancelButton);
        this.CancelButton = null;
        this.removeListeners(this.HelpButton);
        this.HelpButton = null;
        super.dispose();
    }

    private void removeListeners(JButton button) {
        if (button == null) {
            return;
        }
        ActionListener[] listeners = (ActionListener[])button.getListeners(ActionListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            button.removeActionListener(listeners[i]);
        }
    }

    public void setInitialLanguage(int lang) {
        this.appPane.FileTypeCombo.setSelectedIndex(lang);
    }

    public void customizeFileTypes(CodeLanguage[] langs) {
        this.appPane.customizeFileTypes(langs);
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent e) {
        if (e.getID() != 402) {
            return false;
        }
        if (e.getKeyCode() == 27 && this.isActive()) {
            this.onCancel();
            return true;
        }
        return false;
    }
}

