/*
 * Decompiled with CFR 0.152.
 */
package com.sas.editor;

import com.sas.editor.CodeEditorSchemeManager;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class AttributeMap
extends HashMap {
    public static final String TYPE_KEY = "Type";
    public static final String FONT_KEY = "Font";
    public static final String FONT_METRIC_KEY = "FontMetric";
    protected Font mDefaultFont = null;
    protected boolean mFontMetricsCurrent = false;
    protected Color m_singleBgColor = null;
    protected boolean m_usingSingleBgColor = false;

    public AttributeMap(int nMaxEntries) {
        super(AttributeMap.findNearestPrime((int)((double)nMaxEntries * 1.3333333333333333)));
    }

    public AttributeMap() {
        this(10);
    }

    public void addElementAttributes(short elementKey, Color fg, Color bg, boolean bold, boolean italic) {
        Short objKey = new Short(elementKey);
        SimpleAttributeSet attrs = new SimpleAttributeSet();
        attrs.addAttribute(TYPE_KEY, objKey);
        StyleConstants.setForeground(attrs, fg);
        StyleConstants.setBackground(attrs, bg);
        StyleConstants.setBold(attrs, bold);
        StyleConstants.setItalic(attrs, italic);
        this.put(objKey, attrs);
    }

    public void addFontAttributes(Font f) {
        this.mFontMetricsCurrent = false;
        this.mDefaultFont = f;
        Collection items = this.values();
        for (SimpleAttributeSet attrs : items) {
            int fMask = 0;
            if (StyleConstants.isBold(attrs)) {
                fMask |= 1;
            }
            if (StyleConstants.isItalic(attrs)) {
                fMask |= 2;
            }
            Font fontObject = new Font(this.mDefaultFont.getName(), fMask, this.mDefaultFont.getSize());
            attrs.addAttribute(FONT_KEY, fontObject);
            attrs.removeAttribute(FONT_METRIC_KEY);
        }
    }

    public Font getFontAttributes() {
        if (this.mDefaultFont != null) {
            return this.mDefaultFont;
        }
        return CodeEditorSchemeManager.PREDEFINED_FONT;
    }

    public void createFontMetricsIfNecesssary(Container container) {
        if (this.mFontMetricsCurrent) {
            return;
        }
        Collection items = this.values();
        for (SimpleAttributeSet attrs : items) {
            Font fontObject = (Font)attrs.getAttribute(FONT_KEY);
            FontMetrics fontMetricsObject = container.getFontMetrics(fontObject);
            attrs.addAttribute(FONT_METRIC_KEY, fontMetricsObject);
        }
        this.mFontMetricsCurrent = true;
    }

    public AttributeSet getElementAttributes(short elementKey) {
        Short objKey = new Short(elementKey);
        Object objAttrs = this.get(objKey);
        if (objAttrs != null && objAttrs instanceof AttributeSet) {
            return (AttributeSet)objAttrs;
        }
        return null;
    }

    protected static int findNearestPrime(int nSearchNumber) {
        int[] anPrimeNumbers = new int[]{2, 3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37, 41, 43, 47, 53, 59, 61, 67, 71, 73, 79, 83, 89, 97, 101, 103, 107, 109, 113, 127, 131, 137, 139, 149, 151, 157, 163, 167, 173, 179, 181, 191, 193, 197, 199, 211, 223, 227, 229, 233, 239, 241, 251, 257, 263, 269, 271, 277, 281, 283, 293, 307, 311, 313, 317, 331, 337, 347, 349, 353, 359, 367, 373, 379, 383, 389, 397, 401, 409, 419, 421, 431, 433, 439, 443, 449, 457, 461, 463, 467, 479, 487, 491, 499, 503, 509, 521, 523, 541, 547, 557, 563, 569, 571, 577, 587, 593, 599, 601};
        int nStart = 0;
        int nLast = anPrimeNumbers.length;
        int nPrev = 0;
        if (nSearchNumber == 0) {
            return 2;
        }
        int nCurr = (nStart + nLast) / 2;
        while (nCurr != nPrev) {
            int nCmp = anPrimeNumbers[nCurr] - nSearchNumber;
            if (nCmp < 0) {
                nStart = nCurr;
            } else if (nCmp > 0) {
                nLast = nCurr;
            } else {
                nLast = nCurr + 1;
                break;
            }
            nPrev = nCurr;
            nCurr = (nStart + nLast) / 2;
        }
        return anPrimeNumbers[nLast];
    }

    public void setUsingSingleBgColor(boolean b) {
        this.m_usingSingleBgColor = b;
    }

    public boolean isUsingSingleBgColor() {
        return this.m_usingSingleBgColor;
    }

    public void setSingleBgColor(Color c) {
        this.m_singleBgColor = c;
    }

    public Color getSingleBgColor() {
        return this.m_singleBgColor;
    }
}

