/*
 * Decompiled with CFR 0.152.
 */
package com.sas.editor;

import com.sas.editor.AssignEditorKeysPane;
import com.sas.editor.CodeEditorPane;
import com.sas.editor.CodeEditorResource;
import com.sas.swing.util.SASJavaHelp;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JTabbedPane;

public class AssignEditorKeysDialog
extends JDialog
implements KeyEventDispatcher {
    JTabbedPane jtp = new JTabbedPane();
    AssignEditorKeysPane assignPane;
    CodeEditorPane m_Editor;
    CodeEditorResource resource;
    JButton OKButton = new JButton();
    JButton CancelButton = new JButton();
    JButton HelpButton = new JButton();
    GridBagLayout gridBagLayout1 = new GridBagLayout();

    public static AssignEditorKeysDialog CreateDialog(Component startComponent, CodeEditorPane editorPane) {
        Component parent = CodeEditorPane.getParentFrameOrDialog(startComponent);
        if (parent instanceof Frame) {
            return new AssignEditorKeysDialog((Frame)parent, editorPane);
        }
        if (parent instanceof Dialog) {
            return new AssignEditorKeysDialog((Dialog)parent, editorPane);
        }
        return null;
    }

    private AssignEditorKeysDialog(Dialog jd, CodeEditorPane editor) {
        super(jd);
        this.m_Editor = editor;
        this.resource = new CodeEditorResource(AssignEditorKeysDialog.class);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private AssignEditorKeysDialog(Frame jd, CodeEditorPane editor) {
        super(jd);
        this.m_Editor = editor;
        this.resource = new CodeEditorResource(AssignEditorKeysDialog.class);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(this.gridBagLayout1);
        this.OKButton.setText(this.resource.getString("Common.OK.txt"));
        this.CancelButton.setText(this.resource.getString("Common.Cancel.txt"));
        String HelpButtonItem = this.resource.getString("Common.Help.txt");
        String HelpButtonText = Util.getLabelWithoutMnemonic((String)HelpButtonItem);
        this.HelpButton.setText(HelpButtonText);
        this.assignPane = new AssignEditorKeysPane(this.m_Editor.getKeyManager());
        this.jtp.add(this.resource.getString("AssignEditorKeysPane.Title.txt"), this.assignPane);
        Dimension d = new Dimension(100, 25);
        this.OKButton.setMinimumSize(d);
        this.OKButton.setPreferredSize(d);
        this.OKButton.setMaximumSize(d);
        this.CancelButton.setMinimumSize(d);
        this.CancelButton.setPreferredSize(d);
        this.CancelButton.setMaximumSize(d);
        this.HelpButton.setMinimumSize(d);
        this.HelpButton.setPreferredSize(d);
        this.HelpButton.setMaximumSize(d);
        Box box = Box.createHorizontalBox();
        box.add(this.OKButton);
        box.add(Box.createHorizontalStrut(5));
        box.add(this.CancelButton);
        box.add(Box.createHorizontalStrut(5));
        box.add(this.HelpButton);
        this.getContentPane().add((Component)this.jtp, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 0, 10), 505, 365));
        this.getContentPane().add((Component)box, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 14, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.setModal(true);
        this.setSize(600, 445);
        this.setTitle(this.resource.getString("AssignEditorKeysDialog.Title.txt"));
        this.OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AssignEditorKeysDialog.this.onOK();
            }
        });
        this.HelpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AssignEditorKeysDialog.this.onHelp();
            }
        });
        this.CancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AssignEditorKeysDialog.this.onClose();
            }
        });
    }

    protected void onOK() {
        this.assignPane.onApply();
        this.dispose();
    }

    protected void onClose() {
        this.assignPane.onCancel();
        this.dispose();
    }

    protected void onHelp() {
        SASJavaHelp jh = new SASJavaHelp("texteditor");
        jh.setActivationWindow((Window)this);
        jh.showContext("assignkeys");
    }

    @Override
    public void dispose() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this);
        if (this.assignPane != null) {
            this.assignPane.removeAll();
            this.assignPane = null;
        }
        this.m_Editor = null;
        super.dispose();
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent e) {
        if (e.getID() != 402) {
            return false;
        }
        if (e.getKeyCode() == 27 && this.isActive()) {
            this.onClose();
            return true;
        }
        return false;
    }
}

