/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.remote.impl;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MapPool;
import com.sas.metadata.remote.MdEvent;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectBaseXML;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdResponsibilitiesUtil;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.XMLUtil;
import com.sas.metadata.remote.impl.MdObjectBaseUtilImpl;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.w3c.dom.NamedNodeMap;

public class MdObjectBaseXMLImpl
extends MdObjectBaseUtilImpl
implements MdObjectBaseXML {
    public MdObjectBaseXMLImpl() throws RemoteException {
    }

    public MdObjectBaseXMLImpl(String strName) throws RemoteException {
        super(strName);
    }

    public MdObjectBaseXMLImpl(String strName, String strFQID) throws RemoteException {
        super(strName, strFQID);
    }

    public MdObjectBaseXMLImpl(String strName, String strFQID, String strType) throws RemoteException {
        super(strName, strFQID, strType);
    }

    public MdObjectBaseXMLImpl(String strType, NamedNodeMap childNodeMap) throws RemoteException {
        super(strType, childNodeMap);
    }

    @Override
    public String getUpdateSimpleSubstring() throws RemoteException {
        return this.getUpdateSimpleSubstring((CMetadata)((Object)this));
    }

    protected boolean fCheckUpdateSimpleXML() throws RemoteException {
        Map<String, String> attrs = ((CMetadata)((Object)this)).getUpdatedAttrs();
        try {
            boolean bl = attrs.size() > 0;
            return bl;
        }
        finally {
            MapPool.returnMap(attrs);
            attrs = null;
        }
    }

    @Override
    public String createUpdateSimpleXML() throws RemoteException {
        return XMLUtil.createObjectXML(this.m_strType, this.m_strFQID, this.getUpdatedAttrs());
    }

    public String getUpdateSimpleSubstring(CMetadata inObject) throws RemoteException {
        Map<String, String> attrs = inObject.getUpdatedAttrs();
        String xml = XMLUtil.createObjectAttributeXML(attrs);
        MapPool.returnMap(attrs);
        return xml;
    }

    @Override
    public String createEmptyXML() throws RemoteException {
        StringBuffer outXML = new StringBuffer(this.m_strType.length() * 2 + this.m_strFQID.length() + 13);
        outXML.append("<");
        outXML.append(this.m_strType);
        outXML.append(" Id=\"");
        outXML.append(this.m_strFQID);
        outXML.append("\" ></");
        outXML.append(this.m_strType);
        outXML.append(">");
        return outXML.toString();
    }

    @Override
    public String createObjectXML(CMetadata inObject) throws RemoteException {
        return this.createObjectXML(inObject, false);
    }

    @Override
    public String createObjectXML(CMetadata inObject, boolean includeEmptyAssocs) throws RemoteException {
        Map<String, String> attributes = inObject.getAttrs();
        Map<String, AssociationList> associations = inObject.getAssocs();
        StringBuilder sb = new StringBuilder();
        sb.append("<");
        sb.append(this.m_strType);
        sb.append(" ");
        sb.append(XMLUtil.createObjectAttributeXML(attributes));
        sb.append(">");
        for (String associationName : associations.keySet()) {
            AssociationList associationValue = associations.get(associationName);
            if (associationValue != null) {
                sb.append(associationValue.generateAssociationAllXML(inObject.isAssociationRequired(associationName), inObject.getId()));
                continue;
            }
            if (!includeEmptyAssocs) continue;
            sb.append("<");
            sb.append(associationName);
            sb.append("/>");
        }
        sb.append("</");
        sb.append(inObject.getCMetadataType());
        sb.append(">");
        MapPool.returnMap(associations);
        MapPool.returnMap(attributes);
        attributes = null;
        associations = null;
        return sb.toString();
    }

    @Override
    public String createObjectRefreshXML(CMetadata inObject, boolean includeLocallyChangedItems, boolean getFullObjectUpdate) throws RemoteException {
        Map<String, AssociationList> associations = inObject.getAssocs();
        HashMap<String, String> attrs = null;
        if (!getFullObjectUpdate) {
            Map<String, String> attributes = inObject.getAttrs();
            attrs = new HashMap(attributes.size());
            for (String key : attributes.keySet()) {
                attrs.put(key, "");
            }
            MapPool.returnMap(attributes);
        } else {
            attrs = new HashMap<String, String>(1);
            attrs.put("Id", inObject.getId());
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<");
        sb.append(this.m_strType);
        sb.append(" ");
        sb.append(XMLUtil.createObjectAttributeXML(attrs));
        sb.append(">");
        for (String associationName : associations.keySet()) {
            int associationState;
            AssociationList associationValue = associations.get(associationName);
            if (associationValue == null || ((associationState = associationValue.getState()) & 0x20) > 0 || (associationState & 0x40) > 0 || getFullObjectUpdate) continue;
            sb.append("<");
            sb.append(associationName);
            sb.append("/>");
        }
        sb.append("</");
        sb.append(inObject.getCMetadataType());
        sb.append(">");
        MapPool.returnMap(associations);
        associations = null;
        return sb.toString();
    }

    @Override
    public String closeUpdateMetadataXML(String outXML, String strTagToClose) throws RemoteException {
        StringBuffer tempXML = new StringBuffer("");
        if (outXML != null && outXML.length() > 0) {
            tempXML.append("</");
            tempXML.append(strTagToClose);
            tempXML.append(">");
        }
        return tempXML.toString();
    }

    @Override
    public String createUpdateAssociationXML() throws MdException, RemoteException {
        return this.createUpdateAssociationXML((CMetadata)((Object)this), null);
    }

    @Override
    public String createUpdateAssociationXML(CMetadata inObject, StringBuffer outXML) throws MdException, RemoteException {
        if (outXML == null) {
            outXML = new StringBuffer();
        }
        Map<String, AssociationList> assns = inObject.getAssocsWA();
        String Id = inObject.getId();
        boolean isNewObject = Id.indexOf(36) > -1;
        for (String association_name : assns.keySet()) {
            boolean required = inObject.isAssociationRequired(association_name);
            AssociationList association_value = assns.get(association_name);
            if (!(isNewObject && required || isNewObject && association_value != null) && (isNewObject || association_value == null || (association_value.getState() & 1) > 0 && (association_value.getState() & 0) > 0)) continue;
            if (association_value == null) {
                association_value = inObject.getAssociatedObjects(association_name);
                association_value.setParent(inObject);
            }
            outXML.append(association_value.generateAssociationWriteXML(required, Id));
        }
        MapPool.returnMap(assns);
        assns = null;
        return outXML.toString();
    }

    @Override
    public String doCreateUpdateXML(CMetadata object) throws MdException, RemoteException {
        StringBuffer outXML = new StringBuffer();
        outXML.append(object.createUpdateSimpleXML());
        this.createUpdateAssociationXML(object, outXML);
        if (outXML.length() > 0) {
            outXML.append("</");
            outXML.append(object.getCMetadataType());
            outXML.append(">");
        }
        int emptyUpdateLength = object.getCMetadataType().length() * 2 + object.getId().length() + 12;
        if (outXML.length() <= emptyUpdateLength) {
            return "";
        }
        return outXML.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateMetadataAll() throws MdException, RemoteException {
        if (this.m_OwningStore.getStoreType() != 1) throw new MdException("Can't update an object in a MdServerStore");
        MdStore grandparentStore = this.m_OwningStore.getOwningStore();
        if (grandparentStore == null) throw new MdException("Owning Store of parent store is null");
        if (grandparentStore.getStoreType() == 1) {
            ((MdObjectStore)this.m_OwningStore).flushUpdatesToParentStore();
            return;
        }
        if (grandparentStore.getStoreType() == 0) {
            // empty if block
        }
        if (((MdObjectStore)this.m_OwningStore).is_write_lock()) {
            while (!((MdObjectStore)this.m_OwningStore).is_write_lock()) {
                try {
                    this.wait(100L);
                }
                catch (InterruptedException e1) {
                    throw new MdException(e1);
                }
            }
        }
        ((MdObjectStore)this.m_OwningStore).set_write_lock(true);
        try {
            CMetadata[] objsWithAuthTransCtxt;
            Vector<CMetadata> authorizationTransContextList;
            StringBuffer requestBuffer = new StringBuffer();
            List<String> deleteList = this.createDeleteRequest(requestBuffer);
            if (deleteList != null) {
                Iterator<String> iterator = deleteList.iterator();
                while (iterator.hasNext()) {
                    String delObjId;
                    String id = delObjId = iterator.next();
                    CMetadata obj = this.m_OwningStore.getObject(id);
                    Vector<CMetadata> objsWithAuthTransCtxt2 = ((MdObjectStore)this.m_OwningStore).getAuthorizationTransContextList();
                    if (objsWithAuthTransCtxt2 == null || !objsWithAuthTransCtxt2.contains(obj)) continue;
                    obj.getAuthorizationUtil().discard();
                    ((MdObjectStore)this.m_OwningStore).removeObjFromAuthorizationTransContextList(obj);
                }
            }
            List<CMetadata> changedItems = this.createUpdateRequest(requestBuffer, deleteList);
            if (requestBuffer.length() > 0) {
                boolean updateIDs = changedItems != null && changedItems.size() > 0;
                this.m_OwningStore.getFactory().getOMIUtil().DoRequestNoReturn(requestBuffer.toString(), updateIDs);
                if (deleteList != null) {
                    ((MdObjectStore)this.m_OwningStore).getDeletedObjects().clear();
                }
                ArrayList<CMetadata> changes = new ArrayList<CMetadata>(this.getChangeList());
                this.getObjectStore().resetStates(changes);
                this.fireMdObjectModified(new MdEvent(this, this.getObjectStore()));
                if (changedItems != null) {
                    int length = changedItems.size();
                    for (int i = 0; i < length; ++i) {
                        CMetadata cObject = changedItems.get(i);
                        if (cObject == this) continue;
                        cObject.fireMdObjectModified(new MdEvent(cObject, this.getObjectStore()));
                    }
                }
                this.getObjectStore().flushUpdates(changes);
                this.clearChangeList();
            }
            if ((authorizationTransContextList = ((MdObjectStore)this.getObjectStore()).getAuthorizationTransContextList()) == null) return;
            for (CMetadata obj : objsWithAuthTransCtxt = authorizationTransContextList.toArray(new CMetadata[authorizationTransContextList.size()])) {
                if (!obj.getAuthorizationUtil().getCommitOnUpdate()) continue;
                obj.getAuthorizationUtil().commit();
                ((MdObjectStore)this.getObjectStore()).removeObjFromAuthorizationTransContextList(obj);
            }
            return;
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (MdException e) {
            throw e;
        }
        finally {
            ((MdObjectStore)this.m_OwningStore).set_write_lock(false);
            ((MdObjectStore)this.getObjectStore()).clearWriteBuffer();
        }
    }

    private List<CMetadata> createUpdateRequest(StringBuffer requestBuffer, List<String> deleteList) throws MdException, RemoteException {
        CMetadata thisObject;
        Vector<CMetadata> changeList = this.getChangeList();
        if (this.m_strFQID.indexOf(36) <= -1 && changeList.isEmpty() && !this.fCheckUpdateSimpleXML() && (this.objectState & 1) <= 0) {
            return null;
        }
        ArrayList<CMetadata> changedItems = new ArrayList<CMetadata>(10);
        int index = this.isInChangeList(changeList, this.getId());
        if (index > 0) {
            changeList.remove(index);
            changeList.add(0, (CMetadata)((Object)this));
        } else if (index < 0 && (thisObject = ((MdObjectStore)this.m_OwningStore).getObject(this.getId(), false)) != null) {
            changeList.add(0, (CMetadata)((Object)this));
        }
        StringBuffer updateBuffer = new StringBuffer("<UpdateMetadata><Metadata>");
        int writebeforelength = updateBuffer.length();
        int changeListSize = changeList.size();
        if (changeListSize > 0) {
            for (int i = 0; i < changeListSize; ++i) {
                CMetadata object = changeList.elementAt(i);
                int objectState = object.getState();
                if ((objectState & 2) > 0 || (objectState & 0) > 0 || deleteList != null && deleteList.contains(object.getId())) continue;
                MdResponsibilitiesUtil.setCreatedModifiedByValues(object);
                updateBuffer.append(this.doCreateUpdateXML(object));
                changedItems.add(object);
            }
        } else {
            return null;
        }
        String appendBuff = ((MdObjectStore)this.getObjectStore()).getWriteBuffer();
        updateBuffer.append(appendBuff);
        if (writebeforelength == updateBuffer.length()) {
            return null;
        }
        updateBuffer.append("</Metadata><NS>");
        updateBuffer.append(this.m_OwningStore.getFactory().getOMIUtil().getNamespace());
        updateBuffer.append("</NS><Flags>");
        updateBuffer.append(402654208);
        updateBuffer.append("</Flags><Options/></UpdateMetadata>");
        boolean delete = requestBuffer.length() > 0;
        requestBuffer.append(updateBuffer);
        if (delete) {
            requestBuffer.insert(0, "<Multiple_Requests>");
            requestBuffer.append("</Multiple_Requests>");
        }
        return changedItems;
    }

    private int isInChangeList(List<CMetadata> changeList, String id) throws RemoteException {
        int length = changeList.size();
        for (int index = 0; index < length; ++index) {
            CMetadata meta = changeList.get(index);
            if (!id.equals(meta.getId())) continue;
            return index;
        }
        return -1;
    }

    private List<String> createDeleteRequest(StringBuffer requestBuffer) throws MdException, RemoteException {
        Map<String, CMetadata> deletedObjects = ((MdObjectStore)this.m_OwningStore).getDeletedObjects();
        if (deletedObjects == null || deletedObjects.size() == 0) {
            return null;
        }
        ArrayList<String> deleteList = new ArrayList<String>(deletedObjects.size());
        for (String id : deletedObjects.keySet()) {
            CMetadata meta = deletedObjects.get(id);
            if (meta.isNewObject()) {
                this.m_OwningStore.getFactory().deleteMetadataObject(meta);
                continue;
            }
            deleteList.add(id);
            requestBuffer.append("<");
            requestBuffer.append(meta.getCMetadataType());
            requestBuffer.append(" Id=\"");
            requestBuffer.append(meta.getFQID());
            requestBuffer.append("\"/>");
        }
        if (deleteList.size() > 0) {
            int flags = 402654208;
            requestBuffer.insert(0, "<DeleteMetadata><Metadata>");
            requestBuffer.append("</Metadata><NS>");
            requestBuffer.append(this.m_OwningStore.getFactory().getOMIUtil().getNamespace());
            requestBuffer.append("</NS><Flags>");
            requestBuffer.append(flags);
            requestBuffer.append("</Flags><Options/>");
            requestBuffer.append("</DeleteMetadata>");
        }
        return deleteList;
    }
}

