/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.remote;

import com.sas.metadata.remote.Converter;
import java.util.List;
import java.util.Map;

public class XMLUtil {
    public static String formatXML(String original) {
        boolean newLine = false;
        char[] chars = new char[original.length()];
        original.getChars(0, original.length(), chars, 0);
        int indent = 0;
        StringBuilder sb = new StringBuilder(original.length());
        int length = chars.length;
        for (int index = 0; index < length; ++index) {
            if (chars[index] == '<') {
                int indentIndex;
                if (chars[index + 1] != '/') {
                    if (index > 0) {
                        newLine = true;
                        sb.append('\n');
                        for (indentIndex = 0; indentIndex < indent; ++indentIndex) {
                            sb.append('\t');
                        }
                    }
                    if (chars[index + 1] != '!' && chars[index + 1] != '?') {
                        ++indent;
                    }
                } else {
                    --indent;
                    if (newLine) {
                        sb.append('\n');
                        newLine = false;
                        for (indentIndex = 0; indentIndex < indent; ++indentIndex) {
                            sb.append('\t');
                        }
                    }
                }
            }
            if (chars[index] != '\t' && chars[index] != '\n') {
                sb.append(chars[index]);
            }
            if (chars[index] != '>') continue;
            if (chars[index - 1] != '/') {
                if (newLine) {
                    newLine = false;
                    continue;
                }
                newLine = true;
                continue;
            }
            if (!newLine) {
                sb.append('\n');
            }
            --indent;
        }
        return sb.toString();
    }

    public static String normalize(String s) {
        if (s == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(s.length());
        int len = s.length();
        block3: for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case '\"': 
                case '&': 
                case '<': 
                case '>': 
                case '\\': {
                    sb.append("&#");
                    sb.append(Converter.toString(c));
                    sb.append(';');
                    continue block3;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String createGetMetadataXML(String strType, String strFQID, List<String> simpleAttr, List<String> complexAttr) {
        int i;
        int lengthAttr;
        StringBuilder sb = new StringBuilder(60);
        sb.append("<");
        sb.append(strType);
        sb.append(" ");
        if (strFQID != null && strFQID.length() > 0) {
            sb.append("Id=\"");
            sb.append(strFQID);
            sb.append("\" ");
        }
        if (simpleAttr != null) {
            lengthAttr = simpleAttr.size();
            for (i = 0; i < lengthAttr; ++i) {
                sb.append(simpleAttr.get(i));
                sb.append("=\"\" ");
            }
        }
        sb.append(">");
        if (complexAttr != null) {
            lengthAttr = complexAttr.size();
            for (i = 0; i < lengthAttr; ++i) {
                sb.append("<");
                sb.append(complexAttr.get(i));
                sb.append("/>");
            }
        }
        sb.append("</");
        sb.append(strType);
        sb.append(">");
        return sb.toString();
    }

    public static String createGetMetadataXML(Map<String, String> objectMap) {
        StringBuilder sb = new StringBuilder();
        for (String id : objectMap.keySet()) {
            String type = objectMap.get(id);
            if (type == null) continue;
            sb.append("<");
            sb.append(type);
            sb.append(" Id=\"");
            sb.append(id);
            sb.append("\" />");
        }
        return sb.toString();
    }

    public static String createObjectXML(String objectType, String objectID, Map<String, String> attrs) {
        StringBuilder sb = new StringBuilder();
        sb.append("<");
        sb.append(objectType);
        sb.append(" Id=\"");
        sb.append(objectID);
        sb.append("\" ");
        sb.append(XMLUtil.createObjectAttributeXML(attrs));
        sb.append(">");
        return sb.toString();
    }

    public static String createObjectAttributeXML(Map<String, String> attributes) {
        if (attributes == null || attributes.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String attrName : attributes.keySet()) {
            sb.append(attrName);
            sb.append("=\"");
            sb.append(XMLUtil.normalize(attributes.get(attrName)));
            sb.append("\" ");
        }
        return sb.toString();
    }
}

