/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.remote;

import com.sas.codepolicy.SASScope;

@SASScope
public class Converter {
    private static final int MAX_CACHED = 255;
    private static Integer[] _integers = new Integer[256];
    private static String[] _intStrs = new String[256];
    private static int _hits = 0;
    private static int _misses = 0;

    public static Integer toInteger(int value) {
        Integer rval;
        if (value > 255 || value < 0) {
            rval = new Integer(value);
            ++_misses;
        } else {
            rval = _integers[value];
            if (rval == null) {
                Converter._integers[value] = rval = new Integer(value);
                ++_misses;
            } else {
                ++_hits;
            }
        }
        return rval;
    }

    public static String toString(int value) {
        String rval;
        if (value > 255 || value < 0) {
            rval = Integer.toString(value);
            ++_misses;
        } else {
            rval = _intStrs[value];
            if (rval == null) {
                Converter._intStrs[value] = rval = Integer.toString(value);
                ++_misses;
            } else {
                ++_hits;
            }
        }
        return rval;
    }

    public static String toString(Integer value) {
        return Converter.toString((int)value);
    }

    public static String diagnosticInfo() {
        StringBuffer rval = new StringBuffer(100);
        rval.append("Hits(").append(_hits).append("), Misses(").append(_misses).append(")");
        return rval.toString();
    }

    static {
        for (int i = 0; i < 8 && i < 255; ++i) {
            Converter._integers[i] = new Integer(i);
            Converter._intStrs[i] = _integers[i].toString();
        }
    }
}

