/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.remote;

import com.sas.codepolicy.SASScope;
import java.util.IdentityHashMap;
import java.util.Stack;

@SASScope
public abstract class AbstractPool {
    private static final int DEFAULT_MAX_SIZE = 20;
    public static boolean DEBUG_DETECT_DUPLICATES = false;
    private Stack _pool = new Stack();
    private IdentityHashMap _duplicateCheckMap;
    private int _maxInPool;
    private int _allocSize;
    private String _name;
    private int _getFromPool = 0;
    private int _getEmptyPool = 0;
    private int _returnAccepted = 0;
    private int _returnRejectFull = 0;
    private int _returnRejectClass = 0;
    private int _returnRejectNull = 0;

    protected AbstractPool(String name) {
        this._name = name;
        this.setMaxSize(20);
    }

    protected final void setMaxSize(int max) {
        if (max < 1) {
            throw new IllegalArgumentException("max size must be >= 1");
        }
        this._maxInPool = max;
        this._allocSize = Math.min(10, Math.max(2, this._maxInPool / 4));
    }

    protected abstract void sanitize(Object var1);

    protected abstract Object createNewObj();

    protected abstract boolean isClassAcceptable(Object var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getObj() {
        Object rval;
        Stack stack = this._pool;
        synchronized (stack) {
            this.ensurePoolIsCharged();
            rval = this._pool.pop();
        }
        if (rval == null) {
            rval = this.createNewObj();
        }
        if (DEBUG_DETECT_DUPLICATES) {
            this.getDuplicateMap().remove(rval);
        }
        return rval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void returnObj(Object obj) throws IllegalStateException {
        if (obj == null) {
            ++this._returnRejectNull;
            return;
        }
        this.doDuplicateCheckIfNecessary(obj);
        try {
            this.sanitize(obj);
            Stack stack = this._pool;
            synchronized (stack) {
                if (this._pool.size() < this._maxInPool) {
                    if (this.isClassAcceptable(obj)) {
                        ++this._returnAccepted;
                        this._pool.push(obj);
                    } else {
                        ++this._returnRejectClass;
                    }
                } else {
                    ++this._returnRejectFull;
                }
            }
        }
        catch (RuntimeException e) {
            ++this._returnRejectClass;
        }
    }

    private IdentityHashMap getDuplicateMap() {
        if (this._duplicateCheckMap == null) {
            System.out.println("**\n** SPECIAL DEBUG MODE FOR AbstractPool(" + this._name + ")\n**");
            this._duplicateCheckMap = new IdentityHashMap(101);
        }
        return this._duplicateCheckMap;
    }

    private void doDuplicateCheckIfNecessary(Object obj) throws IllegalStateException {
        Object oldValue;
        if (DEBUG_DETECT_DUPLICATES && (oldValue = this.getDuplicateMap().put(obj, obj)) != null) {
            IllegalStateException e = new IllegalStateException("**\n** CODE ERROR USING AbstractPool\n**\n**Duplicate returned detected(" + obj + ")\nPOOL toString -> (" + this + ")");
            e.printStackTrace(System.out);
            throw e;
        }
    }

    private void ensurePoolIsCharged() {
        if (this._pool.isEmpty()) {
            ++this._getEmptyPool;
            for (int i = 0; i < this._allocSize; ++i) {
                this._pool.push(this.createNewObj());
            }
        } else {
            ++this._getFromPool;
        }
    }

    public String toString() {
        return this._name + " Stats: max size(" + this._maxInPool + "), current size (" + this._pool.size() + ")\n\t get from pool(" + this._getFromPool + "), get empty pool(" + this._getEmptyPool + "),\n\t return accepted(" + this._returnAccepted + "), return reject full(" + this._returnRejectFull + "),\n\t return reject class(" + this._returnRejectClass + "), return reject null(" + this._returnRejectNull + ").";
    }
}

