/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.registry.client;

import com.sas.svcs.registry.client.RegisteredService;
import com.sas.svcs.registry.client.ServiceFilterInterface;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class KeywordServiceFilter
implements ServiceFilterInterface,
Serializable {
    private static final long serialVersionUID = 1L;
    private final List<String> keywords;

    public KeywordServiceFilter() {
        this.keywords = new ArrayList<String>(5);
    }

    public KeywordServiceFilter(String keyword) {
        this();
        this.addKeyword(keyword);
    }

    public KeywordServiceFilter(List<String> keywords) {
        this.keywords = keywords;
    }

    public final void addKeyword(String k) {
        this.keywords.add(k);
    }

    @Override
    public boolean isFiltered(RegisteredService service) {
        for (String keyword : this.keywords) {
            if (!service.hasKeyword(keyword)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.keywords == null ? 0 : this.keywords.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KeywordServiceFilter other = (KeywordServiceFilter)obj;
        return !(this.keywords == null ? other.keywords != null : !this.keywords.equals(other.keywords));
    }
}

