/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk.profiles.impl.memory.simple;

import MITI.MIRException;
import MITI.messages.MIR.MIRSDK;
import MITI.sdk.MIRConnection;
import MITI.sdk.MIRContent;
import MITI.sdk.MIRObject;
import MITI.sdk.MIRStoreConnection;
import MITI.sdk.MIRStoreContent;
import MITI.sdk.MIR_Object;
import MITI.sdk.profiles.AggregationProfileLink;
import MITI.sdk.profiles.ProfileLinkProcessor;
import MITI.sdk.profiles.ProfiledObject;
import MITI.sdk.profiles.impl.memory.ProfilerImpl;
import MITI.sdk.profiles.impl.memory.Util;
import MITI.sdk.profiles.impl.memory.simple.MultiModelProfiler;
import MITI.sdk.util.MIRSdkUtil;
import MITI.server.services.common.mir.ObjectIdentifier;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Stack;

public class AggregationLinkProfiler {
    private ProfilerImpl profiler;
    private MultiModelProfiler multiModelProfiler;
    private ProfiledObject root;
    private Stack<AggregationProfileLink> childrenCache = new Stack();
    private Set<ObjectIdentifier> objectIds = new LinkedHashSet<ObjectIdentifier>();
    private Set<ProfiledObject> objectsWithReferenceLinks = new LinkedHashSet<ProfiledObject>();
    private List<MIRConnection> supplierConnections;

    public AggregationLinkProfiler(MultiModelProfiler multiModelProfiler, ProfiledObject profiledObject, ProfiledObject profiledObject2, List<MIRConnection> list) throws MIRException {
        this.multiModelProfiler = multiModelProfiler;
        this.profiler = multiModelProfiler.getProfiler();
        this.root = profiledObject2;
        this.childrenCache.push(this.createAggregationLink(profiledObject, profiledObject2));
        this.objectIds.add(profiledObject2.getObjectDefinition());
        this.supplierConnections = list;
    }

    public String toString() {
        String string = this.getClass().getSimpleName();
        return string + " [" + this.root.getObjectDefinition().toString() + "]";
    }

    private AggregationProfileLink createAggregationLink(ProfiledObject profiledObject, ProfiledObject profiledObject2) throws MIRException {
        return new AggregationProfileLink(profiledObject, profiledObject2, this.profiler.getProfileLink(profiledObject, profiledObject2), profiledObject2.getObjectDefinition().getGroupName());
    }

    public void iterate(ProfileLinkProcessor profileLinkProcessor) {
        try {
            while (!this.childrenCache.isEmpty()) {
                AggregationProfileLink aggregationProfileLink = this.childrenCache.pop();
                ProfiledObject profiledObject = aggregationProfileLink.getDestinationNode();
                ProfiledObject[] profiledObjectArray = this.profiler.getLinks(profiledObject);
                if (profiledObjectArray != null) {
                    for (int i = profiledObjectArray.length - 1; i >= 0; --i) {
                        ProfiledObject profiledObject2 = profiledObjectArray[i];
                        if (profiledObject2.getLinkType() == 0 || profiledObject2.getLinkType() == 1) {
                            this.objectsWithReferenceLinks.add(profiledObject);
                            continue;
                        }
                        MIRContent mIRContent = null;
                        short s = profiledObject2.getObjectDefinition().getObjectType();
                        if (MIR_Object.isInstanceOf(s, (short)159)) {
                            mIRContent = (MIRContent)this.profiler.getMIRObject(profiledObject2.getObjectDefinition());
                        } else if (MIRSdkUtil.isTopLevelModelType(s)) {
                            mIRContent = (MIRContent)this.profiler.getMIRObject(profiledObject2.getObjectDefinition()).getParent();
                        }
                        if (mIRContent != null) {
                            this.multiModelProfiler.addSubModelProfiler(mIRContent, profiledObject, profiledObject2);
                        }
                        if (!this.processChildren(profiledObject, profiledObject2)) continue;
                        AggregationProfileLink aggregationProfileLink2 = this.createAggregationLink(profiledObject, profiledObject2);
                        this.childrenCache.push(aggregationProfileLink2);
                        this.objectIds.add(profiledObject2.getObjectDefinition());
                    }
                }
                profileLinkProcessor.process(aggregationProfileLink);
            }
        }
        catch (Exception exception) {
            MIRSDK.EXCEPTION.log(exception, exception.getMessage());
            throw new NoSuchElementException(exception.getMessage());
        }
    }

    private boolean processChildren(ProfiledObject profiledObject, ProfiledObject profiledObject2) throws MIRException {
        MIRStoreContent mIRStoreContent;
        String string;
        MIRConnection mIRConnection;
        boolean bl = this.multiModelProfiler.getOptions().isMergeExternalConnections();
        short s = profiledObject2.getObjectDefinition().getObjectType();
        MIRObject mIRObject = this.profiler.getMIRObject(profiledObject2.getObjectDefinition());
        MIRStoreConnection mIRStoreConnection = null;
        mIRStoreConnection = s == 216 ? (MIRStoreConnection)mIRObject : Util.getStoreConnection(mIRObject);
        return mIRStoreConnection == null || (mIRConnection = this.getSupplierConnection(string = Util.getStoreConnectionName(mIRStoreConnection))) == null || (mIRStoreContent = mIRConnection.getSupplierStoreContent()).getConnectionOfDirectoryStructureModel() == null || !bl;
    }

    private MIRConnection getSupplierConnection(String string) {
        MIRConnection mIRConnection = null;
        if (this.supplierConnections != null) {
            for (MIRConnection mIRConnection2 : this.supplierConnections) {
                if (!mIRConnection2.getName().equals(string)) continue;
                mIRConnection = mIRConnection2;
                break;
            }
        }
        return mIRConnection;
    }

    public Set<ObjectIdentifier> getObjectIds() {
        return this.objectIds;
    }

    public Set<ProfiledObject> getObjectsWithReferenceLinks() {
        return this.objectsWithReferenceLinks;
    }
}

