/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk.profiles.impl.memory.original;

import MITI.MIRException;
import MITI.bridges.bridgelib.MIRUdpLib;
import MITI.lineage.links.LineageUtil;
import MITI.messages.MIR.MIRSDK;
import MITI.sdk.MIRArgument;
import MITI.sdk.MIRClassifier;
import MITI.sdk.MIRClassifierMap;
import MITI.sdk.MIRCondition;
import MITI.sdk.MIRDataAttribute;
import MITI.sdk.MIRDataSet;
import MITI.sdk.MIRDirectoryStructureModel;
import MITI.sdk.MIRElement;
import MITI.sdk.MIRElementMap;
import MITI.sdk.MIRFeature;
import MITI.sdk.MIRFeatureMap;
import MITI.sdk.MIRModel;
import MITI.sdk.MIRNamespaceElement;
import MITI.sdk.MIRObject;
import MITI.sdk.MIROperation;
import MITI.sdk.MIRPropertyType;
import MITI.sdk.MIRReportField;
import MITI.sdk.MIRStoreModel;
import MITI.sdk.MIRStoredProcedure;
import MITI.sdk.MIRSummaryMap;
import MITI.sdk.MIRTransformation;
import MITI.sdk.profiles.LineageProfileLink;
import MITI.sdk.profiles.ProfileLink;
import MITI.sdk.profiles.ProfiledObject;
import MITI.sdk.profiles.SummaryLineageProfileLink;
import MITI.sdk.profiles.impl.memory.ProfilerImpl;
import MITI.sdk.profiles.impl.memory.SynonymChain;
import MITI.sdk.profiles.impl.memory.SynonymIdentifier;
import MITI.sdk.profiles.impl.memory.TraverseModel;
import MITI.sdk.profiles.impl.memory.Util;
import MITI.sdk.profiles.impl.memory.original.ProfiledObjectWithParent;
import MITI.server.services.common.mir.ObjectIdentifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.SequencedCollection;
import java.util.Stack;
import java.util.TreeSet;

public class SimpleLinkIterator
implements Iterator<ProfileLink> {
    protected Stack<ProfileLink> linksCache = new Stack();
    protected ProfilerImpl profiler;
    private TreeSet<ObjectIdentifier> validObjectIds = new TreeSet();
    private ProfiledObject root;
    private Queue<MIRFeature> features;
    private Queue<MIRElementMap> elementMaps;

    public String toString() {
        String string = this.getClass().getSimpleName();
        return string + " [" + this.root.getObjectDefinition().toString() + "]";
    }

    public SimpleLinkIterator(ProfilerImpl profilerImpl, ProfiledObject profiledObject, TreeSet<ObjectIdentifier> treeSet) throws MIRException {
        this.profiler = profilerImpl;
        this.root = profiledObject;
        this.validObjectIds = treeSet;
        MIRObject mIRObject = profilerImpl.getMIRObject(profiledObject.getObjectDefinition());
        if (!(mIRObject instanceof MIRDirectoryStructureModel)) {
            TraverseModel traverseModel = new TraverseModel();
            mIRObject.depthTraversal(traverseModel);
            this.features = traverseModel.getFeatures();
            this.elementMaps = traverseModel.getElementMaps();
        }
    }

    protected void fetchNextLink() throws MIRException {
        SequencedCollection<MIRElement> sequencedCollection;
        Object object;
        Object object2;
        List<ProfiledObjectWithParent> list;
        List<ProfiledObjectWithParent> list2;
        MIRElement mIRElement;
        if (this.features == null) {
            return;
        }
        while (this.elementMaps.size() > 0 && this.linksCache.size() == 0) {
            mIRElement = this.elementMaps.remove();
            list2 = ((MIRElementMap)mIRElement).getClientElement();
            list = this.getLineageProfileObjects((MIRObject)((Object)list2));
            if (list.size() == 0) continue;
            for (ProfiledObjectWithParent profiledObjectWithParent : list) {
                object2 = profiledObjectWithParent.getObject();
                object = profiledObjectWithParent.getParent();
                sequencedCollection = ((MIRElementMap)mIRElement).getSupplierElements();
                for (MIRElement mIRElement2 : sequencedCollection) {
                    List<ProfiledObjectWithParent> list3 = this.getLineageProfileObjects(mIRElement2);
                    if (list3.size() == 0) continue;
                    for (ProfiledObjectWithParent profiledObjectWithParent2 : list3) {
                        LineageProfileLink lineageProfileLink = new LineageProfileLink(profiledObjectWithParent2.getObject(), (ProfiledObject)object2, ProfileLink.LINK_TYPE.SEMANTIC_LINK);
                        lineageProfileLink.setSourceParent(profiledObjectWithParent2.getParent().getObjectDefinition());
                        lineageProfileLink.setDestinationParent(((ProfiledObject)object).getObjectDefinition());
                        this.linksCache.add(lineageProfileLink);
                    }
                }
            }
        }
        while (this.features.size() > 0 && this.linksCache.size() == 0) {
            mIRElement = this.features.remove();
            if (((MIRFeature)mIRElement).getElementType() == 14 && mIRElement.getName().equals("*") && ((MIRFeature)mIRElement).getClassifier().getNativeType().equals("SYNONYM")) continue;
            list2 = this.getLineageProfileObjects(mIRElement);
            if (list2.size() == 0) {
                list = this.getRepresentativeClassifier((MIRFeature)mIRElement);
                if (list.size() == 0) continue;
                list2 = list;
            }
            for (ProfiledObjectWithParent profiledObjectWithParent : list2) {
                Stack<String> stack = new Stack<String>();
                object2 = new Stack();
                object = new Stack();
                sequencedCollection = new Stack();
                Stack stack2 = new Stack();
                this.getDestinationFeatures(profiledObjectWithParent, (MIRFeature)mIRElement, (List<ProfileLink>)this.linksCache, stack, (Stack<String>)object2, (Stack<String>)object, (Stack<String>)sequencedCollection, stack2, null);
                this.getSummaryFeatures(profiledObjectWithParent, (MIRFeature)mIRElement, this.linksCache, stack, (Stack<String>)object2, null);
            }
        }
    }

    protected boolean isProcessChildren(ProfiledObject profiledObject, ProfiledObject profiledObject2) throws MIRException {
        return true;
    }

    private void getSummaryFeatures(ProfiledObjectWithParent profiledObjectWithParent, MIRFeature mIRFeature, List<ProfileLink> list, Stack<String> stack, Stack<String> stack2, ProfileLink.LINK_TYPE lINK_TYPE) throws MIRException {
        HashSet<MIRFeature> hashSet = new HashSet<MIRFeature>();
        this.getNextSummaryFeatures(profiledObjectWithParent, mIRFeature, list, stack, stack2, hashSet, lINK_TYPE);
    }

    protected void getNextSummaryFeatures(ProfiledObjectWithParent profiledObjectWithParent, MIRFeature mIRFeature, List<ProfileLink> list, Stack<String> stack, Stack<String> stack2, HashSet<MIRFeature> hashSet, ProfileLink.LINK_TYPE lINK_TYPE) throws MIRException {
        List<ProfiledObjectWithParent> list2;
        Object object;
        Object object2;
        Object object3;
        if (hashSet.contains(mIRFeature)) {
            return;
        }
        hashSet.add(mIRFeature);
        ProfileLink.LINK_TYPE lINK_TYPE2 = lINK_TYPE == null ? ProfileLink.LINK_TYPE.SUMMARY_LINEAGE : lINK_TYPE;
        Iterator<MIRSummaryMap> iterator = mIRFeature.getSourceOfSummaryMapIterator();
        while (iterator.hasNext()) {
            object3 = iterator.next();
            this.pushNonEmptyString(((MIRSummaryMap)object3).getOperation(), stack);
            this.pushNonEmptyString(((MIRElement)object3).getDescription(), stack2);
            object2 = ((MIRSummaryMap)object3).getExternalContentId().isEmpty() ? "" : this.profiler.getRuntimeTaskContentPath(((MIRSummaryMap)object3).getExternalContentId());
            object = ((MIRSummaryMap)object3).getDestinationFeature();
            if (object != null) {
                list2 = this.getLineageProfileObjects((MIRObject)object);
                if (list2.size() == 0) {
                    this.getNextSummaryFeatures(profiledObjectWithParent, (MIRFeature)object, list, stack, stack2, hashSet, lINK_TYPE2);
                } else {
                    for (ProfiledObjectWithParent object4 : list2) {
                        SummaryLineageProfileLink summaryLineageProfileLink = new SummaryLineageProfileLink(profiledObjectWithParent.getObject(), object4.getObject(), stack, stack2, ProfileLink.LINK_TYPE.SUMMARY_LINEAGE);
                        summaryLineageProfileLink.setSourceParent(profiledObjectWithParent.getParent().getObjectDefinition());
                        summaryLineageProfileLink.setDestinationParent(object4.getParent().getObjectDefinition());
                        summaryLineageProfileLink.setRuntimePath((String)object2);
                        summaryLineageProfileLink.setDecorations(((MIRSummaryMap)object3).getDecorations());
                        list.add(summaryLineageProfileLink);
                    }
                }
            }
            stack.pop();
            stack2.pop();
        }
        object3 = mIRFeature.getControlOfSummaryMapIterator();
        while (object3.hasNext()) {
            object2 = (MIRSummaryMap)object3.next();
            this.pushNonEmptyString(((MIRSummaryMap)object2).getOperation(), stack);
            this.pushNonEmptyString(((MIRElement)object2).getDescription(), stack2);
            object = ((MIRSummaryMap)object2).getExternalContentId().isEmpty() ? "" : this.profiler.getRuntimeTaskContentPath(((MIRSummaryMap)object2).getExternalContentId());
            list2 = ((MIRSummaryMap)object2).getDestinationFeature();
            if (list2 != null) {
                List<ProfiledObjectWithParent> list3 = this.getLineageProfileObjects((MIRObject)((Object)list2));
                if (list3.size() == 0) {
                    this.getNextSummaryFeatures(profiledObjectWithParent, (MIRFeature)((Object)list2), list, stack, stack2, hashSet, ProfileLink.LINK_TYPE.SUMMARY_CONTROL_LINEAGE);
                } else {
                    for (ProfiledObjectWithParent profiledObjectWithParent2 : list3) {
                        SummaryLineageProfileLink summaryLineageProfileLink = new SummaryLineageProfileLink(profiledObjectWithParent.getObject(), profiledObjectWithParent2.getObject(), stack, stack2, ProfileLink.LINK_TYPE.SUMMARY_CONTROL_LINEAGE);
                        summaryLineageProfileLink.setSourceParent(profiledObjectWithParent.getParent().getObjectDefinition());
                        summaryLineageProfileLink.setDestinationParent(profiledObjectWithParent2.getParent().getObjectDefinition());
                        summaryLineageProfileLink.setRuntimePath((String)object);
                        summaryLineageProfileLink.setDecorations(((MIRSummaryMap)object2).getDecorations());
                        list.add(summaryLineageProfileLink);
                    }
                }
            }
            stack.pop();
            stack2.pop();
        }
    }

    private void getDestinationFeatures(ProfiledObjectWithParent profiledObjectWithParent, MIRFeature mIRFeature, List<ProfileLink> list, Stack<String> stack, Stack<String> stack2, Stack<String> stack3, Stack<String> stack4, Stack<List<SynonymChain>> stack5, ProfileLink.LINK_TYPE lINK_TYPE) throws MIRException {
        HashSet<MIRObject> hashSet = new HashSet<MIRObject>();
        this.getNextDestinationFeatures(profiledObjectWithParent, mIRFeature, hashSet, list, stack, stack2, stack3, stack4, stack5, lINK_TYPE);
    }

    protected void getNextDestinationFeatures(ProfiledObjectWithParent profiledObjectWithParent, MIRFeature mIRFeature, HashSet<MIRObject> hashSet, List<ProfileLink> list, Stack<String> stack, Stack<String> stack2, Stack<String> stack3, Stack<String> stack4, Stack<List<SynonymChain>> stack5, ProfileLink.LINK_TYPE lINK_TYPE) throws MIRException {
        List<ProfiledObjectWithParent> list2;
        Object object;
        Object object2;
        Object object3;
        if (hashSet.contains(mIRFeature)) {
            return;
        }
        hashSet.add(mIRFeature);
        ProfileLink.LINK_TYPE lINK_TYPE2 = lINK_TYPE == null ? ProfileLink.LINK_TYPE.DATA_LINEAGE : lINK_TYPE;
        Iterator<MIRFeatureMap> iterator = mIRFeature.getSourceOfFeatureMapIterator();
        while (iterator.hasNext()) {
            object3 = iterator.next();
            object2 = ((MIRFeatureMap)object3).getDestinationFeature();
            this.addFeatureOperations((MIRFeatureMap)object3, stack, stack2);
            this.addClassifierOperations(((MIRFeatureMap)object3).getClassifierMap(), stack3, stack4);
            this.addClassifierSynonyms(((MIRFeatureMap)object3).getClassifierMap(), stack5, true);
            this.addClassifierSynonyms(((MIRFeatureMap)object3).getClassifierMap(), stack5, false);
            if (object2 != null) {
                object = this.getLineageProfileObjects((MIRObject)object2);
                if (object.size() == 0) {
                    this.getNextDestinationFeatures(profiledObjectWithParent, (MIRFeature)object2, hashSet, list, stack, stack2, stack3, stack4, stack5, lINK_TYPE2);
                } else {
                    Iterator iterator2 = object.iterator();
                    while (iterator2.hasNext()) {
                        list2 = (ProfiledObjectWithParent)iterator2.next();
                        LineageProfileLink object4 = new LineageProfileLink(profiledObjectWithParent.getObject(), ((ProfiledObjectWithParent)((Object)list2)).getObject(), stack, stack2, stack3, stack4, lINK_TYPE2);
                        object4.setDatabaseOperation(this.getProcessNode((MIRFeatureMap)object3));
                        object4.setTransformation(this.getTransformationNode((MIRFeatureMap)object3));
                        object4.setSourceParent(profiledObjectWithParent.getParent().getObjectDefinition());
                        object4.setDestinationParent(((ProfiledObjectWithParent)((Object)list2)).getParent().getObjectDefinition());
                        object4.setSynonymChains(this.flattenSynonymChains(stack5));
                        list.add(object4);
                    }
                }
            }
            stack.pop();
            stack2.pop();
            stack3.pop();
            stack4.pop();
            stack5.pop();
            stack5.pop();
        }
        object3 = mIRFeature.getControlOfFeatureMapIterator();
        while (object3.hasNext()) {
            object2 = (MIRFeatureMap)object3.next();
            object = ((MIRFeatureMap)object2).getDestinationFeature();
            boolean bl = mIRFeature instanceof MIRCondition && ((MIRFeature)object).getClassifier() == mIRFeature.getClassifier();
            this.addFeatureOperations((MIRFeatureMap)object2, stack, stack2);
            if (!bl) {
                this.addClassifierOperations(((MIRFeatureMap)object2).getClassifierMap(), stack3, stack4);
                this.addClassifierSynonyms(((MIRFeatureMap)object2).getClassifierMap(), stack5, true);
                this.addClassifierSynonyms(((MIRFeatureMap)object2).getClassifierMap(), stack5, false);
            }
            if (object != null) {
                list2 = this.getLineageProfileObjects((MIRObject)object);
                if (list2.size() == 0) {
                    this.getNextDestinationFeatures(profiledObjectWithParent, (MIRFeature)object, hashSet, list, stack, stack2, stack3, stack4, stack5, ProfileLink.LINK_TYPE.CONTROL_LINEAGE);
                } else {
                    for (ProfiledObjectWithParent profiledObjectWithParent2 : list2) {
                        LineageProfileLink lineageProfileLink = new LineageProfileLink(profiledObjectWithParent.getObject(), profiledObjectWithParent2.getObject(), stack, stack2, stack3, stack4, ProfileLink.LINK_TYPE.CONTROL_LINEAGE);
                        lineageProfileLink.setDatabaseOperation(this.getProcessNode((MIRFeatureMap)object2));
                        lineageProfileLink.setSourceParent(profiledObjectWithParent.getParent().getObjectDefinition());
                        lineageProfileLink.setDestinationParent(profiledObjectWithParent2.getParent().getObjectDefinition());
                        lineageProfileLink.setSynonymChains(this.flattenSynonymChains(stack5));
                        list.add(lineageProfileLink);
                    }
                }
            }
            stack.pop();
            stack2.pop();
            if (bl) continue;
            stack3.pop();
            stack4.pop();
            stack5.pop();
            stack5.pop();
        }
        object2 = mIRFeature.getReportFieldIterator();
        while (object2.hasNext()) {
            List<ProfiledObjectWithParent> list3;
            object = (MIRReportField)object2.next();
            if (LineageUtil.isHeaderReportField((MIRReportField)object) || (list3 = this.getLineageProfileObjects((MIRObject)object)).size() == 0) continue;
            for (ProfiledObjectWithParent profiledObjectWithParent3 : list3) {
                LineageProfileLink lineageProfileLink = new LineageProfileLink(profiledObjectWithParent.getObject(), profiledObjectWithParent3.getObject(), stack, stack2, stack3, stack4, ProfileLink.LINK_TYPE.DATA_LINEAGE);
                lineageProfileLink.setSourceParent(profiledObjectWithParent.getParent().getObjectDefinition());
                lineageProfileLink.setDestinationParent(profiledObjectWithParent3.getParent().getObjectDefinition());
                list.add(lineageProfileLink);
            }
        }
    }

    private ProfiledObject getProcessNode(MIRFeatureMap mIRFeatureMap) throws MIRException {
        MIROperation mIROperation = mIRFeatureMap.getClassifierMap().getDatabaseOperation();
        if (mIROperation != null) {
            return this.profiler.getObject(mIROperation);
        }
        return null;
    }

    private ProfiledObject getTransformationNode(MIRFeatureMap mIRFeatureMap) throws MIRException {
        MIRTransformation mIRTransformation = mIRFeatureMap.getClassifierMap().getTransformation();
        if (mIRTransformation != null) {
            return this.profiler.getObject(mIRTransformation);
        }
        return null;
    }

    private List<ProfiledObjectWithParent> getRepresentativeClassifier(MIRFeature mIRFeature) throws MIRException {
        ArrayList<ProfiledObjectWithParent> arrayList = new ArrayList<ProfiledObjectWithParent>();
        List<ProfiledObjectWithParent> list = this.getLineageProfileObjects(mIRFeature.getClassifier());
        for (ProfiledObjectWithParent profiledObjectWithParent : list) {
            ProfiledObject[] profiledObjectArray;
            MIRClassifier mIRClassifier;
            ProfiledObject profiledObject = profiledObjectWithParent.getObject();
            MIRObject mIRObject = this.profiler.getMIRObject(profiledObject.getObjectDefinition());
            if (!(mIRObject instanceof MIRClassifier) || (mIRClassifier = (MIRClassifier)mIRObject).getFeatureCount() > 1) continue;
            boolean bl = true;
            for (ProfiledObject profiledObject2 : profiledObjectArray = this.profiler.getLinks(profiledObject)) {
                if (profiledObject2.getLinkType() != 3 || !profiledObject2.getObjectDefinition().isInstanceOf((short)77)) continue;
                bl = false;
            }
            if (!bl) continue;
            ProfiledObject profiledObject3 = this.profiler.getParent(profiledObject);
            arrayList.add(new ProfiledObjectWithParent(profiledObject, profiledObject3));
        }
        return arrayList;
    }

    private List<ProfiledObjectWithParent> getRepresentativeProcedureParameter(MIRStoredProcedure mIRStoredProcedure, MIRDataAttribute mIRDataAttribute) throws MIRException {
        List<ProfiledObjectWithParent> list;
        String string = mIRDataAttribute.getName();
        MIRArgument mIRArgument = mIRStoredProcedure.getArgument(string);
        ArrayList<ProfiledObjectWithParent> arrayList = new ArrayList<ProfiledObjectWithParent>();
        if (mIRArgument != null && !(list = this.getLineageProfileObjects(mIRArgument)).isEmpty()) {
            arrayList.addAll(list);
        }
        return arrayList;
    }

    private void addFeatureOperations(MIRFeatureMap mIRFeatureMap, Stack<String> stack, Stack<String> stack2) {
        this.pushNonEmptyString(mIRFeatureMap.getOperation(), stack);
        this.pushNonEmptyString(mIRFeatureMap.getDescription(), stack2);
    }

    private void addClassifierOperations(MIRClassifierMap mIRClassifierMap, Stack<String> stack, Stack<String> stack2) {
        this.pushNonEmptyString(mIRClassifierMap.getOperation(), stack);
        this.pushNonEmptyString(mIRClassifierMap.getDescription(), stack2);
    }

    private void addClassifierSynonyms(MIRClassifierMap mIRClassifierMap, Stack<List<SynonymChain>> stack, boolean bl) throws MIRException {
        MIRModel mIRModel = mIRClassifierMap.getRootModel();
        List<SynonymChain> list = this.getSynonymChains(mIRModel, mIRClassifierMap, bl ? "SourceSynonyms" : "DestinationSynonym");
        stack.push(list);
    }

    private List<SynonymChain> getSynonymChains(MIRModel mIRModel, MIRElement mIRElement, String string) throws MIRException {
        String[] stringArray;
        String string2;
        ArrayList<SynonymChain> arrayList = new ArrayList<SynonymChain>();
        MIRPropertyType mIRPropertyType = MIRUdpLib.fetchPropertyType(mIRModel, mIRElement.getElementType(), string, (byte)0, "Synonym Lineage", "", "SQL_VARCHAR", false, null);
        if (mIRPropertyType != null && (string2 = MIRUdpLib.getPropertyValueValue(mIRPropertyType, mIRElement)) != null && !string2.isEmpty() && (stringArray = string2.split("\r\n")) != null) {
            for (String string3 : stringArray) {
                String[] stringArray2 = string3.split("\u2028");
                SynonymChain synonymChain = new SynonymChain();
                if (stringArray2 != null) {
                    for (String string4 : stringArray2) {
                        ProfiledObject profiledObject;
                        MIRNamespaceElement mIRNamespaceElement;
                        SynonymIdentifier synonymIdentifier = SynonymIdentifier.parse(string4);
                        if (synonymIdentifier == null || !(mIRModel instanceof MIRStoreModel) || (mIRNamespaceElement = Util.lookupSynonymObject((MIRStoreModel)mIRModel, synonymIdentifier)) == null || (profiledObject = this.profiler.getObject(mIRNamespaceElement)) == null) continue;
                        synonymChain.addElement(profiledObject);
                    }
                }
                arrayList.add(synonymChain);
            }
        }
        return arrayList;
    }

    private List<List<ProfiledObject>> flattenSynonymChains(Stack<List<SynonymChain>> stack) {
        ArrayList<List<ProfiledObject>> arrayList = new ArrayList<List<ProfiledObject>>();
        for (List list : stack) {
            for (SynonymChain synonymChain : list) {
                arrayList.add(synonymChain.getElements());
            }
        }
        return arrayList;
    }

    protected ProfiledObject getValidProfileObject(MIRObject mIRObject) throws MIRException {
        ProfiledObject profiledObject = this.profiler.getObject(mIRObject);
        if (profiledObject == null || this.validObjectIds == null || !this.validObjectIds.contains(profiledObject.getObjectDefinition())) {
            return null;
        }
        return profiledObject;
    }

    protected void pushNonEmptyString(String string, Stack<String> stack) {
        if (string == null) {
            string = "";
        }
        stack.push(string);
    }

    @Override
    public boolean hasNext() {
        try {
            this.fetchNextLink();
            return this.linksCache.size() != 0;
        }
        catch (MIRException mIRException) {
            MIRSDK.EXCEPTION.log(mIRException, mIRException.getMessage());
            throw new NoSuchElementException(mIRException.getMessage());
        }
    }

    @Override
    public ProfileLink next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.linksCache.pop();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    protected List<ProfiledObjectWithParent> getLineageProfileObjects(MIRObject mIRObject) throws MIRException {
        ArrayList<ProfiledObjectWithParent> arrayList = new ArrayList<ProfiledObjectWithParent>();
        ProfiledObject profiledObject = this.getValidProfileObject(mIRObject);
        if (profiledObject != null) {
            ProfiledObject profiledObject2 = this.profiler.getParent(profiledObject);
            arrayList.add(new ProfiledObjectWithParent(profiledObject, profiledObject2));
        } else if (mIRObject instanceof MIRFeature) {
            MIRClassifier mIRClassifier = ((MIRFeature)mIRObject).getClassifier();
            MIRStoredProcedure mIRStoredProcedure = null;
            if (mIRObject instanceof MIRDataAttribute && mIRClassifier instanceof MIRDataSet && (mIRStoredProcedure = ((MIRDataSet)mIRClassifier).getParametersOfStoredProcedure()) != null) {
                return this.getRepresentativeProcedureParameter(mIRStoredProcedure, (MIRDataAttribute)mIRObject);
            }
            return this.getRepresentativeClassifier((MIRFeature)mIRObject);
        }
        return arrayList;
    }
}

