/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk.profiles.impl.memory.original;

import MITI.MIRException;
import MITI.messages.MIRProfiler.PRFLR;
import MITI.sdk.MIRConnection;
import MITI.sdk.MIRContent;
import MITI.sdk.MIRStoreContent;
import MITI.sdk.profiles.ProfileLink;
import MITI.sdk.profiles.ProfiledObject;
import MITI.sdk.profiles.ProfilerOptions;
import MITI.sdk.profiles.impl.memory.ProfilerImpl;
import MITI.sdk.profiles.impl.memory.original.DirectoryContentIterator;
import MITI.sdk.profiles.impl.memory.original.DirectoryStructureLinkIterator;
import MITI.sdk.profiles.impl.memory.original.DirectoryStructureTreeIterator;
import MITI.sdk.profiles.impl.memory.original.QueuedIterators;
import MITI.stitching.memory.Stitcher;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;

public class MultiModelIterator
extends QueuedIterators {
    private Map<MIRContent, DirectoryContentIterator> dirContentIterators = new LinkedHashMap<MIRContent, DirectoryContentIterator>();
    private ProfilerImpl profilerImpl;
    private Stitcher stitcher;

    public MultiModelIterator(ProfilerImpl profilerImpl, ProfiledObject profiledObject) throws MIRException {
        this.profilerImpl = profilerImpl;
        this.stitcher = new Stitcher(profilerImpl.getCache());
        DirectoryStructureTreeIterator directoryStructureTreeIterator = new DirectoryStructureTreeIterator(this, profilerImpl, profiledObject);
        super.addIterator(directoryStructureTreeIterator);
        super.addIterator(new DirectoryStructureLinkIterator(profilerImpl, profiledObject, directoryStructureTreeIterator.getObjectIds()));
    }

    public ProfilerOptions getOptions() {
        return this.profilerImpl.getOptions();
    }

    public void addDirectoryContent(MIRContent mIRContent, ProfiledObject profiledObject, ProfiledObject profiledObject2) {
        DirectoryContentIterator directoryContentIterator = new DirectoryContentIterator(mIRContent, profiledObject, profiledObject2, this);
        this.dirContentIterators.put(mIRContent, directoryContentIterator);
    }

    protected ProfilerImpl getProfiler() {
        return this.profilerImpl;
    }

    protected Stitcher getStitcher() {
        return this.stitcher;
    }

    @Override
    protected void loadNextIterator(Iterator<ProfileLink> iterator) throws MIRException {
        super.loadNextIterator(iterator);
        if (!(iterator instanceof DirectoryContentIterator)) {
            return;
        }
        DirectoryContentIterator directoryContentIterator = (DirectoryContentIterator)iterator;
        directoryContentIterator.load();
    }

    @Override
    protected void iteratorComplete(Iterator<ProfileLink> iterator) throws MIRException {
        if (iterator instanceof DirectoryStructureLinkIterator) {
            LinkedList<DirectoryContentIterator> linkedList = this.sortDirectoryContentIterators();
            this.iterators.clear();
            this.iterators.addAll(linkedList);
        } else if (iterator instanceof DirectoryContentIterator) {
            DirectoryContentIterator directoryContentIterator = (DirectoryContentIterator)iterator;
            if (!directoryContentIterator.isLoaded) {
                return;
            }
            if (!directoryContentIterator.isLineageProcessed() && directoryContentIterator.getModelSummary() == null) {
                MIRContent mIRContent = directoryContentIterator.getDirContent();
                Iterator<MIRConnection> iterator2 = mIRContent.getClientOfConnectionIterator();
                int n = 0;
                while (iterator2.hasNext()) {
                    boolean bl;
                    MIRConnection mIRConnection = iterator2.next();
                    MIRStoreContent mIRStoreContent = mIRConnection.getSupplierStoreContent();
                    DirectoryContentIterator directoryContentIterator2 = this.dirContentIterators.get(mIRStoreContent);
                    if (directoryContentIterator2 == null || directoryContentIterator2.isLoaded || !(bl = this.iterators.remove(directoryContentIterator2))) continue;
                    this.iterators.add(0, directoryContentIterator2);
                    ++n;
                }
                this.iterators.add(n, directoryContentIterator);
            } else {
                directoryContentIterator.unload();
                MIRContent mIRContent = directoryContentIterator.getDirContent();
                Iterator<MIRConnection> iterator3 = mIRContent.getClientOfConnectionIterator();
                while (iterator3.hasNext()) {
                    MIRConnection mIRConnection = iterator3.next();
                    MIRStoreContent mIRStoreContent = mIRConnection.getSupplierStoreContent();
                    DirectoryContentIterator directoryContentIterator3 = this.dirContentIterators.get(mIRStoreContent);
                    if (directoryContentIterator3 == null) continue;
                    directoryContentIterator3.referenceUnloaded(mIRContent);
                }
            }
        }
    }

    private LinkedList<DirectoryContentIterator> sortDirectoryContentIterators() {
        LinkedList<DirectoryContentIterator> linkedList = new LinkedList<DirectoryContentIterator>();
        for (DirectoryContentIterator directoryContentIterator : this.dirContentIterators.values()) {
            boolean bl = false;
            MIRContent object = directoryContentIterator.getDirContent();
            if (object instanceof MIRStoreContent && ((MIRStoreContent)object).getSupplierOfConnectionCount() > 0) {
                bl = true;
            }
            if (bl) continue;
            this.doDepthFirst(linkedList, directoryContentIterator);
        }
        for (DirectoryContentIterator directoryContentIterator : this.dirContentIterators.values()) {
            if (directoryContentIterator.isVisited) continue;
            this.doDepthFirst(linkedList, directoryContentIterator);
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        for (DirectoryContentIterator directoryContentIterator : linkedList) {
            MIRContent mIRContent = directoryContentIterator.getDirContent();
            stringBuffer.append("[").append(mIRContent.getName());
            stringBuffer.append("(").append(mIRContent.getNativeType()).append(")],");
            if (++n <= 30) continue;
            stringBuffer.append("...");
            break;
        }
        PRFLR.MSG_ITERATORS_ORDER.log(stringBuffer.toString());
        return linkedList;
    }

    private void doDepthFirst(LinkedList<DirectoryContentIterator> linkedList, DirectoryContentIterator directoryContentIterator) {
        if (directoryContentIterator.isVisited) {
            return;
        }
        directoryContentIterator.isVisited = true;
        MIRContent mIRContent = directoryContentIterator.getDirContent();
        Iterator<MIRConnection> iterator = mIRContent.getClientOfConnectionIterator();
        while (iterator.hasNext()) {
            MIRStoreContent mIRStoreContent = iterator.next().getSupplierStoreContent();
            DirectoryContentIterator directoryContentIterator2 = this.dirContentIterators.get(mIRStoreContent);
            if (directoryContentIterator2 == null) {
                PRFLR.ERR_STORE_CONTENT_NOT_IN_PROFILE.log(mIRStoreContent.getName());
                continue;
            }
            this.doDepthFirst(linkedList, directoryContentIterator2);
        }
        linkedList.add(directoryContentIterator);
        if (mIRContent instanceof MIRStoreContent) {
            directoryContentIterator.setNumRefModelsRemaining(((MIRStoreContent)mIRContent).getSupplierOfConnectionCount());
        }
    }

    public DirectoryContentIterator getDirectoryContentIterator(MIRStoreContent mIRStoreContent) {
        return this.dirContentIterators.get(mIRStoreContent);
    }
}

