/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk.profiles.impl.memory.original;

import MITI.MIRException;
import MITI.sdk.MIRFeature;
import MITI.sdk.MIRObject;
import MITI.sdk.MIRStoreConnection;
import MITI.sdk.profiles.LineageProfileLink;
import MITI.sdk.profiles.ProfileLink;
import MITI.sdk.profiles.ProfiledObject;
import MITI.sdk.profiles.impl.memory.ProfilerImpl;
import MITI.sdk.profiles.impl.memory.Util;
import MITI.sdk.profiles.impl.memory.original.DirectoryContentIterator;
import MITI.sdk.profiles.impl.memory.original.ModelSummary;
import MITI.sdk.profiles.impl.memory.original.ProfiledObjectWithParent;
import MITI.sdk.profiles.impl.memory.original.SimpleLinkIterator;
import MITI.sdk.profiles.impl.memory.original.StitchingResultsIterator;
import MITI.server.services.common.mir.ObjectIdentifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class DirectoryContentLinkIterator
extends SimpleLinkIterator {
    private boolean canStart = false;
    private TreeMap<String, StitchingResultsIterator> stitchingResults = new TreeMap();
    private Set<String> externalConnections;
    private ModelSummary modelSummary = null;

    public DirectoryContentLinkIterator(ProfilerImpl profilerImpl, ProfiledObject profiledObject, TreeSet<ObjectIdentifier> treeSet, Set<String> set, ModelSummary modelSummary) throws MIRException {
        super(profilerImpl, profiledObject, treeSet);
        this.externalConnections = set;
        this.modelSummary = modelSummary;
    }

    @Override
    public boolean hasNext() {
        if (!this.canStart) {
            return false;
        }
        if (this.modelSummary != null) {
            return false;
        }
        return super.hasNext();
    }

    void setStitchingResults(HashMap<String, StitchingResultsIterator> hashMap) throws MIRException {
        this.canStart = true;
        for (String string : hashMap.keySet()) {
            StitchingResultsIterator stitchingResultsIterator = hashMap.get(string);
            if (stitchingResultsIterator == null) continue;
            this.stitchingResults.put(string, stitchingResultsIterator);
            if (!this.externalConnections.contains(string) || this.modelSummary != null) continue;
            this.createStitchingLinks(stitchingResultsIterator);
        }
        if (this.modelSummary != null) {
            this.modelSummary.buildSummary(this);
        }
    }

    private void createStitchingLinks(StitchingResultsIterator stitchingResultsIterator) throws MIRException {
        DirectoryContentIterator directoryContentIterator = stitchingResultsIterator.getSupplierIterator();
        DirectoryContentLinkIterator directoryContentLinkIterator = directoryContentIterator.getLineageIterator();
        for (MIRObject mIRObject : stitchingResultsIterator.getClients()) {
            ProfiledObject profiledObject = this.getValidProfileObject(mIRObject);
            if (profiledObject == null) continue;
            ProfiledObject profiledObject2 = this.profiler.getParent(profiledObject);
            List<MIRObject> list = stitchingResultsIterator.getSuppliers(mIRObject);
            for (MIRObject mIRObject2 : list) {
                Object object;
                ProfiledObjectWithParent profiledObjectWithParent;
                List<ProfiledObjectWithParent> list2 = directoryContentLinkIterator.getLineageProfileObjects(mIRObject2);
                ProfiledObjectWithParent profiledObjectWithParent2 = profiledObjectWithParent = list2.size() == 1 ? list2.get(0) : null;
                if (profiledObjectWithParent == null) continue;
                ProfiledObject profiledObject3 = profiledObjectWithParent.getObject();
                ProfiledObject profiledObject4 = profiledObjectWithParent.getParent();
                if (!this.isLineageObjectType(profiledObject) || !this.isLineageObjectType(profiledObject3)) continue;
                if (mIRObject instanceof MIRFeature) {
                    LineageProfileLink lineageProfileLink;
                    object = (MIRFeature)mIRObject;
                    if (((MIRFeature)object).getDestinationOfFeatureMap() != null) {
                        lineageProfileLink = new LineageProfileLink(profiledObject, profiledObject3, ProfileLink.LINK_TYPE.STITCHING);
                        lineageProfileLink.setSourceParent(profiledObject2.getObjectDefinition());
                        lineageProfileLink.setDestinationParent(profiledObject4.getObjectDefinition());
                        this.linksCache.add(lineageProfileLink);
                    }
                    if (((MIRFeature)object).getSourceOfFeatureMapCount() <= 0) continue;
                    lineageProfileLink = new LineageProfileLink(profiledObject3, profiledObject, ProfileLink.LINK_TYPE.STITCHING);
                    lineageProfileLink.setSourceParent(profiledObject4.getObjectDefinition());
                    lineageProfileLink.setDestinationParent(profiledObject2.getObjectDefinition());
                    this.linksCache.add(lineageProfileLink);
                    continue;
                }
                object = new LineageProfileLink(profiledObject3, profiledObject, ProfileLink.LINK_TYPE.STITCHING);
                ((LineageProfileLink)object).setSourceParent(profiledObject4.getObjectDefinition());
                ((LineageProfileLink)object).setDestinationParent(profiledObject2.getObjectDefinition());
                this.linksCache.add(object);
            }
        }
    }

    private boolean isLineageObjectType(ProfiledObject profiledObject) {
        return profiledObject.getObjectDefinition().isInstanceOf((short)77) || profiledObject.getObjectDefinition().isInstanceOf((short)317);
    }

    @Override
    protected ProfiledObject getValidProfileObject(MIRObject mIRObject) throws MIRException {
        if (this.isStitchingObject(mIRObject)) {
            return null;
        }
        return super.getValidProfileObject(mIRObject);
    }

    @Override
    protected List<ProfiledObjectWithParent> getLineageProfileObjects(MIRObject mIRObject) throws MIRException {
        if (this.modelSummary != null) {
            ArrayList<ProfiledObjectWithParent> arrayList = new ArrayList<ProfiledObjectWithParent>();
            Set<ProfiledObjectWithParent> set = this.modelSummary.getSources(mIRObject);
            if (set != null && !set.isEmpty()) {
                arrayList.addAll(set);
            }
            return arrayList;
        }
        if (this.isStitchingObject(mIRObject)) {
            return this.getMasterProfiledObjects(mIRObject);
        }
        return super.getLineageProfileObjects(mIRObject);
    }

    private boolean isStitchingObject(MIRObject mIRObject) {
        MIRStoreConnection mIRStoreConnection = Util.getStoreConnection(mIRObject);
        if (mIRStoreConnection == null) {
            return false;
        }
        String string = Util.getStoreConnectionName(mIRStoreConnection);
        if (this.externalConnections.contains(string)) {
            return false;
        }
        return this.stitchingResults.containsKey(string);
    }

    public List<ProfiledObjectWithParent> getMasterProfiledObjects(MIRObject mIRObject) throws MIRException {
        ArrayList<ProfiledObjectWithParent> arrayList = new ArrayList<ProfiledObjectWithParent>();
        MIRStoreConnection mIRStoreConnection = Util.getStoreConnection(mIRObject);
        String string = Util.getStoreConnectionName(mIRStoreConnection);
        StitchingResultsIterator stitchingResultsIterator = this.stitchingResults.get(string);
        if (stitchingResultsIterator != null) {
            DirectoryContentIterator directoryContentIterator = stitchingResultsIterator.getSupplierIterator();
            DirectoryContentLinkIterator directoryContentLinkIterator = directoryContentIterator.getLineageIterator();
            List<MIRObject> list = stitchingResultsIterator.getSuppliers(mIRObject);
            if (list != null) {
                for (MIRObject mIRObject2 : list) {
                    List<ProfiledObjectWithParent> list2 = directoryContentLinkIterator.getLineageProfileObjects(mIRObject2);
                    if (list2 == null) continue;
                    arrayList.addAll(list2);
                }
            }
        }
        return arrayList;
    }

    public void resetStitchingResults() {
        this.stitchingResults = null;
    }
}

