/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.scheduler.visuals;

import com.sas.metadata.logical.scheduler.common.Utilities;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.JFJob;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Root;
import com.sas.scheduler.api.oma.DeployedFlow;
import com.sas.scheduler.api.oma.MetaUtilities;
import com.sas.scheduler.visuals.swing.MessageUtil;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WATextField;
import com.sas.workspace.visuals.WAGeneralPanel;
import com.sas.workspace.visuals.WAGeneralPropertyTab;
import java.awt.Frame;
import java.rmi.RemoteException;
import java.util.List;
import java.util.ResourceBundle;

public class FlowGeneralPropertyTab
extends WAGeneralPropertyTab {
    private static final ResourceBundle m_bundle = MetaUtilities.getMyResourceBundle(FlowGeneralPropertyTab.class);
    private static final long serialVersionUID = 1L;
    protected Frame m_frame;
    protected DeployedFlow m_myflow;
    protected WAGeneralPanel m_panel;
    protected WATextField m_txtName;
    protected WATextArea m_description;
    private Root m_localObject;

    public FlowGeneralPropertyTab(Frame frame, DeployedFlow flow, Root localObject) throws RemoteException {
        super((CMetadata)localObject, null, false, false, true, true);
        this.m_frame = frame;
        if (flow.hasErrors()) {
            MessageUtil.displayMessage((Frame)this.m_frame, (String)flow.errorConditions(), (String)m_bundle.getString("FlowGeneralPropertiesTab.Title.txt"), (int)0);
        }
        this.m_myflow = flow;
        this.m_localObject = localObject;
        if (this.getComponentCount() > 0 && this.getComponent(0) instanceof WAGeneralPanel) {
            this.m_panel = (WAGeneralPanel)this.getComponent(0);
            this.m_panel.setSelectFolderEnabled(true);
            this.m_txtName = (WATextField)this.m_panel.getNameComponent();
            this.m_description = (WATextArea)this.m_panel.getDescriptionComponent();
        }
    }

    public void saveSettingsAndCleanUp() {
        super.saveSettingsAndCleanUp();
        this.m_myflow = null;
        this.m_panel.saveSettingsAndCleanUp();
        this.m_panel = null;
        this.m_txtName = null;
        this.m_description = null;
    }

    public boolean validateData() {
        if (super.validateData()) {
            String flowName = "";
            if (this.m_txtName != null) {
                flowName = this.m_txtName.getText();
            }
            try {
                if (!DeployedFlow.isValidFlowName((String)flowName)) {
                    String errorMessage = m_bundle.getString("FlowGeneralPropertiesTab.InvalidChars.Message.txt");
                    MessageUtil.displayMessage((Frame)this.m_frame, (String)errorMessage, (String)m_bundle.getString("FlowGeneralPropertiesTab.Title.txt"), (int)0);
                    if (this.m_txtName != null) {
                        this.m_txtName.grabFocus();
                    }
                    return false;
                }
                if (!this.isUniqueName(flowName)) {
                    MessageUtil.displayMessage((Frame)this.m_frame, (String)m_bundle.getString("FlowGeneralPropertiesTab.NonUnique.Message.txt"), (String)m_bundle.getString("FlowGeneralPropertiesTab.Title.txt"), (int)0);
                    if (this.m_txtName != null) {
                        this.m_txtName.grabFocus();
                    }
                    return false;
                }
                boolean writechanges = false;
                JFJob jfjob = this.m_myflow.getMetadataObject();
                if (jfjob.getName().compareTo(flowName) != 0) {
                    jfjob.setName(flowName);
                    this.m_localObject.setName(flowName);
                    writechanges = true;
                }
                if (jfjob.getDesc().compareTo(this.m_description.getText()) != 0) {
                    jfjob.setDesc(this.m_description.getText());
                    writechanges = true;
                }
                if (writechanges) {
                    jfjob.updateMetadataAll();
                }
            }
            catch (MdException ex) {
                String errorMessage = MetaUtilities.messageString((String)m_bundle.getString("FlowGeneralPropertiesTab.UnexpectedError.Message.fmt"), (Object)ex.getLocalizedMessage());
                MessageUtil.displayMessage((Frame)this.m_frame, (String)errorMessage, (String)m_bundle.getString("FlowGeneralPropertiesTab.Title.txt"), (int)0);
                return false;
            }
            catch (RemoteException ex) {
                String errorMessage = MetaUtilities.messageString((String)m_bundle.getString("FlowGeneralPropertiesTab.UnexpectedError.Message.fmt"), (Object)ex.getLocalizedMessage());
                MessageUtil.displayMessage((Frame)this.m_frame, (String)errorMessage, (String)m_bundle.getString("FlowGeneralPropertiesTab.Title.txt"), (int)0);
                return false;
            }
            catch (RuntimeException ex) {
                String errorMessage = MetaUtilities.messageString((String)m_bundle.getString("FlowGeneralPropertiesTab.UnexpectedError.Message.fmt"), (Object)new Object[]{ex.getLocalizedMessage()});
                MessageUtil.displayMessage((Frame)this.m_frame, (String)errorMessage, (String)m_bundle.getString("FlowGeneralPropertiesTab.Title.txt"), (int)0);
                return false;
            }
            return true;
        }
        String errorMessage = m_bundle.getString("FlowGeneralPropertiesTab.ValidationFailure.Message.txt");
        MessageUtil.displayMessage((Frame)this.m_frame, (String)errorMessage, (String)m_bundle.getString("FlowGeneralPropertiesTab.Title.txt"), (int)0);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isUniqueName(String flowName) throws MdException, RemoteException {
        MdObjectStore tempStore = null;
        List list = null;
        try {
            String flowId = this.m_myflow.getMetadataObject().getFQID();
            String reposId = "A0000001." + flowId.substring(0, 8);
            MdFactory factory = Utilities.getMdFactory(false);
            tempStore = factory.createObjectStore(null, "FlowGeneralPropertiesTab");
            list = MetaUtilities.getJFJobList((String)flowName, (boolean)true, (MdStore)tempStore, (String)reposId);
            if (list.size() > 0) {
                for (int i = 0; i < list.size(); ++i) {
                    if (((JFJob)list.get(i)).getFQID().compareToIgnoreCase(this.m_myflow.getMetadataObject().getFQID()) == 0) continue;
                    boolean bl = false;
                    return bl;
                }
            }
        }
        finally {
            if (tempStore != null) {
                try {
                    tempStore.dispose();
                }
                catch (RuntimeException runtimeException) {}
                tempStore = null;
            }
            if (list != null) {
                list.clear();
                list = null;
            }
        }
        return true;
    }
}

