/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.scheduler.job;

import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.RelatedObjectsInterface;
import com.sas.metadata.logical.SimpleLogicalObjectInterface;
import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.common.PrivateObjectImportUtility;
import com.sas.metadata.promotion.DefaultExportItem;
import com.sas.metadata.promotion.PromotionUtil;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.JFJob;
import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Root;
import com.sas.scheduler.api.oma.DeployedJob;
import com.sas.scheduler.api.oma.MetaUtilities;
import com.sas.scheduler.model.SchedulerException;
import java.rmi.RemoteException;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;

public class DeployedJobExportItem
extends DefaultExportItem
implements RelatedObjectsInterface {
    private static final ResourceBundle m_bundle = MetaUtilities.getMyResourceBundle(DeployedJobExportItem.class);
    private DeployedJob m_djob;

    public DeployedJobExportItem(String name, String id, TransportableTypeInterface type) {
        super(name, id, type);
        try {
            Factory lfactory = Factory.getInstance();
            MdObjectStore store = lfactory.getScratchStore();
            String repos = PromotionUtil.getRepositoryID((String)id);
            JFJob jfjob = MetaUtilities.getJFJob((String)id, (String)"<Templates><JFJob><JobActivities/><ComputeLocations/><TargetSpecifications/><Properties/><Trees/><AssociatedJob/><SourceCode/><SourceSpecifications/></JFJob></Templates>", (MdStore)store, (String)repos);
            this.m_djob = new DeployedJob(jfjob);
        }
        catch (SchedulerException se) {
            this.m_djob = null;
        }
        catch (RemoteException re) {
            this.m_djob = null;
        }
        catch (MdException mde) {
            this.m_djob = null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<SimpleLogicalObjectInterface> getRelatedObjects(int relationshipType) throws LogicalTypeException {
        Vector<SimpleLogicalObjectInterface> objectList = new Vector<SimpleLogicalObjectInterface>();
        if (this.m_djob == null) {
            return null;
        }
        if (relationshipType == 0) {
            try {
                Job job = this.m_djob.getJobObject();
                if (job == null) {
                    throw new LogicalTypeException(MetaUtilities.messageString((String)m_bundle.getString("DeployedJobExportItem.NoAssociatedJob.fmt"), (Object)this.m_djob.getName()));
                }
                if (job.getTransformRole().compareTo("SCHEDULER_BRIDGE_JOB") == 0) {
                    AssociationList aList = job.getTransformationSources();
                    int num = aList.size();
                    for (int j = 0; j < num; ++j) {
                        Root usedByDJob = (Root)aList.get(j);
                        SimpleLogicalObjectInterface logicalUser = PrivateObjectImportUtility.getLogicalFromJOMAObject((Root)usedByDJob);
                        if (logicalUser == null) continue;
                        objectList.add(logicalUser);
                    }
                    return objectList;
                }
                SimpleLogicalObjectInterface logicalUser = PrivateObjectImportUtility.getLogicalFromJOMAObject((Root)job);
                if (logicalUser == null) return objectList;
                objectList.add(logicalUser);
                return objectList;
            }
            catch (MdException mde) {
                throw new LogicalTypeException((Exception)((Object)mde));
            }
            catch (RemoteException re) {
                throw new LogicalTypeException((Exception)re);
            }
        }
        if (relationshipType != 1) return objectList;
        try {
            List flows = this.m_djob.getListofFlows();
            int num = flows.size();
            for (int j = 0; j < num; ++j) {
                JFJob usedByFlow = (JFJob)flows.get(j);
                SimpleLogicalObjectInterface logicalUser = PrivateObjectImportUtility.getLogicalFromJOMAObject((Root)usedByFlow);
                if (logicalUser == null) continue;
                objectList.add(logicalUser);
            }
            return objectList;
        }
        catch (MdException mde) {
            throw new LogicalTypeException((Exception)((Object)mde));
        }
        catch (RemoteException re) {
            throw new LogicalTypeException((Exception)re);
        }
    }
}

